/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.MACAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.PRFAlgorithm;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsObjectIdentifiers;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerCertificateImpl;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsSessionImpl;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Shorts;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsUtils {
    private static byte[] DOWNGRADE_TLS11 = Hex.decode((String)"444F574E47524400");
    private static byte[] DOWNGRADE_TLS12 = Hex.decode((String)"444F574E47524401");
    private static final Hashtable CERT_SIG_ALG_OIDS = TlsUtils.createCertSigAlgOIDs();
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final Integer EXT_signature_algorithms = TlsExtensionsUtils.EXT_signature_algorithms;
    public static final Integer EXT_signature_algorithms_cert = TlsExtensionsUtils.EXT_signature_algorithms_cert;
    protected static short MINIMUM_HASH_STRICT = (short)2;
    protected static short MINIMUM_HASH_PREFERRED = (short)4;

    private static void addCertSigAlgOID(Hashtable hashtable, ASN1ObjectIdentifier aSN1ObjectIdentifier, short s, short s2) {
        hashtable.put(aSN1ObjectIdentifier.getId(), SignatureAndHashAlgorithm.getInstance(s, s2));
    }

    private static Hashtable createCertSigAlgOIDs() {
        Hashtable hashtable = new Hashtable();
        TlsUtils.addCertSigAlgOID(hashtable, NISTObjectIdentifiers.dsa_with_sha224, (short)3, (short)2);
        TlsUtils.addCertSigAlgOID(hashtable, NISTObjectIdentifiers.dsa_with_sha256, (short)4, (short)2);
        TlsUtils.addCertSigAlgOID(hashtable, NISTObjectIdentifiers.dsa_with_sha384, (short)5, (short)2);
        TlsUtils.addCertSigAlgOID(hashtable, NISTObjectIdentifiers.dsa_with_sha512, (short)6, (short)2);
        TlsUtils.addCertSigAlgOID(hashtable, OIWObjectIdentifiers.dsaWithSHA1, (short)2, (short)2);
        TlsUtils.addCertSigAlgOID(hashtable, OIWObjectIdentifiers.sha1WithRSA, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, PKCSObjectIdentifiers.sha1WithRSAEncryption, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, PKCSObjectIdentifiers.sha224WithRSAEncryption, (short)3, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, PKCSObjectIdentifiers.sha256WithRSAEncryption, (short)4, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, PKCSObjectIdentifiers.sha384WithRSAEncryption, (short)5, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, PKCSObjectIdentifiers.sha512WithRSAEncryption, (short)6, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, X9ObjectIdentifiers.id_dsa_with_sha1, (short)2, (short)2);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, (short)4, (short)1);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, (short)8, (short)9);
        TlsUtils.addCertSigAlgOID(hashtable, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_512, (short)8, (short)11);
        TlsUtils.addCertSigAlgOID(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(hashtable, EdECObjectIdentifiers.id_Ed25519, (short)8, (short)7);
        TlsUtils.addCertSigAlgOID(hashtable, EdECObjectIdentifiers.id_Ed448, (short)8, (short)8);
        return hashtable;
    }

    public static void checkUint8(short s) throws IOException {
        if (!TlsUtils.isValidUint8(s)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int n) throws IOException {
        if (!TlsUtils.isValidUint8(n)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long l) throws IOException {
        if (!TlsUtils.isValidUint8(l)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int n) throws IOException {
        if (!TlsUtils.isValidUint16(n)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long l) throws IOException {
        if (!TlsUtils.isValidUint16(l)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int n) throws IOException {
        if (!TlsUtils.isValidUint24(n)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long l) throws IOException {
        if (!TlsUtils.isValidUint24(l)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long l) throws IOException {
        if (!TlsUtils.isValidUint32(l)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long l) throws IOException {
        if (!TlsUtils.isValidUint48(l)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long l) throws IOException {
        if (!TlsUtils.isValidUint64(l)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short s) {
        return (s & 0xFF) == s;
    }

    public static boolean isValidUint8(int n) {
        return (n & 0xFF) == n;
    }

    public static boolean isValidUint8(long l) {
        return (l & 0xFFL) == l;
    }

    public static boolean isValidUint16(int n) {
        return (n & 0xFFFF) == n;
    }

    public static boolean isValidUint16(long l) {
        return (l & 0xFFFFL) == l;
    }

    public static boolean isValidUint24(int n) {
        return (n & 0xFFFFFF) == n;
    }

    public static boolean isValidUint24(long l) {
        return (l & 0xFFFFFFL) == l;
    }

    public static boolean isValidUint32(long l) {
        return (l & 0xFFFFFFFFL) == l;
    }

    public static boolean isValidUint48(long l) {
        return (l & 0xFFFFFFFFFFFFL) == l;
    }

    public static boolean isValidUint64(long l) {
        return true;
    }

    public static boolean isTLSv10(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv10(TlsContext tlsContext) {
        return TlsUtils.isTLSv10(tlsContext.getServerVersion());
    }

    public static boolean isTLSv11(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext tlsContext) {
        return TlsUtils.isTLSv11(tlsContext.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext tlsContext) {
        return TlsUtils.isTLSv12(tlsContext.getServerVersion());
    }

    public static boolean isTLSv13(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv13(TlsContext tlsContext) {
        return TlsUtils.isTLSv13(tlsContext.getServerVersion());
    }

    public static void writeUint8(short s, OutputStream outputStream) throws IOException {
        outputStream.write(s);
    }

    public static void writeUint8(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n);
    }

    public static void writeUint8(short s, byte[] byArray, int n) {
        byArray[n] = (byte)s;
    }

    public static void writeUint8(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
    }

    public static void writeUint16(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >>> 8);
        outputStream.write(n);
    }

    public static void writeUint16(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static void writeUint24(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >>> 16));
        outputStream.write((byte)(n >>> 8));
        outputStream.write((byte)n);
    }

    public static void writeUint24(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 16);
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)n;
    }

    public static void writeUint32(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)l);
    }

    public static void writeUint32(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 24);
        byArray[n + 1] = (byte)(l >>> 16);
        byArray[n + 2] = (byte)(l >>> 8);
        byArray[n + 3] = (byte)l;
    }

    public static void writeUint48(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)l);
    }

    public static void writeUint48(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)l;
    }

    public static void writeUint64(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 56));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)l);
    }

    public static void writeUint64(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    public static void writeOpaque8(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint8(byArray.length);
        TlsUtils.writeUint8(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeOpaque8(byte[] byArray, byte[] byArray2, int n) throws IOException {
        TlsUtils.checkUint8(byArray.length);
        TlsUtils.writeUint8(byArray.length, byArray2, n);
        System.arraycopy(byArray, 0, byArray2, n + 1, byArray.length);
    }

    public static void writeOpaque16(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint16(byArray.length);
        TlsUtils.writeUint16(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeOpaque24(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint24(byArray.length);
        TlsUtils.writeUint24(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeUint8Array(short[] sArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < sArray.length; ++i) {
            TlsUtils.writeUint8(sArray[i], outputStream);
        }
    }

    public static void writeUint8Array(short[] sArray, byte[] byArray, int n) throws IOException {
        for (int i = 0; i < sArray.length; ++i) {
            TlsUtils.writeUint8(sArray[i], byArray, n);
            ++n;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] sArray, OutputStream outputStream) throws IOException {
        TlsUtils.checkUint8(sArray.length);
        TlsUtils.writeUint8(sArray.length, outputStream);
        TlsUtils.writeUint8Array(sArray, outputStream);
    }

    public static void writeUint8ArrayWithUint8Length(short[] sArray, byte[] byArray, int n) throws IOException {
        TlsUtils.checkUint8(sArray.length);
        TlsUtils.writeUint8(sArray.length, byArray, n);
        TlsUtils.writeUint8Array(sArray, byArray, n + 1);
    }

    public static void writeUint16Array(int[] nArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            TlsUtils.writeUint16(nArray[i], outputStream);
        }
    }

    public static void writeUint16Array(int[] nArray, byte[] byArray, int n) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            TlsUtils.writeUint16(nArray[i], byArray, n);
            n += 2;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] nArray, OutputStream outputStream) throws IOException {
        int n = 2 * nArray.length;
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, outputStream);
        TlsUtils.writeUint16Array(nArray, outputStream);
    }

    public static void writeUint16ArrayWithUint16Length(int[] nArray, byte[] byArray, int n) throws IOException {
        int n2 = 2 * nArray.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, byArray, n);
        TlsUtils.writeUint16Array(nArray, byArray, n + 2);
    }

    public static byte[] decodeOpaque8(byte[] byArray) throws IOException {
        return TlsUtils.decodeOpaque8(byArray, 0);
    }

    public static byte[] decodeOpaque8(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (byArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        short s = TlsUtils.readUint8(byArray, 0);
        if (byArray.length != s + 1 || s < n) {
            throw new TlsFatalAlert(50);
        }
        return Arrays.copyOfRange((byte[])byArray, (int)1, (int)byArray.length);
    }

    public static byte[] decodeOpaque16(byte[] byArray) throws IOException {
        return TlsUtils.decodeOpaque16(byArray, 0);
    }

    public static byte[] decodeOpaque16(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (byArray.length < 2) {
            throw new TlsFatalAlert(50);
        }
        int n2 = TlsUtils.readUint16(byArray, 0);
        if (byArray.length != n2 + 2 || n2 < n) {
            throw new TlsFatalAlert(50);
        }
        return Arrays.copyOfRange((byte[])byArray, (int)2, (int)byArray.length);
    }

    public static short decodeUint8(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (byArray.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8(byArray, 0);
    }

    public static short[] decodeUint8ArrayWithUint8Length(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        int n = TlsUtils.readUint8(byArray, 0);
        if (byArray.length != n + 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = TlsUtils.readUint8(byArray, i + 1);
        }
        return sArray;
    }

    public static int decodeUint16(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (byArray.length != 2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint16(byArray, 0);
    }

    public static long decodeUint32(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (byArray.length != 4) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint32(byArray, 0);
    }

    public static byte[] encodeOpaque8(byte[] byArray) throws IOException {
        TlsUtils.checkUint8(byArray.length);
        return Arrays.prepend((byte[])byArray, (byte)((byte)byArray.length));
    }

    public static byte[] encodeOpaque16(byte[] byArray) throws IOException {
        return Arrays.concatenate((byte[])TlsUtils.encodeUint16(byArray.length), (byte[])byArray);
    }

    public static byte[] encodeUint8(short s) throws IOException {
        TlsUtils.checkUint8(s);
        byte[] byArray = new byte[1];
        TlsUtils.writeUint8(s, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] sArray) throws IOException {
        byte[] byArray = new byte[1 + sArray.length];
        TlsUtils.writeUint8ArrayWithUint8Length(sArray, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16(int n) throws IOException {
        TlsUtils.checkUint16(n);
        byte[] byArray = new byte[2];
        TlsUtils.writeUint16(n, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] nArray) throws IOException {
        int n = 2 * nArray.length;
        byte[] byArray = new byte[2 + n];
        TlsUtils.writeUint16ArrayWithUint16Length(nArray, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint32(long l) throws IOException {
        TlsUtils.checkUint32(l);
        byte[] byArray = new byte[4];
        TlsUtils.writeUint32(l, byArray, 0);
        return byArray;
    }

    public static byte[] encodeVersion(ProtocolVersion protocolVersion) throws IOException {
        return new byte[]{(byte)protocolVersion.getMajorVersion(), (byte)protocolVersion.getMinorVersion()};
    }

    public static short readUint8(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (short)n;
    }

    public static short readUint8(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF);
    }

    public static int readUint16(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n << 8 | n2;
    }

    public static int readUint16(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 8;
        return n2 |= byArray[++n] & 0xFF;
    }

    public static int readUint24(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n << 16 | n2 << 8 | n3;
    }

    public static int readUint24(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 16;
        n2 |= (byArray[++n] & 0xFF) << 8;
        return n2 |= byArray[++n] & 0xFF;
    }

    public static long readUint32(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return (long)(n << 24 | n2 << 16 | n3 << 8 | n4) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        n2 |= (byArray[++n] & 0xFF) << 16;
        n2 |= (byArray[++n] & 0xFF) << 8;
        return (long)(n2 |= byArray[++n] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream inputStream) throws IOException {
        int n = TlsUtils.readUint24(inputStream);
        int n2 = TlsUtils.readUint24(inputStream);
        return ((long)n & 0xFFFFFFFFL) << 24 | (long)n2 & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] byArray, int n) {
        int n2 = TlsUtils.readUint24(byArray, n);
        int n3 = TlsUtils.readUint24(byArray, n + 3);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int n, InputStream inputStream) throws IOException {
        if (n < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = Streams.readFully((InputStream)inputStream, (byte[])byArray);
        if (n2 == 0) {
            return null;
        }
        if (n2 != n) {
            throw new EOFException();
        }
        return byArray;
    }

    public static byte[] readFully(int n, InputStream inputStream) throws IOException {
        if (n < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n];
        if (n != Streams.readFully((InputStream)inputStream, (byte[])byArray)) {
            throw new EOFException();
        }
        return byArray;
    }

    public static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n = byArray.length;
        if (n > 0 && n != Streams.readFully((InputStream)inputStream, (byte[])byArray)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream inputStream) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        return TlsUtils.readFully(s, inputStream);
    }

    public static byte[] readOpaque8(InputStream inputStream, int n) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        if (s < n) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(s, inputStream);
    }

    public static byte[] readOpaque8(InputStream inputStream, int n, int n2) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        if (s < n || n2 < s) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(s, inputStream);
    }

    public static byte[] readOpaque16(InputStream inputStream) throws IOException {
        int n = TlsUtils.readUint16(inputStream);
        return TlsUtils.readFully(n, inputStream);
    }

    public static byte[] readOpaque16(InputStream inputStream, int n) throws IOException {
        int n2 = TlsUtils.readUint16(inputStream);
        if (n2 < n) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(n2, inputStream);
    }

    public static byte[] readOpaque24(InputStream inputStream) throws IOException {
        int n = TlsUtils.readUint24(inputStream);
        return TlsUtils.readFully(n, inputStream);
    }

    public static byte[] readOpaque24(InputStream inputStream, int n) throws IOException {
        int n2 = TlsUtils.readUint24(inputStream);
        if (n2 < n) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(n2, inputStream);
    }

    public static short[] readUint8Array(int n, InputStream inputStream) throws IOException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = TlsUtils.readUint8(inputStream);
        }
        return sArray;
    }

    public static int[] readUint16Array(int n, InputStream inputStream) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = TlsUtils.readUint16(inputStream);
        }
        return nArray;
    }

    public static ProtocolVersion readVersion(byte[] byArray, int n) throws IOException {
        try {
            return ProtocolVersion.get(byArray[n] & 0xFF, byArray[n + 1] & 0xFF);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(50, (Throwable)runtimeException);
        }
    }

    public static ProtocolVersion readVersion(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        try {
            return ProtocolVersion.get(n, n2);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(50, (Throwable)runtimeException);
        }
    }

    public static ASN1Primitive readASN1Object(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (null == aSN1Primitive) {
            throw new TlsFatalAlert(50);
        }
        if (null != aSN1InputStream.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static ASN1Primitive readDERObject(byte[] byArray) throws IOException {
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
        byte[] byArray2 = aSN1Primitive.getEncoded("DER");
        if (!Arrays.areEqual((byte[])byArray2, (byte[])byArray)) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static void writeGMTUnixTime(byte[] byArray, int n) {
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static void writeVersion(ProtocolVersion protocolVersion, OutputStream outputStream) throws IOException {
        outputStream.write(protocolVersion.getMajorVersion());
        outputStream.write(protocolVersion.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion protocolVersion, byte[] byArray, int n) {
        byArray[n] = (byte)protocolVersion.getMajorVersion();
        byArray[n + 1] = (byte)protocolVersion.getMinorVersion();
    }

    public static void addIfSupported(Vector vector, TlsCrypto tlsCrypto, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (tlsCrypto.hasSignatureAndHashAlgorithm(signatureAndHashAlgorithm)) {
            vector.addElement(signatureAndHashAlgorithm);
        }
    }

    public static void addIfSupported(Vector vector, TlsCrypto tlsCrypto, int n) {
        if (tlsCrypto.hasNamedGroup(n)) {
            vector.addElement(Integers.valueOf((int)n));
        }
    }

    public static void addIfSupported(Vector vector, TlsCrypto tlsCrypto, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            TlsUtils.addIfSupported(vector, tlsCrypto, nArray[i]);
        }
    }

    public static boolean addToSet(Vector vector, int n) {
        boolean bl;
        boolean bl2 = bl = !vector.contains(Integers.valueOf((int)n));
        if (bl) {
            vector.add(Integers.valueOf((int)n));
        }
        return bl;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)2);
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)3);
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)1);
    }

    public static SignatureAndHashAlgorithm getDefaultSignatureAlgorithm(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: {
                return SignatureAndHashAlgorithm.getInstance((short)2, s);
            }
        }
        return null;
    }

    public static Vector getDefaultSignatureAlgorithms(short s) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getDefaultSignatureAlgorithm(s);
        return null == signatureAndHashAlgorithm ? new Vector() : TlsUtils.vectorOfOne(signatureAndHashAlgorithm);
    }

    public static Vector getDefaultSupportedSignatureAlgorithms(TlsContext tlsContext) {
        int n;
        TlsCrypto tlsCrypto = tlsContext.getCrypto();
        SignatureAndHashAlgorithm[] signatureAndHashAlgorithmArray = new SignatureAndHashAlgorithm[]{SignatureAndHashAlgorithm.ed25519, SignatureAndHashAlgorithm.ed448, SignatureAndHashAlgorithm.rsa_pss_rsae_sha256, SignatureAndHashAlgorithm.rsa_pss_rsae_sha384, SignatureAndHashAlgorithm.rsa_pss_rsae_sha512, SignatureAndHashAlgorithm.rsa_pss_pss_sha256, SignatureAndHashAlgorithm.rsa_pss_pss_sha384, SignatureAndHashAlgorithm.rsa_pss_pss_sha512};
        short[] sArray = new short[]{2, 3, 4, 5, 6};
        short[] sArray2 = new short[]{1, 2, 3};
        Vector vector = new Vector();
        for (n = 0; n < signatureAndHashAlgorithmArray.length; ++n) {
            TlsUtils.addIfSupported(vector, tlsCrypto, signatureAndHashAlgorithmArray[n]);
        }
        for (n = 0; n < sArray2.length; ++n) {
            for (int i = 0; i < sArray.length; ++i) {
                TlsUtils.addIfSupported(vector, tlsCrypto, new SignatureAndHashAlgorithm(sArray[i], sArray2[n]));
            }
        }
        return vector;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(tlsContext) && (signatureAndHashAlgorithm = tlsCredentialedSigner.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable hashtable, Integer n) {
        return hashtable == null ? null : (byte[])hashtable.get(n);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable hashtable, Integer n, short s) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, n);
        if (byArray == null) {
            return false;
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(s);
        }
        return true;
    }

    public static TlsSession importSession(byte[] byArray, SessionParameters sessionParameters) {
        return new TlsSessionImpl(byArray, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable hashtable, Vector vector) throws IOException {
        TlsExtensionsUtils.addSignatureAlgorithmsExtension(hashtable, vector);
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable hashtable) throws IOException {
        return TlsExtensionsUtils.getSignatureAlgorithmsExtension(hashtable);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector vector) throws IOException {
        return TlsExtensionsUtils.createSignatureAlgorithmsExtension(vector);
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static short getLegacyClientCertType(short s) {
        switch (s) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 64;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClient(short s) {
        switch (s) {
            case 2: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClientCert(short s) {
        switch (s) {
            case 2: 
            case 4: {
                return 2;
            }
            case 64: 
            case 66: {
                return 3;
            }
            case 1: 
            case 3: 
            case 65: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmServer(int n) {
        switch (n) {
            case 3: 
            case 22: {
                return 2;
            }
            case 17: {
                return 3;
            }
            case 5: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    static short getLegacySignatureAlgorithmServerCert(int n) {
        switch (n) {
            case 3: 
            case 7: 
            case 22: {
                return 2;
            }
            case 16: 
            case 17: {
                return 3;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector vector, OutputStream outputStream) throws IOException {
        if (vector == null || vector.size() < 1 || vector.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int n = 2 * vector.size();
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, outputStream);
        for (int i = 0; i < vector.size(); ++i) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i);
            if (signatureAndHashAlgorithm.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            signatureAndHashAlgorithm.encode(outputStream);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(InputStream inputStream) throws IOException {
        int n = TlsUtils.readUint16(inputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n2 = n / 2;
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n2);
        for (int i = 0; i < n2; ++i) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(inputStream);
            if (0 == signatureAndHashAlgorithm.getSignature()) continue;
            vector.addElement(signatureAndHashAlgorithm);
        }
        return vector;
    }

    public static void verifySupportedSignatureAlgorithm(Vector vector, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        if (vector == null || vector.size() < 1 || vector.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAndHashAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAndHashAlgorithm.getSignature() == 0 || !TlsUtils.containsSignatureAlgorithm(vector, signatureAndHashAlgorithm)) {
            throw new TlsFatalAlert(47);
        }
    }

    public static boolean containsSignatureAlgorithm(Vector vector, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm2 = (SignatureAndHashAlgorithm)vector.elementAt(i);
            if (signatureAndHashAlgorithm2.getHash() != signatureAndHashAlgorithm.getHash() || signatureAndHashAlgorithm2.getSignature() != signatureAndHashAlgorithm.getSignature()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnySignatureAlgorithm(Vector vector, short s) {
        for (int i = 0; i < vector.size(); ++i) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i);
            if (signatureAndHashAlgorithm.getSignature() != s) continue;
            return true;
        }
        return false;
    }

    public static TlsSecret PRF(TlsContext tlsContext, TlsSecret tlsSecret, String string, byte[] byArray, int n) {
        int n2 = tlsContext.getSecurityParametersHandshake().getPrfAlgorithm();
        return tlsSecret.deriveUsingPRF(n2, string, byArray, n);
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static byte[] calculateEndPointHash(TlsContext tlsContext, String string, byte[] byArray) {
        return TlsUtils.calculateEndPointHash(tlsContext, string, byArray, 0, byArray.length);
    }

    static byte[] calculateEndPointHash(TlsContext tlsContext, String string, byte[] byArray, int n, int n2) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm;
        if (string != null && (signatureAndHashAlgorithm = TlsUtils.getCertSigAndHashAlg(string)) != null) {
            short s = signatureAndHashAlgorithm.getHash();
            switch (s) {
                case 1: 
                case 2: {
                    s = 4;
                    break;
                }
                case 0: 
                case 8: {
                    return EMPTY_BYTES;
                }
            }
            TlsHash tlsHash = tlsContext.getCrypto().createHash(s);
            if (tlsHash != null) {
                tlsHash.update(byArray, n, n2);
                return tlsHash.calculateHash();
            }
        }
        return EMPTY_BYTES;
    }

    static TlsSecret calculateMasterSecret(TlsContext tlsContext, TlsSecret tlsSecret) {
        byte[] byArray;
        String string;
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (securityParameters.isExtendedMasterSecret()) {
            string = "extended master secret";
            byArray = securityParameters.getSessionHash();
        } else {
            string = "master secret";
            byArray = TlsUtils.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        }
        return TlsUtils.PRF(tlsContext, tlsSecret, string, byArray, 48);
    }

    static byte[] calculateTLSVerifyData(TlsContext tlsContext, TlsHandshakeHash tlsHandshakeHash, boolean bl) {
        String string = bl ? "server finished" : "client finished";
        byte[] byArray = TlsUtils.getCurrentPRFHash(tlsHandshakeHash);
        return TlsUtils.calculateTLSVerifyData(tlsContext, string, byArray);
    }

    static byte[] calculateTLSVerifyData(TlsContext tlsContext, String string, byte[] byArray) {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        TlsSecret tlsSecret = securityParameters.getMasterSecret();
        int n = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(tlsContext, tlsSecret, string, byArray, n).extract();
    }

    public static short getHashAlgorithmForHMACAlgorithm(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(n));
    }

    public static short getHashAlgorithmForPRFAlgorithm(int n) {
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(n));
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short s) {
        switch (s) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(s));
    }

    static byte[] calculateSignatureHash(TlsContext tlsContext, SignatureAndHashAlgorithm signatureAndHashAlgorithm, DigestInputBuffer digestInputBuffer) {
        TlsCrypto tlsCrypto = tlsContext.getCrypto();
        TlsHash tlsHash = signatureAndHashAlgorithm == null ? new CombinedHash(tlsCrypto) : tlsCrypto.createHash(signatureAndHashAlgorithm.getHash());
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        byte[] byArray = securityParameters.getClientRandom();
        byte[] byArray2 = securityParameters.getServerRandom();
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(byArray2, 0, byArray2.length);
        digestInputBuffer.updateDigest(tlsHash);
        return tlsHash.calculateHash();
    }

    static void sendSignatureInput(TlsContext tlsContext, DigestInputBuffer digestInputBuffer, OutputStream outputStream) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        outputStream.write(Arrays.concatenate((byte[])securityParameters.getClientRandom(), (byte[])securityParameters.getServerRandom()));
        digestInputBuffer.copyTo(outputStream);
        outputStream.close();
    }

    static DigitallySigned generateCertificateVerify(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner, TlsStreamSigner tlsStreamSigner, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        byte[] byArray;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(tlsContext, tlsCredentialedSigner);
        if (tlsStreamSigner != null) {
            tlsHandshakeHash.copyBufferTo(tlsStreamSigner.getOutputStream());
            byArray = tlsStreamSigner.getSignature();
        } else {
            byte[] byArray2 = signatureAndHashAlgorithm == null ? tlsContext.getSecurityParametersHandshake().getSessionHash() : tlsHandshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            byArray = tlsCredentialedSigner.generateRawSignature(byArray2);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }

    static void verifyCertificateVerify(TlsServerContext tlsServerContext, CertificateRequest certificateRequest, DigitallySigned digitallySigned, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        short s;
        short s2;
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        Certificate certificate = securityParameters.getPeerCertificate();
        TlsCertificate tlsCertificate = certificate.getCertificateAt(0);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (null == signatureAndHashAlgorithm) {
            s2 = tlsCertificate.getLegacySignatureAlgorithm();
            s = TlsUtils.getLegacyClientCertType(s2);
            if (s < 0 || !Arrays.contains((short[])certificateRequest.getCertificateTypes(), (short)s)) {
                throw new TlsFatalAlert(47);
            }
        } else {
            s2 = signatureAndHashAlgorithm.getSignature();
            if (!TlsUtils.isValidSignatureAlgorithmForCertificateVerify(s2, certificateRequest.getCertificateTypes())) {
                throw new TlsFatalAlert(47);
            }
            TlsUtils.verifySupportedSignatureAlgorithm(certificateRequest.getSupportedSignatureAlgorithms(), signatureAndHashAlgorithm);
        }
        try {
            TlsVerifier tlsVerifier = tlsCertificate.createVerifier(s2);
            TlsStreamVerifier tlsStreamVerifier = tlsVerifier.getStreamVerifier(digitallySigned);
            if (tlsStreamVerifier != null) {
                tlsHandshakeHash.copyBufferTo(tlsStreamVerifier.getOutputStream());
                s = (short)(tlsStreamVerifier.isVerified() ? 1 : 0);
            } else {
                byte[] byArray = TlsUtils.isTLSv12(tlsServerContext) ? tlsHandshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash()) : securityParameters.getSessionHash();
                s = (short)(tlsVerifier.verifyRawSignature(digitallySigned, byArray) ? 1 : 0);
            }
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
        if (s == 0) {
            throw new TlsFatalAlert(51);
        }
    }

    static void generateServerKeyExchangeSignature(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner, DigestInputBuffer digestInputBuffer) throws IOException {
        Object object;
        byte[] byArray;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(tlsContext, tlsCredentialedSigner);
        TlsStreamSigner tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
        if (tlsStreamSigner != null) {
            TlsUtils.sendSignatureInput(tlsContext, digestInputBuffer, tlsStreamSigner.getOutputStream());
            byArray = tlsStreamSigner.getSignature();
        } else {
            object = TlsUtils.calculateSignatureHash(tlsContext, signatureAndHashAlgorithm, digestInputBuffer);
            byArray = tlsCredentialedSigner.generateRawSignature((byte[])object);
        }
        object = new DigitallySigned(signatureAndHashAlgorithm, byArray);
        ((DigitallySigned)object).encode(digestInputBuffer);
    }

    static void verifyServerKeyExchangeSignature(TlsContext tlsContext, InputStream inputStream, TlsCertificate tlsCertificate, DigestInputBuffer digestInputBuffer) throws IOException {
        boolean bl;
        Object object;
        short s;
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsContext, inputStream);
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        int n = securityParameters.getKeyExchangeAlgorithm();
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null) {
            s = TlsUtils.getLegacySignatureAlgorithmServer(n);
        } else {
            s = signatureAndHashAlgorithm.getSignature();
            if (!TlsUtils.isValidSignatureAlgorithmForServerKeyExchange(s, n)) {
                throw new TlsFatalAlert(47);
            }
            object = securityParameters.getClientSigAlgs();
            TlsUtils.verifySupportedSignatureAlgorithm((Vector)object, signatureAndHashAlgorithm);
        }
        object = tlsCertificate.createVerifier(s);
        TlsStreamVerifier tlsStreamVerifier = object.getStreamVerifier(digitallySigned);
        if (tlsStreamVerifier != null) {
            TlsUtils.sendSignatureInput(tlsContext, digestInputBuffer, tlsStreamVerifier.getOutputStream());
            bl = tlsStreamVerifier.isVerified();
        } else {
            byte[] byArray = TlsUtils.calculateSignatureHash(tlsContext, signatureAndHashAlgorithm, digestInputBuffer);
            bl = object.verifyRawSignature(digitallySigned, byArray);
        }
        if (!bl) {
            throw new TlsFatalAlert(51);
        }
    }

    static void trackHashAlgorithms(TlsHandshakeHash tlsHandshakeHash, Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i);
                short s = signatureAndHashAlgorithm.getHash();
                if (8 == s) {
                    tlsHandshakeHash.forceBuffering();
                    continue;
                }
                if (!HashAlgorithm.isRecognized(s)) continue;
                tlsHandshakeHash.trackHashAlgorithm(s);
            }
        }
    }

    public static boolean hasSigningCapability(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static Vector vectorOfOne(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return vector;
    }

    public static int getCipherType(int n) {
        switch (TlsUtils.getEncryptionAlgorithm(n)) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 103: 
            case 104: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static int getEncryptionAlgorithm(int n) {
        switch (n) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 4868: 
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: 
            case 53253: {
                return 15;
            }
            case 4869: 
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: 
            case 53251: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 4865: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 53249: {
                return 10;
            }
            case 65280: 
            case 65282: 
            case 65284: 
            case 65296: 
            case 65298: 
            case 65300: {
                return 103;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 4866: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 53250: {
                return 11;
            }
            case 65281: 
            case 65283: 
            case 65285: 
            case 65297: 
            case 65299: 
            case 65301: {
                return 104;
            }
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: {
                return 22;
            }
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49258: 
            case 49260: 
            case 49262: {
                return 24;
            }
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: {
                return 23;
            }
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49259: 
            case 49261: 
            case 49263: {
                return 25;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 4867: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
        }
        return -1;
    }

    public static int getKeyExchangeAlgorithm(int n) {
        switch (n) {
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49222: 
            case 49223: 
            case 49242: 
            case 49243: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49214: 
            case 49215: 
            case 49240: 
            case 49241: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49216: 
            case 49217: 
            case 49236: 
            case 49237: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49218: 
            case 49219: 
            case 49238: 
            case 49239: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49254: 
            case 49255: 
            case 49260: 
            case 49261: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: 
            case 65298: 
            case 65299: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49220: 
            case 49221: 
            case 49234: 
            case 49235: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: 
            case 65280: 
            case 65281: {
                return 5;
            }
            case 49173: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49226: 
            case 49227: 
            case 49246: 
            case 49247: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49230: 
            case 49231: 
            case 49250: 
            case 49251: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49224: 
            case 49225: 
            case 49244: 
            case 49245: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: 
            case 65284: 
            case 65285: {
                return 17;
            }
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49264: 
            case 49265: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65300: 
            case 65301: {
                return 24;
            }
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49228: 
            case 49229: 
            case 49248: 
            case 49249: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: 
            case 65282: 
            case 65283: {
                return 19;
            }
            case 44: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49252: 
            case 49253: 
            case 49258: 
            case 49259: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: 
            case 65296: 
            case 65297: {
                return 13;
            }
            case 2: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49212: 
            case 49213: 
            case 49232: 
            case 49233: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49256: 
            case 49257: 
            case 49262: 
            case 49263: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        return -1;
    }

    public static Vector getKeyExchangeAlgorithms(int[] nArray) {
        Vector vector = new Vector();
        if (null != nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                TlsUtils.addToSet(vector, TlsUtils.getKeyExchangeAlgorithm(nArray[i]));
            }
            vector.removeElement(Integers.valueOf((int)-1));
        }
        return vector;
    }

    public static int getMACAlgorithm(int n) {
        switch (n) {
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return 0;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        return -1;
    }

    public static ProtocolVersion getMinimumVersion(int n) {
        switch (n) {
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: {
                return ProtocolVersion.TLSv13;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49212: 
            case 49213: 
            case 49214: 
            case 49215: 
            case 49216: 
            case 49217: 
            case 49218: 
            case 49219: 
            case 49220: 
            case 49221: 
            case 49222: 
            case 49223: 
            case 49224: 
            case 49225: 
            case 49226: 
            case 49227: 
            case 49228: 
            case 49229: 
            case 49230: 
            case 49231: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49252: 
            case 49253: 
            case 49254: 
            case 49255: 
            case 49256: 
            case 49257: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49264: 
            case 49265: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static Vector getNamedGroupRoles(int[] nArray) {
        return TlsUtils.getNamedGroupRoles(TlsUtils.getKeyExchangeAlgorithms(nArray));
    }

    public static Vector getNamedGroupRoles(Vector vector) {
        Vector vector2 = new Vector();
        block5: for (int i = 0; i < vector.size(); ++i) {
            int n = (Integer)vector.elementAt(i);
            switch (n) {
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    TlsUtils.addToSet(vector2, 1);
                    continue block5;
                }
                case 18: 
                case 19: 
                case 20: 
                case 24: {
                    TlsUtils.addToSet(vector2, 2);
                    continue block5;
                }
                case 16: 
                case 17: {
                    TlsUtils.addToSet(vector2, 2);
                    TlsUtils.addToSet(vector2, 3);
                }
            }
        }
        return vector2;
    }

    public static boolean isAEADCipherSuite(int n) throws IOException {
        return 2 == TlsUtils.getCipherType(n);
    }

    public static boolean isBlockCipherSuite(int n) throws IOException {
        return 1 == TlsUtils.getCipherType(n);
    }

    public static boolean isStreamCipherSuite(int n) throws IOException {
        return 0 == TlsUtils.getCipherType(n);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int n, Vector vector) {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 11: 
            case 20: {
                return true;
            }
            case 5: 
            case 19: 
            case 23: {
                return vector.contains(Shorts.valueOf((short)1)) || vector.contains(Shorts.valueOf((short)4)) || vector.contains(Shorts.valueOf((short)5)) || vector.contains(Shorts.valueOf((short)6)) || vector.contains(Shorts.valueOf((short)9)) || vector.contains(Shorts.valueOf((short)10)) || vector.contains(Shorts.valueOf((short)11));
            }
            case 3: 
            case 22: {
                return vector.contains(Shorts.valueOf((short)2));
            }
            case 17: {
                return vector.contains(Shorts.valueOf((short)3)) || vector.contains(Shorts.valueOf((short)7)) || vector.contains(Shorts.valueOf((short)8));
            }
        }
        return true;
    }

    public static boolean isValidCipherSuiteForVersion(int n, ProtocolVersion protocolVersion) {
        return TlsUtils.getMinimumVersion(n).isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    static boolean isValidSignatureAlgorithmForCertificateVerify(short s, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!TlsUtils.isValidSignatureAlgorithmForClientCertType(s, sArray[i])) continue;
            return true;
        }
        return false;
    }

    static boolean isValidSignatureAlgorithmForClientCertType(short s, short s2) {
        switch (s2) {
            case 1: {
                switch (s) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                return 2 == s;
            }
            case 64: {
                switch (s) {
                    case 3: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    static boolean isValidSignatureAlgorithmForServerKeyExchange(short s, int n) {
        switch (n) {
            case 5: 
            case 19: 
            case 23: {
                switch (s) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 3: 
            case 22: {
                return 2 == s;
            }
            case 17: {
                switch (s) {
                    case 3: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(TlsContext tlsContext, Vector vector, short s) throws IOException {
        if (!TlsUtils.isTLSv12(tlsContext)) {
            return null;
        }
        if (vector == null) {
            vector = TlsUtils.getDefaultSignatureAlgorithms(s);
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        for (int i = 0; i < vector.size(); ++i) {
            short s2;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm2 = (SignatureAndHashAlgorithm)vector.elementAt(i);
            if (signatureAndHashAlgorithm2.getSignature() != s || (s2 = signatureAndHashAlgorithm2.getHash()) < MINIMUM_HASH_STRICT) continue;
            if (signatureAndHashAlgorithm == null) {
                signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                continue;
            }
            short s3 = signatureAndHashAlgorithm.getHash();
            if (s3 < MINIMUM_HASH_PREFERRED) {
                if (s2 <= s3) continue;
                signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                continue;
            }
            if (s2 < MINIMUM_HASH_PREFERRED || s2 >= s3) continue;
            signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
        }
        if (signatureAndHashAlgorithm == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static Vector getUsableSignatureAlgorithms(Vector vector) {
        if (vector == null) {
            Vector<Short> vector2 = new Vector<Short>(3);
            vector2.addElement(Shorts.valueOf((short)1));
            vector2.addElement(Shorts.valueOf((short)2));
            vector2.addElement(Shorts.valueOf((short)3));
            return vector2;
        }
        Vector<Short> vector3 = new Vector<Short>();
        for (int i = 0; i < vector.size(); ++i) {
            Short s;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i);
            if (signatureAndHashAlgorithm.getHash() < MINIMUM_HASH_STRICT || vector3.contains(s = Shorts.valueOf((short)signatureAndHashAlgorithm.getSignature()))) continue;
            vector3.addElement(s);
        }
        return vector3;
    }

    public static int[] getCommonCipherSuites(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        if (bl) {
            nArray3 = nArray2;
            nArray4 = nArray;
        }
        int n = 0;
        int n2 = Math.min(nArray3.length, nArray4.length);
        int[] nArray5 = new int[n2];
        for (int i = 0; i < nArray3.length; ++i) {
            int n3 = nArray3[i];
            if (TlsUtils.contains(nArray5, 0, n, n3) || !Arrays.contains((int[])nArray4, (int)n3)) continue;
            nArray5[n++] = n3;
        }
        if (n < n2) {
            nArray5 = Arrays.copyOf((int[])nArray5, (int)n);
        }
        return nArray5;
    }

    public static int[] getSupportedCipherSuites(TlsCrypto tlsCrypto, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (!TlsUtils.isSupportedCipherSuite(tlsCrypto, n2)) continue;
            nArray2[n++] = n2;
        }
        if (n < nArray2.length) {
            nArray2 = Arrays.copyOf((int[])nArray2, (int)n);
        }
        return nArray2;
    }

    public static boolean isSupportedCipherSuite(TlsCrypto tlsCrypto, int n) {
        return TlsUtils.isSupportedKeyExchange(tlsCrypto, TlsUtils.getKeyExchangeAlgorithm(n)) && tlsCrypto.hasEncryptionAlgorithm(TlsUtils.getEncryptionAlgorithm(n)) && tlsCrypto.hasMacAlgorithm(TlsUtils.getMACAlgorithm(n));
    }

    public static boolean isSupportedKeyExchange(TlsCrypto tlsCrypto, int n) {
        switch (n) {
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                return tlsCrypto.hasDHAgreement();
            }
            case 3: {
                return tlsCrypto.hasDHAgreement() && tlsCrypto.hasSignatureAlgorithm((short)2);
            }
            case 5: {
                return tlsCrypto.hasDHAgreement() && TlsUtils.hasAnyRSASigAlgs(tlsCrypto);
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                return tlsCrypto.hasECDHAgreement();
            }
            case 17: {
                return tlsCrypto.hasECDHAgreement() && (tlsCrypto.hasSignatureAlgorithm((short)3) || tlsCrypto.hasSignatureAlgorithm((short)7) || tlsCrypto.hasSignatureAlgorithm((short)8));
            }
            case 19: {
                return tlsCrypto.hasECDHAgreement() && TlsUtils.hasAnyRSASigAlgs(tlsCrypto);
            }
            case 0: 
            case 13: {
                return true;
            }
            case 1: 
            case 15: {
                return tlsCrypto.hasRSAEncryption();
            }
            case 21: {
                return tlsCrypto.hasSRPAuthentication();
            }
            case 22: {
                return tlsCrypto.hasSRPAuthentication() && tlsCrypto.hasSignatureAlgorithm((short)2);
            }
            case 23: {
                return tlsCrypto.hasSRPAuthentication() && TlsUtils.hasAnyRSASigAlgs(tlsCrypto);
            }
        }
        return false;
    }

    static boolean hasAnyRSASigAlgs(TlsCrypto tlsCrypto) {
        return tlsCrypto.hasSignatureAlgorithm((short)1) || tlsCrypto.hasSignatureAlgorithm((short)4) || tlsCrypto.hasSignatureAlgorithm((short)5) || tlsCrypto.hasSignatureAlgorithm((short)6) || tlsCrypto.hasSignatureAlgorithm((short)9) || tlsCrypto.hasSignatureAlgorithm((short)10) || tlsCrypto.hasSignatureAlgorithm((short)11);
    }

    static byte[] getCurrentPRFHash(TlsHandshakeHash tlsHandshakeHash) {
        return tlsHandshakeHash.forkPRFHash().calculateHash();
    }

    static void sealHandshakeHash(TlsContext tlsContext, TlsHandshakeHash tlsHandshakeHash, boolean bl) {
        if (bl || !tlsContext.getCrypto().hasAllRawSignatureAlgorithms()) {
            tlsHandshakeHash.forceBuffering();
        }
        tlsHandshakeHash.sealHashAlgorithms();
    }

    private static TlsKeyExchange createKeyExchangeClient(TlsClient tlsClient, int n) throws IOException {
        TlsKeyExchangeFactory tlsKeyExchangeFactory = tlsClient.getKeyExchangeFactory();
        switch (n) {
            case 11: {
                return tlsKeyExchangeFactory.createDHanonKeyExchangeClient(n, tlsClient.getDHGroupVerifier());
            }
            case 7: 
            case 9: {
                return tlsKeyExchangeFactory.createDHKeyExchange(n);
            }
            case 3: 
            case 5: {
                return tlsKeyExchangeFactory.createDHEKeyExchangeClient(n, tlsClient.getDHGroupVerifier());
            }
            case 20: {
                return tlsKeyExchangeFactory.createECDHanonKeyExchangeClient(n);
            }
            case 16: 
            case 18: {
                return tlsKeyExchangeFactory.createECDHKeyExchange(n);
            }
            case 17: 
            case 19: {
                return tlsKeyExchangeFactory.createECDHEKeyExchangeClient(n);
            }
            case 1: {
                return tlsKeyExchangeFactory.createRSAKeyExchange(n);
            }
            case 14: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeClient(n, tlsClient.getPSKIdentity(), tlsClient.getDHGroupVerifier());
            }
            case 13: 
            case 15: 
            case 24: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeClient(n, tlsClient.getPSKIdentity(), null);
            }
            case 21: 
            case 22: 
            case 23: {
                return tlsKeyExchangeFactory.createSRPKeyExchangeClient(n, tlsClient.getSRPIdentity(), tlsClient.getSRPConfigVerifier());
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static TlsKeyExchange createKeyExchangeServer(TlsServer tlsServer, int n) throws IOException {
        TlsKeyExchangeFactory tlsKeyExchangeFactory = tlsServer.getKeyExchangeFactory();
        switch (n) {
            case 11: {
                return tlsKeyExchangeFactory.createDHanonKeyExchangeServer(n, tlsServer.getDHConfig());
            }
            case 7: 
            case 9: {
                return tlsKeyExchangeFactory.createDHKeyExchange(n);
            }
            case 3: 
            case 5: {
                return tlsKeyExchangeFactory.createDHEKeyExchangeServer(n, tlsServer.getDHConfig());
            }
            case 20: {
                return tlsKeyExchangeFactory.createECDHanonKeyExchangeServer(n, tlsServer.getECDHConfig());
            }
            case 16: 
            case 18: {
                return tlsKeyExchangeFactory.createECDHKeyExchange(n);
            }
            case 17: 
            case 19: {
                return tlsKeyExchangeFactory.createECDHEKeyExchangeServer(n, tlsServer.getECDHConfig());
            }
            case 1: {
                return tlsKeyExchangeFactory.createRSAKeyExchange(n);
            }
            case 14: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeServer(n, tlsServer.getPSKIdentityManager(), tlsServer.getDHConfig(), null);
            }
            case 24: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeServer(n, tlsServer.getPSKIdentityManager(), null, tlsServer.getECDHConfig());
            }
            case 13: 
            case 15: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeServer(n, tlsServer.getPSKIdentityManager(), null, null);
            }
            case 21: 
            case 22: 
            case 23: {
                return tlsKeyExchangeFactory.createSRPKeyExchangeServer(n, tlsServer.getSRPLoginParameters());
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static TlsKeyExchange initKeyExchange(TlsContext tlsContext, TlsKeyExchange tlsKeyExchange) throws IOException {
        tlsKeyExchange.init(tlsContext);
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(tlsContext.getServerVersion())) {
            if (null == securityParameters.getClientSigAlgs()) {
                short s = TlsUtils.getLegacySignatureAlgorithmServerCert(securityParameters.getKeyExchangeAlgorithm());
                securityParameters.clientSigAlgs = TlsUtils.getDefaultSignatureAlgorithms(s);
            }
            if (null == securityParameters.getClientSigAlgsCert()) {
                securityParameters.clientSigAlgsCert = securityParameters.getClientSigAlgs();
            }
        } else {
            securityParameters.clientSigAlgs = null;
            securityParameters.clientSigAlgsCert = null;
        }
        return tlsKeyExchange;
    }

    static TlsKeyExchange initKeyExchangeClient(TlsClientContext tlsClientContext, TlsClient tlsClient) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        int n = securityParameters.getCipherSuite();
        securityParameters.keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(n);
        TlsKeyExchange tlsKeyExchange = TlsUtils.createKeyExchangeClient(tlsClient, securityParameters.getKeyExchangeAlgorithm());
        return TlsUtils.initKeyExchange(tlsClientContext, tlsKeyExchange);
    }

    static TlsKeyExchange initKeyExchangeServer(TlsServerContext tlsServerContext, TlsServer tlsServer) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        int n = securityParameters.getCipherSuite();
        securityParameters.keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(n);
        TlsKeyExchange tlsKeyExchange = TlsUtils.createKeyExchangeServer(tlsServer, securityParameters.getKeyExchangeAlgorithm());
        return TlsUtils.initKeyExchange(tlsServerContext, tlsKeyExchange);
    }

    static TlsCipher initCipher(TlsContext tlsContext) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        int n = securityParameters.getCipherSuite();
        int n2 = TlsUtils.getEncryptionAlgorithm(n);
        int n3 = TlsUtils.getMACAlgorithm(n);
        if (n2 < 0 || n3 < 0) {
            throw new TlsFatalAlert(80);
        }
        TlsSecret tlsSecret = tlsContext.getSecurityParametersHandshake().getMasterSecret();
        return tlsSecret.createCipher(new TlsCryptoParameters(tlsContext), n2, n3);
    }

    static void checkSigAlgOfClientCerts(TlsContext tlsContext, Certificate certificate, CertificateRequest certificateRequest) throws IOException {
        Vector vector = certificateRequest.getSupportedSignatureAlgorithms();
        for (int i = 0; i < certificate.getLength(); ++i) {
            String string = certificate.getCertificateAt(i).getSigAlgOID();
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getCertSigAndHashAlg(string);
            boolean bl = false;
            if (null != signatureAndHashAlgorithm) {
                if (null == vector) {
                    short[] sArray = certificateRequest.getCertificateTypes();
                    for (int j = 0; j < sArray.length; ++j) {
                        if (signatureAndHashAlgorithm.getSignature() != TlsUtils.getLegacySignatureAlgorithmClientCert(sArray[j])) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = TlsUtils.containsSignatureAlgorithm(vector, signatureAndHashAlgorithm);
                }
            }
            if (bl) continue;
            throw new TlsFatalAlert(42);
        }
    }

    static void checkSigAlgOfServerCerts(TlsContext tlsContext, Certificate certificate) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        Vector vector = securityParameters.getClientSigAlgsCert();
        for (int i = 0; i < certificate.getLength(); ++i) {
            String string = certificate.getCertificateAt(i).getSigAlgOID();
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getCertSigAndHashAlg(string);
            boolean bl = false;
            if (null != signatureAndHashAlgorithm) {
                short s;
                bl = null == vector ? (s = TlsUtils.getLegacySignatureAlgorithmServerCert(securityParameters.getKeyExchangeAlgorithm())) == signatureAndHashAlgorithm.getSignature() : TlsUtils.containsSignatureAlgorithm(vector, signatureAndHashAlgorithm);
            }
            if (bl) continue;
            throw new TlsFatalAlert(42);
        }
    }

    static void checkTlsFeatures(Certificate certificate, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        byte[] byArray = certificate.getCertificateAt(0).getExtension(TlsObjectIdentifiers.id_pe_tlsfeature);
        if (byArray != null) {
            Enumeration enumeration = ((ASN1Sequence)TlsUtils.readDERObject(byArray)).getObjects();
            while (enumeration.hasMoreElements()) {
                Integer n;
                BigInteger bigInteger = ((ASN1Integer)enumeration.nextElement()).getPositiveValue();
                if (bigInteger.bitLength() > 16 || !hashtable.containsKey(n = Integers.valueOf((int)bigInteger.intValue())) || hashtable2.containsKey(n)) continue;
                throw new TlsFatalAlert(46);
            }
        }
    }

    static void processClientCertificate(TlsServerContext tlsServerContext, Certificate certificate, CertificateRequest certificateRequest, TlsKeyExchange tlsKeyExchange, TlsServer tlsServer) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        if (null == certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        if (certificate.isEmpty()) {
            tlsKeyExchange.skipClientCredentials();
        } else {
            if (tlsServer.shouldCheckSigAlgOfPeerCerts()) {
                TlsUtils.checkSigAlgOfClientCerts(tlsServerContext, certificate, certificateRequest);
            }
            tlsKeyExchange.processClientCertificate(certificate);
        }
        securityParameters.peerCertificate = certificate;
        tlsServer.notifyClientCertificate(certificate);
    }

    static void processServerCertificate(TlsClientContext tlsClientContext, TlsClient tlsClient, CertificateStatus certificateStatus, TlsKeyExchange tlsKeyExchange, TlsAuthentication tlsAuthentication, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        if (null == tlsAuthentication) {
            tlsKeyExchange.skipServerCredentials();
            securityParameters.tlsServerEndPoint = EMPTY_BYTES;
            return;
        }
        Certificate certificate = securityParameters.getPeerCertificate();
        TlsUtils.checkTlsFeatures(certificate, hashtable, hashtable2);
        if (tlsClient.shouldCheckSigAlgOfPeerCerts()) {
            TlsUtils.checkSigAlgOfServerCerts(tlsClientContext, certificate);
        }
        tlsKeyExchange.processServerCertificate(certificate);
        tlsAuthentication.notifyServerCertificate(new TlsServerCertificateImpl(certificate, certificateStatus));
    }

    static SignatureAndHashAlgorithm getCertSigAndHashAlg(String string) {
        return (SignatureAndHashAlgorithm)CERT_SIG_ALG_OIDS.get(string);
    }

    static CertificateRequest validateCertificateRequest(CertificateRequest certificateRequest, TlsKeyExchange tlsKeyExchange) throws IOException {
        short[] sArray = tlsKeyExchange.getClientCertificateTypes();
        if (sArray == null || sArray.length < 1) {
            throw new TlsFatalAlert(10);
        }
        if ((certificateRequest = TlsUtils.normalizeCertificateRequest(certificateRequest, sArray)) == null) {
            throw new TlsFatalAlert(47);
        }
        return certificateRequest;
    }

    static CertificateRequest normalizeCertificateRequest(CertificateRequest certificateRequest, short[] sArray) {
        if (TlsUtils.containsAll(sArray, certificateRequest.getCertificateTypes())) {
            return certificateRequest;
        }
        short[] sArray2 = TlsUtils.retainAll(certificateRequest.getCertificateTypes(), sArray);
        if (sArray2.length < 1) {
            return null;
        }
        return new CertificateRequest(sArray2, certificateRequest.getSupportedSignatureAlgorithms(), certificateRequest.getCertificateAuthorities());
    }

    static boolean contains(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            if (n3 != nArray[n + i]) continue;
            return true;
        }
        return false;
    }

    static boolean containsAll(short[] sArray, short[] sArray2) {
        for (int i = 0; i < sArray2.length; ++i) {
            if (Arrays.contains((short[])sArray, (short)sArray2[i])) continue;
            return false;
        }
        return true;
    }

    static short[] retainAll(short[] sArray, short[] sArray2) {
        short[] sArray3 = new short[Math.min(sArray.length, sArray2.length)];
        int n = 0;
        for (int i = 0; i < sArray2.length; ++i) {
            if (!Arrays.contains((short[])sArray, (short)sArray2[i])) continue;
            sArray3[n++] = sArray2[i];
        }
        return TlsUtils.truncate(sArray3, n);
    }

    static short[] truncate(short[] sArray, int n) {
        if (n < sArray.length) {
            return sArray;
        }
        short[] sArray2 = new short[n];
        System.arraycopy(sArray, 0, sArray2, 0, n);
        return sArray2;
    }

    static TlsCredentialedAgreement requireAgreementCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedAgreement)tlsCredentials;
    }

    static TlsCredentialedDecryptor requireDecryptorCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedDecryptor)tlsCredentials;
    }

    static TlsCredentialedSigner requireSignerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSigner)tlsCredentials;
    }

    private static void checkDowngradeMarker(byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = Arrays.copyOfRange((byte[])byArray, (int)(byArray.length - byArray2.length), (int)byArray.length);
        if (Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])byArray2)) {
            throw new TlsFatalAlert(47);
        }
    }

    static void checkDowngradeMarker(ProtocolVersion protocolVersion, byte[] byArray) throws IOException {
        if ((protocolVersion = protocolVersion.getEquivalentTLSVersion()).isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            TlsUtils.checkDowngradeMarker(byArray, DOWNGRADE_TLS11);
        }
        if (protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv12)) {
            TlsUtils.checkDowngradeMarker(byArray, DOWNGRADE_TLS12);
        }
    }

    static void writeDowngradeMarker(ProtocolVersion protocolVersion, byte[] byArray) throws IOException {
        byte[] byArray2;
        if (ProtocolVersion.TLSv12 == (protocolVersion = protocolVersion.getEquivalentTLSVersion())) {
            byArray2 = DOWNGRADE_TLS12;
        } else if (protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            byArray2 = DOWNGRADE_TLS11;
        } else {
            throw new TlsFatalAlert(80);
        }
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
    }

    static void receiveServerCertificate(TlsClientContext tlsClientContext, ByteArrayInputStream byteArrayInputStream) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Certificate certificate = Certificate.parse(tlsClientContext, byteArrayInputStream, byteArrayOutputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        securityParameters.peerCertificate = certificate;
        securityParameters.tlsServerEndPoint = byteArrayOutputStream.toByteArray();
    }

    public static boolean containsNonAscii(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 128) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonAscii(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') continue;
            return true;
        }
        return false;
    }

    static Hashtable addEarlyKeySharesToClientHello(TlsContext tlsContext, TlsClient tlsClient, Hashtable hashtable) throws IOException {
        if (!TlsUtils.isTLSv13(tlsContext.getClientVersion())) {
            return null;
        }
        int[] nArray = TlsExtensionsUtils.getSupportedGroupsExtension(hashtable);
        if (null == nArray || nArray.length < 1) {
            return null;
        }
        Vector vector = tlsClient.getEarlyKeyShareGroups();
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        TlsCrypto tlsCrypto = tlsContext.getCrypto();
        Vector<KeyShareEntry> vector2 = new Vector<KeyShareEntry>();
        Hashtable<Integer, TlsAgreement> hashtable2 = new Hashtable<Integer, TlsAgreement>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Integer n2 = Integers.valueOf((int)n);
            if (!vector.contains(n2) || hashtable2.containsKey(n2) || !tlsCrypto.hasNamedGroup(n)) continue;
            TlsAgreement tlsAgreement = null;
            if (NamedGroup.refersToASpecificCurve(n)) {
                if (tlsCrypto.hasECDHAgreement()) {
                    tlsAgreement = tlsCrypto.createECDomain(new TlsECConfig(n)).createECDH();
                }
            } else if (NamedGroup.refersToASpecificFiniteField(n) && tlsCrypto.hasDHAgreement()) {
                tlsAgreement = tlsCrypto.createDHDomain(new TlsDHConfig(n, true)).createDH();
            }
            if (null == tlsAgreement) continue;
            byte[] byArray = tlsAgreement.generateEphemeral();
            KeyShareEntry keyShareEntry = new KeyShareEntry(n, byArray);
            vector2.addElement(keyShareEntry);
            hashtable2.put(n2, tlsAgreement);
        }
        if (hashtable2.isEmpty()) {
            return null;
        }
        TlsExtensionsUtils.addKeyShareClientHello(hashtable, vector2);
        return hashtable2;
    }
}

