/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.tree.AnnotationNode;
import org.jruby.org.objectweb.asm.tree.FieldNode;
import org.jruby.org.objectweb.asm.tree.InnerClassNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.ModuleNode;
import org.jruby.org.objectweb.asm.tree.TypeAnnotationNode;
import org.jruby.org.objectweb.asm.tree.UnsupportedClassVersionException;
import org.jruby.org.objectweb.asm.tree.Util;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public ModuleNode module;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public String nestHostClass;
    public List<String> nestMembers;
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(458752);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int api) {
        super(api);
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        this.version = version;
        this.access = access;
        this.name = name2;
        this.signature = signature;
        this.superName = superName;
        this.interfaces = Util.asArrayList(interfaces2);
    }

    public void visitSource(String file2, String debug) {
        this.sourceFile = file2;
        this.sourceDebug = debug;
    }

    public ModuleVisitor visitModule(String name2, int access, String version) {
        this.module = new ModuleNode(name2, access, version);
        return this.module;
    }

    public void visitNestHost(String nestHost) {
        this.nestHostClass = nestHost;
    }

    public void visitOuterClass(String owner2, String name2, String descriptor) {
        this.outerClass = owner2;
        this.outerMethod = name2;
        this.outerMethodDesc = descriptor;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationNode annotation2 = new AnnotationNode(descriptor);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(annotation2);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(annotation2);
        }
        return annotation2;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, typePath, descriptor);
        if (visible) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.visibleTypeAnnotations.add(typeAnnotation);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.invisibleTypeAnnotations.add(typeAnnotation);
        }
        return typeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(1);
        }
        this.attrs.add(attribute);
    }

    public void visitNestMember(String nestMember) {
        if (this.nestMembers == null) {
            this.nestMembers = new ArrayList<String>();
        }
        this.nestMembers.add(nestMember);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        InnerClassNode innerClass = new InnerClassNode(name2, outerName, innerName, access);
        this.innerClasses.add(innerClass);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        FieldNode field2 = new FieldNode(access, name2, descriptor, signature, value2);
        this.fields.add(field2);
        return field2;
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        MethodNode method2 = new MethodNode(access, name2, descriptor, signature, exceptions);
        this.methods.add(method2);
        return method2;
    }

    public void visitEnd() {
    }

    public void check(int api) {
        int i2;
        if (api < 458752 && (this.nestHostClass != null || this.nestMembers != null)) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 393216 && this.module != null) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 327680) {
            if (this.visibleTypeAnnotations != null && !this.visibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleTypeAnnotations != null && !this.invisibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
        }
        if (this.visibleAnnotations != null) {
            for (i2 = this.visibleAnnotations.size() - 1; i2 >= 0; --i2) {
                this.visibleAnnotations.get(i2).check(api);
            }
        }
        if (this.invisibleAnnotations != null) {
            for (i2 = this.invisibleAnnotations.size() - 1; i2 >= 0; --i2) {
                this.invisibleAnnotations.get(i2).check(api);
            }
        }
        if (this.visibleTypeAnnotations != null) {
            for (i2 = this.visibleTypeAnnotations.size() - 1; i2 >= 0; --i2) {
                this.visibleTypeAnnotations.get(i2).check(api);
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (i2 = this.invisibleTypeAnnotations.size() - 1; i2 >= 0; --i2) {
                this.invisibleTypeAnnotations.get(i2).check(api);
            }
        }
        for (i2 = this.fields.size() - 1; i2 >= 0; --i2) {
            this.fields.get(i2).check(api);
        }
        for (i2 = this.methods.size() - 1; i2 >= 0; --i2) {
            this.methods.get(i2).check(api);
        }
    }

    public void accept(ClassVisitor classVisitor) {
        TypeAnnotationNode typeAnnotation;
        AnnotationNode annotation2;
        int i2;
        int n;
        String[] interfacesArray = new String[this.interfaces.size()];
        this.interfaces.toArray(interfacesArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, interfacesArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.module != null) {
            this.module.accept(classVisitor);
        }
        if (this.nestHostClass != null) {
            classVisitor.visitNestHost(this.nestHostClass);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        if (this.visibleAnnotations != null) {
            n = this.visibleAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                annotation2 = this.visibleAnnotations.get(i2);
                annotation2.accept(classVisitor.visitAnnotation(annotation2.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n = this.invisibleAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                annotation2 = this.invisibleAnnotations.get(i2);
                annotation2.accept(classVisitor.visitAnnotation(annotation2.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                typeAnnotation = this.visibleTypeAnnotations.get(i2);
                typeAnnotation.accept(classVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i2 = 0; i2 < n; ++i2) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i2);
                typeAnnotation.accept(classVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
        if (this.attrs != null) {
            n = this.attrs.size();
            for (i2 = 0; i2 < n; ++i2) {
                classVisitor.visitAttribute(this.attrs.get(i2));
            }
        }
        if (this.nestMembers != null) {
            n = this.nestMembers.size();
            for (i2 = 0; i2 < n; ++i2) {
                classVisitor.visitNestMember(this.nestMembers.get(i2));
            }
        }
        n = this.innerClasses.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.innerClasses.get(i2).accept(classVisitor);
        }
        n = this.fields.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.fields.get(i2).accept(classVisitor);
        }
        n = this.methods.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.methods.get(i2).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

