/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterAwareClient;
import org.elasticsearch.transport.RemoteClusterConnection;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.SniffConnectionStrategy;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;

public final class RemoteClusterService
extends RemoteClusterAware
implements Closeable {
    private static final Logger logger = LogManager.getLogger(RemoteClusterService.class);
    public static final Setting<TimeValue> SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING;
    public static final Setting<TimeValue> REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING;
    public static final Setting<String> SEARCH_REMOTE_NODE_ATTRIBUTE;
    public static final Setting<String> REMOTE_NODE_ATTRIBUTE;
    public static final Setting<Boolean> SEARCH_ENABLE_REMOTE_CLUSTERS;
    public static final Setting<Boolean> ENABLE_REMOTE_CLUSTERS;
    public static final Setting.AffixSetting<Boolean> SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE;
    public static final SettingUpgrader<Boolean> SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE_UPGRADER;
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_SKIP_UNAVAILABLE;
    public static final Setting.AffixSetting<TimeValue> REMOTE_CLUSTER_PING_SCHEDULE;
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_COMPRESS;
    private final TransportService transportService;
    private final Map<String, RemoteClusterConnection> remoteClusters = ConcurrentCollections.newConcurrentMap();

    RemoteClusterService(Settings settings, TransportService transportService) {
        super(settings);
        this.transportService = transportService;
    }

    public boolean isCrossClusterSearchEnabled() {
        return !this.remoteClusters.isEmpty();
    }

    boolean isRemoteNodeConnected(String remoteCluster, DiscoveryNode node) {
        return this.remoteClusters.get(remoteCluster).isNodeConnected(node);
    }

    public Map<String, OriginalIndices> groupIndices(IndicesOptions indicesOptions, String[] indices, Predicate<String> indexExists) {
        HashMap<String, OriginalIndices> originalIndicesMap = new HashMap<String, OriginalIndices>();
        if (this.isCrossClusterSearchEnabled()) {
            Map<String, List<String>> groupedIndices = this.groupClusterIndices(this.getRemoteClusterNames(), indices, indexExists);
            if (groupedIndices.isEmpty()) {
                originalIndicesMap.put("", new OriginalIndices(Strings.EMPTY_ARRAY, indicesOptions));
            } else {
                for (Map.Entry<String, List<String>> entry : groupedIndices.entrySet()) {
                    String clusterAlias = entry.getKey();
                    List<String> originalIndices = entry.getValue();
                    originalIndicesMap.put(clusterAlias, new OriginalIndices(originalIndices.toArray(new String[0]), indicesOptions));
                }
            }
        } else {
            originalIndicesMap.put("", new OriginalIndices(indices, indicesOptions));
        }
        return originalIndicesMap;
    }

    boolean isRemoteClusterRegistered(String clusterName) {
        return this.remoteClusters.containsKey(clusterName);
    }

    public Set<String> getRegisteredRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    public Transport.Connection getConnection(DiscoveryNode node, String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection(node);
    }

    void ensureConnected(String clusterAlias, ActionListener<Void> listener) {
        this.getRemoteClusterConnection(clusterAlias).ensureConnected(listener);
    }

    public boolean isSkipUnavailable(String clusterAlias) {
        return this.getRemoteClusterConnection(clusterAlias).isSkipUnavailable();
    }

    public Transport.Connection getConnection(String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection();
    }

    RemoteClusterConnection getRemoteClusterConnection(String cluster) {
        RemoteClusterConnection connection = this.remoteClusters.get(cluster);
        if (connection == null) {
            throw new NoSuchRemoteClusterException(cluster);
        }
        return connection;
    }

    Set<String> getRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    @Override
    public void listenForUpdates(ClusterSettings clusterSettings) {
        super.listenForUpdates(clusterSettings);
        clusterSettings.addAffixUpdateConsumer(REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::updateSkipUnavailable, (alias, value) -> {});
        clusterSettings.addAffixUpdateConsumer(SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::updateSkipUnavailable, (alias, value) -> {});
    }

    private synchronized void updateSkipUnavailable(String clusterAlias, Boolean skipUnavailable) {
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (remote != null) {
            remote.updateSkipUnavailable(skipUnavailable);
        }
    }

    @Override
    protected void updateRemoteCluster(String clusterAlias, Settings settings) {
        CountDownLatch latch = new CountDownLatch(1);
        this.updateRemoteCluster(clusterAlias, settings, ActionListener.wrap(latch::countDown));
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                logger.warn("failed to connect to new remote cluster {} within {}", (Object)clusterAlias, (Object)TimeValue.timeValueSeconds((long)10L));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized void updateRemoteCluster(String clusterAlias, Settings newSettings, ActionListener<Void> listener) {
        if ("".equals(clusterAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (!RemoteConnectionStrategy.isConnectionEnabled(clusterAlias, newSettings)) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{remote});
            }
            catch (IOException e) {
                logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
            }
            this.remoteClusters.remove(clusterAlias);
            listener.onResponse(null);
            return;
        }
        if (remote == null) {
            Settings finalSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
            remote = new RemoteClusterConnection(finalSettings, clusterAlias, this.transportService);
            this.remoteClusters.put(clusterAlias, remote);
            remote.ensureConnected(listener);
        } else if (remote.shouldRebuildConnection(newSettings)) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{remote});
            }
            catch (IOException e) {
                logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
            }
            this.remoteClusters.remove(clusterAlias);
            Settings finalSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
            remote = new RemoteClusterConnection(finalSettings, clusterAlias, this.transportService);
            this.remoteClusters.put(clusterAlias, remote);
            remote.ensureConnected(listener);
        } else {
            listener.onResponse(null);
        }
    }

    void initializeRemoteClusters() {
        TimeValue timeValue = REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.get(this.settings);
        PlainActionFuture future = new PlainActionFuture();
        Set<String> enabledClusters = RemoteClusterAware.getEnabledRemoteClusters(this.settings);
        if (enabledClusters.isEmpty()) {
            return;
        }
        GroupedActionListener<Void> listener = new GroupedActionListener<Void>(future, enabledClusters.size());
        for (String clusterAlias : enabledClusters) {
            this.updateRemoteCluster(clusterAlias, this.settings, listener);
        }
        if (enabledClusters.isEmpty()) {
            future.onResponse(null);
        }
        try {
            future.get(timeValue.millis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException ex) {
            logger.warn("failed to connect to remote clusters within {}", (Object)timeValue.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to connect to remote clusters", e);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.remoteClusters.values());
    }

    public Stream<RemoteConnectionInfo> getRemoteConnectionInfos() {
        return this.remoteClusters.values().stream().map(RemoteClusterConnection::getConnectionInfo);
    }

    public void collectNodes(Set<String> clusters, final ActionListener<BiFunction<String, String, DiscoveryNode>> listener) {
        Map<String, RemoteClusterConnection> remoteClusters = this.remoteClusters;
        for (String cluster : clusters) {
            if (remoteClusters.containsKey(cluster)) continue;
            listener.onFailure(new NoSuchRemoteClusterException(cluster));
            return;
        }
        final HashMap clusterMap = new HashMap();
        final CountDown countDown = new CountDown(clusters.size());
        final Function<String, DiscoveryNode> nullFunction = s -> null;
        for (final String cluster : clusters) {
            RemoteClusterConnection connection = remoteClusters.get(cluster);
            connection.collectNodes(new ActionListener<Function<String, DiscoveryNode>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Function<String, DiscoveryNode> nodeLookup) {
                    Map map = clusterMap;
                    synchronized (map) {
                        clusterMap.put(cluster, nodeLookup);
                    }
                    if (countDown.countDown()) {
                        listener.onResponse((clusterAlias, nodeId) -> (DiscoveryNode)clusterMap.getOrDefault(clusterAlias, nullFunction).apply(nodeId));
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    public Client getRemoteClusterClient(ThreadPool threadPool, String clusterAlias) {
        if (!this.transportService.getRemoteClusterService().getRemoteClusterNames().contains(clusterAlias)) {
            throw new NoSuchRemoteClusterException(clusterAlias);
        }
        return new RemoteClusterAwareClient(this.settings, threadPool, this.transportService, clusterAlias);
    }

    Collection<RemoteClusterConnection> getConnections() {
        return this.remoteClusters.values();
    }

    static {
        assert (Version.CURRENT.major < 8);
        SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("search.remote.initial_connect_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope, Setting.Property.Deprecated);
        REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.remote.initial_connect_timeout", SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING, TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
        SEARCH_REMOTE_NODE_ATTRIBUTE = Setting.simpleString("search.remote.node.attr", Setting.Property.NodeScope, Setting.Property.Deprecated);
        REMOTE_NODE_ATTRIBUTE = Setting.simpleString("cluster.remote.node.attr", SEARCH_REMOTE_NODE_ATTRIBUTE, Setting.Property.NodeScope);
        SEARCH_ENABLE_REMOTE_CLUSTERS = Setting.boolSetting("search.remote.connect", true, Setting.Property.NodeScope, Setting.Property.Deprecated);
        ENABLE_REMOTE_CLUSTERS = Setting.boolSetting("cluster.remote.connect", SEARCH_ENABLE_REMOTE_CLUSTERS, Setting.Property.NodeScope);
        SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("search.remote.", "skip_unavailable", key -> Setting.boolSetting(key, false, Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope), () -> SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS);
        SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE_UPGRADER = new SettingUpgrader<Boolean>(){

            @Override
            public Setting<Boolean> getSetting() {
                return SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE;
            }

            @Override
            public String getKey(String key) {
                return key.replaceFirst("^search", "cluster");
            }
        };
        REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("cluster.remote.", "skip_unavailable", key -> Setting.boolSetting(key, "_na_".equals(key) ? SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSettingForNamespace((String)key) : SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSetting(key.replaceAll("^cluster", "search")), Setting.Property.Dynamic, Setting.Property.NodeScope), () -> SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS);
        REMOTE_CLUSTER_PING_SCHEDULE = Setting.affixKeySetting("cluster.remote.", "transport.ping_schedule", key -> Setting.timeSetting(key, TransportSettings.PING_SCHEDULE, Setting.Property.Dynamic, Setting.Property.NodeScope), () -> SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS);
        REMOTE_CLUSTER_COMPRESS = Setting.affixKeySetting("cluster.remote.", "transport.compress", key -> Setting.boolSetting(key, TransportSettings.TRANSPORT_COMPRESS, Setting.Property.Dynamic, Setting.Property.NodeScope), () -> SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS);
    }
}

