/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.dynamic;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.dynamic.DynamicRangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DynamicRangeBuilder
implements CategoryBuilder {
    private static final Category DYNAMIC = new Category(NbBundle.getMessage(DynamicRangeBuilder.class, (String)"DynamicRangeBuilder.category"), null, null);

    public Category getCategory() {
        return DYNAMIC;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        ArrayList<DynamicRangeFilterBuilder> builders = new ArrayList<DynamicRangeFilterBuilder>();
        GraphModel am = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        if (am.isDynamic()) {
            builders.add(new DynamicRangeFilterBuilder(am));
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class DynamicRangeFilter
    implements ComplexFilter {
        private final TimeRepresentation timeRepresentation;
        private FilterProperty[] filterProperties;
        private Interval visibleInterval;
        private Range range = new Range((Number)Double.NEGATIVE_INFINITY, (Number)Double.POSITIVE_INFINITY);
        private boolean keepNull = true;

        public DynamicRangeFilter(GraphModel graphModel) {
            this.timeRepresentation = graphModel.getConfiguration().getTimeRepresentation();
        }

        public Graph filter(Graph graph) {
            this.visibleInterval = new Interval(this.range.getLowerDouble().doubleValue(), this.range.getUpperDouble().doubleValue());
            ArrayList<Node> toRemoveNodes = new ArrayList<Node>();
            for (Node n : graph.getNodes()) {
                if (this.evaluateElement((Element)n)) continue;
                toRemoveNodes.add(n);
            }
            graph.removeAllNodes(toRemoveNodes);
            ArrayList<Edge> toRemoveEdge = new ArrayList<Edge>();
            for (Edge e : graph.getEdges()) {
                if (this.evaluateElement((Element)e)) continue;
                toRemoveEdge.add(e);
            }
            graph.removeAllEdges(toRemoveEdge);
            graph.getModel().setTimeInterval(graph.getView(), this.visibleInterval);
            return graph;
        }

        private boolean evaluateElement(Element element) {
            if (this.timeRepresentation.equals((Object)TimeRepresentation.INTERVAL)) {
                IntervalSet timeSet = (IntervalSet)element.getAttribute("timeset");
                if (timeSet != null) {
                    for (Interval i : timeSet.toArray()) {
                        if (this.visibleInterval.compareTo(i) != 0) continue;
                        return true;
                    }
                } else if (this.keepNull) {
                    return true;
                }
            } else {
                TimestampSet timeSet = (TimestampSet)element.getAttribute("timeset");
                if (timeSet != null) {
                    for (double t : timeSet.toPrimitiveArray()) {
                        if (this.visibleInterval.compareTo(Double.valueOf(t)) != 0) continue;
                        return true;
                    }
                } else if (this.keepNull) {
                    return true;
                }
            }
            return false;
        }

        public String getName() {
            return NbBundle.getMessage(DynamicRangeBuilder.class, (String)"DynamicRangeBuilder.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty((Filter)this, Range.class, (String)"range"), FilterProperty.createProperty((Filter)this, Boolean.class, (String)"keepNull")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public boolean isKeepNull() {
            return this.keepNull;
        }

        public void setKeepNull(boolean keepNull) {
            this.keepNull = keepNull;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        public void destroy() {
        }
    }

    private static class DynamicRangeFilterBuilder
    implements FilterBuilder {
        private final GraphModel graphModel;

        public DynamicRangeFilterBuilder(GraphModel graphModel) {
            this.graphModel = graphModel;
        }

        public Category getCategory() {
            return DYNAMIC;
        }

        public String getName() {
            return "Time Interval";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public DynamicRangeFilter getFilter(Workspace workspace) {
            return new DynamicRangeFilter(this.graphModel);
        }

        public JPanel getPanel(Filter filter) {
            DynamicRangeFilter dynamicRangeFilter = (DynamicRangeFilter)filter;
            DynamicRangeUI ui = (DynamicRangeUI)Lookup.getDefault().lookup(DynamicRangeUI.class);
            if (ui != null) {
                return ui.getPanel(dynamicRangeFilter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }
}

