/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.IntersectionPoint;
import org.gephi.lib.gleem.linalg.Vec3f;

public class Plane {
    private Vec3f normal;
    private Vec3f point;
    float c;

    public Plane() {
        this.normal = new Vec3f(0.0f, 1.0f, 0.0f);
        this.point = new Vec3f(0.0f, 0.0f, 0.0f);
        this.recalc();
    }

    public Plane(Vec3f normal, Vec3f point) {
        this.normal = new Vec3f(normal);
        this.normal.normalize();
        this.point = new Vec3f(point);
        this.recalc();
    }

    public void setNormal(Vec3f normal) {
        this.normal.set(normal);
        this.normal.normalize();
        this.recalc();
    }

    public Vec3f getNormal() {
        return this.normal;
    }

    public void setPoint(Vec3f point) {
        this.point.set(point);
        this.recalc();
    }

    public Vec3f getPoint() {
        return this.point;
    }

    public void projectPoint(Vec3f pt, Vec3f projPt) {
        float scale = this.normal.dot(pt) - this.c;
        projPt.set(pt.minus(this.normal.times(this.normal.dot(this.point) - this.c)));
    }

    public boolean intersectRay(Vec3f rayStart, Vec3f rayDirection, IntersectionPoint intPt) {
        float denom = this.normal.dot(rayDirection);
        if (denom == 0.0f) {
            return false;
        }
        intPt.setT((this.c - this.normal.dot(rayStart)) / denom);
        intPt.setIntersectionPoint(rayStart.plus(rayDirection.times(intPt.getT())));
        return true;
    }

    private void recalc() {
        this.c = this.normal.dot(this.point);
    }
}

