/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.save.GroutedImage;

public class ImagePreviewPanel
extends JPanel {
    private GroutedImage _baseImage = null;
    private boolean _loading = false;
    private static final String LOADING_STRING = String.valueOf(I18nManager.getText("details.photo.loading")) + " ...";
    private static final Color EMPTY_IMAGE_COLOUR = new Color(0.5f, 0.75f, 0.8f);

    public void setImage(GroutedImage groutedImage) {
        this._baseImage = groutedImage;
        this._loading = false;
        this.repaint();
    }

    public void startLoading() {
        this._baseImage = null;
        this._loading = true;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paint(graphics);
        if (this._loading) {
            graphics.setColor(Color.BLACK);
            graphics.drawString(LOADING_STRING, 10, 30);
        } else if (this._baseImage != null && (n3 = Math.min(n2 = this.getWidth(), n = this.getHeight())) > 1) {
            if (this._baseImage.isValid()) {
                graphics.drawImage(this._baseImage.getImage(), (n2 - n3) / 2, (n - n3) / 2, n3, n3, this);
            } else {
                graphics.setColor(EMPTY_IMAGE_COLOUR);
                graphics.fillRect((n2 - n3) / 2, (n - n3) / 2, n3, n3);
            }
            graphics.setColor(Color.BLACK);
            graphics.drawRect((n2 - n3) / 2, (n - n3) / 2, n3 - 1, n3 - 1);
        }
    }

    public boolean getTilesFound() {
        return this._baseImage != null && this._baseImage.isValid() && this._baseImage.getImageSize() > 1 && this._baseImage.getNumTilesUsed() > 0;
    }
}

