/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.JavaVersion;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;

public class CachingJvmVersionDetector
implements JvmVersionDetector {
    private final Map<JavaInfo, JavaVersion> javaHomeResults = new ConcurrentHashMap<JavaInfo, JavaVersion>();
    private final Map<String, JavaVersion> javaCmdResults = new ConcurrentHashMap<String, JavaVersion>();
    private final JvmVersionDetector delegate;

    public CachingJvmVersionDetector(JvmVersionDetector delegate) {
        this.delegate = delegate;
        this.javaHomeResults.put((JavaInfo)Jvm.current(), JavaVersion.current());
        this.javaCmdResults.put(Jvm.current().getJavaExecutable().getPath(), JavaVersion.current());
    }

    @Override
    public JavaVersion getJavaVersion(JavaInfo jvm) {
        JavaVersion version = this.javaHomeResults.get(jvm);
        if (version != null) {
            return version;
        }
        version = this.delegate.getJavaVersion(jvm);
        this.javaHomeResults.put(jvm, version);
        return version;
    }

    @Override
    public JavaVersion getJavaVersion(String javaCommand) {
        JavaVersion version = this.javaCmdResults.get(javaCommand);
        if (version != null) {
            return version;
        }
        version = this.delegate.getJavaVersion(javaCommand);
        this.javaCmdResults.put(javaCommand, version);
        return version;
    }
}

