/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.AddWayHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.FeaturesHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImageryHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadDataHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadObjectHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.OpenFileHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.VersionHandler;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class RequestProcessor
extends Thread {
    private static final Charset RESPONSE_CHARSET = StandardCharsets.UTF_8;
    private static final String RESPONSE_TEMPLATE = "<!DOCTYPE html><html><head><meta charset=\"" + RESPONSE_CHARSET.name() + "\">%s</head><body>%s</body></html>";
    public static final String PROTOCOLVERSION = "{\"protocolversion\": {\"major\": 1, \"minor\": 8}, \"application\": \"JOSM RemoteControl\"}";
    private final Socket request;
    private static Map<String, Class<? extends RequestHandler>> handlers = new TreeMap<String, Class<? extends RequestHandler>>();

    public RequestProcessor(Socket request) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = Objects.requireNonNull(request);
    }

    public static void processRequest(Socket request) {
        new RequestProcessor(request).start();
    }

    public static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler) {
        RequestProcessor.addRequestHandlerClass(command, handler, false);
    }

    private static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler, boolean silent) {
        String commandWithSlash;
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        if (handlers.get(commandWithSlash = '/' + command) != null) {
            Logging.info("RemoteControl: ignoring duplicate command " + command + " with handler " + handler.getName());
        } else {
            if (!silent) {
                Logging.info("RemoteControl: adding command \"" + command + "\" (handled by " + handler.getSimpleName() + ')');
            }
            handlers.put(commandWithSlash, handler);
            try {
                Optional.ofNullable(handler.getConstructor(new Class[0]).newInstance(new Object[0]).getPermissionPref()).ifPresent(PermissionPrefWithDefault::addPermissionPref);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                Logging.debug(e);
            }
        }
    }

    public static void initialize() {
        if (handlers.isEmpty()) {
            RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
            RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
            RequestProcessor.addRequestHandlerClass("load_object", LoadObjectHandler.class, true);
            RequestProcessor.addRequestHandlerClass("load_data", LoadDataHandler.class, true);
            RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
            RequestProcessor.addRequestHandlerClass("open_file", OpenFileHandler.class, true);
            RequestProcessor.addRequestHandlerClass("imagery", ImageryHandler.class, true);
            PermissionPrefWithDefault.addPermissionPref(PermissionPrefWithDefault.CHANGE_SELECTION);
            PermissionPrefWithDefault.addPermissionPref(PermissionPrefWithDefault.CHANGE_VIEWPORT);
            RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
            RequestProcessor.addRequestHandlerClass("add_way", AddWayHandler.class, true);
            RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
            RequestProcessor.addRequestHandlerClass("features", FeaturesHandler.class, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.request.getOutputStream()), RESPONSE_CHARSET);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.request.getInputStream(), "ASCII"));
            String get = in.readLine();
            if (get == null) {
                RequestProcessor.sendError(out);
                return;
            }
            Logging.info("RemoteControl received: " + get);
            StringTokenizer st = new StringTokenizer(get);
            if (!st.hasMoreTokens()) {
                RequestProcessor.sendError(out);
                return;
            }
            String method = st.nextToken();
            if (!st.hasMoreTokens()) {
                RequestProcessor.sendError(out);
                return;
            }
            String url = st.nextToken();
            if (!"GET".equals(method)) {
                RequestProcessor.sendNotImplemented(out);
                return;
            }
            int questionPos = url.indexOf(63);
            String command = questionPos < 0 ? url : url.substring(0, questionPos);
            HashMap<String, String> headers = new HashMap<String, String>();
            int maxHeaders = 20;
            for (int k = 0; k < maxHeaders && (get = in.readLine()) != null; ++k) {
                String[] h = get.split(": ", 2);
                if (h.length != 2) break;
                headers.put(h[0], h[1]);
            }
            String sender = null;
            if (!this.request.getInetAddress().isLoopbackAddress()) {
                sender = this.request.getInetAddress().getHostAddress();
            } else {
                Matcher m;
                String ref = (String)headers.get("Referer");
                Pattern r = Pattern.compile("(https?://)?([^/]*)");
                if (ref != null && (m = r.matcher(ref)).find()) {
                    sender = m.group(2);
                }
                if (sender == null) {
                    sender = "localhost";
                }
            }
            Class<? extends RequestHandler> handlerClass = handlers.get(command);
            if (handlerClass == null) {
                String usage = RequestProcessor.getUsageAsHtml();
                String websiteDoc = HelpUtil.getWikiBaseHelpUrl() + "/Help/Preferences/RemoteControl";
                String help = "No command specified! The following commands are available:<ul>" + usage + "</ul>See <a href=\"" + websiteDoc + "\">" + websiteDoc + "</a> for complete documentation.";
                RequestProcessor.sendHeader(out, "400 Bad Request", "text/html", true);
                out.write(String.format(RESPONSE_TEMPLATE, "<title>Bad Request</title>", "<h1>HTTP Error 400: Bad Request</h1><p>" + help + "</p>"));
                ((Writer)out).flush();
            } else {
                RequestHandler handler = handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                try {
                    handler.setCommand(command);
                    handler.setUrl(url);
                    handler.setSender(sender);
                    handler.handle();
                    RequestProcessor.sendHeader(out, "200 OK", handler.getContentType(), false);
                    out.write("Content-length: " + handler.getContent().length() + "\r\n");
                    out.write("\r\n");
                    out.write(handler.getContent());
                    ((Writer)out).flush();
                }
                catch (RequestHandler.RequestHandlerErrorException ex) {
                    Logging.debug(ex);
                    RequestProcessor.sendError(out);
                }
                catch (RequestHandler.RequestHandlerBadRequestException ex) {
                    Logging.debug(ex);
                    RequestProcessor.sendBadRequest(out, ex.getMessage());
                }
                catch (RequestHandler.RequestHandlerForbiddenException ex) {
                    Logging.debug(ex);
                    RequestProcessor.sendForbidden(out, ex.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            Logging.debug(Logging.getErrorMessage(ioe));
        }
        catch (ReflectiveOperationException e) {
            Logging.error(e);
            try {
                RequestProcessor.sendError(out);
            }
            catch (IOException e1) {
                Logging.warn(e1);
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException e) {
                Logging.debug(Logging.getErrorMessage(e));
            }
        }
    }

    private static void sendError(Writer out) throws IOException {
        RequestProcessor.sendHeader(out, "500 Internal Server Error", "text/html", true);
        out.write(String.format(RESPONSE_TEMPLATE, "<title>Internal Error</title>", "<h1>HTTP Error 500: Internal Server Error</h1>"));
        out.flush();
    }

    private static void sendNotImplemented(Writer out) throws IOException {
        RequestProcessor.sendHeader(out, "501 Not Implemented", "text/html", true);
        out.write(String.format(RESPONSE_TEMPLATE, "<title>Not Implemented</title>", "<h1>HTTP Error 501: Not Implemented</h1>"));
        out.flush();
    }

    private static void sendForbidden(Writer out, String help) throws IOException {
        RequestProcessor.sendHeader(out, "403 Forbidden", "text/html", true);
        out.write(String.format(RESPONSE_TEMPLATE, "<title>Forbidden</title>", "<h1>HTTP Error 403: Forbidden</h1>" + (help == null ? "" : "<p>" + Utils.escapeReservedCharactersHTML(help) + "</p>")));
        out.flush();
    }

    private static void sendBadRequest(Writer out, String help) throws IOException {
        RequestProcessor.sendHeader(out, "400 Bad Request", "text/html", true);
        out.write(String.format(RESPONSE_TEMPLATE, "<title>Bad Request</title>", "<h1>HTTP Error 400: Bad Request</h1>" + (help == null ? "" : "<p>" + Utils.escapeReservedCharactersHTML(help) + "</p>")));
        out.flush();
    }

    private static void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        out.write("Date: " + new Date() + "\r\n");
        out.write("Server: JOSM RemoteControl\r\n");
        out.write("Content-type: " + contentType + "; charset=" + RESPONSE_CHARSET.name().toLowerCase(Locale.ENGLISH) + "\r\n");
        out.write("Access-Control-Allow-Origin: *\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }

    public static String getHandlersInfoAsJSON() {
        StringBuilder r = new StringBuilder();
        boolean first = true;
        r.append('[');
        for (Map.Entry<String, Class<? extends RequestHandler>> p : handlers.entrySet()) {
            if (first) {
                first = false;
            } else {
                r.append(", ");
            }
            r.append(RequestProcessor.getHandlerInfoAsJSON(p.getKey()));
        }
        r.append(']');
        return r.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getHandlerInfoAsJSON(String cmd) {
        try {
            Throwable throwable = null;
            try (StringWriter w = new StringWriter();){
                String string;
                RequestHandler handler;
                block17: {
                    handler = null;
                    try {
                        Class<? extends RequestHandler> c = handlers.get(cmd);
                        if (c != null) break block17;
                        String string2 = null;
                        return string2;
                    }
                    catch (ReflectiveOperationException ex) {
                        Logging.error(ex);
                        String string3 = null;
                        RequestProcessor.$closeResource(throwable, w);
                        return string3;
                    }
                }
                handler = handlers.get(cmd).getConstructor(new Class[0]).newInstance(new Object[0]);
                PrintWriter r = new PrintWriter(w);
                Throwable throwable2 = null;
                try {
                    RequestProcessor.printJsonInfo(cmd, r, handler);
                    string = w.toString();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            RequestProcessor.$closeResource(throwable2, r);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                RequestProcessor.$closeResource(throwable2, r);
                return string;
            }
        }
        catch (IOException e) {
            Logging.error(e);
            return null;
        }
    }

    private static void printJsonInfo(String cmd, PrintWriter r, RequestHandler handler) {
        r.printf("{ \"request\" : \"%s\"", cmd);
        if (handler.getUsage() != null) {
            r.printf(", \"usage\" : \"%s\"", handler.getUsage());
        }
        r.append(", \"parameters\" : [");
        String[] params = handler.getMandatoryParams();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i == 0) {
                    r.append('\"');
                } else {
                    r.append(", \"");
                }
                r.append(params[i]).append('\"');
            }
        }
        r.append("], \"optional\" : [");
        String[] optional = handler.getOptionalParams();
        if (optional != null) {
            for (int i = 0; i < optional.length; ++i) {
                if (i == 0) {
                    r.append('\"');
                } else {
                    r.append(", \"");
                }
                r.append(optional[i]).append('\"');
            }
        }
        r.append("], \"examples\" : [");
        String[] examples = handler.getUsageExamples(cmd.substring(1));
        if (examples != null) {
            for (int i = 0; i < examples.length; ++i) {
                if (i == 0) {
                    r.append('\"');
                } else {
                    r.append(", \"");
                }
                r.append(examples[i]).append('\"');
            }
        }
        r.append("]}");
    }

    public static String getUsageAsHtml() throws ReflectiveOperationException {
        StringBuilder usage = new StringBuilder(1024);
        for (Map.Entry<String, Class<? extends RequestHandler>> handler : handlers.entrySet()) {
            RequestHandler sample = handler.getValue().getConstructor(new Class[0]).newInstance(new Object[0]);
            CharSequence[] mandatory = sample.getMandatoryParams();
            CharSequence[] optional = sample.getOptionalParams();
            String[] examples = sample.getUsageExamples(handler.getKey().substring(1));
            usage.append("<li>").append(handler.getKey());
            if (sample.getUsage() != null && !sample.getUsage().isEmpty()) {
                usage.append(" &mdash; <i>").append(sample.getUsage()).append("</i>");
            }
            if (mandatory != null && mandatory.length > 0) {
                usage.append("<br/>mandatory parameters: ").append(String.join((CharSequence)", ", mandatory));
            }
            if (optional != null && optional.length > 0) {
                usage.append("<br/>optional parameters: ").append(String.join((CharSequence)", ", optional));
            }
            if (examples != null && examples.length > 0) {
                usage.append("<br/>examples: ");
                for (String ex : examples) {
                    usage.append("<br/> <a href=\"http://localhost:8111").append(ex).append("\">").append(ex).append("</a>");
                }
            }
            usage.append("</li>");
        }
        return usage.toString();
    }

    static {
        RequestProcessor.initialize();
    }
}

