/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.TaginfoRegionalInstance;

public final class Territories {
    public static final String FILENAME = "boundaries.osm";
    private static final String ISO3166_1 = "ISO3166-1:alpha2";
    private static final String ISO3166_2 = "ISO3166-2";
    private static final String ISO3166_1_LC = "ISO3166-1:alpha2".toLowerCase(Locale.ENGLISH);
    private static final String ISO3166_2_LC = "ISO3166-2".toLowerCase(Locale.ENGLISH);
    private static final String TAGINFO = "taginfo";
    private static DataSet dataSet;
    private static volatile Map<String, GeoPropertyIndex<Boolean>> iso3166Cache;
    private static volatile Map<String, TaginfoRegionalInstance> taginfoCache;
    private static volatile Map<String, TaginfoRegionalInstance> taginfoGeofabrikCache;

    private Territories() {
    }

    public static synchronized Set<String> getKnownIso3166Codes() {
        return iso3166Cache.keySet();
    }

    public static GeoPropertyIndex<Boolean> getGeoPropertyIndex(String code) {
        return iso3166Cache.get(code);
    }

    public static synchronized boolean isIso3166Code(String code, LatLon ll) {
        GeoPropertyIndex<Boolean> gpi = iso3166Cache.get(code);
        if (gpi == null) {
            Logging.warn(I18n.tr("Unknown territory id: {0}", code));
            return false;
        }
        return Boolean.TRUE.equals(gpi.get(ll));
    }

    public static synchronized DataSet getOriginalDataSet() {
        return dataSet;
    }

    public static synchronized DataSet getDataSet() {
        return new DataSet(dataSet);
    }

    public static synchronized void initialize() {
        Territories.initializeInternalData();
        Territories.initializeExternalData();
    }

    private static void initializeInternalData() {
        iso3166Cache = new HashMap<String, GeoPropertyIndex<Boolean>>();
        taginfoCache = new TreeMap<String, TaginfoRegionalInstance>();
        try (CachedFile cf = new CachedFile("resource://data/boundaries.osm");
             InputStream is = cf.getInputStream();){
            dataSet = OsmReader.parseDataSet(is, null);
            ArrayList<Way> candidates = new ArrayList<Way>(dataSet.getWays());
            candidates.addAll(dataSet.getRelations());
            for (OsmPrimitive osmPrimitive : candidates) {
                String iso1 = osmPrimitive.get(ISO3166_1);
                String iso2 = osmPrimitive.get(ISO3166_2);
                if (iso1 == null && iso2 == null) continue;
                DefaultGeoProperty gp = osmPrimitive instanceof Way ? new DefaultGeoProperty(Collections.singleton((Way)osmPrimitive)) : new DefaultGeoProperty((Relation)osmPrimitive);
                GeoPropertyIndex<Boolean> gpi = new GeoPropertyIndex<Boolean>(gp, 24);
                if (iso1 != null) {
                    iso3166Cache.put(iso1, gpi);
                    String taginfo = osmPrimitive.get(TAGINFO);
                    if (taginfo != null) {
                        taginfoCache.put(iso1, new TaginfoRegionalInstance(taginfo, Collections.singleton(iso1)));
                    }
                }
                if (iso2 == null) continue;
                iso3166Cache.put(iso2, gpi);
            }
        }
        catch (IOException | IllegalDataException ex) {
            throw new JosmRuntimeException(ex);
        }
    }

    private static void initializeExternalData() {
        taginfoGeofabrikCache = new TreeMap<String, TaginfoRegionalInstance>();
        try (CachedFile cf = new CachedFile(Config.getUrls().getJOSMWebsite() + "/remote/geofabrik-index-v1-nogeom.json");
             InputStream is = cf.getInputStream();
             JsonParser json = Json.createParser(is);){
            while (json.hasNext()) {
                JsonParser.Event event = json.next();
                if (event != JsonParser.Event.START_OBJECT) continue;
                for (JsonValue feature : json.getObject().getJsonArray("features")) {
                    String taginfo;
                    JsonObject urls;
                    JsonObject props = feature.asJsonObject().getJsonObject("properties");
                    if (props == null || (urls = props.getJsonObject("urls")) == null || (taginfo = urls.getString(TAGINFO)) == null) continue;
                    JsonArray iso1 = props.getJsonArray(ISO3166_1_LC);
                    JsonArray iso2 = props.getJsonArray(ISO3166_2_LC);
                    if (iso1 != null) {
                        Territories.readExternalTaginfo(taginfo, iso1);
                        continue;
                    }
                    if (iso2 == null) continue;
                    Territories.readExternalTaginfo(taginfo, iso2);
                }
            }
        }
        catch (IOException | JsonParsingException e) {
            Logging.trace(e);
            Logging.warn(I18n.tr("Failed to parse taginfo data geofabrik-index-v1-nogeom.json", new Object[0]));
        }
    }

    private static void readExternalTaginfo(String taginfo, JsonArray jsonCodes) {
        Set<String> isoCodes = jsonCodes.getValuesAs(JsonString.class).stream().map(JsonString::getString).collect(Collectors.toSet());
        isoCodes.forEach(s -> taginfoGeofabrikCache.put((String)s, new TaginfoRegionalInstance(taginfo, isoCodes, "Geofabrik")));
    }

    public static List<TaginfoRegionalInstance> getRegionalTaginfoUrls(LatLon ll) {
        if (iso3166Cache == null) {
            return Collections.emptyList();
        }
        return iso3166Cache.entrySet().parallelStream().distinct().filter(e -> Boolean.TRUE.equals(((GeoPropertyIndex)e.getValue()).get(ll))).map(Map.Entry::getKey).distinct().flatMap(code -> Stream.of(taginfoCache, taginfoGeofabrikCache).map(cache -> (TaginfoRegionalInstance)cache.get(code))).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

