/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.manualrequest.ExtensionManualRequestEditor;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.history.PopupMenuExportContextURLs;
import org.zaproxy.zap.extension.stdmenus.PopupContextTreeMenu;
import org.zaproxy.zap.extension.stdmenus.PopupCopyMenu;
import org.zaproxy.zap.extension.stdmenus.PopupExcludeFromProxyMenu;
import org.zaproxy.zap.extension.stdmenus.PopupExcludeFromScanMenu;
import org.zaproxy.zap.extension.stdmenus.PopupExcludeFromSpiderMenu;
import org.zaproxy.zap.extension.stdmenus.PopupMenuActiveScanCustom;
import org.zaproxy.zap.extension.stdmenus.PopupMenuCopyUrls;
import org.zaproxy.zap.extension.stdmenus.PopupMenuOpenUrlInBrowser;
import org.zaproxy.zap.extension.stdmenus.PopupMenuResendMessage;
import org.zaproxy.zap.extension.stdmenus.PopupMenuShowInHistory;
import org.zaproxy.zap.extension.stdmenus.PopupMenuShowInSites;
import org.zaproxy.zap.extension.stdmenus.PopupPasteMenu;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ContextExportDialog;
import org.zaproxy.zap.view.DeleteContextAction;
import org.zaproxy.zap.view.popup.PopupMenuItemContextDataDriven;
import org.zaproxy.zap.view.popup.PopupMenuItemContextExclude;
import org.zaproxy.zap.view.popup.PopupMenuItemContextInclude;

public class ExtensionStdMenus
extends ExtensionAdaptor
implements ClipboardOwner {
    public static final String NAME = "ExtensionStandardMenus";
    private PopupCopyMenu popupCopyMenu = null;
    private PopupPasteMenu popupPaste = null;
    private PopupMenuActiveScanCustom popupMenuActiveScanCustom = null;
    private PopupExcludeFromProxyMenu popupExcludeFromProxyMenu = null;
    private PopupExcludeFromScanMenu popupExcludeFromScanMenu = null;
    private PopupExcludeFromSpiderMenu popupExcludeFromSpiderMenu = null;
    private PopupMenuResendMessage popupMenuResendMessage = null;
    private PopupMenuShowInHistory popupMenuShowInHistory = null;
    private PopupMenuShowInSites popupMenuShowInSites = null;
    private PopupMenuOpenUrlInBrowser popupMenuOpenUrlInBrowser = null;
    private PopupMenuItemContextInclude popupContextIncludeMenu = null;
    private PopupMenuItemContextExclude popupContextExcludeMenu = null;
    private PopupMenuItemContextDataDriven popupContextDataDrivenMenu = null;
    private PopupMenuCopyUrls popupMenuCopyUrls = null;
    private PopupContextTreeMenu popupContextTreeMenuInScope = null;
    private PopupContextTreeMenu popupContextTreeMenuOutScope = null;
    private PopupContextTreeMenu popupContextTreeMenuDelete = null;
    private PopupContextTreeMenu popupContextTreeMenuExport;
    private PopupMenuExportContextURLs popupContextTreeMenuExportUrls;
    private static Logger log = Logger.getLogger(ExtensionStdMenus.class);

    public ExtensionStdMenus() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(31);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("std.menu.ext.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuCopy());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuPaste());
            ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
            boolean isExtensionHistoryEnabled = extensionLoader.isExtensionEnabled("ExtensionHistory");
            boolean isExtensionActiveScanEnabled = extensionLoader.isExtensionEnabled("ExtensionActiveScan");
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupExcludeFromProxyMenu(0));
            if (isExtensionActiveScanEnabled) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupExcludeFromScanMenu(0));
            }
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupExcludeFromSpiderMenu(0));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextIncludeMenu(1));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextExcludeMenu(2));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextDataDrivenMenu(2));
            if (isExtensionActiveScanEnabled) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuActiveScanCustom(3));
            }
            if (isExtensionHistoryEnabled) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuResendMessage(4));
            }
            if (isExtensionHistoryEnabled) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuShowInHistory(6));
            }
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuShowInSites(6));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuOpenUrlInBrowser(7));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuCopyUrls(8));
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuInScope());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuOutScope());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuDelete());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuExport());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupContextTreeMenuExportUrls());
        }
    }

    private PopupContextTreeMenu getPopupContextTreeMenuInScope() {
        if (this.popupContextTreeMenuInScope == null) {
            this.popupContextTreeMenuInScope = new PopupContextTreeMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isEnabledForContext(int contextId) {
                    Context ctx = Model.getSingleton().getSession().getContext(contextId);
                    return ctx != null && !ctx.isInScope();
                }
            };
            this.popupContextTreeMenuInScope.setText(Constant.messages.getString("context.inscope.popup"));
            this.popupContextTreeMenuInScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Integer id : ExtensionStdMenus.this.popupContextTreeMenuInScope.getContextIds()) {
                        Context ctx = Model.getSingleton().getSession().getContext(id);
                        ctx.setInScope(true);
                        Model.getSingleton().getSession().saveContext(ctx);
                    }
                }
            });
        }
        return this.popupContextTreeMenuInScope;
    }

    private PopupContextTreeMenu getPopupContextTreeMenuOutScope() {
        if (this.popupContextTreeMenuOutScope == null) {
            this.popupContextTreeMenuOutScope = new PopupContextTreeMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isEnabledForContext(int contextId) {
                    Context ctx = Model.getSingleton().getSession().getContext(contextId);
                    return ctx != null && ctx.isInScope();
                }
            };
            this.popupContextTreeMenuOutScope.setText(Constant.messages.getString("context.outscope.popup"));
            this.popupContextTreeMenuOutScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Integer id : ExtensionStdMenus.this.popupContextTreeMenuOutScope.getContextIds()) {
                        Context ctx = Model.getSingleton().getSession().getContext(id);
                        ctx.setInScope(false);
                        Model.getSingleton().getSession().saveContext(ctx);
                    }
                }
            });
        }
        return this.popupContextTreeMenuOutScope;
    }

    private PopupMenuExportContextURLs getPopupContextTreeMenuExportUrls() {
        if (this.popupContextTreeMenuExportUrls == null) {
            this.popupContextTreeMenuExportUrls = new PopupMenuExportContextURLs(Constant.messages.getString("context.export.urls.menu"), this);
        }
        return this.popupContextTreeMenuExportUrls;
    }

    private PopupContextTreeMenu getPopupContextTreeMenuDelete() {
        if (this.popupContextTreeMenuDelete == null) {
            this.popupContextTreeMenuDelete = new PopupContextTreeMenu();
            this.popupContextTreeMenuDelete.setAction(new DeleteContextAction(){
                private static final long serialVersionUID = 1L;

                @Override
                protected List<Context> getContexts() {
                    ArrayList<Context> contexts = new ArrayList<Context>();
                    for (Integer id : ExtensionStdMenus.this.popupContextTreeMenuDelete.getContextIds()) {
                        contexts.add(Model.getSingleton().getSession().getContext(id));
                    }
                    return contexts;
                }

                @Override
                protected Context getContext() {
                    return Model.getSingleton().getSession().getContext(ExtensionStdMenus.this.popupContextTreeMenuDelete.getContextId());
                }
            });
            this.popupContextTreeMenuDelete.setText(Constant.messages.getString("context.delete.popup"));
        }
        return this.popupContextTreeMenuDelete;
    }

    private PopupContextTreeMenu getPopupContextTreeMenuExport() {
        if (this.popupContextTreeMenuExport == null) {
            this.popupContextTreeMenuExport = new PopupContextTreeMenu(false);
            this.popupContextTreeMenuExport.setText(Constant.messages.getString("menu.file.context.export"));
            this.popupContextTreeMenuExport.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ExtensionStdMenus.class.getResource("/resource/icon/fugue/application-blue-export.png"))));
            this.popupContextTreeMenuExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Context context = Model.getSingleton().getSession().getContext(ExtensionStdMenus.this.popupContextTreeMenuExport.getContextId());
                    ContextExportDialog exportDialog = new ContextExportDialog(ExtensionStdMenus.this.getView().getMainFrame());
                    exportDialog.setSelectedContext(context);
                    exportDialog.setVisible(true);
                }
            });
        }
        return this.popupContextTreeMenuExport;
    }

    private PopupCopyMenu getPopupMenuCopy() {
        if (this.popupCopyMenu == null) {
            this.popupCopyMenu = new PopupCopyMenu();
            this.popupCopyMenu.setText(Constant.messages.getString("copy.copy.popup"));
            this.popupCopyMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionStdMenus.this.setClipboardContents(ExtensionStdMenus.this.popupCopyMenu.getLastInvoker().getSelectedText());
                }
            });
        }
        return this.popupCopyMenu;
    }

    private PopupPasteMenu getPopupMenuPaste() {
        if (this.popupPaste == null) {
            this.popupPaste = new PopupPasteMenu();
            this.popupPaste.setText(Constant.messages.getString("paste.paste.popup"));
            this.popupPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionStdMenus.this.popupPaste.getLastInvoker().setText(ExtensionStdMenus.this.popupPaste.getLastInvoker().getText() + ExtensionStdMenus.this.getClipboardContents());
                }
            });
        }
        return this.popupPaste;
    }

    private String getClipboardContents() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                log.error((Object)"Unable to get data from clipboard");
            }
        }
        return "";
    }

    private void setClipboardContents(String str) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(str), this);
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    private PopupMenuActiveScanCustom getPopupMenuActiveScanCustom(int menuIndex) {
        if (this.popupMenuActiveScanCustom == null) {
            this.popupMenuActiveScanCustom = new PopupMenuActiveScanCustom(Constant.messages.getString("ascan.custom.popup"));
        }
        return this.popupMenuActiveScanCustom;
    }

    private PopupMenuOpenUrlInBrowser getPopupMenuOpenUrlInBrowser(int menuIndex) {
        if (this.popupMenuOpenUrlInBrowser == null) {
            this.popupMenuOpenUrlInBrowser = new PopupMenuOpenUrlInBrowser(Constant.messages.getString("history.browser.popup"));
            this.popupMenuOpenUrlInBrowser.setMenuIndex(menuIndex);
        }
        return this.popupMenuOpenUrlInBrowser;
    }

    private PopupMenuCopyUrls getPopupMenuCopyUrls(int menuIndex) {
        if (this.popupMenuCopyUrls == null) {
            this.popupMenuCopyUrls = new PopupMenuCopyUrls(Constant.messages.getString("stdexts.copyurls.popup"));
            this.popupMenuCopyUrls.setMenuIndex(menuIndex);
        }
        return this.popupMenuCopyUrls;
    }

    private PopupExcludeFromProxyMenu getPopupExcludeFromProxyMenu(int menuIndex) {
        if (this.popupExcludeFromProxyMenu == null) {
            this.popupExcludeFromProxyMenu = new PopupExcludeFromProxyMenu();
            this.popupExcludeFromProxyMenu.setMenuIndex(menuIndex);
        }
        return this.popupExcludeFromProxyMenu;
    }

    private PopupExcludeFromScanMenu getPopupExcludeFromScanMenu(int menuIndex) {
        if (this.popupExcludeFromScanMenu == null) {
            this.popupExcludeFromScanMenu = new PopupExcludeFromScanMenu();
            this.popupExcludeFromScanMenu.setMenuIndex(menuIndex);
        }
        return this.popupExcludeFromScanMenu;
    }

    private PopupExcludeFromSpiderMenu getPopupExcludeFromSpiderMenu(int menuIndex) {
        if (this.popupExcludeFromSpiderMenu == null) {
            this.popupExcludeFromSpiderMenu = new PopupExcludeFromSpiderMenu();
            this.popupExcludeFromSpiderMenu.setMenuIndex(menuIndex);
        }
        return this.popupExcludeFromSpiderMenu;
    }

    private PopupMenuResendMessage getPopupMenuResendMessage(int menuIndex) {
        if (this.popupMenuResendMessage == null) {
            this.popupMenuResendMessage = new PopupMenuResendMessage(Constant.messages.getString("history.resend.popup"), Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class));
            this.popupMenuResendMessage.setMenuIndex(menuIndex);
            this.popupMenuResendMessage.setIcon(ExtensionManualRequestEditor.getIcon());
        }
        return this.popupMenuResendMessage;
    }

    private PopupMenuShowInSites getPopupMenuShowInSites(int menuIndex) {
        if (this.popupMenuShowInSites == null) {
            this.popupMenuShowInSites = new PopupMenuShowInSites(Constant.messages.getString("sites.showinsites.popup"));
            this.popupMenuShowInSites.setMenuIndex(menuIndex);
        }
        return this.popupMenuShowInSites;
    }

    private PopupMenuShowInHistory getPopupMenuShowInHistory(int menuIndex) {
        if (this.popupMenuShowInHistory == null) {
            this.popupMenuShowInHistory = new PopupMenuShowInHistory(Constant.messages.getString("history.showinhistory.popup"), Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class));
            this.popupMenuShowInHistory.setMenuIndex(menuIndex);
        }
        return this.popupMenuShowInHistory;
    }

    private PopupMenuItemContextInclude getPopupContextIncludeMenu(int menuIndex) {
        if (this.popupContextIncludeMenu == null) {
            this.popupContextIncludeMenu = new PopupMenuItemContextInclude();
            this.popupContextIncludeMenu.setParentMenuIndex(menuIndex);
        }
        return this.popupContextIncludeMenu;
    }

    private PopupMenuItemContextExclude getPopupContextExcludeMenu(int menuIndex) {
        if (this.popupContextExcludeMenu == null) {
            this.popupContextExcludeMenu = new PopupMenuItemContextExclude();
            this.popupContextExcludeMenu.setParentMenuIndex(menuIndex);
        }
        return this.popupContextExcludeMenu;
    }

    private PopupMenuItemContextDataDriven getPopupContextDataDrivenMenu(int menuIndex) {
        if (this.popupContextDataDrivenMenu == null) {
            this.popupContextDataDrivenMenu = new PopupMenuItemContextDataDriven();
            this.popupContextDataDrivenMenu.setParentMenuIndex(menuIndex);
        }
        return this.popupContextDataDrivenMenu;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("stdexts.desc");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

