#ifndef _EFL_UI_TEXT_SELECTABLE_EO_H_
#define _EFL_UI_TEXT_SELECTABLE_EO_H_

#ifndef _EFL_UI_TEXT_SELECTABLE_EO_CLASS_TYPE
#define _EFL_UI_TEXT_SELECTABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Text_Selectable;

#endif

#ifndef _EFL_UI_TEXT_SELECTABLE_EO_TYPES
#define _EFL_UI_TEXT_SELECTABLE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl UI text selectable interface
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_TEXT_SELECTABLE_INTERFACE efl_ui_text_selectable_interface_get()

EWAPI const Efl_Class *efl_ui_text_selectable_interface_get(void);

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SELECTION_PASTE;

/** Called when selection is pasted
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_EVENT_SELECTION_PASTE (&(_EFL_UI_EVENT_SELECTION_PASTE))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SELECTION_COPY;

/** Called when selection is copied
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_EVENT_SELECTION_COPY (&(_EFL_UI_EVENT_SELECTION_COPY))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SELECTION_CUT;

/** Called when selection is cut
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_EVENT_SELECTION_CUT (&(_EFL_UI_EVENT_SELECTION_CUT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SELECTION_START;

/** Called at selection start
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_EVENT_SELECTION_START (&(_EFL_UI_EVENT_SELECTION_START))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SELECTION_CHANGED;

/** Called when selection is changed
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_EVENT_SELECTION_CHANGED (&(_EFL_UI_EVENT_SELECTION_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SELECTION_CLEARED;

/** Called when selection is cleared
 *
 * @ingroup Efl_Ui_Text_Selectable
 */
#define EFL_UI_EVENT_SELECTION_CLEARED (&(_EFL_UI_EVENT_SELECTION_CLEARED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
