#ifndef _EFL_UI_MULTI_SELECTABLE_EO_H_
#define _EFL_UI_MULTI_SELECTABLE_EO_H_

#ifndef _EFL_UI_MULTI_SELECTABLE_EO_CLASS_TYPE
#define _EFL_UI_MULTI_SELECTABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Multi_Selectable;

#endif

#ifndef _EFL_UI_MULTI_SELECTABLE_EO_TYPES
#define _EFL_UI_MULTI_SELECTABLE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Interface for getting access to a range of selected items.
 *
 * The implementor of this interface provides the possibility to select
 * multiple Selectables. If not, only @ref Efl_Ui_Single_Selectable should be
 * implemented.
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
#define EFL_UI_MULTI_SELECTABLE_INTERFACE efl_ui_multi_selectable_interface_get()

EWAPI const Efl_Class *efl_ui_multi_selectable_interface_get(void);

/**
 * @brief The mode type for children selection.
 *
 * @param[in] obj The object.
 * @param[in] mode Type of selection of children
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI void efl_ui_selectable_select_mode_set(Eo *obj, Efl_Ui_Select_Mode mode);

/**
 * @brief The mode type for children selection.
 *
 * @param[in] obj The object.
 *
 * @return Type of selection of children
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI Efl_Ui_Select_Mode efl_ui_selectable_select_mode_get(const Eo *obj);

/**
 * @brief Get the selected items in a iterator. The iterator sequence will be
 * decided by selection.
 *
 * @param[in] obj The object.
 *
 * @return User has to free the iterator after usage.
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI Eina_Iterator *efl_ui_selectable_selected_iterator_new(Eo *obj) EFL_TRANSFER_OWNERSHIP EINA_WARN_UNUSED_RESULT;

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Select a range of @ref Efl_Ui_Selectable.
 *
 * This will select the range of selectables from a to b or from b to a
 * depending on which one comes first. If a or b are not part of the widget, a
 * error is returned, and no change is applied. @c null is not allowed as
 * either of the parameters. Both of the passed values will also be selected.
 *
 * @param[in] obj The object.
 * @param[in] a One side of the range.
 * @param[in] b The other side of the range.
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI void efl_ui_selectable_range_select(Eo *obj, Efl_Ui_Selectable *a, Efl_Ui_Selectable *b);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Unselect a range of @ref Efl_Ui_Selectable.
 *
 * This will unselect the range of selectables from a to b or from b to a
 * depending on which one comes first. If a or b are not part of the widget, a
 * error is returned, and no change is applied. @c null is not allowed as
 * either of the parameters. Both of the passed values will also be unselected.
 *
 * @param[in] obj The object.
 * @param[in] a One side of the range.
 * @param[in] b The other side of the range.
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI void efl_ui_selectable_range_unselect(Eo *obj, Efl_Ui_Selectable *a, Efl_Ui_Selectable *b);
#endif /* EFL_BETA_API_SUPPORT */

/** Select all @ref Efl_Ui_Selectable
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI void efl_ui_selectable_all_select(Eo *obj);

/** Unselect all @ref Efl_Ui_Selectable
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI void efl_ui_selectable_all_unselect(Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
