#ifndef _EFL_CANVAS_GESTURE_TYPES_EOT_H_
#define _EFL_CANVAS_GESTURE_TYPES_EOT_H_

#ifndef _EFL_CANVAS_GESTURE_TYPES_EOT_TYPES
#define _EFL_CANVAS_GESTURE_TYPES_EOT_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** This enum type describes the state of a touch event.
 *
 * @ingroup Efl_Canvas
 */
typedef enum
{
  EFL_GESTURE_TOUCH_UNKNOWN = 0, /**< Gesture Touch State unknown */
  EFL_GESTURE_TOUCH_BEGIN, /**< First fingure touch down */
  EFL_GESTURE_TOUCH_UPDATE, /**< fingure touch update */
  EFL_GESTURE_TOUCH_END /**< Last fingure touch up */
} Efl_Canvas_Gesture_Touch_State;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** This enum type describes the state of a gesture.
 *
 * @ingroup Efl_Canvas
 */
typedef enum
{
  EFL_GESTURE_NONE = 0, /**< No gesture state */
  EFL_GESTURE_STARTED = 1, /**< A continuous gesture has started. */
  EFL_GESTURE_UPDATED, /**< A gesture continues. */
  EFL_GESTURE_FINISHED, /**< A gesture has finished. */
  EFL_GESTURE_CANCELED /**< A gesture was canceled. */
} Efl_Canvas_Gesture_State;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** This enum type describes the state of a gesture recognizer.
 *
 * @ingroup Efl_Canvas
 */
typedef enum
{
  EFL_GESTURE_IGNORE = 1, /**< The event does not change the state of the
                           * recognizer. */
  EFL_GESTURE_MAYBE = 2, /**< The event changed the internal state of the
                          * recognizer, but it isn't clear yet if it is a
                          *  gesture or not. The recognizer needs to filter
                          * more events to decide. */
  EFL_GESTURE_TRIGGER = 4, /**< The gesture has been triggered */
  EFL_GESTURE_FINISH = 8, /**< The gesture has been finished successfully. */
  EFL_GESTURE_CANCEL = 16, /**< The event made it clear that it is not a
                            * gesture. If the gesture recognizer was in
                            * Triggered state before, then the gesture is
                            * canceled. */
  EFL_GESTURE_RESULT_MASK = 255 /**< The gesture result mask */
} Efl_Canvas_Gesture_Recognizer_Result;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** This enum type describes the state of a touch event.
 *
 * @ingroup Efl_Canvas
 */
typedef enum
{
  EFL_GESTURE_TAP = 0,
  EFL_GESTURE_DOUBLETAP,
  EFL_GESTURE_TRIPLETAP,
  EFL_GESTURE_LONGTAP,
  EFL_GESTURE_MOMENTUM,
  EFL_GESTURE_FLICK,
  EFL_GESTURE_ZOOM
} Efl_Canvas_Gesture_Recognizer_Type;
#endif /* EFL_BETA_API_SUPPORT */


#endif

#endif
