#ifndef _EFL_GESTURE_EVENTS_EO_H_
#define _EFL_GESTURE_EVENTS_EO_H_

#ifndef _EFL_GESTURE_EVENTS_EO_CLASS_TYPE
#define _EFL_GESTURE_EVENTS_EO_CLASS_TYPE

typedef Eo Efl_Gesture_Events;

#endif

#ifndef _EFL_GESTURE_EVENTS_EO_TYPES
#define _EFL_GESTURE_EVENTS_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
#define EFL_GESTURE_EVENTS_INTERFACE efl_gesture_events_interface_get()

EWAPI const Efl_Class *efl_gesture_events_interface_get(void);

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_TAP;

/** Emitted when a Tap gesture has been detected. A Tap gesture consists of a
 * touch of the screen (or click of the mouse) quickly followed by a release.
 * If the release happens too late a @[Efl.Gesture.Events.gesture,long_tap]
 * event will be emitted instead.
 * @return Efl_Canvas_Gesture_Tap *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_TAP (&(_EFL_EVENT_GESTURE_TAP))

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_DOUBLE_TAP;

/** Emitted when a Double-tap gesture has been detected. A Double-tap gesture
 * consists of two taps on the screen (or clicks of the mouse) in quick
 * succession. If the second one is delayed for too long they will be detected
 * as two independent @[Efl.Gesture.Events.gesture,tap] events.
 * @return Efl_Canvas_Gesture_Double_Tap *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_DOUBLE_TAP (&(_EFL_EVENT_GESTURE_DOUBLE_TAP))

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_TRIPLE_TAP;

/** Emitted when a Triple-tap gesture has been detected. A Triple-tap gesture
 * consists of three taps on the screen (or clicks of the mouse) in quick
 * succession. If any of them is delayed for too long they will be detected as
 * independent @[Efl.Gesture.Events.gesture,tap] or
 * @[Efl.Gesture.Events.gesture,double_tap] events.
 * @return Efl_Canvas_Gesture_Triple_Tap *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_TRIPLE_TAP (&(_EFL_EVENT_GESTURE_TRIPLE_TAP))

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_LONG_TAP;

/** Emitted when a Long-tap gesture has been detected. A Long-tap gesture
 * consists of a touch of the screen (or click of the mouse) followed by a
 * release after some time. If the release happens too quickly a
 * @[Efl.Gesture.Events.gesture,tap] event will be emitted instead.
 * @return Efl_Canvas_Gesture_Long_Tap *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_LONG_TAP (&(_EFL_EVENT_GESTURE_LONG_TAP))

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_MOMENTUM;

/** Emitted when a Momentum gesture has been detected. A Momentum gesture
 * consists of a quick displacement of the finger while touching the screen (or
 * while holding down a mouse button).
 * @return Efl_Canvas_Gesture_Momentum *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_MOMENTUM (&(_EFL_EVENT_GESTURE_MOMENTUM))

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_FLICK;

/** Emitted when a Flick gesture has been detected.
 * @return Efl_Canvas_Gesture_Flick *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_FLICK (&(_EFL_EVENT_GESTURE_FLICK))

EWAPI extern const Efl_Event_Description _EFL_EVENT_GESTURE_ZOOM;

/** Emitted when a Zoom gesture has been detected. A Zoom gesture consists of
 * two fingers touching the screen and separating ("zoom in") or getting closer
 * ("zoom out" or "pinch"). This gesture cannot be performed with a mouse as it
 * requires more than one pointer.
 * @return Efl_Canvas_Gesture_Zoom *
 *
 * @ingroup Efl_Gesture_Events
 */
#define EFL_EVENT_GESTURE_ZOOM (&(_EFL_EVENT_GESTURE_ZOOM))
#endif /* EFL_BETA_API_SUPPORT */

#endif
