﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/connectparticipant/ConnectParticipant_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/connectparticipant/model/Item.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ConnectParticipant
{
namespace Model
{
  class AWS_CONNECTPARTICIPANT_API GetTranscriptResult
  {
  public:
    GetTranscriptResult();
    GetTranscriptResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetTranscriptResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline const Aws::String& GetInitialContactId() const{ return m_initialContactId; }

    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline void SetInitialContactId(const Aws::String& value) { m_initialContactId = value; }

    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline void SetInitialContactId(Aws::String&& value) { m_initialContactId = std::move(value); }

    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline void SetInitialContactId(const char* value) { m_initialContactId.assign(value); }

    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline GetTranscriptResult& WithInitialContactId(const Aws::String& value) { SetInitialContactId(value); return *this;}

    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline GetTranscriptResult& WithInitialContactId(Aws::String&& value) { SetInitialContactId(std::move(value)); return *this;}

    /**
     * <p>The initial contact ID for the contact. </p>
     */
    inline GetTranscriptResult& WithInitialContactId(const char* value) { SetInitialContactId(value); return *this;}


    /**
     * <p>The list of messages in the session.</p>
     */
    inline const Aws::Vector<Item>& GetTranscript() const{ return m_transcript; }

    /**
     * <p>The list of messages in the session.</p>
     */
    inline void SetTranscript(const Aws::Vector<Item>& value) { m_transcript = value; }

    /**
     * <p>The list of messages in the session.</p>
     */
    inline void SetTranscript(Aws::Vector<Item>&& value) { m_transcript = std::move(value); }

    /**
     * <p>The list of messages in the session.</p>
     */
    inline GetTranscriptResult& WithTranscript(const Aws::Vector<Item>& value) { SetTranscript(value); return *this;}

    /**
     * <p>The list of messages in the session.</p>
     */
    inline GetTranscriptResult& WithTranscript(Aws::Vector<Item>&& value) { SetTranscript(std::move(value)); return *this;}

    /**
     * <p>The list of messages in the session.</p>
     */
    inline GetTranscriptResult& AddTranscript(const Item& value) { m_transcript.push_back(value); return *this; }

    /**
     * <p>The list of messages in the session.</p>
     */
    inline GetTranscriptResult& AddTranscript(Item&& value) { m_transcript.push_back(std::move(value)); return *this; }


    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline GetTranscriptResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline GetTranscriptResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The pagination token. Use the value returned previously in the next
     * subsequent request to retrieve the next set of results.</p>
     */
    inline GetTranscriptResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::String m_initialContactId;

    Aws::Vector<Item> m_transcript;

    Aws::String m_nextToken;
  };

} // namespace Model
} // namespace ConnectParticipant
} // namespace Aws
