﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/LightsailRequest.h>
#include <aws/lightsail/model/ContactProtocol.h>
#include <utility>

namespace Aws
{
namespace Lightsail
{
namespace Model
{

  /**
   */
  class AWS_LIGHTSAIL_API DeleteContactMethodRequest : public LightsailRequest
  {
  public:
    DeleteContactMethodRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DeleteContactMethod"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The protocol that will be deleted, such as <code>Email</code> or
     * <code>SMS</code> (text messaging).</p> <note> <p>To delete an <code>Email</code>
     * and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.</p> </note>
     */
    inline const ContactProtocol& GetProtocol() const{ return m_protocol; }

    /**
     * <p>The protocol that will be deleted, such as <code>Email</code> or
     * <code>SMS</code> (text messaging).</p> <note> <p>To delete an <code>Email</code>
     * and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.</p> </note>
     */
    inline bool ProtocolHasBeenSet() const { return m_protocolHasBeenSet; }

    /**
     * <p>The protocol that will be deleted, such as <code>Email</code> or
     * <code>SMS</code> (text messaging).</p> <note> <p>To delete an <code>Email</code>
     * and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.</p> </note>
     */
    inline void SetProtocol(const ContactProtocol& value) { m_protocolHasBeenSet = true; m_protocol = value; }

    /**
     * <p>The protocol that will be deleted, such as <code>Email</code> or
     * <code>SMS</code> (text messaging).</p> <note> <p>To delete an <code>Email</code>
     * and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.</p> </note>
     */
    inline void SetProtocol(ContactProtocol&& value) { m_protocolHasBeenSet = true; m_protocol = std::move(value); }

    /**
     * <p>The protocol that will be deleted, such as <code>Email</code> or
     * <code>SMS</code> (text messaging).</p> <note> <p>To delete an <code>Email</code>
     * and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.</p> </note>
     */
    inline DeleteContactMethodRequest& WithProtocol(const ContactProtocol& value) { SetProtocol(value); return *this;}

    /**
     * <p>The protocol that will be deleted, such as <code>Email</code> or
     * <code>SMS</code> (text messaging).</p> <note> <p>To delete an <code>Email</code>
     * and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.</p> </note>
     */
    inline DeleteContactMethodRequest& WithProtocol(ContactProtocol&& value) { SetProtocol(std::move(value)); return *this;}

  private:

    ContactProtocol m_protocol;
    bool m_protocolHasBeenSet;
  };

} // namespace Model
} // namespace Lightsail
} // namespace Aws
