/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;

public class JoinNodeWayAction
extends JosmAction {
    protected final boolean joinWayToNode;

    protected JoinNodeWayAction(boolean joinWayToNode, String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        super(name, iconName, tooltip, shortcut, registerInToolbar);
        this.joinWayToNode = joinWayToNode;
    }

    public static JoinNodeWayAction createJoinNodeToWayAction() {
        JoinNodeWayAction action = new JoinNodeWayAction(false, I18n.tr("Join Node to Way", new Object[0]), "joinnodeway", I18n.tr("Include a node into the nearest way segments", new Object[0]), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way", new Object[0])), 74, 5003), true);
        action.setHelpId(HelpUtil.ht("/Action/JoinNodeWay"));
        return action;
    }

    public static JoinNodeWayAction createMoveNodeOntoWayAction() {
        JoinNodeWayAction action = new JoinNodeWayAction(true, I18n.tr("Move Node onto Way", new Object[0]), "movenodeontoway", I18n.tr("Move the node onto the nearest way segments and include it", new Object[0]), Shortcut.registerShortcut("tools:movenodeontoway", I18n.tr("Tool: {0}", I18n.tr("Move Node onto Way", new Object[0])), 78, 5003), true);
        action.setHelpId(HelpUtil.ht("/Action/MoveNodeWay"));
        return action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection selectedNodes = ds.getSelectedNodes();
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedHashMap<Way, MultiMap<Integer, Node>> data = new LinkedHashMap<Way, MultiMap<Integer, Node>>();
        boolean restrictToSelectedWays = !ds.getSelectedWays().isEmpty();
        MapView mapView = MainApplication.getMap().mapView;
        block0: for (Node node : selectedNodes) {
            List<WaySegment> wss = mapView.getNearestWaySegments(mapView.getPoint(node), OsmPrimitive::isSelectable);
            TreeMap<Double, List> nearestMap = new TreeMap<Double, List>();
            EastNorth en = node.getEastNorth();
            for (WaySegment ws : wss) {
                if (restrictToSelectedWays && !ws.way.isSelected()) continue;
                double distSq = en.distanceSq(Geometry.closestPointToSegment(ws.getFirstNode().getEastNorth(), ws.getSecondNode().getEastNorth(), en));
                distSq = Double.longBitsToDouble(Double.doubleToLongBits(distSq) >> 32 << 32);
                List wslist = nearestMap.computeIfAbsent(distSq, k -> new LinkedList());
                wslist.add(ws);
            }
            HashSet<Way> seenWays = new HashSet<Way>();
            Double usedDist = null;
            while (!nearestMap.isEmpty()) {
                double d;
                Map.Entry entry = nearestMap.pollFirstEntry();
                if (usedDist != null && (d = (Double)entry.getKey() - usedDist) > 1.0E-4) continue block0;
                for (WaySegment ws : (List)entry.getValue()) {
                    if (!(ws.getFirstNode().equals(node) || ws.getSecondNode().equals(node) || seenWays.contains(ws.way))) {
                        MultiMap<Integer, Node> innerMap;
                        if (usedDist == null) {
                            usedDist = (Double)entry.getKey();
                        }
                        if ((innerMap = (MultiMap)data.get(ws.way)) == null) {
                            innerMap = new MultiMap<Integer, Node>();
                            data.put(ws.way, innerMap);
                        }
                        innerMap.put(ws.lowerIndex, node);
                    }
                    seenWays.add(ws.way);
                }
            }
        }
        HashMap<Node, EastNorth> movedNodes = new HashMap<Node, EastNorth>();
        for (Map.Entry entry : data.entrySet()) {
            Way w = (Way)entry.getKey();
            MultiMap innerEntry = (MultiMap)entry.getValue();
            LinkedList<Object> segmentIndexes = new LinkedList<Object>();
            segmentIndexes.addAll(innerEntry.keySet());
            segmentIndexes.sort(Collections.reverseOrder());
            List<Node> wayNodes = w.getNodes();
            for (Integer n : segmentIndexes) {
                Set nodesInSegment = innerEntry.get(n);
                if (this.joinWayToNode) {
                    for (Node node : nodesInSegment) {
                        EastNorth newPosition = Geometry.closestPointToSegment(w.getNode(n).getEastNorth(), w.getNode(n + 1).getEastNorth(), node.getEastNorth());
                        EastNorth prevMove = (EastNorth)movedNodes.get(node);
                        if (prevMove != null) {
                            if (prevMove.equalsEpsilon(newPosition, 1.0E-4)) continue;
                            new Notification(I18n.tr("Multiple target ways, no common point found. Nothing was changed.", new Object[0])).setIcon(1).show();
                            return;
                        }
                        MoveCommand c = new MoveCommand(node, ProjectionRegistry.getProjection().eastNorth2latlon(newPosition));
                        cmds.add(c);
                        movedNodes.put(node, newPosition);
                    }
                }
                LinkedList<Object> nodesToAdd = new LinkedList<Object>();
                nodesToAdd.addAll(nodesInSegment);
                nodesToAdd.sort(new NodeDistanceToRefNodeComparator(w.getNode(n), w.getNode(n + 1), !this.joinWayToNode));
                wayNodes.addAll(n + 1, nodesToAdd);
            }
            Way wnew = new Way(w);
            wnew.setNodes(wayNodes);
            cmds.add(new ChangeCommand(ds, w, wnew));
        }
        if (cmds.isEmpty()) {
            return;
        }
        UndoRedoHandler.getInstance().add(new SequenceCommand(this.getValue("Name").toString(), cmds));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    private static class NodeDistanceToRefNodeComparator
    implements Comparator<Node>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EastNorth refPoint;
        private final EastNorth refPoint2;
        private final boolean projectToSegment;

        NodeDistanceToRefNodeComparator(Node referenceNode, Node referenceNode2, boolean projectFirst) {
            this.refPoint = referenceNode.getEastNorth();
            this.refPoint2 = referenceNode2.getEastNorth();
            this.projectToSegment = projectFirst;
        }

        @Override
        public int compare(Node first, Node second) {
            EastNorth firstPosition = first.getEastNorth();
            EastNorth secondPosition = second.getEastNorth();
            if (this.projectToSegment) {
                firstPosition = Geometry.closestPointToSegment(this.refPoint, this.refPoint2, firstPosition);
                secondPosition = Geometry.closestPointToSegment(this.refPoint, this.refPoint2, secondPosition);
            }
            double distanceFirst = firstPosition.distance(this.refPoint);
            double distanceSecond = secondPosition.distance(this.refPoint);
            return Double.compare(distanceFirst, distanceSecond);
        }
    }
}

