/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class CycleLayerDownAction
extends JosmAction {
    private static final long serialVersionUID = 1L;
    private static final Shortcut cycleDown = Shortcut.registerShortcut("core:cyclelayerdown", I18n.tr("Cycle layers down", new Object[0]), 93, 5005);

    public CycleLayerDownAction() {
        super(I18n.tr("Cycle layers", new Object[0]), "dialogs/next", I18n.tr("Cycle through layers", new Object[0]), cycleDown, true, "cycle-layer", false);
        new ImageProvider("dialogs", "next").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Cycle through visible layers.", new Object[0]));
        this.putValue("Name", I18n.tr("Cycle layers", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainLayerManager manager = MainApplication.getLayerManager();
        List managerLayers = manager.getLayers().stream().filter(layer -> !(layer instanceof ImageryLayer)).collect(Collectors.toList());
        if (managerLayers.isEmpty()) {
            return;
        }
        List<Object> layers = new ArrayList(managerLayers);
        Collections.reverse(layers);
        int index = layers.indexOf(manager.getActiveLayer());
        int sublist = index < managerLayers.size() - 1 ? index + 1 : 0;
        layers = layers.subList(sublist, layers.size());
        manager.setActiveLayer(layers.stream().filter(Layer::isVisible).filter(tlayer -> !(tlayer instanceof ImageryLayer)).findFirst().orElse(manager.getActiveLayer()));
    }
}

