/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.Arrays;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImageryHandler
extends RequestHandler.RawURLParseRequestHandler {
    public static final String command = "imagery";

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load an imagery layer from the following URL:", new Object[0]) + "<br>" + (String)this.args.get("url");
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"title", "type", "cookies", "min_zoom", "max_zoom"};
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_IMAGERY;
    }

    protected static ImageryInfo findBingEntry() {
        for (ImageryInfo i : ImageryLayerInfo.instance.getDefaultLayers()) {
            if (ImageryInfo.ImageryType.BING != i.getImageryType()) continue;
            return i;
        }
        return null;
    }

    protected ImageryInfo buildImageryInfo() {
        String maxZoom;
        String minZoom;
        ImageryInfo bing;
        String url = (String)this.args.get("url");
        String title = (String)this.args.get("title");
        String type = (String)this.args.get("type");
        ImageryInfo imageryInfo = bing = ImageryInfo.ImageryType.BING.getTypeString().equals(type) ? ImageryHandler.findBingEntry() : null;
        if ((title == null || title.isEmpty()) && bing != null) {
            title = bing.getName();
        }
        if (title == null || title.isEmpty()) {
            title = I18n.tr("Remote imagery", new Object[0]);
        }
        String cookies = (String)this.args.get("cookies");
        ImageryInfo imgInfo = new ImageryInfo(title, url, type, null, cookies);
        if (bing != null) {
            imgInfo.setIcon(bing.getIcon());
        }
        if ((minZoom = (String)this.args.get("min_zoom")) != null && !minZoom.isEmpty()) {
            try {
                imgInfo.setDefaultMinZoom(Integer.parseInt(minZoom));
            }
            catch (NumberFormatException e) {
                Logging.error(e);
            }
        }
        if ((maxZoom = (String)this.args.get("max_zoom")) != null && !maxZoom.isEmpty()) {
            try {
                imgInfo.setDefaultMaxZoom(Integer.parseInt(maxZoom));
            }
            catch (NumberFormatException e) {
                Logging.error(e);
            }
        }
        return imgInfo;
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        ImageryInfo imgInfo = this.buildImageryInfo();
        if (MainApplication.isDisplayingMapView()) {
            for (ImageryLayer layer : MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class)) {
                if (!layer.getInfo().equals(imgInfo)) continue;
                Logging.info("Imagery layer already exists: " + imgInfo);
                return;
            }
        }
        GuiHelper.runInEDT(() -> {
            try {
                MainApplication.getLayerManager().addLayer(ImageryLayer.create(imgInfo));
            }
            catch (IllegalArgumentException e) {
                Logging.log(Logging.LEVEL_ERROR, e);
            }
        });
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        String url = this.args != null ? (String)this.args.get("url") : null;
        String type = this.args != null ? (String)this.args.get("type") : null;
        String cookies = this.args != null ? (String)this.args.get("cookies") : null;
        try {
            ImageryLayer.create(new ImageryInfo(null, url, type, null, cookies));
        }
        catch (IllegalArgumentException e) {
            throw new RequestHandler.RequestHandlerBadRequestException(e.getMessage(), e);
        }
    }

    @Override
    public String getUsage() {
        return "adds an imagery layer (e.g. WMS, TMS)";
    }

    @Override
    public String[] getUsageExamples() {
        String types = String.join((CharSequence)"|", Utils.transform(Arrays.asList(ImageryInfo.ImageryType.values()), ImageryInfo.ImageryType::getTypeString));
        return new String[]{"/imagery?title=osm&type=tms&url=https://a.tile.openstreetmap.org/%7Bzoom%7D/%7Bx%7D/%7By%7D.png", "/imagery?title=landsat&type=wms&url=http://irs.gis-lab.info/?layers=landsat&SRS=%7Bproj%7D&WIDTH=%7Bwidth%7D&HEIGHT=%7Bheight%7D&BBOX=%7Bbbox%7D", "/imagery?title=...&type={" + types + "}&url=....[&cookies=...][&min_zoom=...][&max_zoom=...]"};
    }
}

