/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ProgressOutputStream;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;

public final class Http1Client
extends HttpClient {
    private HttpURLConnection connection;

    public Http1Client(URL url, String requestMethod) {
        super(url, requestMethod);
    }

    @Override
    protected void setupConnection(ProgressMonitor progressMonitor) throws IOException {
        this.connection = (HttpURLConnection)this.getURL().openConnection();
        this.connection.setRequestMethod(this.getRequestMethod());
        this.connection.setRequestProperty("User-Agent", Version.getInstance().getFullAgentString());
        this.connection.setConnectTimeout(this.getConnectTimeout());
        this.connection.setReadTimeout(this.getReadTimeout());
        this.connection.setInstanceFollowRedirects(false);
        if (this.getIfModifiedSince() > 0L) {
            this.connection.setIfModifiedSince(this.getIfModifiedSince());
        }
        this.connection.setUseCaches(this.isUseCache());
        if (!this.isUseCache()) {
            this.connection.setRequestProperty("Cache-Control", "no-cache");
        }
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            if (header.getValue() == null) continue;
            this.connection.setRequestProperty(header.getKey(), header.getValue());
        }
        this.notifyConnect(progressMonitor);
        if (this.requiresBody()) {
            this.logRequestBody();
            byte[] body = this.getRequestBody();
            this.connection.setFixedLengthStreamingMode(body.length);
            this.connection.setDoOutput(true);
            try (BufferedOutputStream out = new BufferedOutputStream(new ProgressOutputStream(this.connection.getOutputStream(), body.length, progressMonitor, this.getOutputMessage(), this.isFinishOnCloseOutput()));){
                ((OutputStream)out).write(body);
            }
        }
    }

    @Override
    protected HttpClient.ConnectionResponse performConnection() throws IOException {
        try {
            this.connection.connect();
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        return new HttpClient.ConnectionResponse(){

            @Override
            public String getResponseVersion() {
                String headerField = Http1Client.this.connection.getHeaderField(0);
                if (headerField != null && headerField.startsWith("HTTP")) {
                    return headerField.replaceFirst(" .*", "");
                }
                return "HTTP/1";
            }

            @Override
            public int getResponseCode() throws IOException {
                return Http1Client.this.connection.getResponseCode();
            }

            @Override
            public String getHeaderField(String name) {
                return Http1Client.this.connection.getHeaderField(name);
            }

            @Override
            public long getContentLengthLong() {
                return Http1Client.this.connection.getContentLengthLong();
            }

            @Override
            public Map<String, List<String>> getHeaderFields() {
                return Http1Client.this.connection.getHeaderFields();
            }
        };
    }

    @Override
    protected void performDisconnection() throws IOException {
        this.connection.disconnect();
    }

    @Override
    protected HttpClient.Response buildResponse(ProgressMonitor progressMonitor) throws IOException {
        return new Http1Response(this.connection, progressMonitor);
    }

    @Override
    public void disconnect() {
        Http1Client.disconnect(this.connection);
    }

    private static void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.setConnectTimeout(100);
            connection.setReadTimeout(100);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logging.warn("InterruptedException in " + Http1Client.class + " during cancel");
                Thread.currentThread().interrupt();
            }
            connection.disconnect();
        }
    }

    public static final class Http1Response
    extends HttpClient.Response {
        private final HttpURLConnection connection;

        private Http1Response(HttpURLConnection connection, ProgressMonitor progressMonitor) throws IOException {
            super(progressMonitor, connection.getResponseCode(), connection.getResponseMessage());
            this.connection = connection;
            this.debugRedirect();
        }

        @Override
        public URL getURL() {
            return this.connection.getURL();
        }

        @Override
        public String getRequestMethod() {
            return this.connection.getRequestMethod();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream in;
            try {
                in = this.connection.getInputStream();
            }
            catch (IOException ioe) {
                Logging.debug(ioe);
                in = Optional.ofNullable(this.connection.getErrorStream()).orElseGet(() -> new ByteArrayInputStream(new byte[0]));
            }
            return in;
        }

        @Override
        public String getContentEncoding() {
            return this.connection.getContentEncoding();
        }

        @Override
        public String getContentType() {
            return this.connection.getHeaderField("Content-Type");
        }

        @Override
        public long getExpiration() {
            return this.connection.getExpiration();
        }

        @Override
        public long getLastModified() {
            return this.connection.getLastModified();
        }

        @Override
        public long getContentLength() {
            return this.connection.getContentLengthLong();
        }

        @Override
        public String getHeaderField(String name) {
            return this.connection.getHeaderField(name);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, List<String>> e : this.connection.getHeaderFields().entrySet()) {
                if (e.getKey() == null) continue;
                ret.put(e.getKey(), e.getValue());
            }
            return Collections.unmodifiableMap(ret);
        }

        @Override
        public void disconnect() {
            Http1Client.disconnect(this.connection);
        }
    }
}

