/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandReferenceMultilinesOverSeveral
extends CommandMultilines<SequenceDiagram> {
    public CommandReferenceMultilinesOverSeveral() {
        super("(?i)^ref(#\\w+)?[%s]+over[%s]+((?:[\\p{L}0-9_.@]+|[%g][^%g]+[%g])(?:[%s]*,[%s]*(?:[\\p{L}0-9_.@]+|[%g][^%g]+[%g]))*)[%s]*(#\\w+)?$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?(ref)?$";
    }

    @Override
    public CommandExecutionResult execute(SequenceDiagram diagram, BlocLines lines) {
        List<String> line0 = StringUtils.getSplit(this.getStartingPattern(), lines.getFirst499().getTrimmed().getString());
        HtmlColor backColorElement = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(line0.get(0));
        List<String> participants = StringUtils.splitComma(line0.get(1));
        ArrayList<Participant> p = new ArrayList<Participant>();
        for (String s : participants) {
            p.add(diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s)));
        }
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display strings = lines.toDisplay();
        Url u = null;
        if (strings.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            u = urlBuilder.getUrl(strings.get(0).toString());
        }
        if (u != null) {
            strings = strings.subList(1, strings.size());
        }
        HtmlColor backColorGeneral = null;
        Reference ref = new Reference(p, u, strings, backColorGeneral, backColorElement, diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addReference(ref);
        return CommandExecutionResult.ok();
    }
}

