/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;

public class PSystemLicense
extends AbstractPSystem
implements UDrawable {
    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(this);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    public static PSystemLicense create() throws IOException {
        return new PSystemLicense();
    }

    private TextBlockBackcolored getGraphicStrings(List<String> strings) {
        return GraphicStrings.createBlackOnWhite(strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(License)");
    }

    @Override
    public void drawU(UGraphic ug) {
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        BufferedImage logo = LicenseInfo.retrieveDistributorImage(licenseInfo);
        if (logo == null) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.addAll(License.getCurrent().getText1(licenseInfo));
            strings.addAll(License.getCurrent().getText2(licenseInfo));
            this.getGraphicStrings(strings).drawU(ug);
        } else {
            ArrayList<String> strings1 = new ArrayList<String>();
            ArrayList<String> strings2 = new ArrayList<String>();
            strings1.addAll(License.getCurrent().getText1(licenseInfo));
            strings2.addAll(License.getCurrent().getText2(licenseInfo));
            TextBlockBackcolored result1 = this.getGraphicStrings(strings1);
            result1.drawU(ug);
            ug = ug.apply(new UTranslate(0.0, 4.0 + result1.calculateDimension(ug.getStringBounder()).getHeight()));
            UImage im = new UImage(logo);
            ug.apply(new UTranslate(20.0, 0.0)).draw(im);
            ug = ug.apply(new UTranslate(0.0, im.getHeight()));
            TextBlockBackcolored result2 = this.getGraphicStrings(strings2);
            result2.drawU(ug);
        }
    }
}

