/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.webp.BoolDecoder;
import net.sourceforge.plantuml.webp.Globals;
import net.sourceforge.plantuml.webp.LoopFilter;
import net.sourceforge.plantuml.webp.MacroBlock;
import net.sourceforge.plantuml.webp.SegmentQuants;
import net.sourceforge.plantuml.webp.SubBlock;

public class VP8Frame {
    private static int BLOCK_TYPES = 4;
    private static int COEF_BANDS = 8;
    private static int MAX_ENTROPY_TOKENS = 12;
    private static int MAX_MODE_LF_DELTAS = 4;
    private static int MAX_REF_LF_DELTAS = 4;
    private static int PREV_COEF_CONTEXTS = 3;
    private ArrayList<IIOReadProgressListener> _listeners = new ArrayList();
    private int bufferCount;
    private int buffersToCreate = 1;
    private int[][][][] coefProbs;
    private boolean debug = false;
    private int filterLevel;
    private int filterType;
    private ImageInputStream frame;
    private int frameType;
    private int height;
    private int macroBlockCols;
    private int macroBlockNoCoeffSkip;
    private int macroBlockRows;
    private MacroBlock[][] macroBlocks;
    private int macroBlockSegementAbsoluteDelta;
    private int[] macroBlockSegmentTreeProbs;
    private int[] modeLoopFilterDeltas = new int[MAX_MODE_LF_DELTAS];
    private int modeRefLoopFilterDeltaEnabled;
    private int modeRefLoopFilterDeltaUpdate;
    private int multiTokenPartition = 0;
    private long offset;
    private int[] refLoopFilterDeltas = new int[MAX_REF_LF_DELTAS];
    private int refreshEntropyProbs;
    private int refreshLastFrame;
    private int segmentationIsEnabled;
    private SegmentQuants segmentQuants;
    private int sharpnessLevel;
    private int simpleFilter;
    private BoolDecoder tokenBoolDecoder;
    private Vector<BoolDecoder> tokenBoolDecoders;
    private int updateMacroBlockSegmentationMap;
    private int updateMacroBlockSegmentatonData;
    private int width;

    public VP8Frame(ImageInputStream stream) throws IOException {
        this.frame = stream;
        this.offset = this.frame.getStreamPosition();
        this.coefProbs = Globals.getDefaultCoefProbs();
        this.tokenBoolDecoders = new Vector();
    }

    public VP8Frame(ImageInputStream stream, int[][][][] coefProbs) throws IOException {
        this.frame = stream;
        this.offset = this.frame.getStreamPosition();
        this.coefProbs = coefProbs;
        this.tokenBoolDecoders = new Vector();
    }

    public void addIIOReadProgressListener(IIOReadProgressListener listener) {
        this._listeners.add(listener);
    }

    private void createMacroBlocks() {
        this.macroBlocks = new MacroBlock[this.macroBlockCols + 2][this.macroBlockRows + 2];
        for (int x = 0; x < this.macroBlockCols + 2; ++x) {
            for (int y = 0; y < this.macroBlockRows + 2; ++y) {
                this.macroBlocks[x][y] = new MacroBlock(x, y, this.debug);
            }
        }
    }

    public boolean decodeFrame(boolean debug) throws IOException {
        int i;
        this.debug = debug;
        this.segmentQuants = new SegmentQuants();
        this.frame.seek(this.offset++);
        int c = this.frame.readUnsignedByte();
        this.frameType = this.getBitAsInt(c, 0);
        if (this.frameType != 0) {
            return false;
        }
        int versionNumber = this.getBitAsInt(c, 1) << 1;
        versionNumber += this.getBitAsInt(c, 2) << 1;
        versionNumber += this.getBitAsInt(c, 3);
        int firstPartitionLengthInBytes = this.getBitAsInt(c, 5) << 0;
        firstPartitionLengthInBytes += this.getBitAsInt(c, 6) << 1;
        firstPartitionLengthInBytes += this.getBitAsInt(c, 7) << 2;
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        firstPartitionLengthInBytes += c << 3;
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        firstPartitionLengthInBytes += c << 11;
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        int hBytes = c = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        this.width = (hBytes += c << 8) & 0x3FFF;
        this.frame.seek(this.offset++);
        int vBytes = c = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        c = this.frame.readUnsignedByte();
        this.height = (vBytes += c << 8) & 0x3FFF;
        int tWidth = this.width;
        int tHeight = this.height;
        if ((tWidth & 0xF) != 0) {
            tWidth += 16 - (tWidth & 0xF);
        }
        if ((tHeight & 0xF) != 0) {
            tHeight += 16 - (tHeight & 0xF);
        }
        this.macroBlockRows = tHeight >> 4;
        this.macroBlockCols = tWidth >> 4;
        this.createMacroBlocks();
        BoolDecoder bc = new BoolDecoder(this.frame, this.offset);
        if (this.frameType == 0) {
            int clr_type = bc.readBit();
            int n = bc.readBit();
        }
        this.segmentationIsEnabled = bc.readBit();
        if (this.segmentationIsEnabled > 0) {
            this.updateMacroBlockSegmentationMap = bc.readBit();
            this.updateMacroBlockSegmentatonData = bc.readBit();
            if (this.updateMacroBlockSegmentatonData > 0) {
                int value;
                this.macroBlockSegementAbsoluteDelta = bc.readBit();
                for (i = 0; i < 4; ++i) {
                    value = 0;
                    if (bc.readBit() > 0) {
                        value = bc.readLiteral(Globals.vp8MacroBlockFeatureDataBits[0]);
                        if (bc.readBit() > 0) {
                            value = -value;
                        }
                    }
                    this.segmentQuants.getSegQuants()[i].setQindex(value);
                }
                for (i = 0; i < 4; ++i) {
                    value = 0;
                    if (bc.readBit() > 0) {
                        value = bc.readLiteral(Globals.vp8MacroBlockFeatureDataBits[1]);
                        if (bc.readBit() > 0) {
                            value = -value;
                        }
                    }
                    this.segmentQuants.getSegQuants()[i].setFilterStrength(value);
                }
                if (this.updateMacroBlockSegmentationMap > 0) {
                    this.macroBlockSegmentTreeProbs = new int[3];
                    for (i = 0; i < 3; ++i) {
                        value = 255;
                        value = bc.readBit() > 0 ? bc.readLiteral(8) : 255;
                        this.macroBlockSegmentTreeProbs[i] = value;
                    }
                }
            }
        }
        this.simpleFilter = bc.readBit();
        this.filterLevel = bc.readLiteral(6);
        this.sharpnessLevel = bc.readLiteral(3);
        this.modeRefLoopFilterDeltaEnabled = bc.readBit();
        if (this.modeRefLoopFilterDeltaEnabled > 0) {
            this.modeRefLoopFilterDeltaUpdate = bc.readBit();
            if (this.modeRefLoopFilterDeltaUpdate > 0) {
                for (i = 0; i < MAX_REF_LF_DELTAS; ++i) {
                    if (bc.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[i] = bc.readLiteral(6);
                    if (bc.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[i] = this.refLoopFilterDeltas[i] * -1;
                }
                for (i = 0; i < MAX_MODE_LF_DELTAS; ++i) {
                    if (bc.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[i] = bc.readLiteral(6);
                    if (bc.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[i] = this.modeLoopFilterDeltas[i] * -1;
                }
            }
        }
        this.filterType = this.filterLevel == 0 ? 0 : (this.simpleFilter > 0 ? 1 : 2);
        this.setupTokenDecoder(bc, firstPartitionLengthInBytes, this.offset);
        bc.seek();
        this.segmentQuants.parse(bc, this.segmentationIsEnabled == 1, this.macroBlockSegementAbsoluteDelta == 1);
        if (this.frameType != 0) {
            throw new IllegalArgumentException("bad input: not intra");
        }
        this.refreshEntropyProbs = bc.readBit();
        if (this.refreshEntropyProbs > 0) {
            // empty if block
        }
        this.refreshLastFrame = 0;
        this.refreshLastFrame = this.frameType == 0 ? 1 : bc.readBit();
        for (i = 0; i < BLOCK_TYPES; ++i) {
            for (int j = 0; j < COEF_BANDS; ++j) {
                for (int k = 0; k < PREV_COEF_CONTEXTS; ++k) {
                    for (int l = 0; l < MAX_ENTROPY_TOKENS - 1; ++l) {
                        int newp;
                        if (bc.readBool(Globals.vp8CoefUpdateProbs[i][j][k][l]) <= 0) continue;
                        this.coefProbs[i][j][k][l] = newp = bc.readLiteral(8);
                    }
                }
            }
        }
        this.macroBlockNoCoeffSkip = bc.readBit();
        if (this.frameType != 0) {
            throw new IllegalArgumentException("bad input: not intra");
        }
        this.readModes(bc);
        int ibc = 0;
        int num_part = 1 << this.multiTokenPartition;
        for (int mb_row = 0; mb_row < this.macroBlockRows; ++mb_row) {
            if (num_part > 1) {
                this.tokenBoolDecoder = this.tokenBoolDecoders.elementAt(ibc);
                this.tokenBoolDecoder.seek();
                this.decodeMacroBlockRow(mb_row);
                if (++ibc == num_part) {
                    ibc = 0;
                }
            } else {
                this.decodeMacroBlockRow(mb_row);
            }
            this.fireProgressUpdate(mb_row);
        }
        if (this.getFilterType() > 0 && this.getFilterLevel() != 0) {
            this.loopFilter();
        }
        return true;
    }

    private void decodeMacroBlockRow(int mbRow) throws IOException {
        for (int mbCol = 0; mbCol < this.macroBlockCols; ++mbCol) {
            MacroBlock mb = this.getMacroBlock(mbCol, mbRow);
            mb.decodeMacroBlock(this);
            mb.dequantMacroBlock(this);
        }
    }

    public void fireLFProgressUpdate(float p) {
        Iterator<IIOReadProgressListener> listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().imageProgress(null, (float)(100 / this.buffersToCreate) + p / (float)this.buffersToCreate);
        }
    }

    private void fireProgressUpdate(int mb_row) {
        Iterator<IIOReadProgressListener> listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().imageProgress(null, 100.0f * ((float)(mb_row + 1) / (float)this.getMacroBlockRows()) / (float)this.buffersToCreate);
        }
    }

    public void fireRGBProgressUpdate(float p) {
        Iterator<IIOReadProgressListener> listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().imageProgress(null, (float)((this.bufferCount + 4) * (100 / this.buffersToCreate)) + p / (float)this.buffersToCreate);
        }
    }

    public SubBlock getAboveRightSubBlock(SubBlock sb, SubBlock.PLANE plane) {
        MacroBlock mb = sb.getMacroBlock();
        int x = mb.getSubblockX(sb);
        int y = mb.getSubblockY(sb);
        if (plane == SubBlock.PLANE.Y1) {
            if (y == 0 && x < 3) {
                MacroBlock mb2 = this.getMacroBlock(mb.getX(), mb.getY() - 1);
                SubBlock r = mb2.getSubBlock(plane, x + 1, 3);
                return r;
            }
            if (y == 0 && x == 3) {
                MacroBlock mb2 = this.getMacroBlock(mb.getX() + 1, mb.getY() - 1);
                SubBlock r = mb2.getSubBlock(plane, 0, 3);
                if (mb2.getX() == this.getMacroBlockCols()) {
                    int[][] dest = new int[4][4];
                    for (int b = 0; b < 4; ++b) {
                        for (int a = 0; a < 4; ++a) {
                            dest[a][b] = mb2.getY() < 0 ? 127 : this.getMacroBlock(mb.getX(), mb.getY() - 1).getSubBlock(SubBlock.PLANE.Y1, 3, 3).getDest()[3][3];
                        }
                    }
                    r = new SubBlock(mb2, null, null, SubBlock.PLANE.Y1);
                    r.setDest(dest);
                }
                return r;
            }
            if (y > 0 && x < 3) {
                SubBlock r = mb.getSubBlock(plane, x + 1, y - 1);
                return r;
            }
            SubBlock sb2 = mb.getSubBlock(sb.getPlane(), 3, 0);
            return this.getAboveRightSubBlock(sb2, plane);
        }
        throw new IllegalArgumentException("bad input: getAboveRightSubBlock()");
    }

    public SubBlock getAboveSubBlock(SubBlock sb, SubBlock.PLANE plane) {
        SubBlock r = sb.getAbove();
        if (r == null) {
            MacroBlock mb = sb.getMacroBlock();
            int x = mb.getSubblockX(sb);
            MacroBlock mb2 = this.getMacroBlock(mb.getX(), mb.getY() - 1);
            while (plane == SubBlock.PLANE.Y2 && mb2.getYMode() == 4) {
                mb2 = this.getMacroBlock(mb2.getX(), mb2.getY() - 1);
            }
            r = mb2.getBottomSubBlock(x, sb.getPlane());
        }
        return r;
    }

    private boolean getBit(int data, int bit) {
        int r = data & 1 << bit;
        return r > 0;
    }

    private int getBitAsInt(int data, int bit) {
        int r = data & 1 << bit;
        if (r > 0) {
            return 1;
        }
        return 0;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.useBufferedImage(bi);
        ++this.bufferCount;
        return bi;
    }

    public int[][][][] getCoefProbs() {
        return this.coefProbs;
    }

    public BufferedImage getDebugImageDiff() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int[] c = new int[3];
                int yy = 127 + this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.Y1, x % 16 / 4, y % 16 / 4).getDiff()[x % 4][y % 4];
                int u = 127 + this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getDiff()[x / 2 % 4][y / 2 % 4];
                int v = 127 + this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getDiff()[x / 2 % 4][y / 2 % 4];
                c[0] = (int)(1.164 * (double)(yy - 16) + 1.596 * (double)(v - 128));
                c[1] = (int)(1.164 * (double)(yy - 16) - 0.813 * (double)(v - 128) - 0.391 * (double)(u - 128));
                c[2] = (int)(1.164 * (double)(yy - 16) + 2.018 * (double)(u - 128));
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImagePredict() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int[] c = new int[3];
                int yy = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.Y1, x % 16 / 4, y % 16 / 4).getPredict()[x % 4][y % 4];
                int u = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getPredict()[x / 2 % 4][y / 2 % 4];
                int v = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getPredict()[x / 2 % 4][y / 2 % 4];
                c[0] = (int)(1.164 * (double)(yy - 16) + 1.596 * (double)(v - 128));
                c[1] = (int)(1.164 * (double)(yy - 16) - 0.813 * (double)(v - 128) - 0.391 * (double)(u - 128));
                c[2] = (int)(1.164 * (double)(yy - 16) + 2.018 * (double)(u - 128));
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageUBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int u = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getDest()[x / 2 % 4][y / 2 % 4];
                int[] c = new int[]{u, u, u};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageUDiffBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int u = 127 + this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getDiff()[x / 2 % 4][y / 2 % 4];
                int[] c = new int[]{u, u, u};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageUPredBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int u = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getPredict()[x / 2 % 4][y / 2 % 4];
                int[] c = new int[]{u, u, u};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageVBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int v = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getDest()[x / 2 % 4][y / 2 % 4];
                int[] c = new int[]{v, v, v};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageVDiffBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int v = 127 + this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getDiff()[x / 2 % 4][y / 2 % 4];
                int[] c = new int[]{v, v, v};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageVPredBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int v = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getPredict()[x / 2 % 4][y / 2 % 4];
                int[] c = new int[]{v, v, v};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageYBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int yy = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.Y1, x % 16 / 4, y % 16 / 4).getDest()[x % 4][y % 4];
                int[] c = new int[]{yy, yy, yy};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageYDiffBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int yy = 127 + this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.Y1, x % 16 / 4, y % 16 / 4).getDiff()[x % 4][y % 4];
                int[] c = new int[]{yy, yy, yy};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public BufferedImage getDebugImageYPredBuffer() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster imRas = bi.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int yy = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.Y1, x % 16 / 4, y % 16 / 4).getPredict()[x % 4][y % 4];
                int[] c = new int[]{yy, yy, yy};
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bi;
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public int getHeight() {
        return this.height;
    }

    public SubBlock getLeftSubBlock(SubBlock sb, SubBlock.PLANE plane) {
        SubBlock r = sb.getLeft();
        if (r == null) {
            MacroBlock mb = sb.getMacroBlock();
            int y = mb.getSubblockY(sb);
            MacroBlock mb2 = this.getMacroBlock(mb.getX() - 1, mb.getY());
            while (plane == SubBlock.PLANE.Y2 && mb2.getYMode() == 4) {
                mb2 = this.getMacroBlock(mb2.getX() - 1, mb2.getY());
            }
            r = mb2.getRightSubBlock(y, sb.getPlane());
        }
        return r;
    }

    public MacroBlock getMacroBlock(int mbCol, int mbRow) {
        return this.macroBlocks[mbCol + 1][mbRow + 1];
    }

    public int getMacroBlockCols() {
        return this.macroBlockCols;
    }

    public String getMacroBlockDebugString(int mbx, int mby, int sbx, int sby) {
        String r = new String();
        if (mbx < this.macroBlockCols && mby < this.getMacroBlockRows()) {
            MacroBlock mb = this.getMacroBlock(mbx, mby);
            r = r + mb.getDebugString();
            if (sbx < 4 && sby < 4) {
                SubBlock sb = mb.getSubBlock(SubBlock.PLANE.Y1, sbx, sby);
                r = r + "\n SubBlock " + sbx + ", " + sby + "\n  " + sb.getDebugString();
                sb = mb.getSubBlock(SubBlock.PLANE.Y2, sbx, sby);
                r = r + "\n SubBlock " + sbx + ", " + sby + "\n  " + sb.getDebugString();
                sb = mb.getSubBlock(SubBlock.PLANE.U, sbx / 2, sby / 2);
                r = r + "\n SubBlock " + sbx / 2 + ", " + sby / 2 + "\n  " + sb.getDebugString();
                sb = mb.getSubBlock(SubBlock.PLANE.V, sbx / 2, sby / 2);
                r = r + "\n SubBlock " + sbx / 2 + ", " + sby / 2 + "\n  " + sb.getDebugString();
            }
        }
        return r;
    }

    public int getMacroBlockRows() {
        return this.macroBlockRows;
    }

    public int getQIndex() {
        return this.segmentQuants.getqIndex();
    }

    public SegmentQuants getSegmentQuants() {
        return this.segmentQuants;
    }

    public int getSharpnessLevel() {
        return this.sharpnessLevel;
    }

    public BoolDecoder getTokenBoolDecoder() throws IOException {
        this.tokenBoolDecoder.seek();
        return this.tokenBoolDecoder;
    }

    public int[][] getUBuffer() {
        int[][] r = new int[this.macroBlockCols * 8][this.macroBlockRows * 8];
        for (int y = 0; y < this.macroBlockRows; ++y) {
            for (int x = 0; x < this.macroBlockCols; ++x) {
                MacroBlock mb = this.macroBlocks[x + 1][y + 1];
                for (int b = 0; b < 2; ++b) {
                    for (int a = 0; a < 2; ++a) {
                        SubBlock sb = mb.getUSubBlock(a, b);
                        for (int d = 0; d < 4; ++d) {
                            for (int c = 0; c < 4; ++c) {
                                r[x * 8 + a * 4 + c][y * 8 + b * 4 + d] = sb.getDest()[c][d];
                            }
                        }
                    }
                }
            }
        }
        return r;
    }

    public int[][] getVBuffer() {
        int[][] r = new int[this.macroBlockCols * 8][this.macroBlockRows * 8];
        for (int y = 0; y < this.macroBlockRows; ++y) {
            for (int x = 0; x < this.macroBlockCols; ++x) {
                MacroBlock mb = this.macroBlocks[x + 1][y + 1];
                for (int b = 0; b < 2; ++b) {
                    for (int a = 0; a < 2; ++a) {
                        SubBlock sb = mb.getVSubBlock(a, b);
                        for (int d = 0; d < 4; ++d) {
                            for (int c = 0; c < 4; ++c) {
                                r[x * 8 + a * 4 + c][y * 8 + b * 4 + d] = sb.getDest()[c][d];
                            }
                        }
                    }
                }
            }
        }
        return r;
    }

    public int getWidth() {
        return this.width;
    }

    public int[][] getYBuffer() {
        int[][] r = new int[this.macroBlockCols * 16][this.macroBlockRows * 16];
        for (int y = 0; y < this.macroBlockRows; ++y) {
            for (int x = 0; x < this.macroBlockCols; ++x) {
                MacroBlock mb = this.macroBlocks[x + 1][y + 1];
                for (int b = 0; b < 4; ++b) {
                    for (int a = 0; a < 4; ++a) {
                        SubBlock sb = mb.getYSubBlock(a, b);
                        for (int d = 0; d < 4; ++d) {
                            for (int c = 0; c < 4; ++c) {
                                r[x * 16 + a * 4 + c][y * 16 + b * 4 + d] = sb.getDest()[c][d];
                            }
                        }
                    }
                }
            }
        }
        return r;
    }

    public void loopFilter() {
        LoopFilter.loopFilter(this);
    }

    private void readModes(BoolDecoder bc) throws IOException {
        int mb_row = -1;
        int prob_skip_false = 0;
        if (this.macroBlockNoCoeffSkip > 0) {
            prob_skip_false = bc.readLiteral(8);
        }
        while (++mb_row < this.macroBlockRows) {
            int mb_col = -1;
            while (++mb_col < this.macroBlockCols) {
                MacroBlock mb = this.getMacroBlock(mb_col, mb_row);
                if (this.segmentationIsEnabled > 0 && this.updateMacroBlockSegmentationMap > 0) {
                    int value = bc.readTree(Globals.macroBlockSegmentTree, this.macroBlockSegmentTreeProbs);
                    mb.setSegmentId(value);
                }
                if (this.modeRefLoopFilterDeltaEnabled > 0) {
                    int level = this.filterLevel;
                    level = (level += this.refLoopFilterDeltas[0]) < 0 ? 0 : (level > 63 ? 63 : level);
                    mb.setFilterLevel(level);
                } else {
                    mb.setFilterLevel(this.segmentQuants.getSegQuants()[mb.getSegmentId()].getFilterStrength());
                }
                int mb_skip_coeff = 0;
                mb_skip_coeff = this.macroBlockNoCoeffSkip > 0 ? bc.readBool(prob_skip_false) : 0;
                mb.setSkipCoeff(mb_skip_coeff);
                int y_mode = this.readYMode(bc);
                mb.setYMode(y_mode);
                if (y_mode == 4) {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            SubBlock sb = mb.getYSubBlock(j, i);
                            SubBlock A = this.getAboveSubBlock(sb, SubBlock.PLANE.Y1);
                            SubBlock L = this.getLeftSubBlock(sb, SubBlock.PLANE.Y1);
                            int mode = this.readSubBlockMode(bc, A.getMode(), L.getMode());
                            sb.setMode(mode);
                        }
                    }
                    if (this.modeRefLoopFilterDeltaEnabled > 0) {
                        int level = mb.getFilterLevel();
                        level = (level += this.modeLoopFilterDeltas[0]) < 0 ? 0 : (level > 63 ? 63 : level);
                        mb.setFilterLevel(level);
                    }
                } else {
                    int BMode;
                    switch (y_mode) {
                        case 0: {
                            BMode = 0;
                            break;
                        }
                        case 1: {
                            BMode = 2;
                            break;
                        }
                        case 2: {
                            BMode = 3;
                            break;
                        }
                        case 3: {
                            BMode = 1;
                            break;
                        }
                        default: {
                            BMode = 0;
                        }
                    }
                    for (int x = 0; x < 4; ++x) {
                        for (int y = 0; y < 4; ++y) {
                            SubBlock sb = mb.getYSubBlock(x, y);
                            sb.setMode(BMode);
                        }
                    }
                }
                int mode = this.readUvMode(bc);
                mb.setUvMode(mode);
            }
        }
    }

    private int readPartitionSize(long l) throws IOException {
        this.frame.seek(l);
        int size = this.frame.readUnsignedByte() + (this.frame.readUnsignedByte() << 8) + (this.frame.readUnsignedByte() << 16);
        return size;
    }

    private int readSubBlockMode(BoolDecoder bc, int A, int L) throws IOException {
        int i = bc.readTree(Globals.vp8SubBlockModeTree, Globals.vp8KeyFrameSubBlockModeProb[A][L]);
        return i;
    }

    private int readUvMode(BoolDecoder bc) throws IOException {
        int i = bc.readTree(Globals.vp8UVModeTree, Globals.vp8KeyFrameUVModeProb);
        return i;
    }

    private int readYMode(BoolDecoder bc) throws IOException {
        int i = bc.readTree(Globals.vp8KeyFrameYModeTree, Globals.vp8KeyFrameYModeProb);
        return i;
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener listener) {
        this._listeners.remove(listener);
    }

    public void setBuffersToCreate(int count) {
        this.buffersToCreate = 3 + count;
        this.bufferCount = 0;
    }

    private void setupTokenDecoder(BoolDecoder bc, int first_partition_length_in_bytes, long offset) throws IOException {
        long partitionsStart;
        long partitionSize = 0L;
        long partition = partitionsStart = offset + (long)first_partition_length_in_bytes;
        this.multiTokenPartition = bc.readLiteral(2);
        int num_part = 1 << this.multiTokenPartition;
        if (num_part > 1) {
            partition += (long)(3 * (num_part - 1));
        }
        for (int i = 0; i < num_part; ++i) {
            if (i < num_part - 1) {
                partitionSize = this.readPartitionSize(partitionsStart + (long)(i * 3));
                bc.seek();
            } else {
                partitionSize = this.frame.length() - partition;
            }
            this.tokenBoolDecoders.add(new BoolDecoder(this.frame, partition));
            partition += partitionSize;
        }
        this.tokenBoolDecoder = this.tokenBoolDecoders.elementAt(0);
    }

    public void useBufferedImage(BufferedImage dst) {
        WritableRaster imRas = dst.getWritableTile(0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int[] c = new int[3];
                int yy = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.Y1, x % 16 / 4, y % 16 / 4).getDest()[x % 4][y % 4];
                int u = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.U, x / 2 % 8 / 4, y / 2 % 8 / 4).getDest()[x / 2 % 4][y / 2 % 4];
                int v = this.getMacroBlock(x / 16, y / 16).getSubBlock(SubBlock.PLANE.V, x / 2 % 8 / 4, y / 2 % 8 / 4).getDest()[x / 2 % 4][y / 2 % 4];
                c[0] = (int)(1.164 * (double)(yy - 16) + 1.596 * (double)(v - 128));
                c[1] = (int)(1.164 * (double)(yy - 16) - 0.813 * (double)(v - 128) - 0.391 * (double)(u - 128));
                c[2] = (int)(1.164 * (double)(yy - 16) + 2.018 * (double)(u - 128));
                for (int z = 0; z < 3; ++z) {
                    if (c[z] < 0) {
                        c[z] = 0;
                    }
                    if (c[z] <= 255) continue;
                    c[z] = 255;
                }
                imRas.setPixel(x, y, c);
            }
            this.fireRGBProgressUpdate(100.0f * (float)x / (float)this.getWidth());
        }
    }

    public void setFrame(ImageInputStream frame) {
        try {
            this.frame.flush();
            this.frame.close();
            this.frame = frame;
            this.offset = frame.getStreamPosition();
            this.coefProbs = Globals.getDefaultCoefProbs();
            this.tokenBoolDecoders = new Vector();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

