/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import java.util.Arrays;

public class PBEKeySpec
implements KeySpec {
    private char[] password;
    private byte[] salt = null;
    private int iterationCount = 0;
    private int keyLength = 0;

    public PBEKeySpec(char[] password) {
        this.password = password == null || password.length == 0 ? new char[0] : (char[])password.clone();
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount, int keyLength) {
        this.password = password == null || password.length == 0 ? new char[0] : (char[])password.clone();
        if (salt == null) {
            throw new NullPointerException("the salt parameter must be non-null");
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException("the salt parameter must not be empty");
        }
        this.salt = (byte[])salt.clone();
        if (iterationCount <= 0) {
            throw new IllegalArgumentException("invalid iterationCount value");
        }
        if (keyLength <= 0) {
            throw new IllegalArgumentException("invalid keyLength value");
        }
        this.iterationCount = iterationCount;
        this.keyLength = keyLength;
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount) {
        this.password = password == null || password.length == 0 ? new char[0] : (char[])password.clone();
        if (salt == null) {
            throw new NullPointerException("the salt parameter must be non-null");
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException("the salt parameter must not be empty");
        }
        this.salt = (byte[])salt.clone();
        if (iterationCount <= 0) {
            throw new IllegalArgumentException("invalid iterationCount value");
        }
        this.iterationCount = iterationCount;
    }

    public final void clearPassword() {
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
    }

    public final char[] getPassword() {
        if (this.password == null) {
            throw new IllegalStateException("password has been cleared");
        }
        return (char[])this.password.clone();
    }

    public final byte[] getSalt() {
        if (this.salt != null) {
            return (byte[])this.salt.clone();
        }
        return null;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }
}

