/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.netbeans.core.startup.logging.NbFormatter;
import org.openide.util.RequestProcessor;

final class DispatchingHandler
extends Handler
implements Runnable {
    private static final int LIMIT = 1024;
    private static RequestProcessor RP = new RequestProcessor("Logging Flush", 1, false, false);
    private static ThreadLocal<Boolean> FLUSHING = new ThreadLocal();
    private final Handler delegate;
    private final BlockingQueue<LogRecord> queue = new LinkedBlockingQueue<LogRecord>(1024);
    private RequestProcessor.Task flush;
    private int delay;

    DispatchingHandler(Handler handler, int n) {
        this.delegate = handler;
        this.flush = RP.create((Runnable)this, true);
        this.flush.setPriority(1);
        this.delay = n;
    }

    @Override
    public void setFormatter(Formatter formatter) throws SecurityException {
        this.delegate.setFormatter(formatter);
    }

    @Override
    public void publish(LogRecord logRecord) {
        Throwable throwable;
        if (RP.isRequestProcessorThread()) {
            return;
        }
        boolean bl = this.queue.isEmpty();
        if (!this.queue.offer(logRecord)) {
            while (true) {
                try {
                    if (!this.schedule(true)) {
                        return;
                    }
                    this.queue.put(logRecord);
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if ((throwable = logRecord.getThrown()) != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StackTraceElement[] stackTraceElementArray2 = new Throwable().getStackTrace();
            for (int i = 1; i <= Math.min(stackTraceElementArray.length, stackTraceElementArray2.length); ++i) {
                if (stackTraceElementArray[stackTraceElementArray.length - i].equals(stackTraceElementArray2[stackTraceElementArray2.length - i])) continue;
                NbFormatter.registerCatchIndex(throwable, stackTraceElementArray.length - i);
                break;
            }
        }
        if (bl) {
            this.schedule(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedule(boolean bl) {
        if (!Boolean.TRUE.equals(FLUSHING.get())) {
            try {
                int n;
                FLUSHING.set(true);
                if (bl) {
                    n = 0;
                } else {
                    int n2 = 1024 - this.queue.size();
                    n = this.delay * n2 / 1024;
                    assert (n <= this.delay) : "d: " + n + " delay: " + this.delay;
                    assert (n >= 0) : "d: " + n;
                }
                this.flush.schedule(n);
            }
            finally {
                FLUSHING.set(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        this.flush.cancel();
        this.flush.waitFinished();
        this.run();
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
        this.delegate.flush();
    }

    final void doClose() throws SecurityException {
        this.flush();
        this.delegate.close();
    }

    @Override
    public Formatter getFormatter() {
        return this.delegate.getFormatter();
    }

    static Handler getInternal(Handler handler) {
        if (handler instanceof DispatchingHandler) {
            return ((DispatchingHandler)handler).delegate;
        }
        return handler;
    }

    @Override
    public void run() {
        if (this.queue.isEmpty()) {
            return;
        }
        while (true) {
            LogRecord logRecord;
            if ((logRecord = (LogRecord)this.queue.poll()) == null) break;
            this.delegate.publish(logRecord);
        }
        this.schedule(false);
        this.delegate.flush();
    }
}

