/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kok extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u092b\u093f\u091c\u0940";
        final String metaValue_ar = "\u0905\u0930\u0947\u092c\u093f\u0915";
        final String metaValue_bn = "\u092c\u093e\u0902\u0917\u094d\u0932\u093e";
        final String metaValue_bo = "\u0924\u093f\u092c\u0947\u0924\u093f\u092f\u0928";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_he = "\u0939\u093f\u092c\u094d\u0930\u0942";
        final String metaValue_hy = "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u0928";
        final String metaValue_ja = "\u091c\u092a\u093e\u0928\u0940";
        final String metaValue_lo = "\u0932\u093e\u0913";
        final String metaValue_or = "\u0913\u0930\u093f\u092f\u093e";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0942";
        final String metaValue_th = "\u0925\u093e\u0908";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0915\u094b\u0932\u094b\u0928\u093f\u092f\u0928" },
            { "mwl", "\u092e\u093f\u0930\u093e\u0902\u0921\u0940\u0938" },
            { "Zsym", "\u091a\u093f\u0928\u094d\u0928\u093e\u0902" },
            { "Zsye", "Emoji" },
            { "tem", "\u0924\u093f\u092e\u094d\u0928\u0947" },
            { "teo", "\u0924\u0947\u0938\u094b" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u094d\u092f\u0941" },
            { "AC", "\u0905\u0938\u0947\u0936\u0928 \u0906\u092f\u0932\u0901\u0921" },
            { "rar", "\u0930\u093e\u0930\u094b\u091f\u094b\u0902\u0917\u093e\u0928" },
            { "tet", "\u0924\u0947\u0924\u092e" },
            { "AD", "\u0905\u0902\u0921\u094b\u0930\u093e" },
            { "AE", "\u092f\u0941\u0928\u093e\u0907\u091f\u0947\u0921 \u0905\u0930\u092c \u0907\u092e\u0940\u0930\u0945\u091f\u094d\u0938" },
            { "nl_BE", "\u092b\u094d\u0932\u0947\u092e\u093f\u0936" },
            { "AF", "\u0905\u092b\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0901\u091f\u093f\u0917\u0941\u0906 \u0906\u0928\u0940 \u092c\u093e\u0930\u092c\u0941\u0921\u093e" },
            { "type.ca.ethiopic", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "AI", "\u0905\u0902\u0917\u0941\u0932\u093e" },
            { "AL", "\u0905\u0932\u094d\u092c\u093e\u0928\u0940\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0940\u0928\u0940\u092f\u093e" },
            { "AO", "\u0905\u0902\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u094d\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e" },
            { "AS", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u093e\u092e\u094b\u0906" },
            { "AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u0940\u092f\u093e" },
            { "AW", "\u0905\u0930\u0941\u092c\u093e" },
            { "en_US", "\u0905\u092e\u0947\u0930\u093f\u0915\u0928 \u0907\u0902\u0917\u094d\u0932\u0940\u0936" },
            { "AX", "\u0905\u0932\u093e\u0902\u0921 \u091c\u0941\u0935\u0947" },
            { "AZ", "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928" },
            { "BA", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0906\u0928\u0940 \u0939\u0947\u0930\u094d\u091c\u0947\u0917\u094b\u0935\u093f\u0928\u093e" },
            { "BB", "\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938" },
            { "ceb", "\u0938\u093f\u092c\u094c\u0928\u093e" },
            { "BD", "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936" },
            { "kum", "\u0915\u0941\u092e\u092f\u0915" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u0945\u0938\u094b" },
            { "BG", "\u092c\u0932\u094d\u0917\u0947\u0930\u0940\u092f\u093e" },
            { "BH", "\u092c\u0947\u0939\u0930\u0947\u0928" },
            { "BI", "\u092c\u0941\u0930\u0941\u0902\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u0940\u0928" },
            { "BL", "\u0938\u0945\u0902\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u094d\u092e\u0940" },
            { "BM", "\u092c\u0930\u094d\u092e\u0941\u0921\u093e" },
            { "myv", "\u090f\u0930\u091d\u093f\u092f\u093e" },
            { "BN", "\u092c\u094d\u0930\u0942\u0928\u0947\u0908" },
            { "BO", "\u092c\u094b\u0932\u093f\u0935\u094d\u0939\u093f\u092f\u093e" },
            { "BQ", "\u0915\u0945\u0930\u093f\u092c\u093f\u092f\u0928 \u0928\u093f\u0926\u0930\u0932\u0901\u0921" },
            { "BR", "\u092c\u094d\u0930\u093e\u091d\u0940\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e\u0938" },
            { "xog", "\u0938\u094b\u0917\u093e" },
            { "BT", "\u092d\u0942\u0924\u093e\u0928" },
            { "BV", "\u092c\u094b\u0935\u091f \u0906\u092f\u0932\u0901\u0921" },
            { "BW", "\u092c\u094b\u0924\u094d\u0938\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u093f\u091d" },
            { "type.ca.persian", "\u092a\u0930\u094d\u0936\u093f\u092f\u0928 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "type.nu.hebr", "\u0939\u093f\u092c\u094d\u0930\u0942 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "CA", "\u0915\u0945\u0928\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 (\u0915\u0940\u0932\u093f\u0902\u0917) \u0906\u092f\u0932\u0901\u0921" },
            { "mzn", "\u092e\u091d\u093e\u0902\u0921\u0947\u0930\u093e\u0923\u0940" },
            { "CD", "\u0915\u094b\u0902\u0917\u094b - \u0915\u093f\u0902\u0936\u093e\u0938\u093e" },
            { "CF", "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u0940\u0915\u0940 \u0932\u094b\u0915\u0938\u0924\u094d\u0924\u0915\u0930\u093e\u091c\u094d\u092f" },
            { "CG", "\u0915\u094b\u0902\u0917\u094b - \u092c\u094d\u0930\u093e\u091d\u093e\u0935\u093f\u0932\u093e" },
            { "CH", "\u0938\u094d\u0935\u093f\u091f\u094d\u091c\u093c\u0930\u0932\u0948\u0902\u0921" },
            { "CI", "\u0915\u094b\u0924 \u0926\u2019\u0908\u0935\u094b\u0906\u0930" },
            { "CK", "\u0915\u0941\u0915 \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "CM", "\u0915\u0945\u092e\u0947\u0930\u0942\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e" },
            { "CP", "\u0915\u094d\u0932\u093f\u092a\u0930\u091f\u0949\u0928 \u0906\u092f\u0932\u0901\u0921" },
            { "CR", "\u0915\u094b\u0938\u094d\u0924\u093e \u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0941\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u0935\u0930\u094d\u0926\u0940" },
            { "CW", "\u0915\u0941\u0930\u0938\u093e\u0935\u094b" },
            { "CX", "\u0915\u094d\u0930\u093f\u0938\u092e\u0938 \u0906\u092f\u0932\u0901\u0921" },
            { "CY", "\u0938\u093e\u092f\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915\u093f\u092f\u093e" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "ace", "\u0905\u091a\u093e\u092f\u0928\u0940\u091c" },
            { "cgg", "\u091a\u093f\u0917\u093e" },
            { "DG", "\u0926\u093f\u0917\u094b \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "type.nu.deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940 \u0905\u0902\u0915" },
            { "DJ", "\u091c\u093f\u092c\u0942\u0924\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "Brai", "\u092c\u094d\u0930\u0948\u0932" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u0940\u0915\u093e" },
            { "type.nu.armnlow", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u0928 \u0932\u094b\u0935\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u092a\u094d\u0930\u091c\u093e\u0938\u0924\u094d\u0924\u093e\u0915" },
            { "gor", "\u0917\u094b\u0930\u094b\u0902\u091f\u093e\u0932\u094b" },
            { "zun", "\u091d\u0942\u0928" },
            { "tig", "\u091f\u093f\u0917\u094d\u0930\u0947" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "pag", "\u092a\u093e\u0902\u0917\u093e\u0938\u093f\u092f\u093e\u0928" },
            { "EA", "\u0938\u093f\u091f\u093e \u0906\u0928\u0940 \u092e\u0947\u0932\u093f\u0932\u094d\u0932\u093e" },
            { "pam", "\u092a\u093e\u0902\u092a\u093e\u0928\u094d\u0917\u093e" },
            { "EC", "\u0907\u0915\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "pap", "\u092a\u093e\u092a\u093f\u092e\u0947\u0902\u091f\u094b" },
            { "ada", "\u0905\u0921\u093e\u0902\u0917\u094d\u092e\u0947" },
            { "EE", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "EG", "\u0908\u091c\u093f\u092a\u094d\u0924" },
            { "EH", "\u0905\u0938\u094d\u0924\u0902\u0924 \u0938\u0939\u093e\u0930\u093e" },
            { "pau", "\u092a\u093e\u0932\u0941\u092f\u093e\u0928" },
            { "chk", "\u091b\u0941\u0928\u093f\u0938" },
            { "chm", "\u092e\u093e\u0930\u0940" },
            { "cho", "\u091a\u094b\u0924\u093e\u0935" },
            { "chr", "\u091a\u093f\u0930\u094b\u0915\u0940" },
            { "ER", "\u0907\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0941\u0930\u094b\u092a\u093f\u092f\u0928 \u092f\u0941\u0928\u093f\u092f\u0928" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "EZ", "\u092f\u0941\u0930\u094b\u091d\u094b\u0928" },
            { "chy", "\u091a\u0947\u092f\u0928\u0940" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0905\u0902\u0915" },
            { "ady", "\u0905\u0921\u093f\u0918\u0947" },
            { "FI", "\u092b\u093f\u0928\u0932\u0901\u0921" },
            { "FJ", metaValue_FJ },
            { "FK", "\u092b\u093c\u0949\u0915\u0932\u0948\u0902\u0921 \u0906\u0907\u0932\u0948\u0902\u0921\u094d\u0938" },
            { "FM", "\u092e\u093e\u092f\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "FO", "\u092b\u0948\u0930\u094b \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "Taml", "\u0924\u092e\u0940\u0933" },
            { "FR", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938" },
            { "root", "\u0930\u0942\u091f" },
            { "GA", "\u0917\u0945\u092c\u094b\u0928" },
            { "GB", "\u092f\u0941\u0928\u093e\u092f\u091f\u0947\u0921 \u0915\u093f\u0902\u0917\u0921\u092e" },
            { "pcm", "\u0928\u093e\u092f\u091d\u0947\u0930\u093f\u092f\u0928 \u092a\u093f\u0921\u0917\u0940\u0928" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u0945\u0921\u093e" },
            { "GE", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u0917\u092f\u093e\u0928\u093e" },
            { "GG", "\u0917\u0930\u094d\u0928\u0938\u0940" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930" },
            { "GL", "\u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921" },
            { "GM", "\u0917\u0945\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "GN", "\u0917\u0941\u090f\u0928\u093f\u092f\u093e" },
            { "GP", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u094b\u092a" },
            { "GQ", "\u0907\u0915\u094d\u0935\u0947\u091f\u094b\u0930\u093f\u092f\u0932 \u0917\u0941\u090f\u0928\u093f\u092f\u093e" },
            { "GR", "\u0917\u094d\u0930\u0940\u0938" },
            { "GS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u094b\u0930\u094d\u091c\u093f\u092f\u093e \u0906\u0928\u0940 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0945\u0923\u094d\u0921\u0935\u093f\u091a \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "GT", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0906\u092e" },
            { "GW", "\u0917\u0941\u0905\u0928\u093f\u092f\u093e-\u092c\u093f\u0938\u093e\u0909" },
            { "tlh", "\u0932\u093f\u0902\u0917\u0949\u0928" },
            { "GY", "\u0917\u092f\u093e\u0928\u093e" },
            { "ckb", "\u092e\u0927\u094d\u092f \u0916\u0941\u0930\u094d\u0926\u0940\u0936" },
            { "zxx", "\u0905\u0923\u0915\u093e\u0930 \u0938\u093e\u092e\u0941\u0917\u094d\u0930\u0940 \u0928\u093e" },
            { "de_AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u0928 \u091c\u0930\u094d\u092e\u0928" },
            { "HK", "\u0939\u093e\u0901\u0917 \u0915\u093e\u0901\u0917 SAR \u091a\u0940\u0928" },
            { "HM", "\u0939\u0930\u094d\u0921 \u0906\u092f\u0932\u0901\u0921\u094d\u0938 \u090d\u0902\u0921 \u092e\u0945\u0915\u094d\u0921\u094b\u0928\u093e\u0932\u094d\u0921 \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "HN", "\u0939\u0949\u0928\u0921\u0941\u0930\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u092f\u0947\u0936\u0940\u092f\u093e" },
            { "agq", "\u0905\u0918\u0947\u092e" },
            { "gsw", "\u0938\u094d\u0935\u093f\u091c \u091c\u0930\u094d\u092e\u0928" },
            { "HT", "\u0939\u0948\u0924\u0940" },
            { "HU", "\u0939\u0902\u0917\u0947\u0930\u0940" },
            { "IC", "\u0915\u0945\u0928\u0930\u0940 \u0906\u092f\u0932\u0948\u0902\u0921\u094d\u0938" },
            { "ID", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u0940\u092f\u093e" },
            { "IE", "\u0906\u092f\u0930\u0932\u0901\u0921" },
            { "nap", "\u0928\u0947\u092a\u094b\u0932\u093f\u091f\u0928" },
            { "naq", "\u0928\u093e\u092e\u093e" },
            { "zza", "\u091d\u093e\u091d\u093e" },
            { "IL", "\u0907\u091c\u093c\u0930\u093e\u0907\u0932" },
            { "IM", "\u0907\u0938\u0932\u0947 \u0911\u092b \u092e\u0945\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "IO", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093f\u0902\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930\u0940\u092f \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "IQ", "\u0907\u0930\u093e\u0915" },
            { "IR", "\u0907\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921" },
            { "IT", "\u0907\u091f\u0932\u0940" },
            { "Zmth", "\u0917\u0923\u093f\u0924\u093e\u091a\u0940 \u091a\u093f\u0928\u094d\u0928\u093e\u0902" },
            { "type.nu.thai", "\u0925\u093e\u092f \u0905\u0902\u0915" },
            { "type.nu.beng", "\u092c\u093e\u0902\u0917\u094d\u0932\u093e \u0905\u0902\u0915" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "type.ca.islamic", "\u0908\u0938\u094d\u0932\u093e\u092e\u0940\u0915 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "Beng", metaValue_bn },
            { "JM", "\u091c\u092e\u0948\u0915\u093e" },
            { "JO", "\u091c\u0949\u0930\u094d\u0921\u0928" },
            { "JP", "\u091c\u092a\u093e\u0928" },
            { "ain", "\u0906\u092f\u0928\u0942" },
            { "guz", "\u0917\u0941\u0938\u0940" },
            { "type.nu.knda", "\u0915\u0928\u094d\u0928\u0921 \u0905\u0902\u0915" },
            { "de_CH", "\u0938\u094d\u0935\u0940\u091d \u092e\u094d\u0939\u093e\u0928 \u091c\u0930\u094d\u092e\u0928" },
            { "type.ca.buddhist", "\u092c\u0941\u0927\u094d\u0926\u0940\u0936\u094d\u091f \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "KE", "\u0915\u0947\u0928\u092f\u093e" },
            { "419", "\u0932\u0945\u091f\u0940\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u0938" },
            { "KN", "\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u0906\u0928\u0940 \u0928\u0947\u0935\u093f\u0938" },
            { "Knda", "\u0915\u0928\u094d\u0928\u0921" },
            { "fr_CA", "\u0915\u0945\u0928\u093e\u0921\u0940\u092f\u0928 \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "KP", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "fr_CH", "\u0938\u094d\u0935\u0940\u091d \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "KW", "\u0915\u0941\u0935\u0947\u0924" },
            { "tpi", "\u0924\u094b\u0915 \u092a\u093f\u0938\u0940\u0928" },
            { "KY", "\u0915\u0948\u092e\u0947\u0928 \u0906\u0907\u0932\u0948\u0902\u0921\u094d\u0938" },
            { "KZ", "\u0915\u091d\u093e\u0915\u0938\u094d\u0924\u093e\u0928" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u093e\u0928" },
            { "LC", "\u0938\u0901\u091f \u0932\u0941\u0938\u093f\u092f\u093e" },
            { "gwi", "\u0917\u094d\u0935\u093f\u091a" },
            { "LI", "\u0932\u093f\u091a\u0947\u0902\u0938\u094d\u091f\u0940\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940 \u0932\u0902\u0915\u093e" },
            { "LR", "\u0932\u093e\u092f\u092c\u0947\u0930\u0940\u092f\u093e" },
            { "LS", "\u0932\u093f\u0938\u094b\u0925\u094b" },
            { "LT", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0915\u094d\u0938\u0947\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u0945\u091f\u0935\u093f\u092f\u093e" },
            { "Kana", "\u0915\u093e\u091f\u0915\u093e\u0928\u093e" },
            { "LY", "\u0932\u0940\u092c\u093f\u092f\u093e" },
            { "lad", "\u0932\u093e\u0921\u093f\u0928\u094b" },
            { "vun", "\u0935\u0941\u0902\u091c\u094b" },
            { "lag", "\u0932\u093e\u0902\u0917\u0940" },
            { "Thaa", "\u0925\u093e\u0923\u093e" },
            { "MA", "\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u0945\u0915\u094b" },
            { "MD", "\u092e\u093e\u0932\u094d\u0921\u094b\u0935\u093e" },
            { "ME", "\u092e\u0949\u0928\u094d\u091f\u0945\u0928\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0945\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "MG", "\u092e\u093e\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "Thai", metaValue_th },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0932 \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "ale", "\u0906\u0932\u093f\u091f" },
            { "MK", "\u0909\u0924\u094d\u0924\u0930 \u092e\u0945\u0938\u093f\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)" },
            { "MN", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "new", "\u0928\u0947\u0935\u0930\u0940" },
            { "MO", "\u092e\u0915\u093e\u0935 SAR \u091a\u0940\u0928" },
            { "MP", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u0930\u093f\u0928\u093e \u0906\u092f\u0938\u0932\u0948\u0923\u094d\u0921" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u0940\u0928\u093f\u0915" },
            { "MR", "\u092e\u0949\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u0949\u0928\u094d\u091f\u0938\u0947\u0930\u093e\u091f" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "MU", "\u092e\u0949\u0930\u093f\u0936\u0938" },
            { "alt", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0905\u0932\u094d\u091f\u093e\u092f" },
            { "MV", "\u092e\u093e\u0932\u0926\u0940\u0935" },
            { "MW", "\u092e\u0932\u093e\u0935\u0940" },
            { "type.ca.japanese", metaValue_ja },
            { "MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "MY", "\u092e\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "MZ", "\u092e\u0949\u091d\u093e\u0902\u092c\u0940\u0915" },
            { "NA", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e" },
            { "202", "\u0909\u092a-\u0938\u0939\u093e\u0930\u093e\u0908 \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "type.ca.hebrew", "\u0939\u093f\u092c\u094d\u0930\u0942 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "NC", "\u0928\u094d\u092f\u0942 \u0915\u0945\u0932\u093f\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u092f\u091c\u0930" },
            { "NF", "\u0928\u0949\u0930\u092b\u0949\u0915 \u0906\u092f\u0932\u0901\u0921" },
            { "NG", "\u0928\u093e\u092f\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "trv", "\u0924\u093e\u0930\u094b\u0915\u094b" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u0917\u0941\u0935\u093e" },
            { "NL", "\u0928\u0945\u0926\u0930\u0932\u0901\u0921" },
            { "NO", "\u0928\u0949\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0933" },
            { "NR", "\u0928\u093e\u0935\u0930\u0942" },
            { "NU", "\u0928\u0940\u092f\u0942" },
            { "rof", "\u0930\u094b\u092e\u094d\u092c\u094b" },
            { "NZ", "\u0928\u094d\u092f\u0941\u091d\u0940\u0932\u0945\u0928\u094d\u0921" },
            { "OM", "\u0913\u092e\u093e\u0928" },
            { "anp", "\u0905\u0902\u0917\u093f\u0915\u093e" },
            { "crs", "\u0938\u0947\u0938\u0947\u0932\u094d\u0935\u093e \u0915\u094d\u0930\u092f\u0949\u0932 \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "PA", "\u092a\u0928\u093e\u092e\u093e" },
            { "en_GB", "\u092c\u094d\u0930\u093f\u091f\u0940\u0936 \u0907\u0902\u0917\u094d\u0932\u0940\u0936" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u092a\u094b\u0932\u093f\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "PG", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0941 \u0917\u093f\u0928\u0940" },
            { "PH", "\u092b\u093f\u0932\u0940\u092a\u093f\u0928\u094d\u091d" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u0902\u0921" },
            { "ewo", "\u090f\u0935\u094b\u0902\u0921\u094b" },
            { "PM", "\u0938\u0901. \u092a\u093e\u092f\u0930\u0947 \u0906\u0928\u0940 \u092e\u093f\u0915\u0947\u0932\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u0945\u0930\u0928 \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "PR", "\u092a\u093f\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "PS", "\u092a\u0947\u0932\u0947\u0938\u094d\u091f\u0940\u0928\u093f\u092f\u0928 \u092a\u094d\u0930\u093e\u0902\u0924" },
            { "PT", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932" },
            { "PW", "\u092a\u0932\u093e\u090a" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "type.nu.greklow", "\u0917\u094d\u0930\u0940\u0915 \u0932\u094b\u0935\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "PY", "\u092a\u0948\u0930\u093e\u0917\u094d\u0935\u0947" },
            { "tum", "\u0924\u0941\u0902\u092c\u0941\u0915\u093e" },
            { "Hebr", metaValue_he },
            { "QA", "\u0915\u0924\u093e\u0930" },
            { "niu", "\u0928\u093f\u092f\u0941\u0928" },
            { "QO", "\u0906\u0935\u091f\u0932\u093e\u092f\u0940\u0902\u0917 \u0913\u0936\u0947\u0928\u093f\u092f\u093e" },
            { "lez", "\u0932\u0947\u091d\u0918\u093f\u092f\u093e\u0928" },
            { "tvl", "\u0924\u0941\u0935\u093e\u0932\u0942" },
            { "001", "\u091c\u0917" },
            { "002", "\u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "003", "\u0909\u0924\u094d\u0924\u0930 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "RE", "\u0930\u0940\u092f\u0942\u0928\u093f\u092f\u0928" },
            { "005", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "jbo", "\u0932\u094b\u092c\u091c\u093e\u0928" },
            { "009", "\u0913\u0938\u0947\u0928\u093f\u092f\u093e" },
            { "RO", "\u0930\u094b\u092e\u093e\u0928\u0940\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u0935\u093e\u0902\u0921\u093e" },
            { "SA", "\u0938\u090a\u0926\u0940 \u0905\u0930\u0947\u092c\u093f\u092f\u093e" },
            { "SB", "\u0938\u094b\u0932\u094b\u092e\u0928 \u0906\u0907\u0932\u0901\u0921\u094d\u0938" },
            { "twq", "\u0924\u093e\u0938\u093e\u0935\u093e\u0915" },
            { "011", "\u0905\u0938\u094d\u0924\u0902\u0924 \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SC", "\u0938\u0947\u0936\u0947\u0932\u094d\u0938" },
            { "SD", "\u0938\u0942\u0921\u093e\u0928" },
            { "013", "\u092e\u0927\u094d\u092f \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "SE", "\u0938\u094d\u0935\u0940\u0921\u0928" },
            { "014", "\u0909\u0926\u0947\u0902\u0924 \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "015", "\u0909\u0924\u094d\u0924\u0930\u0940\u092f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SG", "\u0938\u093f\u0902\u0917\u093e\u092a\u0942\u0930" },
            { "SH", "\u0938\u0947\u0902\u091f \u0939\u0947\u0932\u093f\u0928\u093e" },
            { "type.lb.strict", "\u0938\u0915\u094d\u0924\u0940\u091a\u0940 \u0930\u0947\u0917 \u0916\u0902\u0921 \u0936\u0948\u0932\u0940" },
            { "017", "\u092e\u0927\u094d\u092f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e" },
            { "018", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SJ", "\u0938\u094d\u0935\u093e\u0932\u092c\u093e\u0930\u094d\u0921 \u0906\u0928\u0940 \u091c\u093e\u0928 \u092e\u0947\u092f\u0928" },
            { "019", "\u0905\u092e\u0947\u0930\u093f\u0915\u093e\u0938" },
            { "SK", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u092f\u0949\u0928" },
            { "SM", "\u0938\u0945\u0928 \u092e\u093e\u0930\u0940\u0928\u094b" },
            { "SN", "\u0938\u093f\u0928\u093f\u0917\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "arn", "\u092e\u093e\u092a\u0941\u091a\u0947" },
            { "arp", "\u0905\u0930\u093e\u092a\u093e\u0939\u094b" },
            { "type.nu.taml", "\u092a\u093e\u0930\u0902\u092a\u093e\u0930\u0940\u0915 \u0924\u092e\u093f\u0933 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "SR", "\u0938\u0941\u0930\u0940\u0928\u093e\u092e" },
            { "SS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0941\u0921\u093e\u0928" },
            { "ST", "\u0938\u093e\u0935\u094b \u091f\u094b\u092e\u0947 \u0906\u0928\u0940 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0932" },
            { "SV", "\u090f\u0932 \u0938\u093e\u0932\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "SX", "\u0938\u093f\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u0947\u0928" },
            { "SY", "\u0938\u093f\u0930\u093f\u092f\u093e" },
            { "SZ", "\u0938\u094d\u0935\u093e\u091c\u0940\u0932\u0901\u0921" },
            { "TA", "\u0924\u094d\u0930\u093f\u0938\u094d\u0924\u093e\u0928 \u0926\u093e \u0915\u0941\u0928\u094d\u0939\u093e" },
            { "asa", "\u0905\u0938\u0941" },
            { "type.ms.ussystem", "\u092f\u0941\u090f\u0938 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "021", "\u0909\u0924\u094d\u0924\u0930\u0940\u092f \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915\u094d\u0938 \u0906\u0928\u0940 \u0915\u0945\u0915\u094b\u091c \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "yav", "\u092f\u093e\u0902\u0917\u092c\u0947\u0928" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u094d\u0930\u0947\u0902\u091a \u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u092a\u094d\u0930\u093e\u0902\u0924" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0925\u093e\u092f\u0932\u0901\u0921" },
            { "TJ", "\u0924\u091c\u0940\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "029", "\u0915\u0945\u0930\u093f\u092c\u093f\u092f\u0928" },
            { "TK", "\u091f\u094b\u0915\u0932\u093e\u090a" },
            { "TL", "\u0924\u093f\u092e\u094b\u0930-\u0932\u0947\u0938\u094d\u0924\u0947" },
            { "ybb", "\u092f\u0947\u092e\u094d\u092c\u093e" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u091f\u094d\u092f\u0942\u0928\u0940\u0936\u093f\u092f\u093e" },
            { "TO", "\u091f\u094b\u0902\u0917\u093e" },
            { "TR", "\u0924\u0941\u0930\u094d\u0915\u0940" },
            { "TT", "\u091f\u094d\u0930\u093f\u0928\u0940\u0921\u093e\u0921 \u0906\u0928\u0940 \u091f\u094b\u092c\u0945\u0917\u094b" },
            { "TV", "\u091f\u0941\u0935\u093e\u0932\u0942" },
            { "TW", "\u0924\u093e\u092f\u0935\u093e\u0928" },
            { "ast", "\u0905\u0938\u094d\u091f\u0941\u0930\u093f\u092f\u093e\u0928" },
            { "TZ", "\u0924\u093e\u0902\u091d\u093e\u0928\u093f\u092f\u093e" },
            { "nmg", "\u0916\u094d\u0935\u093e\u0938\u0940" },
            { "Zzzz", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0932\u093f\u092a\u0940" },
            { "UA", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928" },
            { "rup", "\u0906\u0930\u094b\u092e\u0947\u0928\u093f\u092f\u0928" },
            { "030", "\u0909\u0926\u0947\u0902\u0924 \u0906\u0936\u093f\u092f\u093e" },
            { "tyv", "\u0924\u0941\u0935\u093f\u0928\u093f\u092f\u0928" },
            { "sw_CD", "\u0915\u093e\u0901\u0917\u094b \u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "034", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0906\u0936\u093f\u092f\u093e" },
            { "035", "\u0906\u0917\u094d\u0928\u0947\u092f \u0906\u0936\u093f\u092f\u093e" },
            { "UG", "\u092f\u0941\u0917\u093e\u0902\u0921\u093e" },
            { "039", "\u0926\u0915\u094d\u0937\u093f\u0923 \u092f\u0947\u0935\u0930\u094b\u092a" },
            { "Sinh", "\u0938\u093f\u0928\u094d\u0939\u093e\u0932\u093e" },
            { "UM", "\u092f\u0941. \u090f\u0938. \u092e\u093e\u092f\u0928\u0930 \u0906\u0935\u091f\u0932\u093e\u092f\u0940\u0902\u0917 \u0906\u092f\u0932\u0901\u0921\u094d\u200d\u0938" },
            { "UN", "\u092f\u0941\u0928\u093e\u092f\u091f\u0947\u0921 \u0928\u0947\u0936\u0928\u094d\u0938" },
            { "US", "\u092f\u0941\u0928\u093e\u092f\u091f\u0947\u0921 \u0938\u094d\u091f\u0947\u091f\u094d\u0938" },
            { "haw", "\u0939\u0935\u093e\u092f\u093f\u092f\u093e\u0928" },
            { "UY", "\u0909\u0930\u0942\u0917\u094d\u0935\u0947" },
            { "prg", "\u092a\u094d\u0930\u0941\u0938\u093f\u092f\u0928" },
            { "UZ", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "tzm", "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0905\u091f\u0932\u093e\u0938 \u0924\u093e\u092e\u093e\u091d\u093e\u092f\u091f" },
            { "nnh", "\u0928\u094d\u0917\u0947\u092c\u0942\u0928" },
            { "VA", "\u0935\u0945\u091f\u093f\u0915\u0928 \u0938\u093f\u091f\u0940" },
            { "VC", "\u0938\u0947\u0902\u091f \u0935\u093f\u0902\u0938\u0947\u0902\u091f \u0910\u0902\u0921 \u0926 \u0917\u094d\u0930\u0947\u0928\u0947\u0921\u093e\u0907\u0902\u0938" },
            { "VE", "\u0935\u093f\u0928\u0947\u091d\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0935\u0930\u094d\u091c\u093f\u0928 \u0906\u092f\u0932\u0901\u0921\u094d\u0938" },
            { "VI", "\u092f\u0941. \u090f\u0938. \u0935\u0930\u094d\u091c\u093f\u0928 \u0906\u092f\u0932\u0901\u0921\u094d\u200d\u0938" },
            { "VN", "\u0935\u094d\u0939\u093f\u090f\u0924\u0928\u093e\u092e" },
            { "VU", "\u0935\u0928\u093e\u0924\u0942" },
            { "nog", "\u0928\u094b\u0917\u093e\u092f" },
            { "rwk", "\u0930\u0935\u093e" },
            { "053", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u0947\u0938\u093f\u092f\u093e" },
            { "054", "\u092e\u0947\u0932\u093e\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0906\u0928\u0940 \u092b\u094d\u092f\u0942\u091a\u0942\u0928\u093e" },
            { "057", "\u092e\u093e\u092f\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u0928 \u092a\u094d\u0930\u093e\u0902\u0924" },
            { "jgo", "\u0928\u094d\u0917\u094b\u0902\u092c\u093e" },
            { "lkt", "\u0932\u093e\u0915\u094b\u091f\u093e" },
            { "wae", "\u0935\u093e\u0932\u094d\u0938\u0930" },
            { "WS", "\u0938\u093e\u092e\u094b\u0906" },
            { "wal", "\u0935\u094b\u0932\u093e\u092f\u091f\u093e" },
            { "war", "\u0935\u0930\u092f" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "061", "\u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "XK", "\u0915\u094b\u0938\u094b\u0935\u094b" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0905\u0932\u093f\u0916\u0940\u0924" },
            { "YE", "\u092f\u0947\u092e\u0947\u0928" },
            { "nqo", "\u0928\u0915\u094b" },
            { "type.co.standard", "\u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0935\u0930\u094d\u0917\u0935\u093e\u0930\u0940 \u0915\u094d\u0930\u092e" },
            { "YT", "\u092e\u0947\u092f\u094b\u091f" },
            { "ZA", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0906\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "type.lb.loose", "\u0932\u0942\u091c \u0930\u0947\u0917 \u0916\u0902\u0921 \u0936\u0948\u0932\u0940" },
            { "Deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940" },
            { "type.nu.geor", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "Hira", "\u0939\u093f\u0930\u093e\u0917\u0928\u093e" },
            { "ZM", "\u091d\u093e\u0902\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093f\u092e\u094d\u092c\u093e\u092c\u094d\u0935\u0947" },
            { "ZZ", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092a\u094d\u0930\u093e\u0902\u0924" },
            { "type.ms.metric", "\u092e\u0945\u091f\u094d\u0930\u0940\u0915 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ca.iso8601", "\u0906\u092f\u090f\u0938\u0913-8601 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "nso", "\u0909\u0924\u094d\u0924\u0930\u0940\u092f \u0938\u094b\u0925\u094b" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0941\u0917\u0942 \u0905\u0902\u0915" },
            { "loz", "\u0932\u094b\u091d\u0940\u0902" },
            { "jmc", "\u092e\u091a\u093e\u092e\u0947" },
            { "type.nu.hansfin", "\u0938\u094b\u0902\u092a\u0940 \u0915\u0947\u0932\u094d\u0932\u0940 \u091a\u093f\u0928\u0940 \u092e\u0939\u0938\u0942\u0932 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "hil", "\u0939\u093f\u0932\u0940\u0917\u093e\u092f\u0928\u0949\u0928" },
            { "type.nu.arabext", "\u0935\u093f\u0938\u094d\u0924\u093e\u0930\u0940\u0924 \u0905\u0930\u0947\u092c\u0940\u0915-\u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "nus", "\u0928\u094d\u092f\u0941\u092f\u0930" },
            { "dak", "\u0921\u093e\u0915\u094b\u091f\u093e" },
            { "type.nu.fullwide", "\u092a\u0942\u0930\u094d\u0923-\u0930\u0941\u0902\u0926\u0940 \u0905\u0902\u0915" },
            { "dar", "\u0926\u093e\u0930\u094d\u0917\u094d\u0935\u093e" },
            { "dav", "\u0924\u093e\u092f\u0924\u093e" },
            { "lrc", "\u0909\u0924\u094d\u0924\u0930\u0940\u092f \u0932\u0941\u0930\u0940" },
            { "udm", "\u0909\u0921\u092e\u0941\u0930\u094d\u0924" },
            { "Khmr", "\u0916\u092e\u0947\u0930" },
            { "sad", "\u0938\u0902\u0921\u093e\u0935\u0947" },
            { "type.nu.roman", "\u0930\u094b\u092e\u0928 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "sah", "\u0938\u0916\u093e" },
            { "saq", "\u0938\u093e\u0902\u092c\u093e\u0930\u0941" },
            { "sat", "\u0938\u0902\u0925\u093e\u0932\u0940" },
            { "sba", "\u0917\u093e\u0902\u092c\u0947" },
            { "Guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940" },
            { "lua", "\u0932\u0941\u092c\u093e-\u0932\u0941\u0932\u0941\u0906" },
            { "sbp", "\u0938\u093e\u0902\u0917\u0942" },
            { "nyn", "\u0928\u093e\u0928\u0915\u094b\u0932\u0947" },
            { "lun", "\u0932\u0941\u0902\u0921\u093e" },
            { "luo", "\u0932\u0941\u0913" },
            { "fil", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u094b" },
            { "hmn", "\u092e\u094b\u0902\u0917" },
            { "lus", "\u092e\u093f\u091d\u094b" },
            { "ban", "\u092c\u093e\u0932\u093f\u0928\u093f\u0938" },
            { "luy", "\u0932\u0941\u092f" },
            { "bas", "\u092c\u0938\u094d\u0938\u093e" },
            { "es_ES", "\u092f\u0941\u0930\u094b\u092a\u093f\u092f\u0928 \u0938\u094d\u092a\u0945\u0928\u093f\u0936" },
            { "sco", "\u0938\u094d\u0915\u0949\u091f\u094d\u0938" },
            { "scn", "\u0938\u093f\u0938\u093f\u0932\u093f\u092f\u093e\u0928" },
            { "aa", "\u0905\u092b\u093e\u0930" },
            { "ab", "\u0905\u092c\u0916\u0947\u091c\u093c\u093f\u092f\u0928" },
            { "af", "\u0905\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u094d\u0938" },
            { "ak", "\u0905\u0915\u093e\u0928" },
            { "am", "\u0905\u092e\u0939\u093e\u0930\u093f\u0915\u094d" },
            { "Arab", metaValue_ar },
            { "an", "\u0906\u0930\u093e\u0917\u094b\u0928\u093f\u0938" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u091c\u092a\u093e\u0928\u0940 \u0905\u0915\u094d\u0937\u0930\u092e\u093e\u0933" },
            { "as", "\u0906\u0938\u093e\u092e\u0940" },
            { "av", "\u0905\u0935\u093e\u0930\u093f\u0915" },
            { "ay", "\u0910\u092e\u0930\u093e" },
            { "az", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928\u0940" },
            { "ba", "\u092c\u0937\u094d\u0915\u093f\u0930" },
            { "be", "\u092c\u0948\u0932\u094b\u0930\u0941\u0938\u093f\u092f\u0928\u094d" },
            { "bg", "\u092c\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u0928" },
            { "bi", "\u092c\u093f\u0938\u0932\u092e\u093e" },
            { "bm", "\u092c\u0902\u092c\u093e\u0930\u093e" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0921\u094b\u0917\u0930\u0940\u092c" },
            { "br", "\u092c\u094d\u0930\u0947\u091f\u0928" },
            { "bs", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u0928" },
            { "Mymr", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930" },
            { "type.nu.laoo", "\u0932\u093e\u0913 \u0905\u0902\u0915" },
            { "seh", "\u0938\u0947\u0928\u093e" },
            { "ca", "\u0915\u091f\u0932\u093e\u0928" },
            { "ses", "\u0915\u094b\u092f\u0930\u093e\u092c\u094b\u0930\u094b \u0938\u0947\u0928\u094d\u0928\u0940" },
            { "ce", "\u091a\u093f\u091a\u0947\u0928" },
            { "ch", "\u091a\u093e\u092e\u094b\u0930\u094d\u0930\u094b" },
            { "co", "\u0915\u094b\u0930\u094d\u0936\u093f\u092f\u0928" },
            { "Orya", metaValue_or },
            { "cs", "\u091a\u0947\u0915" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u094d\u0932\u0947\u0935\u094d\u0939\u0940\u0915" },
            { "cv", "\u091b\u0941\u0935\u093e\u0938" },
            { "cy", "\u0935\u0947\u0933\u094d\u0937\u094d" },
            { "type.nu.ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "da", "\u0921\u0945\u0928\u093f\u0936" },
            { "pt_PT", "\u092f\u0941\u0930\u094b\u092a\u093f\u092f\u0928 \u092a\u094b\u0930\u094d\u0924\u0941\u0917\u093f\u091c" },
            { "de", "\u091c\u0930\u094d\u092e\u0928" },
            { "type.cf.standard", "\u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924" },
            { "bem", "\u092c\u0947\u092e\u094d\u092c\u093e" },
            { "dv", "\u0926\u093f\u0935\u0947\u0939\u0940" },
            { "es_419", "\u0932\u0945\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u0928 \u0938\u094d\u092a\u0945\u0928\u093f\u0936" },
            { "dz", "\u091d\u094b\u0902\u0917\u094d\u0916\u093e" },
            { "bez", "\u092c\u0947\u0928\u093e" },
            { "type.ca.chinese", "\u091a\u0940\u0928\u0940 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "dje", "\u091d\u0930\u094d\u092e\u093e" },
            { "type.nu.grek", "\u0917\u094d\u0930\u0940\u0915 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "ee", "\u090f\u0935" },
            { "type.lb.normal", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f \u0930\u0947\u0917 \u0916\u0902\u0921 \u0936\u0948\u0932\u0940" },
            { "ro_MD", "\u092e\u094b\u0932\u094d\u0921\u093e\u0935\u093f\u092f\u0928\u094d" },
            { "el", "\u0917\u094d\u0930\u0940\u0915\u094d" },
            { "en", "\u0907\u0902\u0917\u094d\u0932\u0940\u0936" },
            { "eo", "\u0907\u0938\u094d\u092a\u0930\u093e\u0928\u094d\u091f\u094b" },
            { "es", "\u0938\u094d\u092a\u0945\u0928\u093f\u0936" },
            { "et", "\u0907\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u0928\u094d" },
            { "Hanb", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u094b \u0935\u093e\u0902\u0917\u0921\u093e \u0939\u0945\u0928" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "Hang", "\u0939\u0902\u0917\u0942\u0932" },
            { "shi", "\u0924\u093e\u091b\u0947\u0939\u0940\u091f" },
            { "hsb", "\u0905\u092a\u0930 \u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "Hani", "\u0939\u0945\u0928" },
            { "shn", "\u0936\u093e\u0928" },
            { "fa", "\u092a\u0930\u094d\u0937\u093f\u092f\u0928\u094d" },
            { "Hans", "\u0938\u094b\u0902\u092a\u0940" },
            { "type.nu.latn", "\u0905\u0938\u094d\u0924\u0902\u0924 \u0905\u0902\u0915" },
            { "Hant", "\u092a\u093e\u0930\u0902\u092a\u093e\u0930\u0940\u0915" },
            { "ff", "\u092b\u0941\u0932\u093e" },
            { "fi", "\u092b\u093f\u0928\u094d\u0928\u093f\u0937\u094d" },
            { "fj", metaValue_FJ },
            { "fon", "\u092b\u094b\u0928" },
            { "yue", "\u0915\u093e\u0902\u091f\u094b\u0938\u0940" },
            { "fo", "\u092b\u0947\u0930\u094b\u0938\u094d" },
            { "umb", "\u092f\u092e\u092c\u0941\u0902\u0921\u0941" },
            { "fr", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "fy", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092b\u094d\u0930\u093f\u0936\u093f\u092f\u0928" },
            { "ga", "\u0910\u0930\u093f\u0937" },
            { "gd", "\u0938\u094d\u0915\u093e\u091f\u0938\u094d \u0917\u0947\u0932\u093f\u0915\u094d" },
            { "gl", "\u0917\u0947\u0932\u0940\u0936\u093f\u092f\u0928" },
            { "gn", "\u0917\u094c\u0930\u093e\u0928\u0940" },
            { "bho", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940" },
            { "und", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092d\u093e\u0936\u093e" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u0945\u0928\u094d\u0938" },
            { "ha", "\u0939\u094c\u0938\u093e" },
            { "he", metaValue_he },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "hup", "\u0939\u0941\u092a\u093e" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "hr", "\u0915\u094d\u0930\u094b\u092f\u0947\u0937\u093f\u092f\u0928\u094d" },
            { "ht", "\u0939\u0948\u0924\u093f\u092f\u0928 \u0915\u094d\u0930\u0947\u092f\u0949\u0932" },
            { "hu", "\u0939\u0902\u0917\u0947\u0930\u093f\u092f\u0928\u094d" },
            { "hy", metaValue_hy },
            { "hz", "\u0939\u093f\u0930\u093f\u0930\u094b" },
            { "ia", "\u0907\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u094d\u0935\u093e" },
            { "Jamo", "\u091c\u093e\u092e\u094b" },
            { "type.nu.tibt", metaValue_bo },
            { "id", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u0928" },
            { "ie", "\u0907\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u094d" },
            { "ig", "\u0907\u0917\u094d\u092c\u094b" },
            { "ii", "\u0938\u093f\u091a\u094d\u092f\u0941\u0906\u0928 \u092f\u0940" },
            { "ik", "\u0907\u0928\u0942\u092a\u0947\u092f\u093e\u0915\u094d" },
            { "io", "\u0907\u0926\u094b" },
            { "is", "\u0906\u0908\u0938\u094d\u0932\u093e\u0928\u094d\u0921\u093f\u0915" },
            { "it", "\u0907\u091f\u093e\u0932\u093f\u092f\u0928" },
            { "iu", "\u0907\u0928\u094d\u092f\u0941\u0915\u091f\u094d\u091f" },
            { "ja", metaValue_ja },
            { "Mlym", "\u092e\u0932\u092f\u093e\u0933\u092e" },
            { "sma", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u093e\u092e\u0940" },
            { "jv", "\u091c\u093e\u0935\u0928\u0940\u0938\u094d" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0947\u0938\u0947" },
            { "smj", "\u0932\u0941\u0932\u0947 \u0938\u093e\u092e\u0940" },
            { "mag", "\u092e\u0917\u093e\u0939\u0940" },
            { "mai", "\u092e\u0948\u0925\u093f\u0932\u0940" },
            { "smn", "\u0908\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "ka", "\u091c\u093e\u0930\u094d\u091c\u093f\u092f\u0928\u094d" },
            { "bla", "\u0938\u093f\u0915\u0938\u093f\u0915\u093e" },
            { "mak", "\u092e\u093e\u0915" },
            { "sms", "\u0938\u094d\u0915\u094b\u0932\u094d\u091f \u0938\u093e\u092e\u0940" },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0941" },
            { "mas", "\u092e\u0938\u093e\u0908" },
            { "kj", "\u0915\u0941\u092f\u093e\u0902\u092e\u093e" },
            { "kk", "\u0915\u091c\u093c\u0916\u094d" },
            { "kl", "\u0915\u093e\u0932\u093e\u0932\u094d\u0932\u093f\u0938\u0941\u091f" },
            { "km", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u0928" },
            { "kn", "\u0915\u0928\u094d\u0928\u0921\u093e" },
            { "ko", "\u0915\u094b\u0930\u093f\u092f\u0928\u094d" },
            { "kr", "\u0915\u093e\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u0936\u094d\u092e\u0940\u0930\u0940" },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u093f\u0937" },
            { "kv", "\u0915\u094b\u092e\u0940" },
            { "kw", "\u0915\u094b\u0930\u094d\u0928\u093f\u0936" },
            { "ky", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c" },
            { "snk", "\u0938\u094b\u0928\u093f\u0915\u0947" },
            { "la", "\u0932\u093e\u091f\u093f\u0928" },
            { "lb", "\u0932\u0915\u094d\u0938\u0947\u092e\u092c\u0930\u094d\u0917\u0940\u0936" },
            { "type.nu.mlym", "\u092e\u0932\u094d\u092f\u093e\u0933\u092e \u0905\u0902\u0915" },
            { "lg", "\u0917\u093e\u0902\u0921\u093e" },
            { "li", "\u0932\u093f\u0902\u092c\u0941\u0930\u094d\u0917" },
            { "Tibt", "\u0924\u093f\u092c\u0947\u091f\u0928" },
            { "ln", "\u0932\u093f\u0902\u0917\u093e\u0932\u093e" },
            { "fur", "\u092b\u094d\u0930\u093f\u0932\u093f\u092f\u0928" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0935\u094d\u0939\u0921\u0932\u0940 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "lt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u0928\u094d" },
            { "lu", "\u0932\u0941\u092c\u093e-\u0915\u093e\u091f\u093e\u0902\u0917\u093e" },
            { "lv", "\u0932\u093e\u091f\u094d\u0935\u093f\u092f\u0928\u094d (\u0932\u0947\u091f\u094d\u091f\u093f\u0937\u094d)" },
            { "mg", "\u092e\u0932\u093e\u0917\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0936\u0932\u0940" },
            { "type.co.ducet", "\u0921\u093f\u092b\u0949\u0932\u094d\u091f \u092f\u0941\u0928\u093f\u0915\u094b\u0921 \u0935\u0930\u094d\u0917\u0935\u093e\u0930\u0940 \u0915\u094d\u0930\u092e" },
            { "mi", "\u092e\u0941\u0930\u0940" },
            { "mk", "\u092e\u0938\u0940\u0921\u094b\u0928\u093f\u092f\u0928\u094d" },
            { "ml", "\u092e\u0933\u093f\u092f\u093e\u0933\u092e" },
            { "mn", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u0928\u094d" },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u092f" },
            { "mt", "\u092e\u093e\u0932\u0924\u0940\u0938\u094d" },
            { "my", "\u092c\u0930\u094d\u092e\u0940\u091c\u093c\u094d" },
            { "Armn", metaValue_hy },
            { "mdf", "\u092e\u094b\u0915\u094d\u0937" },
            { "dsb", "\u0932\u094b\u0935\u0930 \u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "na", "\u0928\u094c\u0930\u094b" },
            { "type.co.search", "\u0938\u094b\u0926 \u0918\u0947\u0935\u091a\u094b" },
            { "nb", "\u0928\u094b\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u0928 \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "nd", "\u0909\u0924\u094d\u0924\u0930 \u0928\u094d\u0921\u0947\u092c\u0947\u0932\u0947" },
            { "ne", "\u0928\u0947\u092a\u093e\u0933\u0940" },
            { "ng", "\u0921\u094b\u0902\u0917\u093e" },
            { "nl", "\u0921\u091a\u094d" },
            { "nn", "\u0928\u094b\u0930\u094d\u0935\u094b\u091c\u093f\u092f\u0928 \u0928\u093e\u092f\u0928\u094b\u0930\u094d\u0938\u094d\u0915" },
            { "no", "\u0928\u094b\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u0928" },
            { "nr", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0921\u0947\u092c\u0947\u0932\u0947" },
            { "nv", "\u0928\u093e\u0935\u093e\u091c\u094b" },
            { "ny", "\u0928\u093e\u0902\u0928\u094d\u091c\u093e" },
            { "kac", "\u0915\u093e\u091a\u0940\u0928" },
            { "kab", "\u0915\u093e\u092c\u093e\u092f\u0932\u0947" },
            { "oc", "\u0913\u0938\u093f\u091f\u093e\u0928\u094d" },
            { "kaj", "\u091c\u0941" },
            { "kam", "\u0915\u0902\u092c\u093e" },
            { "men", "\u092e\u0947\u0902\u0921\u0947" },
            { "mer", "\u092e\u0947\u0930\u0942" },
            { "type.nu.armn", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u0928 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "om", "\u0913\u0930\u094b\u092e\u094b" },
            { "or", metaValue_or },
            { "os", "\u0913\u0938\u0947\u091f\u093f\u0915" },
            { "kbd", "\u0915\u093e\u092c\u093e\u0930\u094d\u0921\u093f\u092f\u0928" },
            { "mfe", "\u092e\u094b\u0930\u093f\u0938\u0947\u0928" },
            { "srn", "\u0936\u094d\u0930\u093e\u0928\u0928 \u091f\u094b\u0902\u0917\u094b" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "dua", "\u0921\u094c\u0932" },
            { "pl", "\u092a\u094b\u0932\u093f\u0937" },
            { "type.ca.dangi", "\u0921\u093e\u0902\u0917\u0940 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "ps", "\u092a\u093e\u0937\u094d\u091f\u094b" },
            { "pt", "\u092a\u094b\u0930\u094d\u0924\u0941\u0917\u093f\u091c" },
            { "key.co", "\u0935\u0930\u094d\u0917\u0935\u093e\u0930\u0940 \u0915\u094d\u0930\u092e" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091d\u093f\u0932\u093f\u092f\u0928 \u092a\u094b\u0930\u094d\u0924\u0941\u0917\u093f\u091c" },
            { "kcg", "\u0924\u094d\u092f\u093e\u092a" },
            { "mgh", "\u092e\u093e\u0916\u0941\u0935\u093e-\u092e\u093f\u091f\u094d\u091f\u094b" },
            { "key.cf", "\u091a\u0932\u0928\u093e\u091a\u0947\u0902 \u0938\u094d\u0935\u0930\u0942\u092a" },
            { "key.ca", "\u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u092e\u0947\u091f\u093e" },
            { "type.hc.h23", "24 \u0935\u0930\u093e\u0902\u091a\u0940 \u092f\u0902\u0924\u094d\u0930\u0923\u093e (0\u201323)" },
            { "type.hc.h24", "24 \u0935\u0930\u093e\u0902\u091a\u0940 \u092f\u0902\u0924\u094d\u0930\u0923\u093e (1\u201324)" },
            { "ssy", "\u0938\u093e\u0939\u094b" },
            { "type.nu.mymr", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930 \u0905\u0902\u0915" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u094d\u0935\u093e" },
            { "brx", "\u092c\u094b\u0921\u094b" },
            { "kde", "\u092e\u093e\u0915\u094b\u0902\u0921\u0947" },
            { "Ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u0940\u0915" },
            { "type.hc.h12", "12 \u0935\u0930\u093e\u0902\u091a\u0940 \u092f\u0902\u0924\u094d\u0930\u0923\u093e (1\u201312)" },
            { "type.hc.h11", "12 \u0935\u0930\u093e\u0902\u091a\u0940 \u092f\u0902\u0924\u094d\u0930\u0923\u093e (0\u201311)" },
            { "rm", "\u0930\u094b\u092e\u093e\u0902\u0928\u094d\u0936" },
            { "rn", "\u0930\u0941\u0902\u0926\u0940" },
            { "key.cu", "\u091a\u0932\u0928" },
            { "ro", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u0928\u094d" },
            { "type.nu.orya", "\u0913\u0921\u093f\u092f\u093e" },
            { "type.nu.hanidec", "\u091a\u093f\u0928\u0940 \u0926\u0936\u093e\u0902\u0936 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "ru", "\u0930\u0936\u093f\u092f\u0928" },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u094d\u0935\u093e\u0928\u094d\u0921\u093e" },
            { "kea", "\u0915\u093e\u092c\u0941\u0935\u0930\u094d\u0921\u093f\u092f\u0928\u0941" },
            { "mic", "\u092e\u093f\u0915\u094d\u092e\u093e\u0915" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "en_AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u0907\u0902\u0917\u094d\u0932\u0940\u0936" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sc", "\u0938\u093e\u0930\u094d\u0921\u093f\u0928\u093f\u092f\u093e\u0928" },
            { "sd", "\u0938\u093f\u0902\u0927\u0940" },
            { "se", "\u0909\u0924\u094d\u0924\u0930\u0940\u092f \u0938\u093e\u092e\u0940" },
            { "min", "\u092e\u093f\u0928\u093e\u0917\u094d\u0915\u093e\u092c\u094c" },
            { "sg", "\u0938\u093e\u0902\u0917\u094d\u0930\u094b" },
            { "sh", "\u0938\u0947\u0930\u094d\u092c\u094b-\u0915\u094d\u0930\u094b\u092f\u0947\u0937\u093f\u092f\u0928\u094d" },
            { "si", "\u0938\u093f\u0928\u094d\u0939\u0932\u0940\u0938\u094d" },
            { "sk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915" },
            { "sl", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "sm", "\u0938\u092e\u094b\u0928" },
            { "sn", "\u0936\u094b\u0928\u093e" },
            { "so", "\u0938\u094b\u092e\u093e\u0932\u0940" },
            { "type.nu.arab", "\u0905\u0930\u0947\u092c\u093f\u0915-\u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "sq", "\u0906\u0932\u094d\u092c\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "ss", "\u0938\u094d\u0935\u093e\u0924\u0940" },
            { "type.cf.account", "\u0932\u0947\u0916\u093e \u091a\u0932\u0928 \u0938\u094d\u0935\u0930\u0942\u092a" },
            { "st", "\u0938\u0947\u0938\u094b\u0925\u094b" },
            { "su", "\u0938\u0941\u0902\u0926\u0928\u0940\u0938" },
            { "sv", "\u0938\u094d\u0935\u0940\u0926\u0940\u0937" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "type.nu.hantfin", "\u092a\u093e\u0930\u0902\u092a\u093e\u0930\u0940\u0915 \u091a\u093f\u0928\u0940 \u092e\u0939\u0938\u0942\u0932 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "ibb", "\u0908\u092c\u093f\u092c\u093f\u092f\u094b" },
            { "iba", "\u0906\u092f\u092c\u0928" },
            { "ta", "\u0924\u092e\u093f\u0933" },
            { "142", "\u0906\u0936\u093f\u092f\u093e" },
            { "143", "\u092e\u0927\u094d\u092f \u0906\u0936\u093f\u092f\u093e" },
            { "te", metaValue_te },
            { "145", "\u0905\u0938\u094d\u0924\u0902\u0924 \u0906\u0936\u093f\u092f\u093e" },
            { "tg", "\u0924\u091c\u093f\u0915" },
            { "th", metaValue_th },
            { "ti", "\u0924\u093f\u0917\u094d\u0930\u093f\u0928\u094d\u092f\u093e" },
            { "bug", "\u092c\u0917\u093f\u0928\u093f\u0938" },
            { "kfo", "\u0915\u094b\u0930\u094b" },
            { "en_CA", "\u0915\u0945\u0928\u093e\u0921\u0940\u092f\u0928 \u0907\u0902\u0917\u094d\u0932\u0940\u0936" },
            { "tk", "\u0924\u0941\u0930\u094d\u0915\u092e\u0928" },
            { "tl", "\u0924\u0917\u093e\u0932\u094b\u0917" },
            { "tn", "\u0938\u0947\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", "\u0924\u094b\u0902\u0917\u093e" },
            { "dyo", "\u091c\u094b\u0932\u093e-\u092b\u094b\u0928\u0940" },
            { "type.nu.jpan", "\u091c\u092a\u093e\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "tr", "\u0924\u0941\u0930\u094d\u0915\u093f\u0937" },
            { "ts", "\u0924\u094d\u0938\u094b\u0917\u093e" },
            { "swb", "\u0915\u094b\u092e\u094b\u0930\u093f\u092f\u0928" },
            { "tt", "\u0924\u091f\u093e\u0930" },
            { "tw", "\u0924\u094d\u0935\u093f" },
            { "ty", "\u0924\u093e\u0939\u0940\u0936\u093f\u092f\u0928" },
            { "150", "\u092f\u0947\u0935\u0930\u094b\u092a" },
            { "151", "\u0909\u0926\u0947\u0902\u0924 \u092f\u0947\u0935\u0930\u094b\u092a" },
            { "154", "\u0909\u0924\u094d\u0924\u0930 \u092f\u0947\u0935\u0930\u094b\u092a" },
            { "dzg", "\u0921\u093e\u091d\u093e\u0917\u093e" },
            { "155", "\u0905\u0938\u094d\u0924\u0902\u0924 \u092f\u0947\u0935\u0930\u094b\u092a" },
            { "ug", "\u0909\u092f\u0918\u0942\u0930" },
            { "Kore", "\u0915\u094b\u0930\u093f\u092f\u0928" },
            { "Zyyy", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f" },
            { "uk", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "ur", "\u0909\u0930\u094d\u0926\u0942" },
            { "xal", "\u0915\u093e\u0932\u092e\u093e\u092f\u0915" },
            { "uz", "\u0909\u091c\u093c\u092c\u0947\u0915" },
            { "kha", "\u0916\u093e\u0938\u0940" },
            { "ve", "\u0935\u0947\u0902\u0926\u093e" },
            { "type.ca.roc", "\u092e\u093f\u0902\u0917\u0941\u0906 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e (\u0905\u0923\u0915\u093e\u0930\u093e\u091a\u0940 \u0915\u0941\u0930\u0942: \u091c\u093e\u0915\u093e \u091a\u093f\u0928\u0940 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u0947\u091a\u0947\u0902 \u092a\u094d\u0930\u091c\u093e\u0938\u0924\u094d\u0924\u093e\u0915\", \"\u0930\u093f\u092a\u092c\u094d\u0932\u093f\u0915\u0928 \u0926\u093f\u0928\u0926\u0930\u094d\u0936\u093f\u0915\u093e\")" },
            { "vi", "\u0935\u093f\u092f\u0924\u094d\u0928\u093e\u092e\u0940\u091c\u093c" },
            { "khq", "\u0915\u094b\u092f\u0930\u093e \u091b\u093f\u0928\u0940" },
            { "key.hc", "\u0935\u0930\u093e\u091a\u0947\u0902 \u091a\u0915\u094d\u0930 (12 \u0935\u093f 24)" },
            { "vo", "\u0913\u0932\u093e\u092a\u0941\u0915" },
            { "quc", "\u0915\u093f\u091a\u0947" },
            { "gaa", "\u0917\u093e" },
            { "wa", "\u0935\u093e\u0932\u0942\u0928" },
            { "syr", "\u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "Grek", "\u0917\u094d\u0930\u0940\u0915" },
            { "wo", "\u0909\u0932\u094b\u092b\u093c" },
            { "zgh", "\u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u092e\u094b\u0930\u094b\u0915\u094d\u0915\u0928 \u0924\u093e\u092e\u093e\u091d\u093e\u092f\u091f" },
            { "ar_001", "\u0906\u0927\u0941\u0928\u093f\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u093f\u0924 \u0905\u0930\u0947\u092c\u093f\u0915" },
            { "Mong", "\u092e\u094b\u0902\u0917\u094b\u0932\u093f\u092f\u0928" },
            { "mni", "\u092e\u0923\u093f\u092a\u0941\u0930\u0940" },
            { "Latn", "\u0932\u0945\u091f\u0940\u0928" },
            { "type.nu.hans", "\u0938\u094b\u0902\u092a\u0940 \u0915\u0947\u0932\u094d\u0932\u0940 \u091a\u093f\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "type.nu.hant", "\u092a\u093e\u0930\u0902\u092a\u093e\u0930\u0940\u0915 \u091a\u093f\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "xh", "\u091d\u093c\u094c\u0938\u093e" },
            { "type.nu.romanlow", "\u0930\u094b\u092e\u0928 \u0932\u094b\u0935\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "byn", "\u092c\u094d\u0932\u0940\u0928" },
            { "moh", "\u092e\u094b\u0939\u093e\u0915" },
            { "kkj", "\u0915\u093e\u0915\u094b" },
            { "yi", "\u0907\u0926\u094d\u0926\u093f\u0937\u094d" },
            { "mos", "\u092e\u094b\u0938\u094d\u0938\u0940" },
            { "yo", "\u092f\u0942\u0930\u0941\u092c\u093e" },
            { "es_MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u0938\u094d\u092a\u0945\u0928\u093f\u0936" },
            { "vai", "\u0935\u093e\u0908" },
            { "za", "\u091d\u094d\u0939\u0941\u0928\u094d\u0917" },
            { "kln", "\u0915\u093e\u0932\u0947\u0902\u091c\u0940\u0928" },
            { "zh", "\u091a\u093f\u0928\u0940" },
            { "Bopo", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u094b" },
            { "key.lb", "\u0930\u0947\u0917 \u0916\u0902\u0921 \u0915\u0930\u092a\u093e\u091a\u0940 \u0936\u0948\u0932\u0940" },
            { "zu", "\u091c\u0941\u0932\u0942" },
            { "Geor", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928" },
            { "kmb", "\u0915\u093f\u0902\u092c\u0941\u0902\u0921\u0941" },
            { "type.nu.jpanfin", "\u091c\u092a\u093e\u0928\u0940 \u092e\u0939\u0938\u0942\u0932 \u0938\u0902\u0916\u094d\u092f\u093e" },
            { "gez", "\u0917\u0947\u091d" },
            { "ebu", "\u090f\u092e\u094d\u092c\u0941" },
            { "zh_Hans", "\u0938\u094b\u0902\u092a\u0940 \u091a\u093f\u0928\u0940" },
            { "kok", "\u0915\u094b\u0902\u0915\u0923\u0940" },
            { "zh_Hant", "\u092a\u093e\u0930\u0902\u092a\u093e\u0930\u0940\u0915 \u091a\u093f\u0928\u0940" },
            { "kpe", "\u092a\u0947\u0932\u094d\u0932\u0947" },
            { "type.nu.khmr", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u0928 \u0905\u0902\u0915" },
            { "ilo", "\u0932\u094b\u0915\u094b" },
            { "mua", "\u092e\u0941\u0921\u093e\u0902\u0917" },
            { "type.nu.guru", "\u0917\u0941\u0930\u0941\u092e\u0941\u0916\u0940 \u0905\u0902\u0915" },
            { "mul", "\u0938\u093e\u092c\u093e\u0930 \u092d\u093e\u0936\u093e" },
            { "key.ms", "\u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "mus", "\u0915\u094d\u0930\u093f\u0915" },
            { "gil", "\u0917\u093f\u0932\u092c\u0930\u094d\u091f\u0940\u0938" },
            { "type.nu.tamldec", "\u0924\u092e\u093f\u0933 \u0905\u0902\u0915" },
            { "krc", "\u0915\u0930\u093e\u091a\u0940-\u092c\u093e\u0932\u094d\u0915\u0930" },
            { "inh", "\u0907\u0902\u0917\u0942\u0936" },
            { "krl", "\u0915\u093e\u0930\u0947\u0932\u093f\u092f\u0928" },
            { "efi", "\u090f\u092b\u0940\u0915" },
            { "key.nu", "\u0915\u094d\u0930\u092e\u093e\u0902\u0915" },
            { "kru", "\u0915\u0941\u0930\u0941\u0916" },
            { "ksb", "\u0936\u0902\u092c\u093e\u0932\u093e" },
            { "Telu", metaValue_te },
            { "ksf", "\u092c\u093e\u092b\u093f\u092f\u093e" },
        };
        return data;
    }
}
