/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.conversion;

import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.text.Document;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.conversion.StringToComboBoxModelConverter;
import org.netbeans.validation.api.conversion.StringToDocumentConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Converter<From, To> {
    private static Set<Entry> registry = new HashSet<Entry>();

    public abstract Validator<To> convert(Validator<From> var1);

    public final Validator<To> convert(Validator<From> ... froms) {
        return this.convert(Validators.merge(froms));
    }

    public static <From, To> void register(Class<From> from, Class<To> to, Converter<From, To> converter) {
        registry.add(new Entry<From, To>(from, to, converter));
    }

    public static <From, To> Converter<From, To> find(Class<From> from, Class<To> to) {
        for (Entry e : registry) {
            if (!e.match(from, to)) continue;
            return e.getConverter();
        }
        throw new IllegalArgumentException("No registered converter from " + from.getName() + " to " + to.getName());
    }

    static {
        Converter.register(String.class, Document.class, new StringToDocumentConverter());
        Converter.register(String.class, ComboBoxModel.class, new StringToComboBoxModelConverter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<From, To> {
        private final Class<From> from;
        private final Class<To> to;
        private Converter<From, To> converter;

        public boolean match(Class<?> from, Class<?> to) {
            return this.from.equals(from) && this.to.equals(to);
        }

        public Entry(Class<From> from, Class<To> to, Converter<From, To> converter) {
            this.from = from;
            this.to = to;
            this.converter = converter;
        }

        Converter<From, To> getConverter() {
            return this.converter;
        }
    }
}

