/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.distance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.function.distance.DistanceTableModel;
import tim.prune.function.distance.FromTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JTable _pointTable = null;
    private FromTableModel _fromModel = null;
    private DistanceTableModel _distModel = null;

    public DistanceFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.distances";
    }

    @Override
    public void begin() {
        ArrayList<DataPoint> arrayList;
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        if ((arrayList = DistanceFunction.getPointList(this._app.getTrackInfo())).size() < 2) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.distances.toofewpoints");
            return;
        }
        this._fromModel.init(arrayList);
        this._distModel.init(arrayList);
        this._pointTable.getSelectionModel().setSelectionInterval(0, 0);
        this._distModel.recalculate(0);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.distances.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        this._fromModel = new FromTableModel();
        this._pointTable = new JTable(this._fromModel);
        this._pointTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    DistanceFunction.this._distModel.recalculate(DistanceFunction.this._pointTable.getSelectedRow());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._pointTable);
        jScrollPane.setPreferredSize(new Dimension(100, 250));
        jPanel2.add(jScrollPane);
        this._distModel = new DistanceTableModel();
        JTable jTable = new JTable(this._distModel);
        try {
            object = Class.forName("javax.swing.JTable");
            ((Class)object).getDeclaredMethod("setAutoCreateRowSorter", Boolean.TYPE).invoke((Object)jTable, Boolean.TRUE);
        }
        catch (Exception exception) {}
        jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(200, 250));
        jPanel2.add(jScrollPane);
        jPanel.add((Component)jPanel2, "Center");
        object = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DistanceFunction.this._dialog.dispose();
                }
            }
        };
        this._pointTable.addKeyListener((KeyListener)object);
        jTable.addKeyListener((KeyListener)object);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DistanceFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private static ArrayList<DataPoint> getPointList(TrackInfo trackInfo) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        trackInfo.getTrack().getWaypoints(arrayList);
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null && !dataPoint.isWaypoint()) {
            arrayList.add(0, dataPoint);
        }
        return arrayList;
    }
}

