/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperatorCall;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"getOriginalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "toConstKind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toOperatorCall", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirIntegerOperatorCall;", "resolve"})
public final class IntegerLiteralTypeApproximationTransformerKt {
    @NotNull
    public static final FirConstKind<?> toConstKind(@NotNull ConeClassLikeType $this$toConstKind) {
        FirConstKind firConstKind;
        Intrinsics.checkParameterIsNotNull($this$toConstKind, "$this$toConstKind");
        ClassId classId = ConeTypeUtilsKt.getClassId($this$toConstKind);
        if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getInt())) {
            firConstKind = FirConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getLong())) {
            firConstKind = FirConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getShort())) {
            firConstKind = FirConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getByte())) {
            firConstKind = FirConstKind.Byte.INSTANCE;
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return firConstKind;
    }

    @Nullable
    public static final FirCallableDeclaration<?> getOriginalFunction(@NotNull FirFunctionCall $this$getOriginalFunction) {
        AbstractFirBasedSymbol<?> symbol2;
        Intrinsics.checkParameterIsNotNull($this$getOriginalFunction, "$this$getOriginalFunction");
        FirNamedReference reference = $this$getOriginalFunction.getCalleeReference();
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = symbol2 = reference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : (reference instanceof FirNamedReferenceWithCandidate ? ((FirNamedReferenceWithCandidate)reference).getCandidateSymbol() : null);
        Object object = abstractFirBasedSymbol != null ? abstractFirBasedSymbol.getFir() : null;
        if (!(object instanceof FirCallableDeclaration)) {
            object = null;
        }
        return (FirCallableDeclaration)object;
    }

    private static final FirIntegerOperatorCall toOperatorCall(@NotNull FirFunctionCall $this$toOperatorCall) {
        if ($this$toOperatorCall instanceof FirIntegerOperatorCall) {
            return (FirIntegerOperatorCall)$this$toOperatorCall;
        }
        FirIntegerOperatorCall firIntegerOperatorCall = new FirIntegerOperatorCall($this$toOperatorCall.getSource());
        boolean bl = false;
        boolean bl2 = false;
        FirIntegerOperatorCall it = firIntegerOperatorCall;
        boolean bl3 = false;
        it.setTypeRef($this$toOperatorCall.getTypeRef());
        Collection collection = it.getAnnotations();
        Iterable iterable = $this$toOperatorCall.getAnnotations();
        boolean bl4 = false;
        CollectionsKt.addAll(collection, iterable);
        it.setSafe($this$toOperatorCall.getSafe());
        collection = it.getTypeArguments();
        iterable = $this$toOperatorCall.getTypeArguments();
        bl4 = false;
        CollectionsKt.addAll(collection, iterable);
        it.setExplicitReceiver($this$toOperatorCall.getExplicitReceiver());
        it.setDispatchReceiver($this$toOperatorCall.getDispatchReceiver());
        it.setExtensionReceiver($this$toOperatorCall.getExtensionReceiver());
        collection = it.getArguments();
        iterable = $this$toOperatorCall.getArguments();
        bl4 = false;
        CollectionsKt.addAll(collection, iterable);
        it.setCalleeReference($this$toOperatorCall.getCalleeReference());
        return firIntegerOperatorCall;
    }

    public static final /* synthetic */ FirIntegerOperatorCall access$toOperatorCall(FirFunctionCall $this$access_u24toOperatorCall) {
        return IntegerLiteralTypeApproximationTransformerKt.toOperatorCall($this$access_u24toOperatorCall);
    }
}

