/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.PdfBookmark;
import com.gitlab.pdftk_java.PdfPageLabel;
import com.gitlab.pdftk_java.PdfPageMedia;
import com.gitlab.pdftk_java.bookmarks;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;
import pdftk.com.lowagie.text.Rectangle;
import pdftk.com.lowagie.text.pdf.PRStream;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfBoolean;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfString;

class report {
    private static CharSequenceTranslator XmlUnicodeEscaper = null;
    static final int LLx = 0;
    static final int LLy = 1;
    static final int URx = 2;
    static final int URy = 3;

    report() {
    }

    static String OutputXmlString(String jss_p) {
        if (XmlUnicodeEscaper == null) {
            XmlUnicodeEscaper = StringEscapeUtils.ESCAPE_XML10.with(new CharSequenceTranslator[]{NumericEntityEscaper.between((int)127, (int)Integer.MAX_VALUE)});
        }
        return XmlUnicodeEscaper.translate((CharSequence)jss_p);
    }

    static String OutputUtf8String(String jss_p) {
        return jss_p;
    }

    static String OutputPdfString(PdfString pdfss_p, boolean utf8_b) {
        if (pdfss_p != null && pdfss_p.isString()) {
            String jss_p = pdfss_p.toUnicodeString();
            if (utf8_b) {
                return report.OutputUtf8String(jss_p);
            }
            return report.OutputXmlString(jss_p);
        }
        return "";
    }

    static String OutputPdfName(PdfName pdfnn_p) {
        if (pdfnn_p != null && pdfnn_p.isName()) {
            String jnn_p = new String(pdfnn_p.getBytes());
            jnn_p = PdfName.decodeName(jnn_p);
            return report.OutputXmlString(jnn_p);
        }
        return "";
    }

    static String OutputPdfStringOrName(PdfObject pdfoo_p, boolean utf8_b) {
        if (pdfoo_p != null && pdfoo_p.isString()) {
            return report.OutputPdfString((PdfString)pdfoo_p, utf8_b);
        }
        if (pdfoo_p != null && pdfoo_p.isName()) {
            return report.OutputPdfName((PdfName)pdfoo_p);
        }
        return null;
    }

    static void OutputFormField(PrintStream ofs, FormField ff) {
        ofs.println("---");
        ofs.println("FieldType: " + ff.m_ft);
        ofs.println("FieldName: " + ff.m_tt);
        if (!ff.m_tu.isEmpty()) {
            ofs.println("FieldNameAlt: " + ff.m_tu);
        }
        ofs.println("FieldFlags: " + ff.m_ff);
        for (String string : ff.m_vv) {
            ofs.println("FieldValue: " + string);
        }
        if (!ff.m_dv.isEmpty()) {
            ofs.println("FieldValueDefault: " + ff.m_dv);
        }
        ofs.print("FieldJustification: ");
        switch (ff.m_qq) {
            case 0: {
                ofs.println("Left");
                break;
            }
            case 1: {
                ofs.println("Center");
                break;
            }
            case 2: {
                ofs.println("Right");
                break;
            }
            default: {
                ofs.println(ff.m_qq);
            }
        }
        if (!ff.m_ds.isEmpty()) {
            ofs.println("FieldStyleDefault: " + ff.m_ds);
        }
        if (ff.m_rv.length > 0) {
            ofs.print("FieldValueRichText: ");
            try {
                ofs.write(ff.m_rv);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ofs.println();
        }
        if (0 < ff.m_maxlen) {
            ofs.println("FieldMaxLength: " + ff.m_maxlen);
        }
        for (String string : ff.m_states) {
            ofs.println("FieldStateOption: " + string);
        }
        for (List list : ff.m_states_value_display) {
            ofs.println("FieldStateOption: " + (String)list.get(0));
            ofs.println("FieldStateOptionDisplay: " + (String)list.get(1));
        }
    }

    static boolean ReportAcroFormFields(PrintStream ofs, PdfArray kids_array_p, FormField acc_state, PdfReader reader_p, boolean utf8_b) {
        FormField prev_state = new FormField(acc_state);
        boolean ret_val_b = false;
        ArrayList kids_p = kids_array_p.getArrayList();
        if (kids_p != null) {
            for (PdfObject kids_ii : kids_p) {
                String maybe_output;
                PdfObject pdfs_p;
                PdfObject kid_po = PdfReader.getPdfObject(kids_ii);
                if (kid_po == null || !kid_po.isDictionary()) continue;
                PdfDictionary kid_p = (PdfDictionary)kid_po;
                if (kid_p.contains(PdfName.FT)) {
                    PdfObject ft_p = PdfReader.getPdfObject(kid_p.get(PdfName.FT));
                    if (ft_p != null && ft_p.isName()) {
                        if (ft_p.equals(PdfName.BTN)) {
                            acc_state.m_ft = "Button";
                        } else if (ft_p.equals(PdfName.TX)) {
                            acc_state.m_ft = "Text";
                        } else if (ft_p.equals(PdfName.CH)) {
                            acc_state.m_ft = "Choice";
                        } else if (ft_p.equals(PdfName.SIG)) {
                            acc_state.m_ft = "Signature";
                        } else {
                            System.err.println("pdftk Warning in ReportAcroFormFields(): unexpected field type;");
                        }
                    }
                }
                if (kid_p.contains(PdfName.T)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.T));
                    if (pdfs_p != null && pdfs_p.isString()) {
                        if (!acc_state.m_tt.isEmpty()) {
                            acc_state.m_tt = acc_state.m_tt + ".";
                        }
                        acc_state.m_tt = acc_state.m_tt + report.OutputPdfString((PdfString)pdfs_p, utf8_b);
                    }
                }
                if (kid_p.contains(PdfName.TU)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.TU));
                    if (pdfs_p != null && pdfs_p.isString()) {
                        acc_state.m_tu = report.OutputPdfString((PdfString)pdfs_p, utf8_b);
                    }
                } else {
                    acc_state.m_tu = "";
                }
                if (kid_p.contains(PdfName.FF)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.FF));
                    if (pdfs_p != null && pdfs_p.isNumber()) {
                        acc_state.m_ff = ((PdfNumber)pdfs_p).intValue();
                    }
                }
                if (kid_p.contains(PdfName.V)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.V));
                    if (pdfs_p == null) continue;
                    maybe_output = report.OutputPdfStringOrName(pdfs_p, utf8_b);
                    if (maybe_output != null) {
                        acc_state.m_vv.add(maybe_output);
                    } else if (pdfs_p.isArray()) {
                        ArrayList vv_p = ((PdfArray)pdfs_p).getArrayList();
                        for (PdfObject vv_ii : vv_p) {
                            PdfObject pdfs_p_2 = PdfReader.getPdfObject(vv_ii);
                            String maybe_output_2 = report.OutputPdfStringOrName(pdfs_p_2, utf8_b);
                            if (maybe_output_2 == null) continue;
                            acc_state.m_vv.add(maybe_output_2);
                        }
                    }
                }
                if (kid_p.contains(PdfName.DV)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.DV));
                    maybe_output = report.OutputPdfStringOrName(pdfs_p, utf8_b);
                    if (maybe_output != null) {
                        acc_state.m_dv = maybe_output;
                    }
                }
                if (kid_p.contains(PdfName.Q)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.Q));
                    if (pdfs_p != null && pdfs_p.isNumber()) {
                        acc_state.m_qq = ((PdfNumber)pdfs_p).intValue();
                    }
                }
                if (kid_p.contains(PdfName.DS)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.DS));
                    if (pdfs_p != null && pdfs_p.isString()) {
                        acc_state.m_ds = report.OutputPdfString((PdfString)pdfs_p, utf8_b);
                    }
                } else {
                    acc_state.m_ds = "";
                }
                if (kid_p.contains(PdfName.RV)) {
                    PdfObject pdfo_p = PdfReader.getPdfObject(kid_p.get(PdfName.RV));
                    if (pdfo_p != null && pdfo_p.isString()) {
                        String name_oss = report.OutputPdfString((PdfString)pdfo_p, utf8_b);
                        acc_state.m_rv = name_oss.getBytes(StandardCharsets.UTF_8);
                    } else if (pdfo_p != null && pdfo_p.isStream()) {
                        acc_state.m_rv = ((PRStream)pdfo_p).getBytes();
                    }
                } else {
                    acc_state.m_rv = new byte[0];
                }
                if (kid_p.contains(PdfName.MAXLEN)) {
                    pdfs_p = PdfReader.getPdfObject(kid_p.get(PdfName.MAXLEN));
                    if (pdfs_p != null && pdfs_p.isNumber()) {
                        acc_state.m_maxlen = ((PdfNumber)pdfs_p).intValue();
                    }
                }
                if (kid_p.contains(PdfName.AP)) {
                    PdfObject ap_po = PdfReader.getPdfObject(kid_p.get(PdfName.AP));
                    if (ap_po != null && ap_po.isDictionary()) {
                        PdfDictionary ap_p = (PdfDictionary)ap_po;
                        acc_state.addApStates(reader_p, ap_p, PdfName.N);
                        acc_state.addApStates(reader_p, ap_p, PdfName.D);
                        acc_state.addApStates(reader_p, ap_p, PdfName.R);
                    }
                }
                if (kid_p.contains(PdfName.OPT)) {
                    PdfObject kid_opts_p = PdfReader.getPdfObject(kid_p.get(PdfName.OPT));
                    if (kid_opts_p != null && kid_opts_p.isArray()) {
                        acc_state.addOptions(reader_p, (PdfArray)kid_opts_p, utf8_b);
                    }
                }
                if (kid_p.contains(PdfName.KIDS)) {
                    PdfObject kid_kids_p = PdfReader.getPdfObject(kid_p.get(PdfName.KIDS));
                    if (kid_kids_p == null || !kid_kids_p.isArray()) continue;
                    boolean kids_have_names_b = report.ReportAcroFormFields(ofs, (PdfArray)kid_kids_p, acc_state, reader_p, utf8_b);
                    if (!kids_have_names_b && kid_p.contains(PdfName.T)) {
                        report.OutputFormField(ofs, acc_state);
                    }
                    acc_state.copyFrom(prev_state);
                    ret_val_b |= kids_have_names_b;
                    continue;
                }
                if (!kid_p.contains(PdfName.T)) continue;
                report.OutputFormField(ofs, acc_state);
                acc_state.copyFrom(prev_state);
                ret_val_b = true;
            }
        } else {
            System.err.println("pdftk Warning in ReportAcroFormFields(): unable to get ArrayList;");
        }
        return ret_val_b;
    }

    static void ReportAcroFormFields(PrintStream ofs, PdfReader reader_p, boolean utf8_b) {
        PdfDictionary catalog_p = reader_p.catalog;
        if (catalog_p != null && catalog_p.isDictionary()) {
            PdfObject acro_form_p = PdfReader.getPdfObject(catalog_p.get(PdfName.ACROFORM));
            if (acro_form_p != null && acro_form_p.isDictionary()) {
                PdfObject fields_p = PdfReader.getPdfObject(((PdfDictionary)acro_form_p).get(PdfName.FIELDS));
                if (fields_p != null && fields_p.isArray()) {
                    FormField root_field_state = new FormField();
                    report.ReportAcroFormFields(ofs, (PdfArray)fields_p, root_field_state, reader_p, utf8_b);
                }
            }
        } else {
            System.err.println("pdftk Error in ReportAcroFormFields(): unable to access PDF catalog;");
        }
    }

    static void ReportAction(PrintStream ofs, PdfReader reader_p, PdfDictionary action_p, boolean utf8_b, String prefix) {
        if (action_p.contains(PdfName.S)) {
            PdfObject s_p = PdfReader.getPdfObject(action_p.get(PdfName.S));
            if (s_p.equals(PdfName.URI)) {
                ofs.println(prefix + "ActionSubtype: URI");
                if (action_p.contains(PdfName.URI)) {
                    PdfObject uri_p = PdfReader.getPdfObject(action_p.get(PdfName.URI));
                    if (uri_p != null && uri_p.isString()) {
                        ofs.println(prefix + "ActionURI: " + report.OutputPdfString((PdfString)uri_p, utf8_b));
                    }
                }
                if (action_p.contains(PdfName.ISMAP)) {
                    PdfObject ismap_p = PdfReader.getPdfObject(action_p.get(PdfName.ISMAP));
                    if (ismap_p != null && ismap_p.isBoolean() && ((PdfBoolean)ismap_p).booleanValue()) {
                        ofs.println(prefix + "ActionIsMap: true");
                    } else {
                        ofs.println(prefix + "ActionIsMap: false");
                    }
                }
            }
        }
        if (action_p.contains(PdfName.NEXT)) {
            PdfObject next_p = PdfReader.getPdfObject(action_p.get(PdfName.NEXT));
            if (next_p != null && next_p.isDictionary()) {
                report.ReportAction(ofs, reader_p, (PdfDictionary)next_p, utf8_b, prefix);
            } else if (next_p != null && next_p.isArray()) {
                ArrayList actions_p = ((PdfArray)next_p).getArrayList();
                for (PdfObject ii : actions_p) {
                    PdfObject next_action_p = PdfReader.getPdfObject(ii);
                    if (next_action_p == null || !next_action_p.isDictionary()) continue;
                    report.ReportAction(ofs, reader_p, (PdfDictionary)next_action_p, utf8_b, prefix);
                }
            }
        }
    }

    static void ReportAnnot(PrintStream ofs, PdfReader reader_p, int page_num, PdfDictionary page_p, PdfDictionary annot_p, boolean utf8_b) {
        ArrayList rect_al_p;
        PdfObject subtype_p = PdfReader.getPdfObject(annot_p.get(PdfName.SUBTYPE));
        if (subtype_p != null && subtype_p.isName()) {
            ofs.println("AnnotSubtype: " + report.OutputPdfName((PdfName)subtype_p));
        }
        float[] rect = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        PdfObject rect_p = PdfReader.getPdfObject(annot_p.get(PdfName.RECT));
        if (rect_p != null && rect_p.isArray() && (rect_al_p = ((PdfArray)rect_p).getArrayList()).size() == 4) {
            for (int ii = 0; ii < 4; ++ii) {
                PdfObject coord_p = PdfReader.getPdfObject((PdfObject)rect_al_p.get(ii));
                rect[ii] = coord_p != null && coord_p.isNumber() ? ((PdfNumber)coord_p).floatValue() : -1.0f;
            }
        }
        float page_crop_width = 0.0f;
        float page_crop_height = 0.0f;
        Rectangle page_crop_p = reader_p.getCropBox(page_num);
        rect[0] = rect[0] - page_crop_p.left();
        rect[1] = rect[1] - page_crop_p.bottom();
        rect[2] = rect[2] - page_crop_p.left();
        rect[3] = rect[3] - page_crop_p.bottom();
        page_crop_width = page_crop_p.right() - page_crop_p.left();
        page_crop_height = page_crop_p.top() - page_crop_p.bottom();
        int page_rot = reader_p.getPageRotation(page_num) % 360;
        float[] rot_rect = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        switch (page_rot) {
            case 90: {
                rot_rect[0] = rect[1];
                rot_rect[1] = page_crop_width - rect[2];
                rot_rect[2] = rect[3];
                rot_rect[3] = page_crop_width - rect[0];
                break;
            }
            case 180: {
                rot_rect[0] = page_crop_width - rect[2];
                rot_rect[1] = page_crop_height - rect[3];
                rot_rect[2] = page_crop_width - rect[0];
                rot_rect[3] = page_crop_height - rect[1];
                break;
            }
            case 270: {
                rot_rect[0] = page_crop_height - rect[3];
                rot_rect[1] = rect[0];
                rot_rect[2] = page_crop_height - rect[1];
                rot_rect[3] = rect[2];
                break;
            }
            default: {
                rot_rect[0] = rect[0];
                rot_rect[1] = rect[1];
                rot_rect[2] = rect[2];
                rot_rect[3] = rect[3];
            }
        }
        ofs.println("AnnotRect: " + rot_rect[0] + " " + rot_rect[1] + " " + rot_rect[2] + " " + rot_rect[3]);
    }

    static void ReportAnnots(PrintStream ofs, PdfReader reader_p, boolean utf8_b) {
        reader_p.resetReleasePage();
        ofs.println("NumberOfPages: " + reader_p.getNumberOfPages());
        PdfObject uri_p = PdfReader.getPdfObject(reader_p.catalog.get(PdfName.URI));
        if (uri_p != null && uri_p.isDictionary()) {
            PdfObject base_p = PdfReader.getPdfObject(((PdfDictionary)uri_p).get(PdfName.BASE));
            if (base_p != null && base_p.isString()) {
                ofs.println("PdfUriBase: " + report.OutputPdfString((PdfString)base_p, utf8_b));
            }
        }
        for (int ii = 1; ii <= reader_p.getNumberOfPages(); ++ii) {
            PdfDictionary page_p = reader_p.getPageN(ii);
            PdfObject annots_p = PdfReader.getPdfObject(page_p.get(PdfName.ANNOTS));
            if (annots_p != null && annots_p.isArray()) {
                ArrayList annots_al_p = ((PdfArray)annots_p).getArrayList();
                for (PdfObject jj : annots_al_p) {
                    PdfObject annot_po = PdfReader.getPdfObject(jj);
                    if (annot_po == null || !annot_po.isDictionary()) continue;
                    PdfDictionary annot_p = (PdfDictionary)annot_po;
                    PdfObject type_p = PdfReader.getPdfObject(annot_p.get(PdfName.TYPE));
                    if (type_p == null || !type_p.equals(PdfName.ANNOT)) continue;
                    PdfObject subtype_p = PdfReader.getPdfObject(annot_p.get(PdfName.SUBTYPE));
                    if (!subtype_p.equals(PdfName.LINK)) continue;
                    ofs.println("---");
                    report.ReportAnnot(ofs, reader_p, ii, page_p, annot_p, utf8_b);
                    ofs.println("AnnotPageNumber: " + ii);
                    if (!annot_p.contains(PdfName.A)) continue;
                    PdfObject action_p = PdfReader.getPdfObject(annot_p.get(PdfName.A));
                    if (action_p == null || !action_p.isDictionary()) continue;
                    report.ReportAction(ofs, reader_p, (PdfDictionary)action_p, utf8_b, "Annot");
                }
            }
            reader_p.releasePage(ii);
        }
        reader_p.resetReleasePage();
    }

    static void ReportOutlines(PrintStream ofs, PdfDictionary outline_p, PdfReader reader_p, boolean utf8_b) {
        ArrayList<PdfBookmark> bookmark_data = new ArrayList<PdfBookmark>();
        bookmarks.ReadOutlines(bookmark_data, outline_p, 0, reader_p, utf8_b);
        for (PdfBookmark it : bookmark_data) {
            ofs.print(it);
        }
    }

    static void ReportInfo(PrintStream ofs, PdfReader reader_p, PdfDictionary info_p, boolean utf8_b) {
        if (info_p != null && info_p.isDictionary()) {
            Set keys_p = info_p.getKeys();
            for (PdfName key_p : keys_p) {
                int key_len = key_p.getBytes().length - 1;
                PdfObject value_p = PdfReader.getPdfObject(info_p.get(key_p));
                if (0 >= key_len || !value_p.isString() || 0 >= ((PdfString)value_p).toUnicodeString().length()) continue;
                ofs.println("InfoBegin");
                ofs.println("InfoKey: " + report.OutputPdfName(key_p));
                ofs.println("InfoValue: " + report.OutputPdfString((PdfString)value_p, utf8_b));
            }
        }
    }

    static void ReportPageLabels(PrintStream ofs, PdfDictionary numtree_node_p, PdfReader reader_p, boolean utf8_b) {
        PdfObject nums_p = PdfReader.getPdfObject(numtree_node_p.get(PdfName.NUMS));
        if (nums_p != null && nums_p.isArray()) {
            ArrayList labels_p = ((PdfArray)nums_p).getArrayList();
            Iterator labels_ii = labels_p.iterator();
            while (labels_ii.hasNext()) {
                PdfObject index_p = PdfReader.getPdfObject((PdfObject)labels_ii.next());
                PdfObject label_po = PdfReader.getPdfObject((PdfObject)labels_ii.next());
                if (index_p != null && index_p.isNumber() && label_po != null && label_po.isDictionary()) {
                    PdfObject style_p;
                    PdfDictionary label_p = (PdfDictionary)label_po;
                    PdfPageLabel pagelabel = new PdfPageLabel();
                    pagelabel.m_new_index = ((PdfNumber)index_p).intValue() + 1;
                    PdfObject start_p = PdfReader.getPdfObject(label_p.get(PdfName.ST));
                    pagelabel.m_start = start_p != null && start_p.isNumber() ? ((PdfNumber)start_p).intValue() : 1;
                    PdfObject prefix_p = PdfReader.getPdfObject(label_p.get(PdfName.P));
                    if (prefix_p != null && prefix_p.isString()) {
                        pagelabel.m_prefix = report.OutputPdfString((PdfString)prefix_p, utf8_b);
                    }
                    pagelabel.m_num_style = (style_p = PdfReader.getPdfObject(label_p.get(PdfName.S))) != null && style_p.isName() ? PdfPageLabel.NumberingStyle.fromPdfName.getOrDefault((Object)style_p, (PdfPageLabel.NumberingStyle)PdfPageLabel.NumberingStyle.ERROR).representation : PdfPageLabel.NumberingStyle.EMPTY.representation;
                    ofs.print(pagelabel);
                    continue;
                }
                ofs.println("[PDFTK ERROR: INVALID label_p IN ReportPageLabelNode]");
            }
        } else {
            PdfObject kids_p = PdfReader.getPdfObject(numtree_node_p.get(PdfName.KIDS));
            if (kids_p != null && kids_p.isArray()) {
                ArrayList kids_ar_p = ((PdfArray)kids_p).getArrayList();
                for (PdfObject kids_ii : kids_ar_p) {
                    PdfObject kid_p = PdfReader.getPdfObject(kids_ii);
                    if (kid_p != null && kid_p.isDictionary()) {
                        report.ReportPageLabels(ofs, (PdfDictionary)kid_p, reader_p, utf8_b);
                        continue;
                    }
                    ofs.println("[PDFTK ERROR: INVALID kid_p]");
                }
            } else {
                ofs.println("[PDFTK ERROR: INVALID PAGE LABEL NUMBER TREE]");
            }
        }
    }

    static void ReportPageMedia(PrintStream ofs, int numPages, PdfReader reader_p, boolean utf8_b) {
        for (int ii = 1; ii <= numPages; ++ii) {
            PdfDictionary page_p = reader_p.getPageN(ii);
            PdfPageMedia pagemedia = new PdfPageMedia();
            pagemedia.m_number = ii;
            pagemedia.m_rotation = reader_p.getPageRotation(page_p);
            pagemedia.m_rect = reader_p.getPageSize(page_p);
            pagemedia.m_crop = reader_p.getBoxSize(page_p, PdfName.CROPBOX);
            ofs.print(pagemedia);
            PdfString stamptkData_p = page_p.getAsString(PdfName.STAMPTKDATA);
            if (stamptkData_p != null) {
                ofs.println("PageMediaStamptkData: " + report.OutputPdfString(stamptkData_p, utf8_b));
            }
            reader_p.releasePage(ii);
        }
    }

    static void ReportOnPdf(PrintStream ofs, PdfReader reader_p, boolean utf8_b) {
        PdfDictionary trailer_p = reader_p.getTrailer();
        if (trailer_p != null) {
            PdfObject info_p = PdfReader.getPdfObject(trailer_p.get(PdfName.INFO));
            if (info_p != null && info_p.isDictionary()) {
                report.ReportInfo(ofs, reader_p, (PdfDictionary)info_p, utf8_b);
            } else {
                System.err.println("Warning: no info dictionary found");
            }
            PdfObject id_p = PdfReader.getPdfObject(trailer_p.get(PdfName.ID));
            if (id_p != null && id_p.isArray()) {
                ArrayList id_al_p = ((PdfArray)id_p).getArrayList();
                for (int ii = 0; ii < id_al_p.size(); ++ii) {
                    ofs.print("PdfID" + ii + ": ");
                    PdfObject id_ss_p = PdfReader.getPdfObject((PdfObject)id_al_p.get(ii));
                    if (id_ss_p != null && id_ss_p.isString()) {
                        byte[] bb = ((PdfString)id_ss_p).getBytes();
                        if (bb != null && bb.length > 0) {
                            for (byte bb_ss : bb) {
                                ofs.printf("%02x", bb_ss);
                            }
                        }
                    } else {
                        System.err.println("pdftk Error in ReportOnPdf(): invalid pdf id array string;");
                    }
                    ofs.println();
                }
            }
        } else {
            System.err.println("pdftk Error in ReportOnPdf(): invalid trailer;");
        }
        int numPages = reader_p.getNumberOfPages();
        PdfDictionary catalog_p = reader_p.catalog;
        if (catalog_p != null && catalog_p.isDictionary()) {
            ofs.println("NumberOfPages: " + numPages);
            PdfObject outlines_p = PdfReader.getPdfObject(catalog_p.get(PdfName.OUTLINES));
            if (outlines_p != null && outlines_p.isDictionary()) {
                PdfObject top_outline_p = PdfReader.getPdfObject(((PdfDictionary)outlines_p).get(PdfName.FIRST));
                if (top_outline_p != null && top_outline_p.isDictionary()) {
                    report.ReportOutlines(ofs, (PdfDictionary)top_outline_p, reader_p, utf8_b);
                }
            }
        } else {
            System.err.println("pdftk Error in ReportOnPdf(): couldn't find catalog;");
        }
        report.ReportPageMedia(ofs, numPages, reader_p, utf8_b);
        catalog_p = reader_p.catalog;
        if (catalog_p != null) {
            PdfObject pagelabels_p = PdfReader.getPdfObject(catalog_p.get(PdfName.PAGELABELS));
            if (pagelabels_p != null && pagelabels_p.isDictionary()) {
                report.ReportPageLabels(ofs, (PdfDictionary)pagelabels_p, reader_p, utf8_b);
            }
        } else {
            System.err.println("pdftk Error in ReportOnPdf(): couldn't find catalog (2);");
        }
    }

    static class FormField {
        String m_ft = "";
        String m_tt = "";
        String m_tu = "";
        int m_ff = 0;
        Set<String> m_vv = new HashSet<String>();
        String m_dv = "";
        int m_qq = 0;
        String m_ds = "";
        byte[] m_rv = new byte[0];
        int m_maxlen = 0;
        Set<String> m_states = new HashSet<String>();
        Set<List<String>> m_states_value_display = new HashSet<List<String>>();
        String m_state = "";

        FormField() {
        }

        void copyFrom(FormField copy) {
            this.m_ft = copy.m_ft;
            this.m_tt = copy.m_tt;
            this.m_tu = copy.m_tu;
            this.m_ff = copy.m_ff;
            this.m_vv = new HashSet<String>(copy.m_vv);
            this.m_dv = copy.m_dv;
            this.m_qq = copy.m_qq;
            this.m_ds = copy.m_ds;
            this.m_rv = Arrays.copyOf(copy.m_rv, copy.m_rv.length);
            this.m_maxlen = copy.m_maxlen;
            this.m_states = new HashSet<String>(copy.m_states);
            this.m_states_value_display = new HashSet<List<String>>();
            for (List<String> l : copy.m_states_value_display) {
                this.m_states_value_display.add(new ArrayList<String>(l));
            }
            this.m_state = copy.m_state;
        }

        FormField(FormField copy) {
            this.copyFrom(copy);
        }

        void addOptions(PdfReader reader_p, PdfArray opts_p, boolean utf8_b) {
            ArrayList opts_a = opts_p.getArrayList();
            for (PdfObject opts_ii : opts_a) {
                PdfObject opt_p = PdfReader.getPdfObject(opts_ii);
                if (opt_p == null) continue;
                if (opt_p.isString()) {
                    this.m_states.add(report.OutputPdfString((PdfString)opt_p, utf8_b));
                    continue;
                }
                if (!opt_p.isArray()) continue;
                ArrayList opt_value_display_p = ((PdfArray)opt_p).getArrayList();
                ArrayList<String> opt_value_display_a = new ArrayList<String>();
                for (PdfObject subopt_p : opt_value_display_p) {
                    if (!subopt_p.isString()) continue;
                    opt_value_display_a.add(report.OutputPdfString((PdfString)subopt_p, utf8_b));
                }
                if (opt_value_display_a.size() != 2) continue;
                this.m_states_value_display.add(opt_value_display_a);
            }
        }

        void addApStates(PdfReader reader_p, PdfDictionary ap_p, PdfName state_name) {
            if (ap_p.contains(state_name)) {
                PdfObject n_p = PdfReader.getPdfObject(ap_p.get(state_name));
                if (n_p != null && n_p.isDictionary()) {
                    Set n_set_p = ((PdfDictionary)n_p).getKeys();
                    for (PdfName key_p : n_set_p) {
                        this.m_states.add(report.OutputPdfName(key_p));
                    }
                }
            }
        }
    }
}

