/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.nwdiag.DiagElement;
import net.sourceforge.plantuml.nwdiag.DiagGroup;
import net.sourceforge.plantuml.nwdiag.GridTextBlockDecorated;
import net.sourceforge.plantuml.nwdiag.Network;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NwDiagram
extends UmlDiagram {
    private boolean initDone;
    private final Map<String, DiagElement> elements = new LinkedHashMap<String, DiagElement>();
    private final List<Network> networks = new ArrayList<Network>();
    private final List<DiagGroup> groups = new ArrayList<DiagGroup>();
    private DiagGroup currentGroup = null;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Nwdiag)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.NWDIAG;
    }

    public void init() {
        this.initDone = true;
    }

    private Network currentNetwork() {
        if (this.networks.size() == 0) {
            return null;
        }
        return this.networks.get(this.networks.size() - 1);
    }

    public CommandExecutionResult openGroup(String name) {
        if (!this.initDone) {
            return this.error();
        }
        this.currentGroup = new DiagGroup(name, this.currentNetwork());
        this.groups.add(this.currentGroup);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult openNetwork(String name) {
        if (!this.initDone) {
            return this.error();
        }
        Network network = new Network(name);
        this.networks.add(network);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult endSomething() {
        if (!this.initDone) {
            return this.error();
        }
        this.currentGroup = null;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addElement(String name, String definition) {
        if (!this.initDone) {
            return this.error();
        }
        if (this.currentGroup != null) {
            this.currentGroup.addElement(name);
        }
        if (this.currentNetwork() != null) {
            String shape;
            Map<String, String> props;
            String description;
            DiagElement element = this.elements.get(name);
            if (element == null) {
                element = new DiagElement(name, this.currentNetwork());
                this.elements.put(name, element);
            }
            if ((description = (props = this.toSet(definition)).get("description")) != null) {
                element.setDescription(description);
            }
            if ((shape = props.get("shape")) != null) {
                element.setShape(shape);
            }
            this.currentNetwork().addElement(element, props);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult error() {
        return CommandExecutionResult.error("");
    }

    private Map<String, String> toSet(String definition) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (definition == null) {
            return result;
        }
        Pattern p = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\"([^\"]*)\"|[^\\s,]+)");
        Matcher m = p.matcher(definition);
        while (m.find()) {
            String name = m.group(1);
            String value = m.group(3) == null ? m.group(2) : m.group(3);
            result.put(name, value);
        }
        return result;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? 1.0 : scale.getScale(100.0, 100.0);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), dpiFactor, null, "", "", 0.0, 0.0, null, false);
        UDrawable result = this.getUDrawable();
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, 0L, os);
    }

    private UDrawable getUDrawable() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }
        };
    }

    private TextBlock toTextBlock(String name, String s) {
        if (s != null) {
            name = name + "\\n" + s;
        }
        return Display.getWithNewlines(name).create(this.getFontConfiguration(), HorizontalAlignment.RIGHT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    private void drawMe(UGraphic ug) {
        double margin = 5.0;
        ug = ug.apply(new UTranslate(5.0, 5.0));
        StringBounder stringBounder = ug.getStringBounder();
        GridTextBlockDecorated grid = new GridTextBlockDecorated(this.networks.size(), this.elements.size(), this.groups);
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            Network next = i + 1 < this.networks.size() ? this.networks.get(i + 1) : null;
            int j = 0;
            for (Map.Entry<String, DiagElement> ent : this.elements.entrySet()) {
                DiagElement element = ent.getValue();
                if (element.getMainNetwork() == current && current.constainsLocally(ent.getKey())) {
                    String ad1 = current.getAdress(element);
                    String ad2 = next == null ? null : next.getAdress(element);
                    grid.add(i, j, element.asTextBlock(ad1, ad2));
                }
                ++j;
            }
        }
        double deltaX = 0.0;
        double deltaY = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlock(current.getName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            if (i == 0) {
                deltaY = (dim.getHeight() - 5.0) / 2.0;
            }
            deltaX = Math.max(deltaX, dim.getWidth());
        }
        double y = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlock(current.getName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            desc.drawU(ug.apply(new UTranslate(deltaX - dim.getWidth(), y)));
            y += grid.lineHeight(stringBounder, i);
        }
        grid.drawU(ug.apply(ColorParam.activityBorder.getDefaultValue()).apply(ColorParam.activityBackground.getDefaultValue().bg()).apply(new UTranslate(deltaX += 5.0, deltaY)));
        Dimension2D dimGrid = grid.calculateDimension(stringBounder);
        ug.apply(new UTranslate(dimGrid.getWidth() + deltaX + 5.0, dimGrid.getHeight() + deltaY + 5.0)).draw(new UEmpty(1.0, 1.0));
    }

    public CommandExecutionResult setProperty(String property, String value) {
        if (!this.initDone) {
            return this.error();
        }
        if ("address".equalsIgnoreCase(property) && this.currentNetwork() != null) {
            this.currentNetwork().setOwnAdress(value);
        }
        if ("color".equalsIgnoreCase(property)) {
            HColor color = GridTextBlockDecorated.colors.getColorIfValid(value);
            if (this.currentGroup != null) {
                this.currentGroup.setColor(color);
            } else if (this.currentNetwork() != null) {
                this.currentNetwork().setColor(color);
            }
        }
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult link() {
        if (!this.initDone) {
            return this.error();
        }
        return CommandExecutionResult.ok();
    }
}

