/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYItem;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;

final class TimelineModel
implements Timeline {
    private static final int STORAGE_BUFFER_STEP = 50;
    private int bufferStep;
    private int valuesCount;
    private long[] timestamps;
    private long[][] values;
    private final List<TimelineXYItem> items = new ArrayList<TimelineXYItem>();

    TimelineModel() {
        this(50);
    }

    private TimelineModel(int n) {
        this.bufferStep = n;
        this.reset();
    }

    int getItemsCount() {
        return this.items.size();
    }

    TimelineXYItem[] createItems(ProbeItemDescriptor[] probeItemDescriptorArray) {
        int n = this.values == null ? 0 : this.values.length;
        int n2 = probeItemDescriptorArray.length;
        TimelineXYItem[] timelineXYItemArray = new TimelineXYItem[n2];
        for (int i = 0; i < n2; ++i) {
            if (probeItemDescriptorArray[i] instanceof ValueItemDescriptor) {
                ValueItemDescriptor valueItemDescriptor = (ValueItemDescriptor)probeItemDescriptorArray[i];
                timelineXYItemArray[i] = new TimelineXYItem(valueItemDescriptor.getName(), valueItemDescriptor.getMinValue(), valueItemDescriptor.getMaxValue(), n + i){

                    public long getYValue(int n) {
                        return TimelineModel.this.values[this.getIndex()][n];
                    }
                };
            }
            this.items.add(timelineXYItemArray[i]);
        }
        this.addItemsImpl(n2);
        return timelineXYItemArray;
    }

    void removeItems(SynchronousXYItem[] synchronousXYItemArray) {
        this.removeItemsImpl(synchronousXYItemArray.length);
        int n = ((TimelineXYItem)synchronousXYItemArray[0]).getIndex();
        for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
            this.items.remove(n);
        }
        for (int i = n; i < this.items.size(); ++i) {
            this.items.get(i).setIndex(i);
        }
    }

    void addValues(long l, long[] lArray) {
        long l2;
        this.updateStorage();
        long l3 = l2 = this.valuesCount == 0 ? -1L : this.timestamps[this.valuesCount - 1];
        if (l2 >= l) {
            l = l2 + 1L;
        }
        this.timestamps[this.valuesCount] = l;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i][this.valuesCount] = lArray[i];
        }
        ++this.valuesCount;
    }

    void reset() {
        this.valuesCount = 0;
        this.timestamps = null;
        if (this.values != null) {
            if (this.values.length == 0) {
                this.values = null;
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = new long[0];
                }
            }
        }
    }

    private void addItemsImpl(int n) {
        int n2 = (this.values == null ? 0 : this.values.length) + n;
        this.values = new long[n2][];
        this.reset();
    }

    private void removeItemsImpl(int n) {
        this.values = new long[this.values.length - n][];
        this.reset();
    }

    public int getTimestampsCount() {
        return this.valuesCount;
    }

    public long getTimestamp(int n) {
        return this.timestamps[n];
    }

    private void updateStorage() {
        block3: {
            block2: {
                if (this.timestamps != null) break block2;
                this.timestamps = new long[this.bufferStep];
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = new long[this.bufferStep];
                }
                break block3;
            }
            if (this.valuesCount != this.timestamps.length) break block3;
            this.timestamps = TimelineModel.extendArray(this.timestamps, this.bufferStep);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = TimelineModel.extendArray(this.values[i], this.bufferStep);
            }
        }
    }

    private static long[] extendArray(long[] lArray, int n) {
        int n2 = lArray.length;
        long[] lArray2 = new long[n2 + n];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }
}

