/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;

public final class RepositoryData {
    public static final long EMPTY_REPO_GEN = -1L;
    public static final long UNKNOWN_REPO_GEN = -2L;
    public static final long CORRUPTED_REPO_GEN = -3L;
    public static final RepositoryData EMPTY = new RepositoryData(-1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), ShardGenerations.EMPTY);
    private final long genId;
    private final Map<String, SnapshotId> snapshotIds;
    private final Map<String, SnapshotState> snapshotStates;
    private final Map<String, IndexId> indices;
    private final Map<IndexId, Set<SnapshotId>> indexSnapshots;
    private final Map<String, Version> snapshotVersions;
    private final ShardGenerations shardGenerations;
    private static final String SHARD_GENERATIONS = "shard_generations";
    private static final String SNAPSHOTS = "snapshots";
    private static final String INDICES = "indices";
    private static final String INDEX_ID = "id";
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private static final String STATE = "state";
    private static final String VERSION = "version";
    private static final String MIN_VERSION = "min_version";

    public RepositoryData(long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotState> snapshotStates, Map<String, Version> snapshotVersions, Map<IndexId, Set<SnapshotId>> indexSnapshots, ShardGenerations shardGenerations) {
        this.genId = genId;
        this.snapshotIds = Collections.unmodifiableMap(snapshotIds);
        this.snapshotStates = Collections.unmodifiableMap(snapshotStates);
        this.indices = Collections.unmodifiableMap(indexSnapshots.keySet().stream().collect(Collectors.toMap(IndexId::getName, Function.identity())));
        this.indexSnapshots = Collections.unmodifiableMap(indexSnapshots);
        this.shardGenerations = Objects.requireNonNull(shardGenerations);
        this.snapshotVersions = snapshotVersions;
        assert (this.indices.values().containsAll(shardGenerations.indices())) : "ShardGenerations contained indices " + shardGenerations.indices() + " but snapshots only reference indices " + this.indices.values();
    }

    protected RepositoryData copy() {
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indexSnapshots, this.shardGenerations);
    }

    public RepositoryData withVersions(Map<SnapshotId, Version> versions) {
        if (versions.isEmpty()) {
            return this;
        }
        HashMap<String, Version> newVersions = new HashMap<String, Version>(this.snapshotVersions);
        versions.forEach((id, version) -> newVersions.put(id.getUUID(), (Version)version));
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, newVersions, this.indexSnapshots, this.shardGenerations);
    }

    public ShardGenerations shardGenerations() {
        return this.shardGenerations;
    }

    public long getGenId() {
        return this.genId;
    }

    public Collection<SnapshotId> getSnapshotIds() {
        return Collections.unmodifiableCollection(this.snapshotIds.values());
    }

    @Nullable
    public SnapshotState getSnapshotState(SnapshotId snapshotId) {
        return this.snapshotStates.get(snapshotId.getUUID());
    }

    @Nullable
    public Version getVersion(SnapshotId snapshotId) {
        return this.snapshotVersions.get(snapshotId.getUUID());
    }

    public Map<String, IndexId> getIndices() {
        return this.indices;
    }

    public List<IndexId> indicesToUpdateAfterRemovingSnapshot(SnapshotId snapshotId) {
        return this.indexSnapshots.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1 && ((Set)entry.getValue()).contains(snapshotId)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public RepositoryData addSnapshot(SnapshotId snapshotId, SnapshotState snapshotState, Version version, ShardGenerations shardGenerations) {
        if (this.snapshotIds.containsKey(snapshotId.getUUID())) {
            return this;
        }
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>(this.snapshotIds);
        snapshots.put(snapshotId.getUUID(), snapshotId);
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        newSnapshotStates.put(snapshotId.getUUID(), snapshotState);
        HashMap<String, Version> newSnapshotVersions = new HashMap<String, Version>(this.snapshotVersions);
        newSnapshotVersions.put(snapshotId.getUUID(), version);
        HashMap<IndexId, Set<SnapshotId>> allIndexSnapshots = new HashMap<IndexId, Set<SnapshotId>>(this.indexSnapshots);
        for (IndexId indexId : shardGenerations.indices()) {
            allIndexSnapshots.computeIfAbsent(indexId, k -> new LinkedHashSet()).add(snapshotId);
        }
        return new RepositoryData(this.genId, snapshots, newSnapshotStates, newSnapshotVersions, allIndexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(shardGenerations).build());
    }

    public RepositoryData withGenId(long newGeneration) {
        if (newGeneration == this.genId) {
            return this;
        }
        return new RepositoryData(newGeneration, this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indexSnapshots, this.shardGenerations);
    }

    public RepositoryData removeSnapshot(SnapshotId snapshotId, ShardGenerations updatedShardGenerations) {
        Map<String, SnapshotId> newSnapshotIds = this.snapshotIds.values().stream().filter(id -> !snapshotId.equals(id)).collect(Collectors.toMap(SnapshotId::getUUID, Function.identity()));
        if (newSnapshotIds.size() == this.snapshotIds.size()) {
            throw new ResourceNotFoundException("Attempting to remove non-existent snapshot [{}] from repository data", snapshotId);
        }
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        newSnapshotStates.remove(snapshotId.getUUID());
        HashMap<String, Version> newSnapshotVersions = new HashMap<String, Version>(this.snapshotVersions);
        newSnapshotVersions.remove(snapshotId.getUUID());
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>();
        for (IndexId indexId : this.indices.values()) {
            Set<SnapshotId> set;
            Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            if (snapshotIds.contains(snapshotId)) {
                if (snapshotIds.size() == 1) continue;
                set = new LinkedHashSet<SnapshotId>(snapshotIds);
                set.remove(snapshotId);
            } else {
                set = snapshotIds;
            }
            indexSnapshots.put(indexId, set);
        }
        return new RepositoryData(this.genId, newSnapshotIds, newSnapshotStates, newSnapshotVersions, indexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(updatedShardGenerations).retainIndicesAndPruneDeletes(indexSnapshots.keySet()).build());
    }

    public Set<SnapshotId> getSnapshots(IndexId indexId) {
        Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
        if (snapshotIds == null) {
            throw new IllegalArgumentException("unknown snapshot index " + indexId);
        }
        return snapshotIds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryData that = (RepositoryData)obj;
        return this.snapshotIds.equals(that.snapshotIds) && this.snapshotStates.equals(that.snapshotStates) && this.snapshotVersions.equals(that.snapshotVersions) && this.indices.equals(that.indices) && this.indexSnapshots.equals(that.indexSnapshots) && this.shardGenerations.equals(that.shardGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indices, this.indexSnapshots, this.shardGenerations);
    }

    public IndexId resolveIndexId(String indexName) {
        return Objects.requireNonNull(this.indices.get(indexName), () -> "Tried to resolve unknown index [" + indexName + "]");
    }

    public List<IndexId> resolveIndices(List<String> indices) {
        ArrayList<IndexId> resolvedIndices = new ArrayList<IndexId>(indices.size());
        for (String indexName : indices) {
            resolvedIndices.add(this.resolveIndexId(indexName));
        }
        return resolvedIndices;
    }

    public List<IndexId> resolveNewIndices(List<String> indicesToResolve) {
        ArrayList<IndexId> snapshotIndices = new ArrayList<IndexId>();
        for (String index : indicesToResolve) {
            IndexId indexId = this.indices.containsKey(index) ? this.indices.get(index) : new IndexId(index, UUIDs.randomBase64UUID());
            snapshotIndices.add(indexId);
        }
        return snapshotIndices;
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, boolean shouldWriteShardGens) throws IOException {
        builder.startObject();
        builder.startArray(SNAPSHOTS);
        for (SnapshotId snapshot : this.getSnapshotIds()) {
            builder.startObject();
            builder.field(NAME, snapshot.getName());
            builder.field(UUID, snapshot.getUUID());
            if (this.snapshotStates.containsKey(snapshot.getUUID())) {
                builder.field(STATE, this.snapshotStates.get(snapshot.getUUID()).value());
            }
            if (this.snapshotVersions.containsKey(snapshot.getUUID())) {
                builder.field(VERSION, this.snapshotVersions.get(snapshot.getUUID()).toString());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.startObject(INDICES);
        for (IndexId indexId : this.getIndices().values()) {
            builder.startObject(indexId.getName());
            builder.field(INDEX_ID, indexId.getId());
            builder.startArray(SNAPSHOTS);
            Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            for (SnapshotId snapshotId : snapshotIds) {
                builder.value(snapshotId.getUUID());
            }
            builder.endArray();
            if (shouldWriteShardGens) {
                builder.startArray(SHARD_GENERATIONS);
                for (String gen : this.shardGenerations.getGens(indexId)) {
                    builder.value(gen);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        if (shouldWriteShardGens) {
            builder.field(MIN_VERSION, SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION.toString());
        }
        builder.endObject();
        return builder;
    }

    public static RepositoryData snapshotsFromXContent(XContentParser parser, long genId) throws IOException {
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotState> snapshotStates = new HashMap<String, SnapshotState>();
        HashMap<String, Version> snapshotVersions = new HashMap<String, Version>();
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>();
        ShardGenerations.Builder shardGenerations = ShardGenerations.builder();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String field = parser.currentName();
                if (SNAPSHOTS.equals(field)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            String name = null;
                            String uuid = null;
                            SnapshotState state = null;
                            Version version = null;
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                String currentFieldName = parser.currentName();
                                parser.nextToken();
                                if (NAME.equals(currentFieldName)) {
                                    name = parser.text();
                                    continue;
                                }
                                if (UUID.equals(currentFieldName)) {
                                    uuid = parser.text();
                                    continue;
                                }
                                if (STATE.equals(currentFieldName)) {
                                    state = SnapshotState.fromValue(parser.numberValue().byteValue());
                                    continue;
                                }
                                if (!VERSION.equals(currentFieldName)) continue;
                                version = Version.fromString(parser.text());
                            }
                            SnapshotId snapshotId = new SnapshotId(name, uuid);
                            if (state != null) {
                                snapshotStates.put(uuid, state);
                            }
                            if (version != null) {
                                snapshotVersions.put(uuid, version);
                            }
                            snapshots.put(snapshotId.getUUID(), snapshotId);
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("expected array for [" + field + "]", new Object[0]);
                }
                if (INDICES.equals(field)) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("start object expected [indices]", new Object[0]);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String indexName = parser.currentName();
                        LinkedHashSet<SnapshotId> snapshotIds = new LinkedHashSet<SnapshotId>();
                        ArrayList<String> gens = new ArrayList<String>();
                        IndexId indexId = null;
                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("start object expected index[" + indexName + "]", new Object[0]);
                        }
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String indexMetaFieldName = parser.currentName();
                            parser.nextToken();
                            if (INDEX_ID.equals(indexMetaFieldName)) {
                                indexId = new IndexId(indexName, parser.text());
                                continue;
                            }
                            if (SNAPSHOTS.equals(indexMetaFieldName)) {
                                if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                                    throw new ElasticsearchParseException("start array expected [snapshots]", new Object[0]);
                                }
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    SnapshotId snapshotId;
                                    String uuid = null;
                                    if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                            String currentFieldName = parser.currentName();
                                            parser.nextToken();
                                            if (!UUID.equals(currentFieldName)) continue;
                                            uuid = parser.text();
                                        }
                                    } else {
                                        uuid = parser.text();
                                    }
                                    if ((snapshotId = (SnapshotId)snapshots.get(uuid)) != null) {
                                        snapshotIds.add(snapshotId);
                                        continue;
                                    }
                                    throw new ElasticsearchParseException("Detected a corrupted repository, index " + indexId + " references an unknown snapshot uuid [" + uuid + "]", new Object[0]);
                                }
                                continue;
                            }
                            if (!SHARD_GENERATIONS.equals(indexMetaFieldName)) continue;
                            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                gens.add(parser.textOrNull());
                            }
                        }
                        assert (indexId != null);
                        indexSnapshots.put(indexId, snapshotIds);
                        for (int i = 0; i < gens.size(); ++i) {
                            shardGenerations.put(indexId, i, (String)gens.get(i));
                        }
                    }
                    continue;
                }
                if (MIN_VERSION.equals(field)) {
                    if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("version string expected [min_version]", new Object[0]);
                    }
                    Version version = Version.fromString(parser.text());
                    assert (version.onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION));
                    continue;
                }
                throw new ElasticsearchParseException("unknown field name  [" + field + "]", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("start object expected", new Object[0]);
        }
        return new RepositoryData(genId, snapshots, snapshotStates, snapshotVersions, indexSnapshots, shardGenerations.build());
    }
}

