#ifndef _EFL_CANVAS_GESTURE_MANAGER_EO_H_
#define _EFL_CANVAS_GESTURE_MANAGER_EO_H_

#ifndef _EFL_CANVAS_GESTURE_MANAGER_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_MANAGER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture_Manager;

#endif

#ifndef _EFL_CANVAS_GESTURE_MANAGER_EO_TYPES
#define _EFL_CANVAS_GESTURE_MANAGER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief This class keeps track of active @ref Efl_Canvas_Gesture_Recognizer
 * objects. For internal use only.
 *
 * This gesture class defines methods that register and unregister a recognizer
 * and get a recognizer according to gesture event type.
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
#define EFL_CANVAS_GESTURE_MANAGER_CLASS efl_canvas_gesture_manager_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_manager_class_get(void);

/**
 * @brief Registers a new @ref Efl_Canvas_Gesture_Recognizer.
 *
 * @param[in] obj The object.
 * @param[in] recognizer The gesture recognizer object.
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI void efl_gesture_manager_recognizer_register(Eo *obj, Efl_Canvas_Gesture_Recognizer *recognizer);

/**
 * @brief Unregisters an existing @ref Efl_Canvas_Gesture_Recognizer.
 *
 * @param[in] obj The object.
 * @param[in] recognizer The gesture recognizer object.
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI void efl_gesture_manager_recognizer_unregister(Eo *obj, Efl_Canvas_Gesture_Recognizer *recognizer);

/**
 * @brief Returns the event recognizer object associated with the given
 * @c gesture_type.
 *
 * @param[in] obj The object.
 * @param[in] gesture_type The gesture event type.
 *
 * @return The gesture recognizer.
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI const Efl_Canvas_Gesture_Recognizer *efl_gesture_manager_recognizer_get(Eo *obj, Efl_Canvas_Gesture_Recognizer_Type gesture_type);

/**
 * @brief This property holds configuration values for the recognizer.
 *
 * @param[in] obj The object.
 * @param[in] name Property name.
 * @param[in] value Value of the property.
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI void efl_gesture_manager_config_set(Eo *obj, const char *name, Eina_Value *value);

/**
 * @brief This property holds configuration values for the recognizer.
 *
 * @param[in] obj The object.
 * @param[in] name Property name.
 *
 * @return Value of the property.
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI Eina_Value *efl_gesture_manager_config_get(const Eo *obj, const char *name);
#endif /* EFL_BETA_API_SUPPORT */

#endif
