/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.AbstractHDRPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentileRanks;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

class HDRPercentileRanksAggregator
extends AbstractHDRPercentilesAggregator {
    HDRPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat format, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, format, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalHDRPercentileRanks.percentileRank(state, Double.valueOf(name));
    }
}

