/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class ShardSearchRequest
extends TransportRequest
implements IndicesRequest {
    private final String clusterAlias;
    private final ShardId shardId;
    private final int numberOfShards;
    private final SearchType searchType;
    private final Scroll scroll;
    private final String[] types;
    private final float indexBoost;
    private final Boolean requestCache;
    private final long nowInMillis;
    private final boolean allowPartialSearchResults;
    private final String[] indexRoutings;
    private final String preference;
    private final OriginalIndices originalIndices;
    private AliasFilter aliasFilter;
    private SearchSourceBuilder source;

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, String[] indexRoutings) {
        this(originalIndices, shardId, numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.types(), searchRequest.requestCache(), aliasFilter, indexBoost, searchRequest.allowPartialSearchResults(), indexRoutings, searchRequest.preference(), searchRequest.scroll(), nowInMillis, clusterAlias);
        assert (searchRequest.allowPartialSearchResults() != null);
    }

    public ShardSearchRequest(ShardId shardId, String[] types, long nowInMillis, AliasFilter aliasFilter) {
        this(OriginalIndices.NONE, shardId, -1, null, null, types, null, aliasFilter, 1.0f, false, Strings.EMPTY_ARRAY, null, null, nowInMillis, null);
    }

    private ShardSearchRequest(OriginalIndices originalIndices, ShardId shardId, int numberOfShards, SearchType searchType, SearchSourceBuilder source, String[] types, Boolean requestCache, AliasFilter aliasFilter, float indexBoost, boolean allowPartialSearchResults, String[] indexRoutings, String preference, Scroll scroll, long nowInMillis, @Nullable String clusterAlias) {
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source = source;
        this.types = types;
        this.requestCache = requestCache;
        this.aliasFilter = aliasFilter;
        this.indexBoost = indexBoost;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.indexRoutings = indexRoutings;
        this.preference = preference;
        this.scroll = scroll;
        this.nowInMillis = nowInMillis;
        this.clusterAlias = clusterAlias;
        this.originalIndices = originalIndices;
    }

    public ShardSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.types = in.readStringArray();
        this.aliasFilter = new AliasFilter(in);
        this.indexBoost = in.readFloat();
        this.nowInMillis = in.readVLong();
        this.requestCache = in.readOptionalBoolean();
        this.clusterAlias = in.readOptionalString();
        this.allowPartialSearchResults = in.getVersion().onOrAfter(Version.V_7_0_0) ? in.readBoolean() : (in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readOptionalBoolean() : false);
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.indexRoutings = in.readStringArray();
            this.preference = in.readOptionalString();
        } else {
            this.indexRoutings = Strings.EMPTY_ARRAY;
            this.preference = null;
        }
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    protected final void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        this.shardId.writeTo(out);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.numberOfShards);
        }
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        out.writeStringArray(this.types);
        this.aliasFilter.writeTo(out);
        out.writeFloat(this.indexBoost);
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeOptionalBoolean(this.requestCache);
        out.writeOptionalString(this.clusterAlias);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeBoolean(this.allowPartialSearchResults);
        } else if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalBoolean(this.allowPartialSearchResults);
        }
        if (!asKey && out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeStringArray(this.indexRoutings);
            out.writeOptionalString(this.preference);
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String[] types() {
        return this.types;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public AliasFilter getAliasFilter() {
        return this.aliasFilter;
    }

    public void setAliasFilter(AliasFilter aliasFilter) {
        this.aliasFilter = aliasFilter;
    }

    public void source(SearchSourceBuilder source) {
        this.source = source;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public float indexBoost() {
        return this.indexBoost;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public String[] indexRoutings() {
        return this.indexRoutings;
    }

    public String preference() {
        return this.preference;
    }

    public BytesReference cacheKey() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        this.innerWriteTo(out, true);
        return new BytesArray(out.bytes().toBytesRef(), true);
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardId[" + this.shardId() + "]";
    }

    public Rewriteable<Rewriteable> getRewriteable() {
        return new RequestRewritable(this);
    }

    public static QueryBuilder parseAliasFilter(CheckedFunction<byte[], QueryBuilder, IOException> filterParser, IndexMetaData metaData, String ... aliasNames) {
        if (aliasNames == null || aliasNames.length == 0) {
            return null;
        }
        Index index = metaData.getIndex();
        ImmutableOpenMap<String, AliasMetaData> aliases = metaData.getAliases();
        Function<AliasMetaData, QueryBuilder> parserFunction = alias -> {
            if (alias.filter() == null) {
                return null;
            }
            try {
                return (QueryBuilder)filterParser.apply((Object)alias.filter().uncompressed());
            }
            catch (IOException ex) {
                throw new AliasFilterParsingException(index, alias.getAlias(), "Invalid alias filter", ex);
            }
        };
        if (aliasNames.length == 1) {
            AliasMetaData alias2 = aliases.get(aliasNames[0]);
            if (alias2 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            return parserFunction.apply(alias2);
        }
        BoolQueryBuilder combined = new BoolQueryBuilder();
        for (String aliasName : aliasNames) {
            AliasMetaData alias3 = aliases.get(aliasName);
            if (alias3 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            QueryBuilder parsedFilter = parserFunction.apply(alias3);
            if (parsedFilter == null) {
                return null;
            }
            combined.should(parsedFilter);
        }
        return combined;
    }

    static class RequestRewritable
    implements Rewriteable<Rewriteable> {
        final ShardSearchRequest request;

        RequestRewritable(ShardSearchRequest request) {
            this.request = request;
        }

        @Override
        public Rewriteable rewrite(QueryRewriteContext ctx) throws IOException {
            SearchSourceBuilder newSource = this.request.source() == null ? null : Rewriteable.rewrite(this.request.source(), ctx);
            AliasFilter newAliasFilter = Rewriteable.rewrite(this.request.getAliasFilter(), ctx);
            if (newSource == this.request.source() && newAliasFilter == this.request.getAliasFilter()) {
                return this;
            }
            this.request.source(newSource);
            this.request.setAliasFilter(newAliasFilter);
            return new RequestRewritable(this.request);
        }
    }
}

