/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;

public class PSubNullSafeCallInvoke
extends AExpression {
    private AExpression guarded;

    public PSubNullSafeCallInvoke(Location location, AExpression guarded) {
        super(location);
        this.guarded = Objects.requireNonNull(guarded);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.guarded.analyze(scriptRoot, locals);
        this.actual = this.guarded.actual;
        if (this.actual.isPrimitive()) {
            throw new IllegalArgumentException("Result of null safe operator must be nullable");
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        Label end = new Label();
        methodWriter.dup();
        methodWriter.ifNull(end);
        this.guarded.write(classWriter, methodWriter, globals);
        methodWriter.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.guarded);
    }
}

