/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.wizard.AbstractWizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportLocationOptionsPanel;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class SelectImportLocationPage
extends AbstractWizardPanel {
    public static final String ID = "SelectImportLocationPage";
    private Box mainBox;
    private Collection<ImportLocationOptionsPanel> optionsPanels = new ArrayList<ImportLocationOptionsPanel>();
    private Object backPanelDescriptor;

    public SelectImportLocationPage(OWLEditorKit owlEditorKit) {
        super((Object)ID, "Select URI In Import Statement", (EditorKit)owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("Please choose a value for the imported location:");
        parent.setLayout(new BorderLayout());
        this.mainBox = new Box(1);
        parent.add((Component)this.mainBox, "Center");
    }

    public void aboutToDisplayPanel() {
        this.mainBox.removeAll();
        this.optionsPanels.clear();
        Set<ImportInfo> parameters = ((OntologyImportWizard)this.getWizard()).getImports();
        for (ImportInfo parameter : parameters) {
            OWLOntologyID id = parameter.getOntologyID();
            if (id == null) continue;
            ImportLocationOptionsPanel optionsPanel = new ImportLocationOptionsPanel(parameter);
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Physical Location: " + parameter.getPhysicalLocation().toString());
            optionsPanel.setBorder(titledBorder);
            this.mainBox.add(optionsPanel);
            this.optionsPanels.add(optionsPanel);
        }
    }

    public void displayingPanel() {
        if (this.optionsPanels.size() == 0) {
            this.getWizard().setCurrentPanel(this.getNextPanelDescriptor());
        }
    }

    public void aboutToHidePanel() {
        for (ImportLocationOptionsPanel optionsPanel : this.optionsPanels) {
            optionsPanel.setImportLocation();
        }
    }

    public void setBackPanelDescriptor(Object backPanelDescriptor) {
        this.backPanelDescriptor = backPanelDescriptor;
    }

    public Object getBackPanelDescriptor() {
        return this.backPanelDescriptor;
    }

    public Object getNextPanelDescriptor() {
        return "ImportConfirmationPage";
    }
}

