/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.transfer;

import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import org.protege.editor.owl.ui.table.OWLObjectDropTargetListener;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.tree.OWLTreePreferences;

public class OWLObjectTreeDropTargetListener
extends OWLObjectDropTargetListener {
    private final OWLObjectTree tree;
    private final OWLTreePreferences treePreferences;

    public OWLObjectTreeDropTargetListener(OWLObjectTree component, OWLTreePreferences treePreferences) {
        super(component);
        this.tree = component;
        this.treePreferences = treePreferences;
    }

    @Override
    protected boolean isDragAcceptable(DropTargetDragEvent event) {
        int row = this.tree.getRowForLocation(event.getLocation().x, event.getLocation().y);
        if (row == -1) {
            return false;
        }
        Rectangle r = this.tree.getRowBounds(row);
        if (!r.contains(event.getLocation())) {
            this.tree.setDropRow(-1);
            return false;
        }
        boolean isAcceptable = super.isDragAcceptable(event);
        if (isAcceptable) {
            this.tree.setDropRow(row);
        }
        return isAcceptable;
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        super.dragExit(dte);
        this.tree.setDropRow(-1);
    }

    @Override
    protected boolean isDropAcceptable(DropTargetDropEvent event) {
        return this.treePreferences.isTreeDragAndDropEnabled() && super.isDropAcceptable(event);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        super.drop(dtde);
        this.tree.setDropRow(-1);
    }
}

