"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const ShUtil = require("./util/sh");
// https://www.gnu.org/software/bash/manual/html_node/Reserved-Word-Index.html
exports.LIST = [
    '!',
    '[[',
    ']]',
    '{',
    '}',
    'case',
    'do',
    'done',
    'elif',
    'else',
    'esac',
    'fi',
    'for',
    'function',
    'if',
    'in',
    'select',
    'then',
    'time',
    'until',
    'while',
];
const SET = new Set(exports.LIST);
function isReservedWord(word) {
    return SET.has(word);
}
exports.isReservedWord = isReservedWord;
function documentation(reservedWord) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const doc = yield ShUtil.execShellScript(`help ${reservedWord}`);
            return doc || '';
        }
        catch (error) {
            return '';
        }
    });
}
exports.documentation = documentation;
//# sourceMappingURL=reservedWords.js.map