// Copyright 2011 The Emscripten Authors.  All rights reserved.
// Emscripten is available under two separate licenses, the MIT license and the
// University of Illinois/NCSA Open Source License.  Both these licenses can be
// found in the LICENSE file.

/**
 Bitmaps for all GLUI images.
 
 These were converted from original PPM images 
 (mostly lost) with the tools/ppm2array program.
 
 The images here are extracted in typical OpenGL
 bottom-to-top fashion.
 
 FIXME: don't use greyscale brightness here--this prevents
 people changing the background color.  Instead, use a code
 indicating the underlying purpose of the pixel:
 	0 = shadows; outlines; UI elements (check boxes, arrows)
	64 = disabled shadows and UI elements
	128 = shadowing, disabled
	192 = disabled white; background
	255 = highlights; checkbox/radio background
 
 I'm thinking the way to do this would be to have an
enum {
  BG = 0, // Background shines through-- totally alpha transparent
  BS, // Background of scrollbar/spin box-- opaque gray
  SB, // Shadowed-black element-- strong alpha blend to black
  SD, // Shadowed-dark element-- weak alpha blend to black
  HL, // Highlight-light-- weak alpha blend to white
  HW, // Highlight-white-- strong alpha blend to white
  UB, // User-interface black-- arrows, checkboxes, radio buttons
  UW, // User-interface white-- backgrounds of checkboxes and radio buttons
};
 
 Orion Sky Lawlor, olawlor@acm.org, 2006/05/04 (LGPL)
*/

/*----------------------- checkboxes --------------------------*/
unsigned char glui_img_checkbox_0[] = {  13, 13,  /* width, height */
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 255,
};


unsigned char glui_img_checkbox_0_dis[] = {  13, 13,  /* width, height */
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64, 192, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 255,
};


unsigned char glui_img_checkbox_1[] = {  13, 13,  /* width, height */
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 192, 255, 128,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 192, 255, 128,   0, 255,   0,   0,   0,   0,   0, 255, 255, 255, 192, 255, 128,   0, 255,   0,   0, 255,   0,   0,   0, 255, 255, 192, 255, 128,   0, 255,   0, 255, 255, 255,   0,   0,   0, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 192, 255, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 255,
};


unsigned char glui_img_checkbox_1_dis[] = {  13, 13,  /* width, height */
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192, 192,  64, 192, 192, 192, 192, 192, 192, 255, 128,  64, 192, 192,  64,  64,  64, 192, 192, 192, 192, 192, 255, 128,  64, 192,  64,  64,  64,  64,  64, 192, 192, 192, 192, 255, 128,  64, 192,  64,  64, 192,  64,  64,  64, 192, 192, 192, 255, 128,  64, 192,  64, 192, 192, 192,  64,  64,  64, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192,  64,  64, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192,  64, 192, 192, 255, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 128,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64, 192, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 255,
};


/*------------------------------- arrows -------------------------------------*/
unsigned char glui_img_downarrow[] = {  16, 16,  /* width, height */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192,   0, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192,   0,   0,   0,   0,   0, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192,   0,   0,   0,   0,   0,   0,   0, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128,   0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,   0,
};


unsigned char glui_img_leftarrow[] = {  16, 16,  /* width, height */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192,   0,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128,   0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,   0,
};

unsigned char glui_img_rightarrow[] = {  16, 16,  /* width, height */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0,   0, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128,   0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,   0,
};

unsigned char glui_img_uparrow[] = {  16, 16,  /* width, height */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192,   0,   0,   0,   0,   0,   0,   0, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192,   0,   0,   0,   0,   0, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192,   0,   0,   0, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192,   0, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128,   0, 192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128,   0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,   0,
};

/*------------------ listboxes ---------------------*/
unsigned char glui_img_listbox_down[] = {  11, 17,  /* width, height */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 127, 191, 191, 191, 127,   0, 127, 191, 191, 191, 127, 127, 127, 191, 191, 127,   0, 127, 191, 191, 127, 127, 127, 127, 127, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,   0,
};


unsigned char glui_img_listbox_up[] = {  11, 17,  /* width, height */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 191, 127, 127, 127, 127, 127, 127, 127, 127, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191,   0, 191, 191, 191, 127,   0, 191, 255, 191, 191,   0,   0,   0, 191, 191, 127,   0, 191, 255, 191,   0,   0,   0,   0,   0, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127,   0, 191, 255, 255, 255, 255, 255, 255, 255, 255, 127,   0, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191,   0,
};

unsigned char glui_img_listbox_up_dis[] = {  11, 17,  /* width, height */
127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 191, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 254, 191, 191, 191, 127, 127, 191, 255, 191, 191, 127, 127, 254, 191, 191, 127, 127, 191, 255, 191, 127, 127, 127, 127, 254, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 191, 191, 191, 191, 191, 191, 191, 127, 127, 191, 255, 255, 255, 255, 255, 255, 255, 255, 127, 127, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,
};

/*--------------------------- radio buttons -------------------------*/
unsigned char glui_img_radiobutton_0[] = {  14, 14,  /* width, height */
192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 255, 255, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 192, 128, 192, 192, 255, 255, 255, 255, 192, 192, 255, 192, 192, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 192, 192, 128,   0,   0, 255, 255, 255, 255,   0,   0, 255, 192, 192, 192, 192, 192, 128, 128,   0,   0,   0,   0, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 128, 128, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
};


unsigned char glui_img_radiobutton_0_dis[] = {  14, 14,  /* width, height */
192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 255, 255, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 192, 128, 192, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 192, 128,  64,  64, 192, 192, 192, 192,  64,  64, 255, 192, 192, 192, 192, 192, 128, 128,  64,  64,  64,  64, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 128, 128, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
};


unsigned char glui_img_radiobutton_1[] = {  14, 14,  /* width, height */
192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 255, 255, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 192, 128, 192, 192, 255, 255, 255, 255, 192, 192, 255, 192, 192, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 192, 128,   0, 255, 255, 255,   0,   0, 255, 255, 255, 192, 255, 192, 192, 128,   0, 255, 255,   0,   0,   0,   0, 255, 255, 192, 255, 192, 192, 128,   0, 255, 255,   0,   0,   0,   0, 255, 255, 192, 255, 192, 192, 128,   0, 255, 255, 255,   0,   0, 255, 255, 255, 192, 255, 192, 192, 192, 128,   0, 255, 255, 255, 255, 255, 255, 192, 255, 192, 192, 192, 192, 128,   0,   0, 255, 255, 255, 255,   0,   0, 255, 192, 192, 192, 192, 192, 128, 128,   0,   0,   0,   0, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 128, 128, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
};


unsigned char glui_img_radiobutton_1_dis[] = {  14, 14,  /* width, height */
192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 255, 255, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 255, 255, 192, 192, 192, 192, 192, 128, 192, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 128,  64, 192, 192, 192,  64,  64, 192, 192, 192, 192, 255, 192, 192, 128,  64, 192, 192,  64,  64,  64,  64, 192, 192, 192, 255, 192, 192, 128,  64, 192, 192,  64,  64,  64,  64, 192, 192, 192, 255, 192, 192, 128,  64, 192, 192, 192,  64,  64, 192, 192, 192, 192, 255, 192, 192, 192, 128,  64, 192, 192, 192, 192, 192, 192, 192, 255, 192, 192, 192, 192, 128,  64,  64, 192, 192, 192, 192,  64,  64, 255, 192, 192, 192, 192, 192, 128, 128,  64,  64,  64,  64, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 128, 128, 128, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
};



/*----------------- spinners ----------------------------*/
unsigned char glui_img_spindown_0[] = {  12, 8,  /* width, height */
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,   0, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 255, 191, 191, 191, 191,   0, 127, 191, 191, 191, 127,   0, 255, 191, 191, 191,   0,   0,   0, 127, 191, 191, 127,   0, 255, 191, 191,   0,   0,   0,   0,   0, 127, 191, 127,   0, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,
};


unsigned char   glui_img_spindown_1[] = {  12, 8,  /* width, height */
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 191, 255,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 191, 255,   0, 127, 191, 191, 191, 127,   0, 191, 191, 191, 191, 255,   0, 127, 191, 191, 127,   0,   0,   0, 191, 191, 191, 255,   0, 127, 191, 127,   0,   0,   0,   0,   0, 191, 191, 255,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 191, 255,   0, 127, 127, 127, 127, 127, 127, 127, 127, 127, 191, 255,
};


unsigned char glui_img_spindown_dis[] = {  12, 8,  /* width, height */
255,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64, 255, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,  64, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,  64, 255, 191, 191, 191, 191, 127, 255, 191, 191, 191, 127,  64, 255, 191, 191, 191, 127, 127, 127, 255, 191, 191, 127,  64, 255, 191, 191, 127, 127, 127, 127, 127, 255, 191, 127,  64, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,  64, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  64,
};


unsigned char glui_img_spinup_0[] = {  12, 8,  /* width, height */
255, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,   0, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 255, 191, 191,   0,   0,   0,   0,   0, 127, 191, 127,   0, 255, 191, 191, 191,   0,   0,   0, 127, 191, 191, 127,   0, 255, 191, 191, 191, 191,   0, 127, 191, 191, 191, 127,   0, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,   0, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};


unsigned char glui_img_spinup_1[] = {  12, 8,  /* width, height */
  0, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 191, 255,   0, 127, 191, 127,   0,   0,   0,   0,   0, 191, 191, 255,   0, 127, 191, 191, 127,   0,   0,   0, 191, 191, 191, 255,   0, 127, 191, 191, 191, 127,   0, 191, 191, 191, 191, 255,   0, 127, 191, 191, 191, 191, 191, 191, 191, 191, 191, 255,   0, 127, 127, 127, 127, 127, 127, 127, 127, 127, 191, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,
};


unsigned char glui_img_spinup_dis[] = {  12, 8,  /* width, height */
255, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,  64, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,  64, 255, 191, 191, 127, 127, 127, 127, 127, 255, 191, 127,  64, 255, 191, 191, 191, 127, 127, 127, 255, 191, 191, 127,  64, 255, 191, 191, 191, 191, 127, 255, 191, 191, 191, 127,  64, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 127,  64, 255, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191,  64, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};

