/*
 * Copyright 2011 The Emscripten Authors.  All rights reserved.
 * Emscripten is available under two separate licenses, the MIT license and the
 * University of Illinois/NCSA Open Source License.  Both these licenses can be
 * found in the LICENSE file.
 */

typedef struct
{
  char *op;
  char *description;
} OperatorMapping;

OperatorMapping op_mapping[] = {
  { "b", "Close, fill, and stroke path using nonzero winding number rule" },
  { "B", "Fill and stroke path using nonzero winding number rule" },
  { "b*", "Close, fill, and stroke path using even-odd rule" },
  { "B*", "Fill and stroke path using even-odd rule" },
  { "BDC", "(PDF 1.2) Begin marked-content sequence with property list" },
  { "BI", "Begin inline image object" },
  { "BMC", "(PDF 1.2) Begin marked-content sequence" },
  { "BT", "Begin text object" },
  { "BX", "(PDF 1.1) Begin compatibility section" },
  { "c", "Append curved segment to path (three control points)" },
  { "cm", "Concatenate matrix to current transformation matrix" },
  { "CS", "(PDF 1.1) Set color space for stroking operations" },
  { "cs", "(PDF 1.1) Set color space for nonstroking operations" },
  { "d", "Set line dash pattern" },
  { "d0", "Set glyph width in Type 3 font" },
  { "d1", "Set glyph width and bounding box in Type 3 font" },
  { "Do", "Invoke named XObject" },
  { "DP", "(PDF 1.2) Define marked-content point with property list" },
  { "EI", "End inline image object" },
  { "EMC", "(PDF 1.2) End marked-content sequence" },
  { "ET", "End text object" },
  { "EX", "(PDF 1.1) End compatibility section" },
  { "f", "Fill path using nonzero winding number rule" },
  { "F", "Fill path using nonzero winding number rule (obsolete)" },
  { "f*", "Fill path using even-odd rule" },
  { "G", "Set gray level for stroking operations" },
  { "g", "Set gray level for nonstroking operations" },
  { "gs", "(PDF 1.2) Set parameters from graphics state parameter dictionary" },
  { "h", "Close subpath" },
  { "i", "Set flatness tolerance" },
  { "ID", "Begin inline image data" },
  { "j", "Set line join style" },
  { "J", "Set line cap style" },
  { "K", "Set CMYK color for stroking operations" },
  { "k", "Set CMYK color for nonstroking operations" },
  { "l", "Append straight line segment to path" },
  { "m", "Begin new subpath" },
  { "M", "Set miter limit" },
  { "MP", "(PDF 1.2) Define marked-content point" },
  { "n", "End path without filling or stroking" },
  { "q", "Save graphics state" },
  { "Q", "Restore graphics state" },
  { "re", "Append rectangle to path" },
  { "RG", "Set RGB color for stroking operations" },
  { "rg", "Set RGB color for nonstroking operations" },
  { "ri", "Set color rendering intent" },
  { "s", "Close and stroke path" },
  { "S", "Stroke path" },
  { "SC", "(PDF 1.1) Set color for stroking operations" },
  { "sc", "(PDF 1.1) Set color for nonstroking operations" },
  { "SCN", "(PDF 1.2) Set color for stroking operations (ICCBased and special color spaces)" },
  { "scn", "(PDF 1.2) Set color for nonstroking operations (ICCBased and special color spaces)" },
  { "sh", "(PDF 1.3) Paint area defined by shading pattern" },
  { "T*", "Move to start of next text line" },
  { "Tc", "Set character spacing" },
  { "Td", "Move text position" },
  { "TD", "Move text position and set leading" },
  { "Tf", "Set text font and size" },
  { "Tj", "Show text" },
  { "TJ", "Show text, allowing individual glyph positioning" },
  { "TL", "Set text leading" },
  { "Tm", "Set text matrix and text line matrix" },
  { "Tr", "Set text rendering mode" },
  { "Ts", "Set text rise" },
  { "Tw", "Set word spacing" },
  { "Tz", "Set horizontal text scaling" },
  { "v", "Append curved segment to path (initial point replicated)" },
  { "w", "Set line width" },
  { "W", "Set clipping path using nonzero winding number rule" },
  { "W*", "Set clipping path using even-odd rule" },
  { "y", "Append curved segment to path (final point replicated)" },
  { "'", "Move to next line and show text" },
  { "\"", "Set word and character spacing, move to next line, and show text" },
};
