/**
 * SECTION:gender-details
 * @short_description: New general types required by Folks.
 *
 * Since: 0.3.1
 */
/**
 * FolksGender:
 * @FOLKS_GENDER_UNSPECIFIED: The gender of the contact is unknown or the contact didn&apos;t specify it.
 * @FOLKS_GENDER_MALE: The contact is male.
 * @FOLKS_GENDER_FEMALE: The contact is female.
 * 
 * The gender of a contact
 *
 * Since: 0.3.5
 */
/**
 * folks_gender_details_change_gender:
 * @self: the <link linkend="FolksGenderDetails"><type>FolksGenderDetails</type></link> instance
 * @gender: (in): &nbsp;.  <para>the contact&apos;s gender </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s gender.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> directly, as this method gives error notification and will only return once the gender has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the gender failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-gender-details-change-gender-finish"><function>folks_gender_details_change_gender_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_gender_details_change_gender_finish:
 * @self: the <link linkend="FolksGenderDetails"><type>FolksGenderDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s gender.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> directly, as this method gives error notification and will only return once the gender has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the gender failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-gender-details-change-gender"><function>folks_gender_details_change_gender()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksGenderDetails:gender:
 * 
 * The gender of the contact.
 *
 * Since: 0.3.5
 */
/**
 * folks_gender_details_get_gender:
 * @self: the <link linkend="FolksGenderDetails"><type>FolksGenderDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> property.
 * 
 * The gender of the contact.
 * 
 * Returns: the value of the <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_gender_details_set_gender:
 * @self: the <link linkend="FolksGenderDetails"><type>FolksGenderDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> property
 * 
 * Set the value of the <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> property to @value.
 * 
 * The gender of the contact.
 *
 * Since: 0.3.5
 */
/**
 * FolksGenderDetails:
 * 
 * Gender of a contact.
 * 
 * <para>This allows representation of the gender of a contact.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksGenderDetailsIface:
 * @change_gender: virtual method called by <link linkend="folks-gender-details-change-gender"><function>folks_gender_details_change_gender()</function></link>
 * @change_gender_finish: asynchronous finish function for <structfield>change_gender</structfield>, called by <link linkend="folks-gender-details-change-gender"><function>folks_gender_details_change_gender()</function></link>
 * @get_gender: getter method for the abstract property <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link>
 * @set_gender: setter method for the abstract property <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksGenderDetails"><type>FolksGenderDetails</type></link> implementations.
 */
