/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs.utils.discovery.UDPDiscoverySender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoverySenderThread
implements Runnable {
    private static final Log log = LogFactory.getLog(UDPDiscoverySenderThread.class);
    private final UDPDiscoveryAttributes attributes;
    private ArrayList<String> cacheNames = new ArrayList();

    protected void setCacheNames(ArrayList<String> cacheNames) {
        if (log.isInfoEnabled()) {
            log.info("Resetting cacheNames = [" + cacheNames + "]");
        }
        this.cacheNames = cacheNames;
    }

    protected ArrayList<String> getCacheNames() {
        return this.cacheNames;
    }

    public UDPDiscoverySenderThread(UDPDiscoveryAttributes attributes, ArrayList<String> cacheNames) {
        this.attributes = attributes;
        this.cacheNames = cacheNames;
        if (log.isDebugEnabled()) {
            log.debug("Creating sender thread for discoveryAddress = [" + attributes.getUdpDiscoveryAddr() + "] and discoveryPort = [" + attributes.getUdpDiscoveryPort() + "] myHostName = [" + attributes.getServiceAddress() + "] and port = [" + attributes.getServicePort() + "]");
        }
        try (UDPDiscoverySender sender = new UDPDiscoverySender(attributes.getUdpDiscoveryAddr(), attributes.getUdpDiscoveryPort());){
            sender.requestBroadcast();
            if (log.isDebugEnabled()) {
                log.debug("Sent a request broadcast to the group");
            }
        }
        catch (IOException e) {
            log.error("Problem sending a Request Broadcast", e);
        }
    }

    @Override
    public void run() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort());){
            sender.passiveBroadcast(this.attributes.getServiceAddress(), this.attributes.getServicePort(), this.cacheNames);
            if (log.isDebugEnabled()) {
                log.debug("Called sender to issue a passive broadcast");
            }
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender [" + this.attributes.getUdpDiscoveryAddr() + ":" + this.attributes.getUdpDiscoveryPort() + "]", e);
        }
    }

    protected void shutdown() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort());){
            sender.removeBroadcast(this.attributes.getServiceAddress(), this.attributes.getServicePort(), this.cacheNames);
            if (log.isDebugEnabled()) {
                log.debug("Called sender to issue a remove broadcast in shudown.");
            }
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender", e);
        }
    }
}

