/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ml extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0d28\u0d57\u0d31\u0d41";
        final String metaValue_TV = "\u0d1f\u0d41\u0d35\u0d3e\u0d32\u0d41";
        final String metaValue_ar = "\u0d05\u0d31\u0d2c\u0d3f\u0d15\u0d4d";
        final String metaValue_bn = "\u0d2c\u0d02\u0d17\u0d3e\u0d33\u0d3f";
        final String metaValue_bo = "\u0d1f\u0d3f\u0d2c\u0d31\u0d4d\u0d31\u0d7b";
        final String metaValue_el = "\u0d17\u0d4d\u0d30\u0d40\u0d15\u0d4d\u0d15\u0d4d";
        final String metaValue_gu = "\u0d17\u0d41\u0d1c\u0d31\u0d3e\u0d24\u0d4d\u0d24\u0d3f";
        final String metaValue_he = "\u0d39\u0d40\u0d2c\u0d4d\u0d30\u0d41";
        final String metaValue_hy = "\u0d05\u0d7c\u0d2e\u0d47\u0d28\u0d3f\u0d2f\u0d7b";
        final String metaValue_ja = "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d";
        final String metaValue_km = "\u0d16\u0d2e\u0d46\u0d7c";
        final String metaValue_kn = "\u0d15\u0d28\u0d4d\u0d28\u0d21";
        final String metaValue_ko = "\u0d15\u0d4a\u0d31\u0d3f\u0d2f\u0d7b";
        final String metaValue_la = "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d7b";
        final String metaValue_lo = "\u0d32\u0d3e\u0d35\u0d4b";
        final String metaValue_ml = "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02";
        final String metaValue_mn = "\u0d2e\u0d02\u0d17\u0d4b\u0d33\u0d3f\u0d2f\u0d7b";
        final String metaValue_or = "\u0d12\u0d21\u0d3f\u0d2f";
        final String metaValue_si = "\u0d38\u0d3f\u0d02\u0d39\u0d33";
        final String metaValue_ta = "\u0d24\u0d2e\u0d3f\u0d34\u0d4d";
        final String metaValue_te = "\u0d24\u0d46\u0d32\u0d41\u0d19\u0d4d\u0d15\u0d4d";
        final String metaValue_th = "\u0d24\u0d3e\u0d2f\u0d4d";
        final String metaValue_ban = "\u0d2c\u0d3e\u0d32\u0d3f\u0d28\u0d40\u0d38\u0d4d";
        final String metaValue_bug = "\u0d2c\u0d41\u0d17\u0d3f\u0d28\u0d40\u0d38\u0d4d";
        final String metaValue_cop = "\u0d15\u0d4b\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d";
        final String metaValue_peo = "\u0d2a\u0d34\u0d2f \u0d2a\u0d47\u0d7c\u0d37\u0d4d\u0d2f\u0d7b";
        final String metaValue_vai = "\u0d35\u0d48";
        final String metaValue_type_nu_mathdbl = "\u0d17\u0d23\u0d3f\u0d24 \u0d0f\u0d15\u0d38\u0d4d\u200c\u0d2a\u0d46\u0d2f\u0d4d\u200c\u0d38\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0d15\u0d4a\u0d33\u0d4b\u0d23\u0d3f\u0d2f\u0d7b" },
            { "Ogam", "\u0d12\u0d16\u0d3e\u0d02" },
            { "mwl", "\u0d2e\u0d3f\u0d30\u0d3e\u0d7b\u0d31\u0d38\u0d47" },
            { "Zsym", "\u0d1a\u0d3f\u0d39\u0d4d\u0d28\u0d19\u0d4d\u0d19\u0d7e" },
            { "cch", "\u0d05\u0d31\u0d4d\u0d31\u0d4d\u0d38\u0d3e\u0d02" },
            { "mwr", "\u0d2e\u0d7c\u0d35\u0d3e\u0d30\u0d3f" },
            { "type.nu.lanatham", "\u0d24\u0d3e\u0d2f\u0d4d \u0d24\u0d3e\u0d02 \u0d24\u0d3e\u0d02 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "Tagb", "\u0d24\u0d17\u0d4d\u0d2c\u0d7b\u0d35\u0d3e" },
            { "Zsye", "\u0d07\u0d2e\u0d4b\u0d1c\u0d3f" },
            { "%%NJIVA", "\u0d17\u0d4d\u0d28\u0d3f\u0d35/\u0d28\u0d3f\u0d1c\u0d3f\u0d35 \u0d2a\u0d4d\u0d30\u0d3e\u0d26\u0d47\u0d36\u0d3f\u0d15\u0d30\u0d42\u0d2a\u0d02" },
            { "egy", "\u0d2a\u0d4d\u0d30\u0d3e\u0d1a\u0d40\u0d28 \u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u0d37\u0d4d\u0d2f\u0d7b" },
            { "raj", "\u0d30\u0d3e\u0d1c\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f" },
            { "Phag", "\u0d2b\u0d17\u0d38\u0d4d \u0d2a" },
            { "tem", "\u0d1f\u0d3f\u0d02\u0d28\u0d47" },
            { "type.nu.sind", "\u0d16\u0d41\u0d21\u0d35\u0d3e\u0d21\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "teo", "\u0d1f\u0d46\u0d38\u0d4b" },
            { "rap", "\u0d30\u0d3e\u0d2a\u0d28\u0d42\u0d2f\u0d3f" },
            { "ter", "\u0d1f\u0d46\u0d31\u0d47\u0d28\u0d4b" },
            { "AC", "\u0d05\u0d38\u0d7b\u0d37\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d" },
            { "rar", "\u0d30\u0d3e\u0d30\u0d4b\u0d1f\u0d4b\u0d19\u0d4d\u0d15\u0d7b" },
            { "tet", "\u0d1f\u0d46\u0d31\u0d4d\u0d31\u0d41\u0d02" },
            { "type.nu.sinh", "\u0d38\u0d3f\u0d02\u0d39\u0d33 \u0d32\u0d3f\u0d24\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "AD", "\u0d05\u0d7b\u0d21\u0d4b\u0d31" },
            { "AE", "\u0d2f\u0d41\u0d23\u0d48\u0d31\u0d4d\u0d31\u0d21\u0d4d \u0d05\u0d31\u0d2c\u0d4d \u0d0e\u0d2e\u0d3f\u0d31\u0d48\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d38\u0d4d" },
            { "nl_BE", "\u0d2b\u0d4d\u0d32\u0d2e\u0d3f\u0d37\u0d4d" },
            { "AF", "\u0d05\u0d2b\u0d4d\u200c\u0d17\u0d3e\u0d28\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "AG", "\u0d06\u0d7b\u0d31\u0d3f\u0d17\u0d4d\u0d35\u0d2f\u0d41\u0d02 \u0d2c\u0d7c\u0d2c\u0d41\u0d21\u0d2f\u0d41\u0d02" },
            { "type.nu.mroo", "\u0d2e\u0d4d\u0d30\u0d4b \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.ca.ethiopic", "\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "AI", "\u0d06\u0d7b\u0d17\u0d4d\u0d35\u0d3f\u0d32\u0d4d\u0d32" },
            { "key.tz", "\u0d38\u0d2e\u0d2f \u0d2e\u0d47\u0d16\u0d32" },
            { "AL", "\u0d05\u0d7d\u0d2c\u0d47\u0d28\u0d3f\u0d2f" },
            { "AM", "\u0d05\u0d7c\u0d2e\u0d47\u0d28\u0d3f\u0d2f" },
            { "Teng", "\u0d24\u0d46\u0d02\u0d17\u0d4d\u0d35\u0d7c" },
            { "AO", "\u0d05\u0d02\u0d17\u0d4b\u0d33" },
            { "AQ", "\u0d05\u0d28\u0d4d\u0d31\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d15\u0d4d\u0d15" },
            { "AR", "\u0d05\u0d7c\u0d1c\u0d28\u0d4d\u0d31\u0d40\u0d28" },
            { "Prti", "\u0d2a\u0d43\u0d24\u0d3f" },
            { "AS", "\u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d2e\u0d4b\u0d35" },
            { "AT", "\u0d13\u0d38\u0d4d\u0d1f\u0d4d\u0d30\u0d3f\u0d2f" },
            { "AU", "\u0d13\u0d38\u0d4d\u200c\u0d1f\u0d4d\u0d30\u0d47\u0d32\u0d3f\u0d2f" },
            { "AW", "\u0d05\u0d31\u0d42\u0d2c" },
            { "en_US", "\u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "AX", "\u0d05\u0d32\u0d7b\u0d21\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "mye", "\u0d2e\u0d2f\u0d40\u0d7b" },
            { "AZ", "\u0d05\u0d38\u0d7c\u0d2c\u0d48\u0d1c\u0d3e\u0d7b" },
            { "%%AREVELA", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d05\u0d7c\u0d2e\u0d40\u0d28\u0d3f\u0d2f\u0d7b" },
            { "BA", "\u0d2c\u0d4b\u0d38\u0d4d\u0d28\u0d3f\u0d2f\u0d2f\u0d41\u0d02 \u0d39\u0d46\u0d7c\u0d38\u0d17\u0d4b\u0d35\u0d3f\u0d28\u0d2f\u0d41\u0d02" },
            { "BB", "\u0d2c\u0d3e\u0d7c\u0d2c\u0d21\u0d4b\u0d38\u0d4d" },
            { "ceb", "\u0d38\u0d46\u0d2c\u0d41\u0d35\u0d3e\u0d28\u0d4b" },
            { "BD", "\u0d2c\u0d02\u0d17\u0d4d\u0d32\u0d3e\u0d26\u0d47\u0d36\u0d4d" },
            { "kum", "\u0d15\u0d41\u0d2e\u0d48\u0d15\u0d4d" },
            { "BE", "\u0d2c\u0d46\u0d7d\u0d1c\u0d3f\u0d2f\u0d02" },
            { "gmh", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f \u0d09\u0d1a\u0d4d\u0d1a \u0d1c\u0d7c\u0d2e\u0d7b" },
            { "BF", "\u0d2c\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d28 \u0d2b\u0d3e\u0d38\u0d4b" },
            { "BG", "\u0d2c\u0d7e\u0d17\u0d47\u0d31\u0d3f\u0d2f" },
            { "BH", "\u0d2c\u0d39\u0d4d\u0d31\u0d3f\u0d7b" },
            { "BI", "\u0d2c\u0d31\u0d41\u0d23\u0d4d\u0d1f\u0d3f" },
            { "BJ", "\u0d2c\u0d46\u0d28\u0d3f\u0d7b" },
            { "BL", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d2c\u0d3e\u0d7c\u0d24\u0d4d\u0d24\u0d32\u0d2e\u0d3f" },
            { "BM", "\u0d2c\u0d7c\u0d2e\u0d41\u0d21" },
            { "kut", "\u0d15\u0d41\u0d24\u0d47\u0d28\u0d48" },
            { "myv", "\u0d0f\u0d34\u0d4d\u0d38\u0d4d\u0d2f" },
            { "BN", "\u0d2c\u0d4d\u0d30\u0d42\u0d23\u0d48" },
            { "BO", "\u0d2c\u0d4a\u0d33\u0d40\u0d35\u0d3f\u0d2f" },
            { "BQ", "\u0d15\u0d30\u0d40\u0d2c\u0d3f\u0d2f\u0d7b \u0d28\u0d46\u0d24\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d\u0d38\u0d4d" },
            { "BR", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d7d" },
            { "BS", "\u0d2c\u0d39\u0d3e\u0d2e\u0d3e\u0d38\u0d4d" },
            { "xog", "\u0d38\u0d4b\u0d17\u0d4b" },
            { "BT", "\u0d2d\u0d42\u0d1f\u0d4d\u0d1f\u0d3e\u0d7b" },
            { "BV", "\u0d2c\u0d57\u0d35\u0d46\u0d1f\u0d4d\u0d1f\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d" },
            { "BW", "\u0d2c\u0d4b\u0d1f\u0d4d\u0d38\u0d4d\u0d35\u0d3e\u0d28" },
            { "BY", "\u0d2c\u0d46\u0d32\u0d31\u0d42\u0d38\u0d4d" },
            { "BZ", "\u0d2c\u0d46\u0d32\u0d40\u0d38\u0d4d" },
            { "Visp", "\u0d26\u0d43\u0d36\u0d4d\u0d2f\u0d2d\u0d3e\u0d37" },
            { "type.ca.persian", "\u0d2a\u0d47\u0d7c\u0d37\u0d4d\u0d2f\u0d7b \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "type.nu.hebr", "\u0d39\u0d40\u0d2c\u0d4d\u0d30\u0d41 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "CA", "\u0d15\u0d3e\u0d28\u0d21" },
            { "CC", "\u0d15\u0d4b\u0d15\u0d4d\u0d15\u0d38\u0d4d (\u0d15\u0d40\u0d32\u0d3f\u0d02\u0d17\u0d4d) \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "mzn", "\u0d2e\u0d38\u0d28\u0d4d\u0d31\u0d31\u0d3e\u0d28\u0d3f" },
            { "CD", "\u0d15\u0d4b\u0d02\u0d17\u0d4b - \u0d15\u0d3f\u0d7b\u0d37\u0d3e\u0d38" },
            { "CF", "\u0d38\u0d46\u0d7b\u0d1f\u0d4d\u0d30\u0d7d \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d3f\u0d2a\u0d4d\u0d2a\u0d2c\u0d4d\u0d32\u0d3f\u0d15\u0d4d\u0d15\u0d4d" },
            { "CG", "\u0d15\u0d4b\u0d02\u0d17\u0d4b - \u0d2c\u0d4d\u0d30\u0d3e\u0d38\u0d35\u0d3f\u0d32\u0d4d\u0d32\u0d3f" },
            { "CH", "\u0d38\u0d4d\u0d35\u0d3f\u0d31\u0d4d\u0d31\u0d4d\u0d38\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d" },
            { "CI", "\u0d15\u0d4b\u0d1f\u0d4d\u0d1f\u0d4d \u0d21\u0d3f \u0d35\u0d3e\u0d7c" },
            { "CK", "\u0d15\u0d41\u0d15\u0d4d\u0d15\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "CL", "\u0d1a\u0d3f\u0d32\u0d3f" },
            { "Kthi", "\u0d15\u0d4d\u0d24\u0d3f" },
            { "CM", "\u0d15\u0d3e\u0d2e\u0d31\u0d42\u0d7a" },
            { "CN", "\u0d1a\u0d48\u0d28" },
            { "CO", "\u0d15\u0d4a\u0d33\u0d02\u0d2c\u0d3f\u0d2f" },
            { "CP", "\u0d15\u0d4d\u0d32\u0d3f\u0d2a\u0d4d\u0d2a\u0d46\u0d7c\u0d1f\u0d4d\u0d1f\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d" },
            { "CR", "\u0d15\u0d4b\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d31\u0d3f\u0d15\u0d4d\u0d15" },
            { "CU", "\u0d15\u0d4d\u0d2f\u0d42\u0d2c" },
            { "CV", "\u0d15\u0d47\u0d2a\u0d4d\u0d2a\u0d4d \u0d35\u0d47\u0d7c\u0d21\u0d4d" },
            { "CW", "\u0d15\u0d41\u0d31\u0d3e\u0d15\u0d3e\u0d35\u0d4b" },
            { "CX", "\u0d15\u0d4d\u0d30\u0d3f\u0d38\u0d4d\u0d2e\u0d38\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d" },
            { "CY", "\u0d38\u0d48\u0d2a\u0d4d\u0d30\u0d38\u0d4d" },
            { "type.nu.bali", "\u0d2c\u0d46\u0d32\u0d3f\u0d28\u0d40\u0d38\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "CZ", "\u0d1a\u0d46\u0d15\u0d4d\u0d15\u0d3f\u0d2f" },
            { "eka", "\u0d0e\u0d15\u0d3e\u0d1c\u0d41\u0d15\u0d4d" },
            { "DE", "\u0d1c\u0d7c\u0d2e\u0d4d\u0d2e\u0d28\u0d3f" },
            { "goh", "\u0d13\u0d7e\u0d21\u0d4d \u0d39\u0d48 \u0d1c\u0d7c\u0d2e\u0d7b" },
            { "ace", "\u0d05\u0d1a\u0d3f\u0d28\u0d40\u0d38\u0d4d" },
            { "cgg", "\u0d1a\u0d3f\u0d17" },
            { "DG", "\u0d21\u0d40\u0d17\u0d4b \u0d17\u0d4d\u0d30\u0d3e\u0d37\u0d4d\u0d2f" },
            { "type.nu.deva", "\u0d26\u0d47\u0d35\u0d28\u0d3e\u0d17\u0d30\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "DJ", "\u0d1c\u0d3f\u0d2c\u0d42\u0d24\u0d4d\u0d24\u0d3f" },
            { "DK", "\u0d21\u0d46\u0d7b\u0d2e\u0d3e\u0d7c\u0d15\u0d4d\u0d15\u0d4d" },
            { "ach", "\u0d05\u0d15\u0d4b\u0d32\u0d3f" },
            { "gon", "\u0d17\u0d4b\u0d23\u0d4d\u0d21\u0d3f" },
            { "Brai", "\u0d2c\u0d4d\u0d30\u0d46\u0d2f\u0d4d\u200c\u0d32\u0d3f" },
            { "Brah", "\u0d2c\u0d4d\u0d30\u0d3e\u0d39\u0d4d\u0d2e\u0d3f" },
            { "DM", "\u0d21\u0d4a\u0d2e\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15" },
            { "type.nu.armnlow", "\u0d05\u0d7c\u0d2e\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d1a\u0d46\u0d31\u0d3f\u0d2f \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "DO", "\u0d21\u0d4a\u0d2e\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d3f\u0d2a\u0d4d\u0d2a\u0d2c\u0d4d\u0d32\u0d3f\u0d15\u0d4d\u0d15\u0d4d" },
            { "gor", "\u0d17\u0d4a\u0d31\u0d4b\u0d28\u0d4d\u0d31\u0d3e\u0d32\u0d4b" },
            { "got", "\u0d17\u0d4b\u0d25\u0d3f\u0d15\u0d4d\u0d15\u0d4d" },
            { "Mtei", "\u0d2e\u0d47\u0d31\u0d4d\u0d31\u0d3f \u0d2e\u0d3e\u0d2f\u0d15\u0d4d" },
            { "zun", "\u0d38\u0d41\u0d28\u0d3f" },
            { "tig", "\u0d1f\u0d48\u0d17\u0d4d\u0d30\u0d3f" },
            { "DZ", "\u0d05\u0d7e\u0d1c\u0d40\u0d30\u0d3f\u0d2f" },
            { "pag", "\u0d2a\u0d19\u0d4d\u0d15\u0d3e\u0d38\u0d3f\u0d28\u0d7b" },
            { "type.d0.hwidth", "\u0d39\u0d3e\u0d2b\u0d4d\u200c\u0d35\u0d3f\u0d21\u0d4d\u200c\u0d24\u0d4d\u0d24\u0d3f\u0d32\u0d47\u0d15\u0d4d\u0d15\u0d4d" },
            { "pal", "\u0d2a\u0d3e\u0d39\u0d4d\u0d32\u0d35\u0d3f" },
            { "EA", "\u0d38\u0d46\u0d2f\u0d42\u0d24\u0d4d\u0d24 \u0d06\u0d7b\u0d21\u0d4d \u0d2e\u0d46\u0d32\u0d3f\u0d2f" },
            { "chb", "\u0d1a\u0d3f\u0d2c\u0d4d\u0d1a" },
            { "pam", "\u0d2a\u0d3e\u0d02\u0d2a\u0d7b\u0d17" },
            { "EC", "\u0d07\u0d15\u0d4d\u0d35\u0d21\u0d4b\u0d7c" },
            { "pap", "\u0d2a\u0d3e\u0d2a\u0d3f\u0d2f\u0d3e\u0d2e\u0d46\u0d28\u0d4d\u0d31\u0d4a" },
            { "ada", "\u0d05\u0d21\u0d3e\u0d19\u0d4d\u200c\u0d2e\u0d3f" },
            { "EE", "\u0d0e\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4b\u0d23\u0d3f\u0d2f\u200d" },
            { "tiv", "\u0d1f\u0d3f\u0d35\u0d4d" },
            { "EG", "\u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u0d24\u0d4d" },
            { "EH", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d38\u0d39\u0d3e\u0d31" },
            { "chg", "\u0d37\u0d3e\u0d17\u0d24\u0d3e\u0d2f\u0d4d" },
            { "pau", "\u0d2a\u0d32\u0d3e\u0d35\u0d41\u0d7b" },
            { "chk", "\u0d1a\u0d42\u0d15\u0d40\u0d38\u0d4d" },
            { "chn", "\u0d1a\u0d3f\u0d28\u0d42\u0d17\u0d4d \u0d1c\u0d3e\u0d7c\u0d17\u0d7a" },
            { "chm", "\u0d2e\u0d3e\u0d30\u0d3f" },
            { "chp", "\u0d1a\u0d3f\u0d2a\u0d47\u0d35\u0d4d\u0d2f\u0d7b" },
            { "cho", "\u0d1a\u0d4b\u0d15\u0d4d\u0d31\u0d4d\u0d31\u0d3e\u0d35\u0d4d" },
            { "type.nu.mathbold", "\u0d17\u0d23\u0d3f\u0d24 \u0d2c\u0d4b\u0d7e\u0d21\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "chr", "\u0d37\u0d46\u0d30\u0d4b\u0d15\u0d4d\u0d15\u0d3f" },
            { "ER", "\u0d0e\u0d31\u0d3f\u0d24\u0d4d\u0d30\u0d3f\u0d2f" },
            { "ES", "\u0d38\u0d4d\u200c\u0d2a\u0d46\u0d2f\u0d3f\u0d7b" },
            { "ET", "\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d4d\u0d2f" },
            { "EU", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d2f\u0d42\u0d23\u0d3f\u0d2f\u0d7b" },
            { "elx", "\u0d0e\u0d32\u0d3e\u0d2e\u0d48\u0d31\u0d4d\u0d31\u0d4d" },
            { "type.ca.gregorian", "\u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "EZ", "\u0d2f\u0d42\u0d31\u0d4b\u0d38\u0d4b\u0d7a" },
            { "chy", "\u0d37\u0d3e\u0d2f\u0d3e\u0d7b" },
            { "type.nu.gujr", "\u0d17\u0d41\u0d1c\u0d31\u0d3e\u0d24\u0d4d\u0d24\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "Inds", "\u0d38\u0d3f\u0d28\u0d4d\u0d27\u0d41" },
            { "ady", "\u0d05\u0d21\u0d48\u0d17\u0d47" },
            { "FI", "\u0d2b\u0d3f\u0d7b\u0d32\u0d3e\u0d7b\u0d21\u0d4d" },
            { "FJ", "\u0d2b\u0d3f\u0d1c\u0d3f" },
            { "FK", "\u0d2b\u0d3e\u0d15\u0d4d\u0d15\u0d4d\u200c\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "FM", "\u0d2e\u0d48\u0d15\u0d4d\u0d30\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f" },
            { "key.va", "\u0d2d\u0d3e\u0d37\u0d3e \u0d2d\u0d47\u0d26\u0d02" },
            { "FO", "\u0d2b\u0d31\u0d4b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "Taml", metaValue_ta },
            { "FR", "\u0d2b\u0d4d\u0d30\u0d3e\u0d7b\u0d38\u0d4d" },
            { "tkl", "\u0d1f\u0d4a\u0d15\u0d4d\u0d15\u0d47\u0d32\u0d57" },
            { "grb", "\u0d17\u0d4d\u0d30\u0d2c\u0d4a" },
            { "root", "\u0d2e\u0d42\u0d32\u0d2d\u0d3e\u0d37" },
            { "type.ca.indian", "\u0d36\u0d15\u0d35\u0d7c\u0d37 \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "grc", "\u0d2a\u0d41\u0d30\u0d3e\u0d24\u0d28 \u0d17\u0d4d\u0d30\u0d40\u0d15\u0d4d\u0d15\u0d4d" },
            { "GA", "\u0d17\u0d3e\u0d2c\u0d7a" },
            { "vot", "\u0d35\u0d4b\u0d1f\u0d4d\u0d1f\u0d3f\u0d15\u0d4d" },
            { "GB", "\u0d2f\u0d41\u0d23\u0d48\u0d31\u0d4d\u0d31\u0d21\u0d4d \u0d15\u0d3f\u0d02\u0d17\u0d4d\u0d21\u0d02" },
            { "pcm", "\u0d28\u0d48\u0d1c\u0d40\u0d30\u0d3f\u0d2f\u0d7b \u0d2a\u0d3f\u0d21\u0d4d\u200c\u0d17\u0d3f\u0d7b" },
            { "GD", "\u0d17\u0d4d\u0d30\u0d28\u0d47\u0d21" },
            { "GE", "\u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f" },
            { "GF", "\u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d \u0d17\u0d2f\u0d3e\u0d28" },
            { "GG", "\u0d17\u0d47\u0d7a\u0d38\u0d3f" },
            { "GH", "\u0d18\u0d3e\u0d28" },
            { "Tale", "\u0d24\u0d3e\u0d2f\u0d4d \u0d32\u0d47" },
            { "GI", "\u0d1c\u0d3f\u0d2c\u0d4d\u0d30\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f\u0d7c" },
            { "afh", "\u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d39\u0d3f\u0d32\u0d3f" },
            { "GL", "\u0d17\u0d4d\u0d30\u0d40\u0d7b\u0d32\u0d3e\u0d7b\u0d31\u0d4d" },
            { "enm", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f \u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "GM", "\u0d17\u0d3e\u0d02\u0d2c\u0d3f\u0d2f" },
            { "GN", "\u0d17\u0d3f\u0d28\u0d3f\u0d2f" },
            { "GP", "\u0d17\u0d4d\u0d35\u0d3e\u0d21\u0d32\u0d42\u0d2a\u0d4d\u0d2a\u0d4d" },
            { "GQ", "\u0d07\u0d15\u0d4d\u0d35\u0d31\u0d4d\u0d31\u0d4b\u0d31\u0d3f\u0d2f\u0d7d \u0d17\u0d3f\u0d28\u0d3f\u0d2f" },
            { "GR", "\u0d17\u0d4d\u0d30\u0d40\u0d38\u0d4d" },
            { "GS", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f\u0d2f\u0d41\u0d02 \u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d38\u0d3e\u0d7b\u0d21\u0d4d\u200c\u0d35\u0d3f\u0d1a\u0d4d\u0d1a\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d02" },
            { "GT", "\u0d17\u0d4d\u0d35\u0d3e\u0d1f\u0d4d\u0d1f\u0d3f\u0d2e\u0d3e\u0d32" },
            { "type.nu.mathmono", metaValue_type_nu_mathdbl },
            { "GU", "\u0d17\u0d4d\u0d35\u0d3e\u0d02" },
            { "GW", "\u0d17\u0d3f\u0d28\u0d3f\u0d2f-\u0d2c\u0d3f\u0d38\u0d57" },
            { "tli", "\u0d32\u0d3f\u0d02\u0d17\u0d4d\u0d35\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "tlh", "\u0d15\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4b\u0d7a" },
            { "Talu", "\u0d2a\u0d41\u0d24\u0d3f\u0d2f \u0d24\u0d3e\u0d2f\u0d4d \u0d32\u0d4d\u0d2f\u0d42" },
            { "GY", "\u0d17\u0d2f\u0d3e\u0d28" },
            { "ckb", "\u0d38\u0d46\u0d7b\u0d1f\u0d4d\u0d30\u0d7d \u0d15\u0d41\u0d7c\u0d26\u0d3f\u0d37\u0d4d" },
            { "zxx", "\u0d2d\u0d3e\u0d37\u0d3e\u0d2a\u0d30\u0d2e\u0d3e\u0d2f \u0d09\u0d33\u0d4d\u0d33\u0d1f\u0d15\u0d4d\u0d15\u0d2e\u0d4a\u0d28\u0d4d\u0d28\u0d41\u0d2e\u0d3f\u0d32\u0d4d\u0d32" },
            { "de_AT", "\u0d13\u0d38\u0d4d\u200c\u0d1f\u0d4d\u0d30\u0d3f\u0d2f\u0d7b \u0d1c\u0d7c\u0d2e\u0d7b" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0d39\u0d4b\u0d19\u0d4d\u0d15\u0d4b\u0d19\u0d4d (SAR) \u0d1a\u0d48\u0d28" },
            { "HM", "\u0d39\u0d3f\u0d2f\u0d47\u0d7c\u0d21\u0d41\u0d02 \u0d2e\u0d15\u0d4d\u200c\u0d21\u0d4a\u0d23\u0d3e\u0d7e\u0d21\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d02" },
            { "HN", "\u0d39\u0d4b\u0d23\u0d4d\u0d1f\u0d41\u0d31\u0d3e\u0d38\u0d4d" },
            { "HR", "\u0d15\u0d4d\u0d30\u0d4a\u0d2f\u0d47\u0d37\u0d4d\u0d2f" },
            { "agq", "\u0d06\u0d18\u0d47\u0d02" },
            { "gsw", "\u0d38\u0d4d\u0d35\u0d3f\u0d38\u0d4d \u0d1c\u0d7c\u0d2e\u0d4d\u0d2e\u0d7b" },
            { "type.ca.islamic-umalqura", "\u0d07\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d2e\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c (\u0d09\u0d02 \u0d05\u0d7d \u0d16\u0d41\u0d31)" },
            { "HT", "\u0d39\u0d46\u0d2f\u0d4d\u0d24\u0d3f" },
            { "HU", "\u0d39\u0d02\u0d17\u0d31\u0d3f" },
            { "tmh", "\u0d1f\u0d2e\u0d37\u0d47\u0d15\u0d4d" },
            { "IC", "\u0d15\u0d3e\u0d28\u0d31\u0d3f \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "nan", "\u0d2e\u0d3f\u0d7b \u0d28\u0d3e\u0d7b \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "peo", metaValue_peo },
            { "ID", "\u0d07\u0d28\u0d4d\u0d24\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f" },
            { "type.nu.kali", "\u0d15\u0d2f\u0d3e\u0d39\u0d4d \u0d32\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "IE", "\u0d05\u0d2f\u0d7c\u0d32\u0d7b\u0d21\u0d4d" },
            { "nap", "\u0d28\u0d46\u0d2a\u0d4d\u0d2a\u0d4b\u0d33\u0d3f\u0d31\u0d4d\u0d31\u0d3e\u0d7b" },
            { "naq", "\u0d28\u0d3e\u0d2e" },
            { "type.nu.sora", "\u0d38\u0d4b\u0d31 \u0d38\u0d4b\u0d02\u0d2a\u0d46\u0d19\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "zza", "\u0d38\u0d3e\u0d38\u0d3e" },
            { "IL", "\u0d07\u0d38\u0d4d\u0d30\u0d3e\u0d2f\u0d47\u0d7d" },
            { "IM", "\u0d10\u0d7d \u0d13\u0d2b\u0d4d \u0d2e\u0d3e\u0d7b" },
            { "IN", "\u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f" },
            { "type.co.eor", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d28\u0d3f\u0d2f\u0d2e\u0d19\u0d4d\u0d19\u0d7e" },
            { "IO", "\u0d2c\u0d4d\u0d30\u0d3f\u0d1f\u0d4d\u0d1f\u0d40\u0d37\u0d4d \u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f\u0d7b \u0d2e\u0d39\u0d3e\u0d38\u0d2e\u0d41\u0d26\u0d4d\u0d30 \u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d02" },
            { "IQ", "\u0d07\u0d31\u0d3e\u0d16\u0d4d" },
            { "IR", "\u0d07\u0d31\u0d3e\u0d7b" },
            { "IS", "\u0d10\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d" },
            { "IT", "\u0d07\u0d31\u0d4d\u0d31\u0d32\u0d3f" },
            { "Zmth", "\u0d17\u0d23\u0d3f\u0d24 \u0d30\u0d42\u0d2a\u0d02" },
            { "type.nu.thai", "\u0d24\u0d3e\u0d2f\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "%%POSIX", "\u0d15\u0d2e\u0d4d\u0d2a\u0d4d\u0d2f\u0d42\u0d1f\u0d4d\u0d1f\u0d7c" },
            { "type.nu.beng", "\u0d2c\u0d02\u0d17\u0d3e\u0d33\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.nu.cyrl", "\u0d38\u0d3f\u0d31\u0d3f\u0d32\u0d3f\u0d15\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "JE", "\u0d1c\u0d47\u0d34\u0d4d\u0d38\u0d3f" },
            { "type.ca.islamic", "\u0d07\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d2e\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "Beng", metaValue_bn },
            { "JM", "\u0d1c\u0d2e\u0d48\u0d15\u0d4d\u0d15" },
            { "JO", "\u0d1c\u0d4b\u0d7c\u0d26\u0d4d\u0d26\u0d3e\u0d7b" },
            { "JP", "\u0d1c\u0d2a\u0d4d\u0d2a\u0d3e\u0d7b" },
            { "%%1606NICT", "1606 \u0d35\u0d30\u0d46\u0d2f\u0d41\u0d33\u0d4d\u0d33 \u0d06\u0d27\u0d41\u0d28\u0d3f\u0d15\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f\u0d15\u0d3e\u0d32 \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "ain", "\u0d10\u0d28\u0d41" },
            { "guz", "\u0d17\u0d41\u0d38\u0d40" },
            { "tog", "\u0d28\u0d4d\u0d2f\u0d3e\u0d38\u0d3e \u0d21\u0d4b\u0d19\u0d4d\u0d15" },
            { "type.nu.knda", "\u0d15\u0d28\u0d4d\u0d28\u0d21 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "Kali", "\u0d15\u0d2f\u0d3e \u0d32\u0d3f" },
            { "de_CH", "\u0d38\u0d4d\u0d35\u0d3f\u0d38\u0d4d \u0d39\u0d48 \u0d1c\u0d7c\u0d2e\u0d7b" },
            { "type.co.phonetic", "\u0d38\u0d4d\u0d35\u0d30\u0d38\u0d42\u0d1a\u0d15 \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "type.ca.buddhist", "\u0d2c\u0d41\u0d26\u0d4d\u0d27\u0d2e\u0d24\u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "KE", "\u0d15\u0d46\u0d28\u0d3f\u0d2f" },
            { "419", "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d28\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "KG", "\u0d15\u0d3f\u0d7c\u0d17\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "KH", "\u0d15\u0d02\u0d2c\u0d4b\u0d21\u0d3f\u0d2f" },
            { "KI", "\u0d15\u0d3f\u0d30\u0d3f\u0d2c\u0d3e\u0d1f\u0d4d\u0d1f\u0d3f" },
            { "KM", "\u0d15\u0d4b\u0d2e\u0d4a\u0d31\u0d4b\u0d38\u0d4d" },
            { "Knda", metaValue_kn },
            { "KN", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d15\u0d3f\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d38\u0d41\u0d02 \u0d28\u0d46\u0d35\u0d3f\u0d38\u0d41\u0d02" },
            { "Zinh", "\u0d2a\u0d3e\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d4d\u0d2f\u0d2e\u0d3e\u0d2f" },
            { "fr_CA", "\u0d15\u0d28\u0d47\u0d21\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "KP", "\u0d09\u0d24\u0d4d\u0d24\u0d30\u0d15\u0d4a\u0d31\u0d3f\u0d2f" },
            { "KR", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23\u0d15\u0d4a\u0d31\u0d3f\u0d2f" },
            { "Plrd", "\u0d2a\u0d4a\u0d33\u0d4d\u0d33\u0d3e\u0d7c\u0d21\u0d4d \u0d36\u0d2c\u0d4d\u0d26\u0d32\u0d3f\u0d2a\u0d3f" },
            { "fr_CH", "\u0d38\u0d4d\u0d35\u0d3f\u0d38\u0d4d \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "KW", "\u0d15\u0d41\u0d35\u0d48\u0d31\u0d4d\u0d31\u0d4d" },
            { "tpi", "\u0d1f\u0d4b\u0d15\u0d4d \u0d2a\u0d3f\u0d38\u0d3f\u0d7b" },
            { "KY", "\u0d15\u0d47\u0d2f\u0d4d\u0d2e\u0d3e\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "KZ", "\u0d15\u0d38\u0d3e\u0d16\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "Cyrl", "\u0d38\u0d3f\u0d31\u0d3f\u0d32\u0d3f\u0d15\u0d4d" },
            { "LA", "\u0d32\u0d3e\u0d35\u0d4b\u0d38\u0d4d" },
            { "LB", "\u0d32\u0d46\u0d2c\u0d28\u0d7b" },
            { "LC", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d32\u0d42\u0d38\u0d3f\u0d2f" },
            { "phn", "\u0d2b\u0d40\u0d28\u0d3f\u0d37\u0d4d\u0d2f\u0d7b" },
            { "Cyrs", "\u0d2a\u0d41\u0d30\u0d3e\u0d24\u0d28 \u0d1a\u0d7c\u0d1a\u0d4d\u0d1a\u0d4d \u0d38\u0d4d\u0d32\u0d35\u0d4b\u0d23\u0d3f\u0d15\u0d4d \u0d38\u0d3f\u0d31\u0d3f\u0d32\u0d3f\u0d15\u0d4d" },
            { "gwi", "\u0d17\u0d4d\u0d35\u0d3f\u0d1a\u0d4d\u0d1a\u0d3f\u0d7b" },
            { "nds", "\u0d32\u0d4b \u0d1c\u0d7c\u0d2e\u0d7b" },
            { "LI", "\u0d32\u0d3f\u0d1a\u0d4d\u0d1a\u0d7a\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d48\u0d7b" },
            { "LK", "\u0d36\u0d4d\u0d30\u0d40\u0d32\u0d19\u0d4d\u0d15" },
            { "akk", "\u0d05\u0d15\u0d4d\u0d15\u0d3e\u0d21\u0d3f\u0d2f\u0d7b" },
            { "cop", metaValue_cop },
            { "LR", "\u0d32\u0d48\u0d2c\u0d40\u0d30\u0d3f\u0d2f" },
            { "LS", "\u0d32\u0d46\u0d38\u0d4b\u0d24\u0d4b" },
            { "Phlv", "\u0d2a\u0d39\u0d7d\u0d35\u0d3f \u0d32\u0d3f\u0d2a\u0d3f" },
            { "LT", "\u0d32\u0d3f\u0d24\u0d4d\u0d35\u0d3e\u0d28\u0d3f\u0d2f" },
            { "LU", "\u0d32\u0d15\u0d4d\u0d38\u0d02\u0d2c\u0d7c\u0d17\u0d4d" },
            { "LV", "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d4d\u0d35\u0d3f\u0d2f" },
            { "Kana", "\u0d15\u0d31\u0d4d\u0d31\u0d15\u0d4d\u0d15\u0d3e\u0d28" },
            { "LY", "\u0d32\u0d3f\u0d2c\u0d3f\u0d2f" },
            { "lad", "\u0d32\u0d3e\u0d21\u0d3f\u0d28\u0d4b" },
            { "vun", "\u0d35\u0d41\u0d7b\u0d1c\u0d4b" },
            { "lah", "\u0d32\u0d39\u0d4d\u200c\u0d7b\u0d21" },
            { "lag", "\u0d32\u0d3e\u0d02\u0d17\u0d3f" },
            { "Thaa", "\u0d25\u0d3e\u0d28" },
            { "MA", "\u0d2e\u0d4a\u0d31\u0d4b\u0d15\u0d4d\u0d15\u0d4a" },
            { "MC", "\u0d2e\u0d4a\u0d23\u0d3e\u0d15\u0d4d\u0d15\u0d4b" },
            { "MD", "\u0d2e\u0d7e\u0d21\u0d4b\u0d35" },
            { "ME", "\u0d2e\u0d4b\u0d23\u0d4d\u0d1f\u0d46\u0d28\u0d46\u0d17\u0d4d\u0d30\u0d4b" },
            { "MF", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d2e\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d7b" },
            { "lam", "\u0d32\u0d02\u0d2c" },
            { "MG", "\u0d2e\u0d21\u0d17\u0d3e\u0d38\u0d4d\u0d15\u0d7c" },
            { "Thai", metaValue_th },
            { "MH", "\u0d2e\u0d3e\u0d7c\u0d37\u0d7d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "ale", "\u0d05\u0d32\u0d42\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "type.nu.vaii", "\u0d35\u0d3e\u0d2f\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "type.nu.mathdbl", metaValue_type_nu_mathdbl },
            { "MK", "\u0d28\u0d4b\u0d7c\u0d24\u0d4d\u0d24\u0d4d \u0d2e\u0d3e\u0d38\u0d3f\u0d21\u0d4b\u0d23\u0d3f\u0d2f" },
            { "ML", "\u0d2e\u0d3e\u0d32\u0d3f" },
            { "MM", "\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c (\u0d2c\u0d7c\u0d2e\u0d4d\u0d2e)" },
            { "MN", "\u0d2e\u0d02\u0d17\u0d4b\u0d33\u0d3f\u0d2f" },
            { "new", "\u0d28\u0d47\u0d35\u0d3e\u0d30\u0d3f" },
            { "MO", "\u0d2e\u0d15\u0d4d\u0d15\u0d3e\u0d35\u0d41 (SAR) \u0d1a\u0d48\u0d28" },
            { "MP", "\u0d09\u0d24\u0d4d\u0d24\u0d30 \u0d2e\u0d31\u0d3f\u0d2f\u0d3e\u0d28\u0d3e \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "MQ", "\u0d2e\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d4d" },
            { "MR", "\u0d2e\u0d57\u0d31\u0d3f\u0d31\u0d4d\u0d31\u0d3e\u0d28\u0d3f\u0d2f" },
            { "MS", "\u0d2e\u0d4a\u0d23\u0d4d\u0d1f\u0d46\u0d38\u0d30\u0d24\u0d4d\u0d24\u0d4d" },
            { "MT", "\u0d2e\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f" },
            { "type.m0.ungegn", "\u0d2f\u0d41.\u0d0e\u0d7b. GEGN \u0d32\u0d3f\u0d2a\u0d4d\u0d2f\u0d28\u0d4d\u0d24\u0d30\u0d23\u0d02" },
            { "MU", "\u0d2e\u0d57\u0d31\u0d40\u0d37\u0d4d\u0d2f\u0d38\u0d4d" },
            { "alt", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d7b \u0d05\u0d7e\u0d24\u0d4d\u0d24\u0d3e\u0d2f\u0d3f" },
            { "MV", "\u0d2e\u0d3e\u0d32\u0d3f\u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d" },
            { "MW", "\u0d2e\u0d32\u0d3e\u0d35\u0d3f" },
            { "MX", "\u0d2e\u0d46\u0d15\u0d4d\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d4b" },
            { "type.ca.japanese", "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "MY", "\u0d2e\u0d32\u0d47\u0d37\u0d4d\u0d2f" },
            { "MZ", "\u0d2e\u0d4a\u0d38\u0d3e\u0d02\u0d2c\u0d3f\u0d15\u0d4d\u0d15\u0d4d" },
            { "Phli", "\u0d0e\u0d34\u0d41\u0d24\u0d4d\u0d24\u0d41 \u0d2a\u0d39\u0d7d\u0d35\u0d3f" },
            { "NA", "\u0d28\u0d2e\u0d40\u0d2c\u0d3f\u0d2f" },
            { "202", "\u0d38\u0d2c\u0d4d-\u0d38\u0d39\u0d3e\u0d31\u0d7b \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "type.ca.hebrew", "\u0d39\u0d40\u0d2c\u0d4d\u0d30\u0d42 \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "type.co.dictionary", "\u0d28\u0d3f\u0d18\u0d23\u0d4d\u0d1f\u0d41 \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "NC", "\u0d28\u0d4d\u0d2f\u0d42 \u0d15\u0d3e\u0d32\u0d3f\u0d21\u0d4b\u0d23\u0d3f\u0d2f" },
            { "NE", "\u0d28\u0d48\u0d1c\u0d7c" },
            { "NF", "\u0d28\u0d4b\u0d7c\u0d2b\u0d4b\u0d15\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d" },
            { "NG", "\u0d28\u0d48\u0d1c\u0d40\u0d30\u0d3f\u0d2f" },
            { "trv", "\u0d24\u0d30\u0d4b\u0d15\u0d4d\u0d15\u0d4b" },
            { "Phlp", "\u0d38\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f\u0d7c \u0d2a\u0d39\u0d7d\u0d35\u0d3f" },
            { "NI", "\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d30\u0d3e\u0d17\u0d4d\u0d35" },
            { "Hmng", "\u0d2a\u0d39\u0d4d\u0d35\u0d3e \u0d39\u0d2e\u0d4b\u0d02\u0d17\u0d4d" },
            { "NL", "\u0d28\u0d46\u0d24\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d\u200c\u0d38\u0d4d" },
            { "NO", "\u0d28\u0d4b\u0d7c\u0d35\u0d46" },
            { "NP", "\u0d28\u0d47\u0d2a\u0d4d\u0d2a\u0d3e\u0d7e" },
            { "NR", metaValue_NR },
            { "NU", "\u0d28\u0d4d\u0d2f\u0d42\u0d2f\u0d3f" },
            { "Phnx", "\u0d2b\u0d3f\u0d28\u0d40\u0d37\u0d4d\u0d2f\u0d7b" },
            { "rof", "\u0d31\u0d4b\u0d02\u0d2c\u0d4b" },
            { "tsi", "\u0d38\u0d3f\u0d02\u0d37\u0d4d\u0d2f\u0d7b" },
            { "NZ", "\u0d28\u0d4d\u0d2f\u0d42\u0d38\u0d3f\u0d32\u0d3e\u0d7b\u0d31\u0d4d" },
            { "rom", "\u0d31\u0d4a\u0d2e\u0d3e\u0d28\u0d3f" },
            { "Mero", "\u0d2e\u0d46\u0d31\u0d4b\u0d2f\u0d3f\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d" },
            { "crh", "\u0d15\u0d4d\u0d30\u0d3f\u0d2e\u0d3f\u0d2f\u0d7b \u0d1f\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d37\u0d4d" },
            { "ang", "\u0d2a\u0d34\u0d2f \u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "OM", "\u0d12\u0d2e\u0d3e\u0d7b" },
            { "anp", "\u0d06\u0d7b\u0d17\u0d3f\u0d15" },
            { "crs", "\u0d38\u0d46\u0d37\u0d7d\u0d35 \u0d15\u0d4d\u0d30\u0d3f\u0d2f\u0d4b\u0d7e \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "\u0d2a\u0d39\u0d3e\u0d35\u0d4d \u0d2e\u0d4b\u0d02\u0d17\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "PA", "\u0d2a\u0d28\u0d3e\u0d2e" },
            { "type.ca.islamic-civil", "\u0d07\u0d38\u0d4d\u0d32\u0d3e\u0d02-\u0d38\u0d3f\u0d35\u0d3f\u0d7d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "csb", "\u0d15\u0d3e\u0d37\u0d41\u0d2c\u0d3f\u0d2f\u0d3e\u0d7b" },
            { "en_GB", "\u0d2c\u0d4d\u0d30\u0d3f\u0d1f\u0d4d\u0d1f\u0d40\u0d37\u0d4d \u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "PE", "\u0d2a\u0d46\u0d31\u0d41" },
            { "PF", "\u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d \u0d2a\u0d4b\u0d33\u0d3f\u0d28\u0d47\u0d37\u0d4d\u0d2f" },
            { "PG", "\u0d2a\u0d3e\u0d2a\u0d4d\u0d2a\u0d41\u0d35 \u0d28\u0d4d\u0d2f\u0d42 \u0d17\u0d3f\u0d28\u0d3f\u0d2f" },
            { "PH", "\u0d2b\u0d3f\u0d32\u0d3f\u0d2a\u0d4d\u0d2a\u0d40\u0d7b\u0d38\u0d4d" },
            { "PK", "\u0d2a\u0d3e\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "PL", "\u0d2a\u0d4b\u0d33\u0d23\u0d4d\u0d1f\u0d4d" },
            { "ewo", "\u0d0e\u0d35\u0d4b\u0d7b\u0d21\u0d4b" },
            { "PM", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d2a\u0d3f\u0d2f\u0d31\u0d3f\u0d2f\u0d41\u0d02 \u0d2e\u0d3f\u0d15\u0d4d\u0d15\u0d32\u0d23\u0d41\u0d02" },
            { "PN", "\u0d2a\u0d3f\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d15\u0d46\u0d2f\u0d4d\u200c\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "PR", "\u0d2a\u0d4b\u0d7c\u0d1f\u0d4d\u0d1f\u0d4b \u0d31\u0d3f\u0d15\u0d4d\u0d15\u0d4b" },
            { "Bali", metaValue_ban },
            { "PS", "\u0d2a\u0d3e\u0d32\u0d38\u0d4d\u200c\u0d24\u0d40\u0d7b \u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d19\u0d4d\u0d19\u0d7e" },
            { "PT", "\u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d7d" },
            { "PW", "\u0d2a\u0d32\u0d3e\u0d35\u0d41" },
            { "nia", "\u0d28\u0d3f\u0d2f\u0d3e\u0d38\u0d4d" },
            { "type.nu.greklow", "\u0d17\u0d4d\u0d30\u0d40\u0d15\u0d4d\u0d15\u0d4d \u0d1a\u0d46\u0d31\u0d3f\u0d2f\u0d15\u0d4d\u0d37\u0d30 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "PY", "\u0d2a\u0d30\u0d3e\u0d17\u0d4d\u0d35\u0d47" },
            { "tum", "\u0d1f\u0d41\u0d02\u0d2c\u0d41\u0d15" },
            { "Hebr", metaValue_he },
            { "QA", "\u0d16\u0d24\u0d4d\u0d24\u0d7c" },
            { "niu", "\u0d28\u0d4d\u0d2f\u0d41\u0d35\u0d3e\u0d7b" },
            { "QO", "\u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d38\u0d2e\u0d42\u0d39\u0d02" },
            { "lez", "\u0d32\u0d39\u0d4d\u0d17\u0d3f\u0d2f\u0d3e\u0d7b" },
            { "type.nu.ahom", "\u0d05\u0d39\u0d4b\u0d02 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.nu.takr", "\u0d1f\u0d3e\u0d15\u0d4d\u0d30\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u0d24\u0d4d\u0d35\u0d1f\u0d4d" },
            { "001", "\u0d32\u0d4b\u0d15\u0d02" },
            { "002", "\u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "003", "\u0d35\u0d1f\u0d15\u0d4d\u0d15\u0d47 \u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "RE", "\u0d31\u0d40\u0d2f\u0d42\u0d23\u0d3f\u0d2f\u0d7b" },
            { "005", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d47 \u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "jbo", "\u0d32\u0d4b\u0d1c\u0d4d\u0d2c\u0d3e\u0d7b" },
            { "Rjng", "\u0d31\u0d46\u0d1c\u0d3e\u0d02\u0d17\u0d4d" },
            { "009", "\u0d13\u0d37\u0d4d\u0d2f\u0d3e\u0d28\u0d3f\u0d2f" },
            { "RO", "\u0d31\u0d4a\u0d2e\u0d3e\u0d28\u0d3f\u0d2f" },
            { "RS", "\u0d38\u0d46\u0d7c\u0d2c\u0d3f\u0d2f" },
            { "RU", "\u0d31\u0d37\u0d4d\u0d2f" },
            { "RW", "\u0d31\u0d41\u0d35\u0d3e\u0d23\u0d4d\u0d1f" },
            { "type.nu.talu", "\u0d2a\u0d41\u0d24\u0d3f\u0d2f \u0d24\u0d3e\u0d2f\u0d4d \u0d32\u0d42 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "Mani", "\u0d2e\u0d23\u0d3f\u0d1a\u0d47\u0d2f\u0d7b" },
            { "Ugar", "\u0d09\u0d17\u0d4d\u0d30\u0d48\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d" },
            { "Khar", "\u0d16\u0d30\u0d4b\u0d37\u0d4d\u0d1f\u0d3f" },
            { "SA", "\u0d38\u0d57\u0d26\u0d3f \u0d05\u0d31\u0d47\u0d2c\u0d4d\u0d2f" },
            { "pon", "\u0d2a\u0d4a\u0d7b\u0d2a\u0d3f\u0d2f\u0d7b" },
            { "Mand", "\u0d2e\u0d7b\u0d21\u0d47\u0d2f\u0d7b" },
            { "SB", "\u0d38\u0d4b\u0d33\u0d2e\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "twq", "\u0d1f\u0d38\u0d35\u0d3e\u0d15\u0d4d\u0d15\u0d4d" },
            { "011", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "SC", "\u0d38\u0d40\u0d37\u0d46\u0d7d\u0d38\u0d4d" },
            { "SD", "\u0d38\u0d41\u0d21\u0d3e\u0d7b" },
            { "013", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f\u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "SE", "\u0d38\u0d4d\u0d35\u0d40\u0d21\u0d7b" },
            { "014", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "arc", "\u0d05\u0d30\u0d2e\u0d3e\u0d2f" },
            { "015", "\u0d09\u0d24\u0d4d\u0d24\u0d30\u0d3e\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "SG", "\u0d38\u0d3f\u0d02\u0d17\u0d2a\u0d4d\u0d2a\u0d42\u0d7c" },
            { "SH", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d39\u0d46\u0d32\u0d40\u0d28" },
            { "type.lb.strict", "\u0d28\u0d3f\u0d2f\u0d28\u0d4d\u0d24\u0d4d\u0d30\u0d3f\u0d24 \u0d30\u0d47\u0d16\u0d3e \u0d35\u0d3f\u0d2d\u0d3e\u0d1c\u0d3f \u0d36\u0d48\u0d32\u0d3f" },
            { "017", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f\u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "SI", "\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d47\u0d28\u0d3f\u0d2f" },
            { "type.nu.mymrtlng", "\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c \u0d24\u0d3e\u0d2f\u0d4d \u0d32\u0d46\u0d2f\u0d3f\u0d02\u0d17\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "018", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d47 \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "SJ", "\u0d38\u0d4d\u0d35\u0d3e\u0d7d\u0d2c\u0d3e\u0d21\u0d41\u0d02 \u0d1c\u0d3e\u0d7b \u0d2e\u0d3e\u0d2f\u0d47\u0d28\u0d41\u0d02" },
            { "019", "\u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d15\u0d7e" },
            { "SK", "\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d3e\u0d15\u0d4d\u0d2f" },
            { "SL", "\u0d38\u0d3f\u0d2f\u0d46\u0d31 \u0d32\u0d3f\u0d2f\u0d4b\u0d7a" },
            { "SM", "\u0d38\u0d3e\u0d7b \u0d2e\u0d31\u0d3f\u0d28\u0d4b" },
            { "SN", "\u0d38\u0d46\u0d28\u0d17\u0d7d" },
            { "SO", "\u0d38\u0d4b\u0d2e\u0d3e\u0d32\u0d3f\u0d2f" },
            { "arn", "\u0d2e\u0d3e\u0d2a\u0d41\u0d1a\u0d3f" },
            { "arp", "\u0d05\u0d31\u0d3e\u0d2a\u0d39\u0d4b" },
            { "type.nu.taml", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24 \u0d24\u0d2e\u0d3f\u0d34\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "SR", "\u0d38\u0d41\u0d30\u0d3f\u0d28\u0d3e\u0d02" },
            { "SS", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d38\u0d41\u0d21\u0d3e\u0d7b" },
            { "ST", "\u0d38\u0d3e\u0d35\u0d4b \u0d1f\u0d4b\u0d2e\u0d41\u0d02 \u0d2a\u0d4d\u0d30\u0d3f\u0d7b\u0d38\u0d3f\u0d2a\u0d46\u0d2f\u0d41\u0d02" },
            { "SV", "\u0d0e\u0d7d \u0d38\u0d3e\u0d7d\u0d35\u0d26\u0d4b\u0d7c" },
            { "SX", "\u0d38\u0d3f\u0d28\u0d4d\u0d31\u0d4d \u0d2e\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d46\u0d7b" },
            { "SY", "\u0d38\u0d3f\u0d31\u0d3f\u0d2f" },
            { "yao", "\u0d2f\u0d3e\u0d35\u0d4b" },
            { "SZ", "\u0d38\u0d4d\u0d35\u0d3e\u0d38\u0d3f\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d" },
            { "arw", "\u0d05\u0d31\u0d3e\u0d35\u0d15\u0d4d" },
            { "yap", "\u0d2f\u0d46\u0d2a\u0d4d\u0d2a\u0d40\u0d38\u0d4d" },
            { "TA", "\u0d1f\u0d4d\u0d30\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d7b \u0d21 \u0d15\u0d42\u0d28" },
            { "asa", "\u0d06\u0d38\u0d41" },
            { "type.ms.ussystem", "\u0d2f\u0d41\u0d0e\u0d38\u0d4d \u0d05\u0d33\u0d15\u0d4d\u0d15\u0d7d \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02" },
            { "021", "\u0d35\u0d1f\u0d15\u0d4d\u0d15\u0d7b \u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "TC", "\u0d1f\u0d7c\u0d15\u0d4d\u0d15\u0d4d\u200c\u0d38\u0d41\u0d02 \u0d15\u0d46\u0d2f\u0d4d\u200c\u0d15\u0d4d\u0d15\u0d4b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d02" },
            { "yav", "\u0d2f\u0d3e\u0d02\u0d17\u0d4d\u0d2c\u0d46\u0d7b" },
            { "TD", "\u0d1b\u0d3e\u0d21\u0d4d" },
            { "TF", "\u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d \u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d2d\u0d42\u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d02" },
            { "TG", "\u0d1f\u0d4b\u0d17\u0d4b" },
            { "TH", "\u0d24\u0d3e\u0d2f\u0d4d\u200c\u0d32\u0d3e\u0d7b\u0d21\u0d4d" },
            { "TJ", "\u0d24\u0d3e\u0d1c\u0d3f\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "029", "\u0d15\u0d30\u0d40\u0d2c\u0d3f\u0d2f\u0d7b" },
            { "TK", "\u0d1f\u0d4b\u0d15\u0d4d\u0d15\u0d46\u0d32\u0d42" },
            { "TL", "\u0d24\u0d3f\u0d2e\u0d4b\u0d7c-\u0d32\u0d46\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d46" },
            { "ybb", "\u0d2f\u0d02\u0d2c" },
            { "type.co.searchjl", "\u0d39\u0d3e\u0d02\u0d17\u0d7d \u0d2a\u0d4d\u0d30\u0d3e\u0d30\u0d02\u0d2d \u0d35\u0d4d\u0d2f\u0d1e\u0d4d\u0d1c\u0d28\u0d3e\u0d15\u0d4d\u0d37\u0d30\u0d02 \u0d2a\u0d4d\u0d30\u0d15\u0d3e\u0d30\u0d02 \u0d24\u0d3f\u0d30\u0d2f\u0d41\u0d15" },
            { "TM", "\u0d24\u0d41\u0d7c\u0d15\u0d4d\u0d15\u0d4d\u0d2e\u0d46\u0d28\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "%%BOONT", "\u0d2c\u0d42\u0d23\u0d4d\u0d1f\u0d4d\u200c\u0d32\u0d3f\u0d19\u0d4d\u0d19\u0d4d" },
            { "TN", "\u0d1f\u0d41\u0d23\u0d40\u0d37\u0d4d\u0d2f" },
            { "TO", "\u0d1f\u0d4b\u0d02\u0d17" },
            { "TR", "\u0d24\u0d41\u0d7c\u0d15\u0d4d\u0d15\u0d3f" },
            { "TT", "\u0d1f\u0d4d\u0d30\u0d3f\u0d28\u0d3f\u0d21\u0d3e\u0d21\u0d41\u0d02 \u0d1f\u0d41\u0d2c\u0d3e\u0d17\u0d4b\u0d2f\u0d41\u0d02" },
            { "TV", metaValue_TV },
            { "TW", "\u0d24\u0d3e\u0d2f\u0d4d\u200c\u0d35\u0d3e\u0d7b" },
            { "ast", "\u0d13\u0d38\u0d4d\u200c\u0d1f\u0d4d\u0d30\u0d3f\u0d2f\u0d7b" },
            { "Orkh", "\u0d12\u0d7c\u0d16\u0d4b\u0d7a" },
            { "TZ", "\u0d1f\u0d3e\u0d7b\u0d38\u0d3e\u0d28\u0d3f\u0d2f" },
            { "nmg", "\u0d15\u0d4d\u0d35\u0d3e\u0d38\u0d3f\u0d2f\u0d4b" },
            { "Zzzz", "\u0d05\u0d1c\u0d4d\u0d1e\u0d3e\u0d24 \u0d32\u0d3f\u0d2a\u0d3f" },
            { "UA", "\u0d09\u0d15\u0d4d\u0d30\u0d46\u0d2f\u0d4d\u200c\u0d7b" },
            { "rup", "\u0d06\u0d30\u0d4b\u0d2e\u0d3e\u0d28\u0d3f\u0d2f\u0d7b" },
            { "030", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d0f\u0d37\u0d4d\u0d2f" },
            { "tyv", "\u0d24\u0d41\u0d35\u0d3f\u0d28\u0d3f\u0d2f\u0d7b" },
            { "sw_CD", "\u0d15\u0d4b\u0d02\u0d17\u0d4b \u0d38\u0d4d\u0d35\u0d3e\u0d39\u0d3f\u0d32\u0d3f" },
            { "034", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d47 \u0d0f\u0d37\u0d4d\u0d2f" },
            { "hai", "\u0d39\u0d48\u0d21" },
            { "035", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d4d-\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d0f\u0d37\u0d4d\u0d2f" },
            { "UG", "\u0d09\u0d17\u0d3e\u0d23\u0d4d\u0d1f" },
            { "hak", "\u0d39\u0d3e\u0d15\u0d4d\u0d15 \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "type.co.pinyin", "\u0d2a\u0d3f\u0d7b\u200c\u0d2f\u0d3f\u0d7b \u0d15\u0d4d\u0d30\u0d2e\u0d40\u0d15\u0d30\u0d23\u0d02" },
            { "039", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d47 \u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2a\u0d4d" },
            { "Sinh", metaValue_si },
            { "UM", "\u0d2f\u0d41.\u0d0e\u0d38\u0d4d. \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d38\u0d2e\u0d42\u0d39\u0d19\u0d4d\u0d19\u0d7e" },
            { "UN", "\u0d10\u0d15\u0d4d\u0d2f\u0d30\u0d3e\u0d37\u0d4d\u0d1f\u0d4d\u0d30\u0d38\u0d2d" },
            { "US", "\u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d10\u0d15\u0d4d\u0d2f\u0d28\u0d3e\u0d1f\u0d41\u0d15\u0d7e" },
            { "haw", "\u0d39\u0d35\u0d3e\u0d2f\u0d3f\u0d2f\u0d7b" },
            { "type.co.gb2312han", "\u0d32\u0d33\u0d3f\u0d24\u0d2e\u0d3e\u0d2f \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d15\u0d4d\u0d30\u0d2e\u0d40\u0d15\u0d30\u0d23\u0d02 - \u0d1c\u0d40\u0d2c\u0d3f2312" },
            { "UY", "\u0d09\u0d31\u0d41\u0d17\u0d4d\u0d35\u0d47" },
            { "prg", "\u0d2a\u0d4d\u0d30\u0d37\u0d4d\u0d2f\u0d7b" },
            { "UZ", "\u0d09\u0d38\u0d4d\u200c\u0d2c\u0d46\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b" },
            { "tzm", "\u0d2e\u0d27\u0d4d\u0d2f \u0d05\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d32\u0d38\u0d4d \u0d1f\u0d2e\u0d3e\u0d38\u0d48\u0d31\u0d4d\u0d31\u0d4d" },
            { "type.co.stroke", "\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\u0d30\u0d4b\u0d15\u0d4d\u0d15\u0d4d \u0d15\u0d4d\u0d30\u0d2e\u0d40\u0d15\u0d30\u0d23\u0d02" },
            { "nnh", "\u0d17\u0d40\u0d02\u0d2c\u0d42\u0d7a" },
            { "VA", "\u0d35\u0d24\u0d4d\u0d24\u0d3f\u0d15\u0d4d\u0d15\u0d3e\u0d7b" },
            { "pro", "\u0d2a\u0d34\u0d2f \u0d2a\u0d4d\u0d30\u0d4a\u0d35\u0d7b\u0d37\u0d4d\u0d7d" },
            { "VC", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d35\u0d3f\u0d7b\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d41\u0d02 \u0d17\u0d4d\u0d30\u0d28\u0d46\u0d21\u0d48\u0d7b\u0d38\u0d41\u0d02" },
            { "VE", "\u0d35\u0d46\u0d28\u0d3f\u0d38\u0d4d\u0d35\u0d47\u0d32" },
            { "VG", "\u0d2c\u0d4d\u0d30\u0d3f\u0d1f\u0d4d\u0d1f\u0d40\u0d37\u0d4d \u0d35\u0d46\u0d7c\u0d1c\u0d3f\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "VI", "\u0d2f\u0d41.\u0d0e\u0d38\u0d4d. \u0d35\u0d46\u0d7c\u0d1c\u0d3f\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e" },
            { "VN", "\u0d35\u0d3f\u0d2f\u0d31\u0d4d\u0d31\u0d4d\u0d28\u0d3e\u0d02" },
            { "VU", "\u0d35\u0d28\u0d4d\u0d35\u0d3e\u0d24\u0d41" },
            { "nog", "\u0d28\u0d4b\u0d17\u0d48" },
            { "rwk", "\u0d31\u0d41\u0d35\u0d3e" },
            { "non", "\u0d2a\u0d34\u0d2f \u0d28\u0d4b\u0d34\u0d4d\u200c\u0d38\u0d4d" },
            { "053", "\u0d13\u0d38\u0d4d\u200c\u0d1f\u0d4d\u0d30\u0d47\u0d32\u0d3f\u0d2f\u0d2f\u0d41\u0d02 \u0d28\u0d4d\u0d2f\u0d42\u0d38\u0d3f\u0d32\u0d3e\u0d7b\u0d21\u0d41\u0d02" },
            { "054", "\u0d2e\u0d46\u0d32\u0d28\u0d47\u0d37\u0d4d\u0d2f" },
            { "WF", "\u0d35\u0d3e\u0d32\u0d3f\u0d38\u0d4d \u0d06\u0d28\u0d4d\u0d31\u0d4d \u0d2b\u0d4d\u0d2f\u0d42\u0d1a\u0d4d\u0d2f\u0d41\u0d28" },
            { "type.co.traditional", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24 \u0d15\u0d4d\u0d30\u0d2e\u0d40\u0d15\u0d30\u0d23\u0d02" },
            { "057", "\u0d2e\u0d48\u0d15\u0d4d\u0d30\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f\u0d7b \u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d02" },
            { "jgo", "\u0d17\u0d4b\u0d2e\u0d4d\u0d2a" },
            { "lkt", "\u0d32\u0d17\u0d4b\u0d24\u0d4d\u0d24" },
            { "type.nu.finance", "\u0d38\u0d3e\u0d2e\u0d4d\u0d2a\u0d24\u0d4d\u0d24\u0d3f\u0d15 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "type.co.compat", "\u0d05\u0d28\u0d41\u0d2f\u0d4b\u0d1c\u0d4d\u0d2f\u0d24\u0d2f\u0d4d\u200c\u0d15\u0d4d\u0d15\u0d3e\u0d2f\u0d41\u0d33\u0d4d\u0d33 \u0d2e\u0d41\u0d7b \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "wae", "\u0d35\u0d3e\u0d7e\u0d38\u0d7c" },
            { "WS", "\u0d38\u0d2e\u0d4b\u0d35" },
            { "type.nu.mtei", "\u0d2e\u0d40\u0d31\u0d4d\u0d31\u0d46\u0d2f\u0d4d \u0d2e\u0d3e\u0d2f\u0d46\u0d15\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "wal", "\u0d35\u0d4a\u0d32\u0d48\u0d31\u0d4d\u0d31" },
            { "was", "\u0d35\u0d3e\u0d37\u0d4a" },
            { "war", "\u0d35\u0d3e\u0d30\u0d47\u0d2f\u0d4d" },
            { "awa", "\u0d05\u0d35\u0d3e\u0d27\u0d3f" },
            { "061", "\u0d2a\u0d4b\u0d33\u0d3f\u0d28\u0d47\u0d37\u0d4d\u0d2f" },
            { "XK", "\u0d15\u0d4a\u0d38\u0d4b\u0d35\u0d4a" },
            { "type.nu.brah", "\u0d2c\u0d4d\u0d30\u0d3e\u0d39\u0d4d\u200c\u0d2e\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0d0e\u0d34\u0d41\u0d24\u0d2a\u0d4d\u0d2a\u0d46\u0d1f\u0d3e\u0d24\u0d4d\u0d24\u0d24\u0d4d" },
            { "Olck", "\u0d12\u0d7d \u0d1a\u0d3f\u0d15\u0d4d\u0d15\u0d3f" },
            { "wbp", "\u0d35\u0d42\u0d7e\u0d2a\u0d3f\u0d30\u0d3f" },
            { "Batk", "\u0d2c\u0d1f\u0d4d\u0d1f\u0d15\u0d4d" },
            { "Blis", "\u0d2c\u0d4d\u0d32\u0d3f\u0d38\u0d4d \u0d1a\u0d3f\u0d24\u0d4d\u0d30 \u0d32\u0d3f\u0d2a\u0d3f" },
            { "YE", "\u0d2f\u0d46\u0d2e\u0d7b" },
            { "nqo", "\u0d07\u0d7b\u0d15\u0d4b" },
            { "type.co.standard", "\u0d38\u0d3e\u0d27\u0d3e\u0d30\u0d23 \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "fan", "\u0d2b\u0d19\u0d4d" },
            { "fat", "\u0d2b\u0d3e\u0d28\u0d4d\u0d31\u0d3f" },
            { "Sgnw", "\u0d1a\u0d3f\u0d39\u0d4d\u0d28\u0d32\u0d3f\u0d2a\u0d3f" },
            { "YT", "\u0d2e\u0d2f\u0d4b\u0d1f\u0d4d\u0d1f\u0d3f" },
            { "type.nu.cham", "\u0d1a\u0d3e\u0d02 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "ZA", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23\u0d3e\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15" },
            { "type.nu.sund", "\u0d38\u0d41\u0d21\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.lb.loose", "\u0d05\u0d28\u0d3f\u0d2f\u0d28\u0d4d\u0d24\u0d4d\u0d30\u0d3f\u0d24 \u0d30\u0d47\u0d16\u0d3e \u0d35\u0d3f\u0d2d\u0d3e\u0d1c\u0d3f \u0d36\u0d48\u0d32\u0d3f" },
            { "Deva", "\u0d26\u0d47\u0d35\u0d28\u0d3e\u0d17\u0d30\u0d3f" },
            { "type.nu.geor", "\u0d1c\u0d4b\u0d7c\u0d1c\u0d3f\u0d2f\u0d7b \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "type.co.zhuyin", "\u0d1c\u0d41\u0d2f\u0d7b \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "Hira", "\u0d39\u0d3f\u0d30\u0d17\u0d3e\u0d28" },
            { "ZM", "\u0d38\u0d3e\u0d02\u0d2c\u0d3f\u0d2f" },
            { "ZW", "\u0d38\u0d3f\u0d02\u0d2c\u0d3e\u0d2c\u0d4d\u200c\u0d35\u0d47" },
            { "ZZ", "\u0d05\u0d1c\u0d4d\u0d1e\u0d3e\u0d24 \u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d02" },
            { "Runr", "\u0d31\u0d41\u0d23\u0d3f\u0d15\u0d4d" },
            { "type.ms.metric", "\u0d2e\u0d46\u0d1f\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d4d \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02" },
            { "type.ca.iso8601", "\u0d10\u0d0e\u0d38\u0d4d\u0d13 8601 \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "lol", "\u0d2e\u0d4b\u0d19\u0d4d\u0d15\u0d4b" },
            { "nso", "\u0d28\u0d4b\u0d7c\u0d24\u0d4d\u0d24\u0d47\u0d7b \u0d38\u0d4b\u0d24\u0d4b" },
            { "type.nu.telu", "\u0d24\u0d46\u0d32\u0d41\u0d19\u0d4d\u0d15\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "lou", "\u0d32\u0d42\u0d38\u0d3f\u0d2f\u0d3e\u0d28 \u0d15\u0d4d\u0d30\u0d3f\u0d2f\u0d4b\u0d7e" },
            { "loz", "\u0d32\u0d4a\u0d38\u0d3f" },
            { "jmc", "\u0d2e\u0d1a\u0d47\u0d02" },
            { "type.nu.hansfin", "\u0d32\u0d33\u0d3f\u0d24\u0d35\u0d7d\u0d15\u0d4d\u0d15\u0d30\u0d3f\u0d1a\u0d4d\u0d1a \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d27\u0d28\u0d15\u0d3e\u0d30\u0d4d\u0d2f \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "hil", "\u0d39\u0d3f\u0d32\u0d3f\u0d17\u0d2f\u0d4d\u0d28\u0d4b\u0d7a" },
            { "type.nu.arabext", "\u0d35\u0d3f\u0d2a\u0d41\u0d32\u0d40\u0d15\u0d43\u0d24 \u0d05\u0d31\u0d2c\u0d3f\u0d15\u0d4d-\u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "nus", "\u0d28\u0d41\u0d35\u0d47\u0d7c" },
            { "dak", "\u0d21\u0d15\u0d4b\u0d1f\u0d4d\u0d1f" },
            { "type.nu.fullwide", "\u0d2a\u0d42\u0d7c\u0d23 \u0d35\u0d32\u0d41\u0d2a\u0d4d\u0d2a\u0d2e\u0d41\u0d33\u0d4d\u0d33 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "hit", "\u0d39\u0d3f\u0d31\u0d4d\u0d31\u0d48\u0d31\u0d4d\u0d31\u0d4d" },
            { "dar", "\u0d21\u0d7c\u0d17\u0d4d\u0d35\u0d3e" },
            { "dav", "\u0d24\u0d48\u0d24" },
            { "Maya", "\u0d2e\u0d3e\u0d2f\u0d7b \u0d1a\u0d3f\u0d24\u0d4d\u0d30\u0d32\u0d3f\u0d2a\u0d3f" },
            { "lrc", "\u0d35\u0d1f\u0d15\u0d4d\u0d15\u0d7b \u0d32\u0d42\u0d31\u0d3f" },
            { "type.co.emoji", "\u0d07\u0d2e\u0d4b\u0d1c\u0d3f \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0d15\u0d4d\u0d32\u0d3e\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d7d \u0d28\u0d47\u0d35\u0d3e\u0d30\u0d3f" },
            { "udm", "\u0d09\u0d21\u0d4d\u0d2e\u0d41\u0d7c\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0d07\u0d38\u0d4d\u0d32\u0d3e\u0d02-\u0d05\u0d31\u0d2c\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "Limb", "\u0d32\u0d3f\u0d02\u0d2c\u0d41" },
            { "sad", "\u0d38\u0d3e\u0d7b\u0d21\u0d35\u0d47" },
            { "type.nu.roman", "\u0d31\u0d4b\u0d2e\u0d7b \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "sah", "\u0d38\u0d3e\u0d16" },
            { "type.nu.shrd", "\u0d36\u0d3e\u0d30\u0d26 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "sam", "\u0d38\u0d2e\u0d30\u0d3f\u0d2f\u0d3e\u0d15\u0d4d\u0d15\u0d3e\u0d30\u0d41\u0d1f\u0d46 \u0d05\u0d30\u0d2e\u0d3e\u0d2f" },
            { "saq", "\u0d38\u0d02\u0d2c\u0d41\u0d30\u0d41" },
            { "sas", "\u0d38\u0d38\u0d3e\u0d15\u0d4d" },
            { "sat", "\u0d38\u0d28\u0d4d\u0d24\u0d3e\u0d32\u0d3f" },
            { "Tfng", "\u0d24\u0d3f\u0d2b\u0d3f\u0d28\u0d3e\u0d17\u0d4d" },
            { "jpr", "\u0d1c\u0d42\u0d21\u0d3f\u0d2f\u0d4b-\u0d2a\u0d47\u0d7c\u0d37\u0d4d\u0d2f\u0d7b" },
            { "type.d0.npinyin", "\u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d3e\u0d2a\u0d30\u0d2e\u0d3e\u0d2f" },
            { "type.nu.native", "\u0d38\u0d4d\u0d35\u0d3e\u0d2d\u0d3e\u0d35\u0d3f\u0d15 \u0d21\u0d3f\u0d1c\u0d3f\u0d31\u0d4d\u0d31\u0d41\u0d15\u0d7e" },
            { "sba", "\u0d17\u0d02\u0d2c\u0d3e\u0d2f\u0d4d" },
            { "Guru", "\u0d17\u0d41\u0d30\u0d41\u0d2e\u0d41\u0d16\u0d3f" },
            { "lua", "\u0d32\u0d42\u0d2c-\u0d32\u0d41\u0d32\u0d41\u0d35" },
            { "type.nu.tirh", "\u0d24\u0d3f\u0d7c\u0d39\u0d41\u0d24\u0d4d\u0d24 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.d0.fwidth", "\u0d2b\u0d41\u0d7e\u0d35\u0d3f\u0d21\u0d4d\u200c\u0d24\u0d4d\u0d24\u0d3f\u0d32\u0d47\u0d15\u0d4d\u0d15\u0d4d" },
            { "sbp", "\u0d38\u0d02\u0d17\u0d41" },
            { "lui", "\u0d32\u0d42\u0d2f\u0d3f\u0d38\u0d46\u0d28\u0d4b" },
            { "nyn", "\u0d28\u0d4d\u0d2f\u0d3e\u0d7b\u0d15\u0d4b\u0d7e" },
            { "nym", "\u0d28\u0d4d\u0d2f\u0d3e\u0d02\u0d35\u0d47\u0d38\u0d3f" },
            { "lun", "\u0d32\u0d41\u0d7b\u0d21" },
            { "nyo", "\u0d28\u0d4d\u0d2f\u0d4b\u0d31\u0d4b" },
            { "luo", "\u0d32\u0d41\u0d35\u0d4b" },
            { "fil", "\u0d2b\u0d3f\u0d32\u0d3f\u0d2a\u0d4d\u0d2a\u0d3f\u0d28\u0d4b" },
            { "hmn", "\u0d2e\u0d4b\u0d19\u0d4d" },
            { "del", "\u0d26\u0d46\u0d32\u0d35\u0d47\u0d7c" },
            { "lus", "\u0d2e\u0d3f\u0d38\u0d4b" },
            { "bal", "\u0d2c\u0d32\u0d42\u0d1a\u0d3f" },
            { "den", "\u0d38\u0d4d\u0d32\u0d47\u0d35\u0d4d" },
            { "ban", metaValue_ban },
            { "uga", "\u0d09\u0d17\u0d31\u0d3f\u0d1f\u0d4d\u0d1f\u0d3f\u0d15\u0d4d" },
            { "type.nu.wara", "\u0d35\u0d31\u0d3e\u0d19\u0d4d \u0d38\u0d3f\u0d31\u0d4d\u0d31\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "luy", "\u0d32\u0d41\u0d2f\u0d3f\u0d2f" },
            { "bas", "\u0d2c\u0d38" },
            { "bax", "\u0d2c\u0d3e\u0d2e\u0d41\u0d7b" },
            { "jrb", "\u0d1c\u0d42\u0d21\u0d3f\u0d2f\u0d4b-\u0d05\u0d31\u0d2c\u0d3f\u0d15\u0d4d" },
            { "es_ES", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d38\u0d4d\u200c\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d" },
            { "nzi", "\u0d38\u0d3f\u0d2e" },
            { "sco", "\u0d38\u0d4d\u0d15\u0d4b\u0d1f\u0d4d\u0d38\u0d4d" },
            { "scn", "\u0d38\u0d3f\u0d38\u0d3f\u0d32\u0d3f\u0d2f\u0d7b" },
            { "aa", "\u0d05\u0d2b\u0d3e\u0d7c" },
            { "ab", "\u0d05\u0d2c\u0d4d\u200c\u0d16\u0d3e\u0d38\u0d3f\u0d2f\u0d7b" },
            { "ae", "\u0d05\u0d35\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3e\u0d7b" },
            { "af", "\u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d3e\u0d7b\u0d38\u0d4d" },
            { "ak", "\u0d05\u0d15\u0d3e\u0d7b\u200c" },
            { "type.nu.cakm", "\u0d1a\u0d15\u0d4d\u0d2e \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "bbj", "\u0d18\u0d4b\u0d2e\u0d3e\u0d32" },
            { "am", "\u0d05\u0d02\u0d39\u0d3e\u0d30\u0d3f\u0d15\u0d4d" },
            { "Arab", metaValue_ar },
            { "an", "\u0d05\u0d30\u0d17\u0d4b\u0d23\u0d40\u0d38\u0d4d" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d \u0d38\u0d3f\u0d32\u0d4d\u0d32\u0d2c\u0d31\u0d40\u0d38\u0d4d" },
            { "as", "\u0d06\u0d38\u0d4d\u0d38\u0d3e\u0d2e\u0d40\u0d38\u0d4d" },
            { "Lina", "\u0d38\u0d2e\u0d30\u0d47\u0d16\u0d2f\u0d3f\u0d32\u0d41\u0d33\u0d4d\u0d33 \u0d0e" },
            { "av", "\u0d05\u0d35\u0d3e\u0d30\u0d3f\u0d15\u0d4d" },
            { "Linb", "\u0d32\u0d40\u0d28\u0d3f\u0d2f\u0d7c \u0d2c\u0d3f" },
            { "sdh", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d7b \u0d15\u0d41\u0d7c\u0d26\u0d4d\u0d26\u0d3f\u0d37\u0d4d" },
            { "ay", "\u0d05\u0d2f\u0d4d\u0d2e\u0d3e\u0d31" },
            { "az", "\u0d05\u0d38\u0d7c\u0d2c\u0d48\u0d1c\u0d3e\u0d28\u0d3f" },
            { "ba", "\u0d2c\u0d37\u0d4d\u0d16\u0d3f\u0d7c" },
            { "type.co.unihan", "\u0d31\u0d3e\u0d21\u0d3f\u0d15\u0d4d\u0d15\u0d7d-\u0d38\u0d4d\u0d1f\u0d4d\u0d30\u0d4b\u0d15\u0d4d\u0d15\u0d4d \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "be", "\u0d2c\u0d46\u0d32\u0d3e\u0d31\u0d41\u0d37\u0d4d\u0d2f\u0d7b" },
            { "bg", "\u0d2c\u0d7e\u0d17\u0d47\u0d31\u0d3f\u0d2f\u0d7b" },
            { "bi", "\u0d2c\u0d3f\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d2e" },
            { "type.nu.java", "\u0d1c\u0d3e\u0d35\u0d28\u0d40\u0d38\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "bm", "\u0d2c\u0d02\u0d2c\u0d3e\u0d31" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0d21\u0d4b\u0d17\u0d4d\u0d30\u0d3f\u0d2c\u0d4d" },
            { "br", "\u0d2c\u0d4d\u0d30\u0d46\u0d1f\u0d4d\u0d1f\u0d7a" },
            { "bs", "\u0d2c\u0d4b\u0d38\u0d4d\u0d28\u0d3f\u0d2f\u0d7b" },
            { "see", "\u0d38\u0d46\u0d28\u0d47\u0d15" },
            { "Mymr", "\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c" },
            { "type.nu.laoo", "\u0d32\u0d3e\u0d35\u0d4b \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "seh", "\u0d38\u0d47\u0d28" },
            { "Nkoo", "\u0d0e\u0d7b\u0d15\u0d4b" },
            { "sel", "\u0d38\u0d46\u0d7d\u0d15\u0d2a\u0d4d" },
            { "ca", "\u0d15\u0d31\u0d4d\u0d31\u0d3e\u0d32\u0d3e\u0d7b" },
            { "ses", "\u0d15\u0d4a\u0d2f\u0d4d\u0d31\u0d3e\u0d2c\u0d4a\u0d31\u0d4b \u0d38\u0d46\u0d28\u0d4d\u0d28\u0d3f" },
            { "ce", "\u0d1a\u0d46\u0d1a\u0d7b" },
            { "ch", "\u0d1a\u0d2e\u0d4b\u0d31\u0d4b" },
            { "%%REVISED", "\u0d2a\u0d30\u0d3f\u0d37\u0d4d\u0d15\u0d4d\u0d15\u0d30\u0d3f\u0d1a\u0d4d\u0d1a \u0d32\u0d3f\u0d2a\u0d3f" },
            { "co", "\u0d15\u0d4b\u0d7c\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d7b" },
            { "Orya", metaValue_or },
            { "cr", "\u0d15\u0d4d\u0d30\u0d40" },
            { "cs", "\u0d1a\u0d46\u0d15\u0d4d\u0d15\u0d4d" },
            { "cu", "\u0d1a\u0d7c\u0d1a\u0d4d\u0d1a\u0d4d \u0d38\u0d4d\u0d32\u0d3e\u0d35\u0d3f\u0d15\u0d4d" },
            { "cv", "\u0d1a\u0d41\u0d35\u0d3e\u0d37\u0d4d" },
            { "cy", "\u0d35\u0d46\u0d7d\u0d37\u0d4d" },
            { "type.nu.ethi", "\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d3f\u0d15\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "Yiii", "\u0d2f\u0d3f" },
            { "da", "\u0d21\u0d3e\u0d28\u0d3f\u0d37\u0d4d" },
            { "pt_PT", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d40\u0d38\u0d4d" },
            { "de", "\u0d1c\u0d7c\u0d2e\u0d4d\u0d2e\u0d7b" },
            { "type.cf.standard", "\u0d38\u0d3e\u0d27\u0d3e\u0d30\u0d23 \u0d15\u0d31\u0d7b\u0d38\u0d3f \u0d2b\u0d4b\u0d7c\u0d2e\u0d3e\u0d31\u0d4d\u0d31\u0d4d" },
            { "bej", "\u0d2c\u0d47\u0d1c" },
            { "din", "\u0d26\u0d3f\u0d7b\u0d15" },
            { "Bugi", metaValue_bug },
            { "bem", "\u0d2c\u0d47\u0d02\u0d2c" },
            { "sga", "\u0d2a\u0d34\u0d2f \u0d10\u0d31\u0d3f\u0d37\u0d4d" },
            { "type.nu.mong", "\u0d2e\u0d02\u0d17\u0d4b\u0d33\u0d3f\u0d2f\u0d7b \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "dv", "\u0d26\u0d3f\u0d35\u0d46\u0d39\u0d3f" },
            { "es_419", "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d7b \u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d4d\u200c\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d" },
            { "dz", "\u0d38\u0d4b\u0d19\u0d4d\u0d15" },
            { "bez", "\u0d2c\u0d46\u0d28\u0d3e" },
            { "type.ca.chinese", "\u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "dje", "\u0d38\u0d3e\u0d7c\u0d2e\u0d4d\u0d2e" },
            { "type.nu.grek", "\u0d17\u0d4d\u0d30\u0d40\u0d15\u0d4d\u0d15\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "ee", "\u0d2f\u0d42\u0d35\u0d4d" },
            { "bfd", "\u0d2c\u0d3e\u0d2b\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "type.lb.normal", "\u0d38\u0d3e\u0d27\u0d3e\u0d30\u0d23 \u0d30\u0d47\u0d16\u0d3e \u0d35\u0d3f\u0d2d\u0d3e\u0d1c\u0d3f \u0d36\u0d48\u0d32\u0d3f" },
            { "ro_MD", "\u0d2e\u0d4b\u0d7e\u0d21\u0d3e\u0d35\u0d3f\u0d2f\u0d7b" },
            { "el", metaValue_el },
            { "en", "\u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "eo", "\u0d0e\u0d38\u0d4d\u200c\u0d2a\u0d30\u0d3e\u0d28\u0d4d\u0d31\u0d4b" },
            { "type.co.big5han", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24 \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d15\u0d4d\u0d30\u0d2e\u0d40\u0d15\u0d30\u0d23\u0d02 - \u0d2c\u0d3f\u0d17\u0d4d5" },
            { "es", "\u0d38\u0d4d\u200c\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d" },
            { "et", "\u0d0e\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4b\u0d23\u0d3f\u0d2f\u0d7b" },
            { "Hanb", "\u0d39\u0d7b\u0d2c\u0d4d" },
            { "eu", "\u0d2c\u0d3e\u0d38\u0d4d\u200c\u0d15\u0d4d" },
            { "Buhd", "\u0d2c\u0d41\u0d39\u0d3f\u0d21\u0d4d" },
            { "Hang", "\u0d39\u0d3e\u0d02\u0d17\u0d41\u0d7d" },
            { "Samr", "\u0d38\u0d2e\u0d30\u0d3f\u0d2f" },
            { "shi", "\u0d24\u0d3e\u0d1a\u0d4d\u0d1a\u0d32\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "hsb", "\u0d05\u0d2a\u0d4d\u0d2a\u0d7c \u0d38\u0d4b\u0d7c\u0d2c\u0d3f\u0d2f\u0d7b" },
            { "Hani", "\u0d39\u0d3e\u0d7b" },
            { "shn", "\u0d37\u0d3e\u0d7b" },
            { "Hano", "\u0d39\u0d28\u0d41\u0d28\u0d42" },
            { "fa", "\u0d2a\u0d47\u0d7c\u0d37\u0d4d\u0d2f\u0d7b" },
            { "Hans", "\u0d32\u0d33\u0d3f\u0d24\u0d35\u0d7d\u0d15\u0d4d\u0d15\u0d30\u0d3f\u0d1a\u0d4d\u0d1a\u0d24\u0d4d" },
            { "type.nu.latn", "\u0d2a\u0d1f\u0d3f\u0d1e\u0d4d\u0d1e\u0d3e\u0d31\u0d7b \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "Hant", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24\u0d02" },
            { "ff", "\u0d2b\u0d41\u0d32" },
            { "shu", "\u0d1a\u0d3e\u0d21\u0d3f\u0d2f\u0d7b \u0d05\u0d31\u0d2c\u0d3f" },
            { "hsn", "\u0d37\u0d4d\u0d2f\u0d3e\u0d19\u0d4d \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "fi", "\u0d2b\u0d3f\u0d28\u0d4d\u0d28\u0d3f\u0d37\u0d4d" },
            { "fj", "\u0d2b\u0d3f\u0d1c\u0d3f\u0d2f\u0d7b" },
            { "fon", "\u0d2b\u0d4b\u0d7b" },
            { "bgn", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d2c\u0d32\u0d42\u0d1a\u0d3f" },
            { "yue", "\u0d15\u0d3e\u0d28\u0d4d\u0d31\u0d23\u0d40\u0d38\u0d4d" },
            { "fo", "\u0d2b\u0d3e\u0d31\u0d4b\u0d38\u0d4d" },
            { "type.m0.bgn", "\u0d2f\u0d41.\u0d0e\u0d38\u0d4d. BGN \u0d32\u0d3f\u0d2a\u0d4d\u0d2f\u0d28\u0d4d\u0d24\u0d30\u0d23\u0d02" },
            { "umb", "\u0d09\u0d02\u0d2c\u0d41\u0d28\u0d4d\u0d26\u0d41" },
            { "fr", "\u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "sid", "\u0d38\u0d3f\u0d21\u0d3e\u0d2e\u0d4b" },
            { "fy", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d2b\u0d4d\u0d30\u0d3f\u0d37\u0d3f\u0d2f\u0d7b" },
            { "ga", "\u0d10\u0d31\u0d3f\u0d37\u0d4d" },
            { "gd", "\u0d38\u0d4d\u0d15\u0d4b\u0d1f\u0d4d\u0d1f\u0d3f\u0d37\u0d4d \u0d17\u0d48\u0d32\u0d3f\u0d15\u0d4d" },
            { "gl", "\u0d17\u0d32\u0d40\u0d37\u0d4d\u0d2f\u0d7b" },
            { "gn", "\u0d17\u0d4d\u0d35\u0d30\u0d28\u0d40" },
            { "bho", "\u0d2d\u0d4b\u0d1c\u0d4d\u200c\u0d2a\u0d41\u0d30\u0d3f" },
            { "und", "\u0d05\u0d1c\u0d4d\u0d1e\u0d3e\u0d24 \u0d2d\u0d3e\u0d37" },
            { "type.ca.ethiopic-amete-alem", "\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d3f\u0d15\u0d4d \u0d05\u0d2e\u0d46\u0d24\u0d46 \u0d05\u0d32\u0d46\u0d02 \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0d07\u0d38\u0d4d\u0d32\u0d3e\u0d02-\u0d1c\u0d4d\u0d2f\u0d4b\u0d24\u0d3f\u0d37 \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "gv", "\u0d2e\u0d3e\u0d7b\u0d38\u0d4d" },
            { "type.nu.osma", "\u0d12\u0d38\u0d4d\u200c\u0d2e\u0d3e\u0d28\u0d4d\u0d2f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "ha", "\u0d39\u0d57\u0d38" },
            { "he", metaValue_he },
            { "hi", "\u0d39\u0d3f\u0d28\u0d4d\u0d26\u0d3f" },
            { "hup", "\u0d39\u0d42\u0d2a" },
            { "bik", "\u0d2c\u0d3f\u0d15\u0d4b\u0d7d" },
            { "bin", "\u0d2c\u0d3f\u0d28\u0d3f" },
            { "ho", "\u0d39\u0d3f\u0d30\u0d3f \u0d2e\u0d4b\u0d24\u0d41" },
            { "hr", "\u0d15\u0d4d\u0d30\u0d4a\u0d2f\u0d47\u0d37\u0d4d\u0d2f\u0d7b" },
            { "ht", "\u0d39\u0d46\u0d2f\u0d4d\u200c\u0d24\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d3f\u0d2f\u0d4b\u0d7e" },
            { "hu", "\u0d39\u0d02\u0d17\u0d47\u0d31\u0d3f\u0d2f\u0d7b" },
            { "hy", metaValue_hy },
            { "hz", "\u0d39\u0d46\u0d30\u0d47\u0d30\u0d4a" },
            { "frc", "\u0d15\u0d47\u0d1c\u0d7a \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "%%FONIPA", "\u0d10\u0d2a\u0d3f\u200c\u0d0e \u0d38\u0d4d\u0d35\u0d28\u0d35\u0d4d\u0d2f\u0d35\u0d38\u0d4d\u0d25" },
            { "ia", "\u0d07\u0d28\u0d4d\u0d31\u0d7c\u0d32\u0d3f\u0d02\u0d17\u0d4d\u0d35" },
            { "Jamo", "\u0d1c\u0d3e\u0d2e\u0d4b" },
            { "id", "\u0d07\u0d28\u0d4d\u0d24\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f\u0d7b" },
            { "type.nu.tibt", "\u0d1f\u0d3f\u0d2c\u0d31\u0d4d\u0d31\u0d7b \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "ie", "\u0d07\u0d28\u0d4d\u0d31\u0d7c\u0d32\u0d3f\u0d02\u0d17\u0d4d\u0d35\u0d47" },
            { "ig", "\u0d07\u0d17\u0d4d\u0d2c\u0d4b" },
            { "ii", "\u0d37\u0d41\u0d35\u0d3e\u0d7b\u0d2f\u0d3f" },
            { "frm", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "ik", "\u0d07\u0d28\u0d41\u0d2a\u0d3f\u0d2f\u0d3e\u0d15\u0d4d" },
            { "fro", "\u0d2a\u0d34\u0d2f \u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "io", "\u0d07\u0d21\u0d4b" },
            { "frs", "\u0d08\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d47\u0d7a \u0d2b\u0d4d\u0d30\u0d3f\u0d37\u0d4d\u0d2f\u0d7b" },
            { "frr", "\u0d28\u0d4b\u0d7c\u0d24\u0d4d\u0d24\u0d47\u0d7b \u0d2b\u0d4d\u0d30\u0d3f\u0d37\u0d4d\u0d2f\u0d7b" },
            { "is", "\u0d10\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d7b\u0d21\u0d3f\u0d15\u0d4d" },
            { "it", "\u0d07\u0d31\u0d4d\u0d31\u0d3e\u0d32\u0d3f\u0d2f\u0d7b" },
            { "iu", "\u0d07\u0d28\u0d41\u0d15\u0d4d\u0d31\u0d4d\u0d31\u0d3f\u0d31\u0d4d\u0d31\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "\u0d38\u0d30\u0d24\u0d3f" },
            { "doi", "\u0d21\u0d4b\u0d17\u0d4d\u0d30\u0d3f" },
            { "type.nu.lepc", "\u0d32\u0d46\u0d2a\u0d4d\u200c\u0d1a \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "bkm", "\u0d15\u0d4b\u0d02" },
            { "sma", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d2e\u0d3f" },
            { "jv", "\u0d1c\u0d3e\u0d35\u0d3e\u0d28\u0d40\u0d38\u0d4d" },
            { "Shaw", "\u0d37\u0d3e\u0d35\u0d3f\u0d2f\u0d7b" },
            { "mad", "\u0d2e\u0d26\u0d41\u0d30\u0d47\u0d38\u0d47" },
            { "smj", "\u0d32\u0d42\u0d32\u0d40 \u0d38\u0d2e\u0d3f" },
            { "mag", "\u0d2e\u0d17\u0d3e\u0d39\u0d3f" },
            { "maf", "\u0d2e\u0d3e\u0d2b" },
            { "mai", "\u0d2e\u0d48\u0d25\u0d3f\u0d32\u0d3f" },
            { "smn", "\u0d07\u0d28\u0d3e\u0d30\u0d3f \u0d38\u0d2e\u0d3f" },
            { "ka", "\u0d1c\u0d4b\u0d7c\u0d1c\u0d3f\u0d2f\u0d7b" },
            { "bla", "\u0d38\u0d3f\u0d15\u0d4d\u0d38\u0d3f\u0d15" },
            { "mak", "\u0d2e\u0d15\u0d3e\u0d38\u0d7c" },
            { "wuu", "\u0d35\u0d41 \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "sms", "\u0d38\u0d4d\u0d15\u0d4b\u0d7e\u0d1f\u0d4d\u0d1f\u0d4d \u0d38\u0d2e\u0d3f" },
            { "man", "\u0d2e\u0d23\u0d4d\u0d21\u0d3f\u0d7b\u0d17\u0d4b" },
            { "kg", "\u0d15\u0d4b\u0d02\u0d17\u0d4b" },
            { "Goth", "\u0d17\u0d4b\u0d25\u0d3f\u0d15\u0d4d" },
            { "ki", "\u0d15\u0d3f\u0d15\u0d42\u0d2f\u0d41" },
            { "mas", "\u0d2e\u0d38\u0d3e\u0d2f\u0d4d" },
            { "kj", "\u0d15\u0d4d\u0d35\u0d3e\u0d28\u0d4d\u0d2f\u0d2e" },
            { "kk", "\u0d15\u0d38\u0d3e\u0d16\u0d4d" },
            { "kl", "\u0d15\u0d32\u0d3e\u0d32\u0d4d\u0d32\u0d3f\u0d38\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0d15\u0d28\u0d42\u0d31\u0d3f" },
            { "ks", "\u0d15\u0d3e\u0d36\u0d4d\u200c\u0d2e\u0d40\u0d30\u0d3f" },
            { "Cirt", "\u0d1a\u0d3f\u0d7c\u0d24\u0d4d\u0d24\u0d4d" },
            { "Lepc", "\u0d32\u0d46\u0d2a\u0d4d\u0d1a" },
            { "Avst", "\u0d05\u0d35\u0d46\u0d38\u0d4d\u0d25\u0d7b" },
            { "ku", "\u0d15\u0d41\u0d7c\u0d26\u0d4d\u0d26\u0d3f\u0d37\u0d4d" },
            { "kv", "\u0d15\u0d4b\u0d2e\u0d3f" },
            { "kw", "\u0d15\u0d4b\u0d7c\u0d23\u0d3f\u0d37\u0d4d" },
            { "ky", "\u0d15\u0d3f\u0d7c\u0d17\u0d3f\u0d38\u0d4d" },
            { "snk", "\u0d38\u0d4b\u0d23\u0d3f\u0d7b\u0d15\u0d46" },
            { "la", metaValue_la },
            { "lb", "\u0d32\u0d15\u0d4d\u200c\u0d38\u0d02\u0d2c\u0d7c\u0d17\u0d3f\u0d37\u0d4d" },
            { "type.nu.mlym", "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "lg", "\u0d17\u0d3e\u0d23\u0d4d\u0d1f" },
            { "Roro", "\u0d31\u0d4a\u0d02\u0d17\u0d4b\u0d31\u0d4a\u0d02\u0d17\u0d4b" },
            { "li", "\u0d32\u0d3f\u0d02\u0d2c\u0d7c\u0d17\u0d3f\u0d37\u0d4d" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0d32\u0d3f\u0d02\u0d17\u0d3e\u0d32" },
            { "fur", "\u0d2b\u0d4d\u0d30\u0d3f\u0d2f\u0d41\u0d32\u0d3f\u0d2f\u0d3e\u0d7b" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0d2c\u0d4d\u0d30\u0d3f\u0d1f\u0d4d\u0d1f\u0d40\u0d37\u0d4d \u0d05\u0d33\u0d15\u0d4d\u0d15\u0d7d \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02" },
            { "type.nu.lana", "\u0d24\u0d3e\u0d2f\u0d4d \u0d24\u0d3e\u0d02 \u0d39\u0d4b\u0d31 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "lt", "\u0d32\u0d3f\u0d24\u0d4d\u0d35\u0d3e\u0d28\u0d3f\u0d2f\u0d7b" },
            { "lu", "\u0d32\u0d41\u0d2c-\u0d15\u0d31\u0d4d\u0d31\u0d02\u0d17" },
            { "lv", "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d4d\u0d35\u0d3f\u0d2f\u0d7b" },
            { "sog", "\u0d38\u0d4b\u0d1c\u0d3f\u0d21\u0d3f\u0d2f\u0d7b" },
            { "mg", "\u0d2e\u0d32\u0d17\u0d3e\u0d38\u0d3f" },
            { "mh", "\u0d2e\u0d3e\u0d7c\u0d37\u0d32\u0d4d\u0d32\u0d40\u0d38\u0d4d" },
            { "type.co.ducet", "\u0d38\u0d4d\u0d25\u0d3f\u0d30 \u0d2f\u0d42\u0d23\u0d3f\u0d15\u0d4b\u0d21\u0d4d \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "mi", "\u0d2e\u0d35\u0d4b\u0d31\u0d3f" },
            { "mk", "\u0d2e\u0d3e\u0d38\u0d3f\u0d21\u0d4b\u0d23\u0d3f\u0d2f\u0d7b" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0d2e\u0d31\u0d3e\u0d24\u0d4d\u0d24\u0d3f" },
            { "ms", "\u0d2e\u0d32\u0d46\u0d2f\u0d4d" },
            { "mt", "\u0d2e\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f\u0d40\u0d38\u0d4d" },
            { "my", "\u0d2c\u0d7c\u0d2e\u0d40\u0d38\u0d4d" },
            { "Saur", "\u0d38\u0d57\u0d30\u0d3e\u0d37\u0d4d\u0d1f\u0d4d\u0d30" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0d2e\u0d4b\u0d15\u0d4d\u0d37" },
            { "mde", "\u0d2e\u0d3e\u0d2c" },
            { "dsb", "\u0d32\u0d4b\u0d35\u0d7c \u0d38\u0d4b\u0d7c\u0d2c\u0d3f\u0d2f\u0d7b" },
            { "Armi", "\u0d05\u0d7c\u0d2e\u0d3f" },
            { "na", metaValue_NR },
            { "type.co.search", "\u0d2a\u0d4a\u0d24\u0d41\u0d35\u0d3e\u0d2f \u0d06\u0d35\u0d36\u0d4d\u0d2f\u0d24\u0d4d\u0d24\u0d3f\u0d28\u0d41\u0d33\u0d4d\u0d33 \u0d24\u0d3f\u0d30\u0d2f\u0d7d" },
            { "nb", "\u0d28\u0d4b\u0d7c\u0d35\u0d40\u0d1c\u0d3f\u0d2f\u0d7b \u0d2c\u0d41\u0d15\u0d4d\u200c\u0d2e\u0d7d" },
            { "nd", "\u0d28\u0d4b\u0d7c\u0d24\u0d4d\u0d24\u0d4d \u0d21\u0d46\u0d2c\u0d3f\u0d7e" },
            { "ne", "\u0d28\u0d47\u0d2a\u0d4d\u0d2a\u0d3e\u0d33\u0d3f" },
            { "ng", "\u0d21\u0d4b\u0d19\u0d4d\u0d15" },
            { "mdr", "\u0d2e\u0d23\u0d4d\u0d21\u0d3e\u0d7c" },
            { "nl", "\u0d21\u0d1a\u0d4d\u0d1a\u0d4d" },
            { "nn", "\u0d28\u0d4b\u0d7c\u0d35\u0d40\u0d1c\u0d3f\u0d2f\u0d7b \u0d28\u0d48\u0d28\u0d4b\u0d7c\u0d15\u0d4d\u200c\u0d38\u0d4d" },
            { "no", "\u0d28\u0d4b\u0d7c\u0d35\u0d40\u0d1c\u0d3f\u0d2f\u0d7b" },
            { "nr", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d28\u0d46\u0d21\u0d3f\u0d2c\u0d3f\u0d7e" },
            { "type.nu.modi", "\u0d2e\u0d4b\u0d21\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "nv", "\u0d28\u0d35\u0d3e\u0d1c\u0d4b" },
            { "kaa", "\u0d15\u0d30-\u0d15\u0d3e\u0d7d\u0d2a\u0d4d\u0d2a\u0d15\u0d4d" },
            { "ny", "\u0d28\u0d4d\u0d2f\u0d7b\u0d1c" },
            { "kac", "\u0d15\u0d3e\u0d1a\u0d3f\u0d7b" },
            { "kab", "\u0d15\u0d2c\u0d48\u0d7d" },
            { "oc", "\u0d13\u0d15\u0d4d\u200c\u0d38\u0d3f\u0d31\u0d4d\u0d31\u0d7b" },
            { "kaj", "\u0d1c\u0d4d\u0d1c\u0d41" },
            { "kam", "\u0d15\u0d02\u0d2c" },
            { "men", "\u0d2e\u0d46\u0d7b\u0d21\u0d46" },
            { "oj", "\u0d13\u0d1c\u0d3f\u0d2c\u0d4d\u0d35\u0d3e" },
            { "mer", "\u0d2e\u0d47\u0d30\u0d41" },
            { "type.nu.armn", "\u0d05\u0d7c\u0d2e\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "om", "\u0d12\u0d31\u0d4b\u0d2e\u0d4b" },
            { "kaw", "\u0d15\u0d3e\u0d35\u0d3f" },
            { "or", metaValue_or },
            { "os", "\u0d12\u0d38\u0d4d\u0d38\u0d46\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d" },
            { "kbd", "\u0d15\u0d2c\u0d7c\u0d21\u0d3f\u0d2f\u0d3e\u0d7b" },
            { "mfe", "\u0d2e\u0d4a\u0d31\u0d3f\u0d38\u0d3f\u0d7b" },
            { "srn", "\u0d36\u0d4d\u0d30\u0d3e\u0d28\u0d7b \u0d21\u0d4b\u0d19\u0d4d\u0d15\u0d4b" },
            { "pa", "\u0d2a\u0d1e\u0d4d\u0d1a\u0d3e\u0d2c\u0d3f" },
            { "dua", "\u0d26\u0d4d\u0d35\u0d3e\u0d32" },
            { "srr", "\u0d38\u0d46\u0d31\u0d7c" },
            { "kbl", "\u0d15\u0d28\u0d46\u0d02\u0d2c\u0d41" },
            { "pi", "\u0d2a\u0d3e\u0d32\u0d3f" },
            { "pl", "\u0d2a\u0d4b\u0d33\u0d3f\u0d37\u0d4d" },
            { "dum", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f \u0d21\u0d1a\u0d4d\u0d1a\u0d4d" },
            { "type.nu.saur", "\u0d38\u0d57\u0d30\u0d3e\u0d37\u0d4d\u200c\u0d1f\u0d4d\u0d30 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.ca.dangi", "\u0d21\u0d3e\u0d02\u0d17\u0d3f \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "ps", "\u0d2a\u0d37\u0d4d\u200c\u0d24\u0d4b" },
            { "pt", "\u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d40\u0d38\u0d4d" },
            { "mga", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f \u0d10\u0d31\u0d3f\u0d37\u0d4d" },
            { "key.co", "\u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "pt_BR", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d40\u0d38\u0d4d" },
            { "kcg", "\u0d1f\u0d4d\u0d2f\u0d3e\u0d2a\u0d4d" },
            { "mgh", "\u0d2e\u0d3e\u0d16\u0d41\u0d35\u0d3e-\u0d2e\u0d40\u0d24\u0d4d\u0d24\u0d4b" },
            { "key.cf", "\u0d15\u0d31\u0d7b\u0d38\u0d3f \u0d2b\u0d4b\u0d7c\u0d2e\u0d3e\u0d31\u0d4d\u0d31\u0d4d" },
            { "type.nu.nkoo", "\u0d0e\u0d7b\u0d15\u0d4b \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "bra", "\u0d2c\u0d4d\u0d30\u0d1c\u0d4d" },
            { "key.ca", "\u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0d2e\u0d47\u0d24\u0d4d\u0d24\u0d3e" },
            { "type.hc.h23", "24 \u0d2e\u0d23\u0d3f\u0d15\u0d4d\u0d15\u0d42\u0d7c \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02 (0\u201323)" },
            { "type.hc.h24", "24 \u0d2e\u0d23\u0d3f\u0d15\u0d4d\u0d15\u0d42\u0d7c \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02 (1\u201324)" },
            { "ssy", "\u0d38\u0d3e\u0d39\u0d4b" },
            { "type.nu.mymr", "\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "qu", "\u0d15\u0d4d\u0d35\u0d46\u0d1a\u0d4d\u0d1a\u0d41\u0d35" },
            { "zap", "\u0d38\u0d3e\u0d2a\u0d4d\u0d2a\u0d4b\u0d1f\u0d46\u0d15\u0d4d" },
            { "brx", "\u0d2c\u0d4b\u0d21\u0d4b" },
            { "Lana", "\u0d32\u0d28\u0d4d\u0d28" },
            { "kde", "\u0d2e\u0d15\u0d4d\u0d15\u0d4b\u0d23\u0d4d\u0d1f\u0d46" },
            { "Ethi", "\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d3f\u0d15\u0d4d" },
            { "type.hc.h12", "12 \u0d2e\u0d23\u0d3f\u0d15\u0d4d\u0d15\u0d42\u0d7c \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02 (1\u201312)" },
            { "type.hc.h11", "12 \u0d2e\u0d23\u0d3f\u0d15\u0d4d\u0d15\u0d42\u0d7c \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02 (0\u201311)" },
            { "rm", "\u0d31\u0d4a\u0d2e\u0d3e\u0d1e\u0d4d\u0d1a\u0d4d" },
            { "rn", "\u0d31\u0d41\u0d23\u0d4d\u0d1f\u0d3f" },
            { "key.cu", "\u0d28\u0d3e\u0d23\u0d2f\u0d02" },
            { "ro", "\u0d31\u0d4a\u0d2e\u0d3e\u0d28\u0d3f\u0d2f\u0d7b" },
            { "type.nu.orya", "\u0d12\u0d21\u0d3f\u0d2f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.nu.hanidec", "\u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d26\u0d36\u0d3e\u0d02\u0d36 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "ru", "\u0d31\u0d37\u0d4d\u0d2f\u0d7b" },
            { "bss", "\u0d05\u0d15\u0d4d\u0d15\u0d42\u0d38\u0d4d" },
            { "rw", "\u0d15\u0d3f\u0d28\u0d4d\u0d2f\u0d3e\u0d7c\u0d35\u0d3e\u0d23\u0d4d\u0d1f" },
            { "zbl", "\u0d2c\u0d4d\u0d32\u0d3f\u0d38\u0d4d\u0d38\u0d3f\u0d02\u0d2c\u0d7d\u0d38\u0d4d" },
            { "kea", "\u0d15\u0d2c\u0d41\u0d35\u0d46\u0d7c\u0d26\u0d3f\u0d2f\u0d3e\u0d28\u0d41" },
            { "mic", "\u0d2e\u0d3f\u0d15\u0d4d\u0d2e\u0d3e\u0d15\u0d4d" },
            { "suk", "\u0d38\u0d41\u0d15\u0d41\u0d2e" },
            { "en_AU", "\u0d13\u0d38\u0d4d\u200c\u0d1f\u0d4d\u0d30\u0d47\u0d32\u0d3f\u0d2f\u0d7b \u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "sa", "\u0d38\u0d02\u0d38\u0d4d\u200c\u0d15\u0d43\u0d24\u0d02" },
            { "sc", "\u0d38\u0d7c\u0d21\u0d3f\u0d28\u0d3f\u0d2f\u0d3e\u0d7b" },
            { "sus", "\u0d38\u0d41\u0d38\u0d41" },
            { "sd", "\u0d38\u0d3f\u0d28\u0d4d\u0d27\u0d3f" },
            { "se", "\u0d35\u0d1f\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d2e\u0d3f" },
            { "min", "\u0d2e\u0d3f\u0d28\u0d3e\u0d19\u0d4d\u0d15\u0d2c\u0d57" },
            { "sg", "\u0d38\u0d3e\u0d02\u0d17\u0d4b" },
            { "sh", "\u0d38\u0d46\u0d7c\u0d2c\u0d4b-\u0d15\u0d4d\u0d30\u0d4a\u0d2f\u0d47\u0d37\u0d4d\u0d2f\u0d7b" },
            { "si", metaValue_si },
            { "sux", "\u0d38\u0d41\u0d2e\u0d47\u0d30\u0d3f\u0d2f\u0d7b" },
            { "sk", "\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d3e\u0d15\u0d4d" },
            { "sl", "\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d47\u0d28\u0d3f\u0d2f\u0d7b" },
            { "sm", "\u0d38\u0d2e\u0d4b\u0d35\u0d7b" },
            { "sn", "\u0d37\u0d4b\u0d23" },
            { "so", "\u0d38\u0d4b\u0d2e\u0d3e\u0d32\u0d3f" },
            { "type.nu.arab", "\u0d05\u0d31\u0d2c\u0d3f\u0d15\u0d4d-\u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "sq", "\u0d05\u0d7d\u0d2c\u0d47\u0d28\u0d3f\u0d2f\u0d7b" },
            { "sr", "\u0d38\u0d46\u0d7c\u0d2c\u0d3f\u0d2f\u0d7b" },
            { "ss", "\u0d38\u0d4d\u0d35\u0d3e\u0d31\u0d4d\u0d31\u0d3f" },
            { "type.cf.account", "\u0d05\u0d15\u0d4d\u0d15\u0d57\u0d23\u0d4d\u0d1f\u0d3f\u0d02\u0d17\u0d4d \u0d15\u0d31\u0d7b\u0d38\u0d3f \u0d2b\u0d4b\u0d7c\u0d2e\u0d3e\u0d31\u0d4d\u0d31\u0d4d" },
            { "st", "\u0d24\u0d46\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d4b\u0d24\u0d4b" },
            { "Java", "\u0d1c\u0d3e\u0d35\u0d28\u0d40\u0d38\u0d4d" },
            { "su", "\u0d38\u0d41\u0d23\u0d4d\u0d1f\u0d3e\u0d28\u0d40\u0d38\u0d4d" },
            { "%%NEDIS", "\u0d28\u0d47\u0d31\u0d4d\u0d31\u0d3f\u0d38\u0d4b\u0d7a \u0d2a\u0d4d\u0d30\u0d3e\u0d26\u0d47\u0d36\u0d3f\u0d15\u0d30\u0d42\u0d2a\u0d02" },
            { "sv", "\u0d38\u0d4d\u0d35\u0d40\u0d21\u0d3f\u0d37\u0d4d" },
            { "sw", "\u0d38\u0d4d\u0d35\u0d3e\u0d39\u0d3f\u0d32\u0d3f" },
            { "type.nu.hantfin", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24 \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d27\u0d28\u0d15\u0d3e\u0d30\u0d4d\u0d2f \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "ibb", "\u0d07\u0d2c\u0d40\u0d2c\u0d3f\u0d2f\u0d4b" },
            { "iba", "\u0d07\u0d2c\u0d3e\u0d7b" },
            { "ta", metaValue_ta },
            { "142", "\u0d0f\u0d37\u0d4d\u0d2f" },
            { "bua", "\u0d2c\u0d41\u0d31\u0d3f\u0d2f\u0d24\u0d4d\u0d24\u0d4d" },
            { "143", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f\u0d47\u0d37\u0d4d\u0d2f" },
            { "te", metaValue_te },
            { "145", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e\u0d47\u0d37\u0d4d\u0d2f" },
            { "tg", "\u0d24\u0d3e\u0d1c\u0d3f\u0d15\u0d4d" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u0d1f\u0d48\u0d17\u0d4d\u0d30\u0d3f\u0d28\u0d4d\u0d2f" },
            { "kfo", "\u0d15\u0d4b\u0d31\u0d4b" },
            { "en_CA", "\u0d15\u0d28\u0d47\u0d21\u0d3f\u0d2f\u0d7b \u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d" },
            { "tk", "\u0d24\u0d41\u0d7c\u0d15\u0d4d\u200c\u0d2e\u0d46\u0d7b" },
            { "tl", "\u0d24\u0d17\u0d3e\u0d32\u0d4b\u0d17\u0d4d" },
            { "tn", "\u0d38\u0d4d\u0d35\u0d3e\u0d28" },
            { "to", "\u0d1f\u0d4b\u0d02\u0d17\u0d7b" },
            { "bum", "\u0d2c\u0d41\u0d33\u0d41" },
            { "dyo", "\u0d2f\u0d4b\u0d32-\u0d2b\u0d4b\u0d28\u0d4d\u0d2f\u0d3f" },
            { "type.nu.jpan", "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "tr", "\u0d1f\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d37\u0d4d" },
            { "ts", "\u0d38\u0d4b\u0d02\u0d17" },
            { "swb", "\u0d15\u0d4a\u0d2e\u0d4b\u0d31\u0d3f\u0d2f\u0d7b" },
            { "Cakm", "\u0d1a\u0d15\u0d02" },
            { "tt", "\u0d1f\u0d3e\u0d1f\u0d4d\u0d1f\u0d7c" },
            { "dyu", "\u0d26\u0d4d\u0d35\u0d48\u0d32" },
            { "tw", "\u0d1f\u0d4d\u0d35\u0d3f" },
            { "ty", "\u0d24\u0d3e\u0d39\u0d3f\u0d24\u0d3f\u0d2f\u0d7b" },
            { "150", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2a\u0d4d" },
            { "151", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2a\u0d4d" },
            { "type.nu.mathsanb", "\u0d17\u0d23\u0d3f\u0d24 \u0d38\u0d3e\u0d7b\u0d38\u0d4d\u200c-\u0d38\u0d46\u0d30\u0d40\u0d2b\u0d4d \u0d2c\u0d4b\u0d7e\u0d21\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "154", "\u0d35\u0d1f\u0d15\u0d4d\u0d15\u0d47 \u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2a\u0d4d" },
            { "dzg", "\u0d21\u0d3e\u0d38\u0d3e\u0d17" },
            { "155", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2a\u0d4d" },
            { "ug", "\u0d09\u0d2f\u0d4d\u0d18\u0d41\u0d7c" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0d2a\u0d34\u0d2f \u0d07\u0d31\u0d4d\u0d31\u0d3e\u0d32\u0d3f\u0d2f\u0d7b" },
            { "Zyyy", "\u0d38\u0d3e\u0d27\u0d3e\u0d30\u0d23" },
            { "uk", "\u0d09\u0d15\u0d4d\u0d30\u0d47\u0d28\u0d3f\u0d2f\u0d7b" },
            { "type.ca.coptic", "\u0d15\u0d4b\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "ur", "\u0d09\u0d31\u0d41\u0d26\u0d41" },
            { "xal", "\u0d15\u0d7d\u0d2e\u0d48\u0d15\u0d4d" },
            { "zen", "\u0d38\u0d46\u0d28\u0d17" },
            { "uz", "\u0d09\u0d38\u0d4d\u200c\u0d2c\u0d46\u0d15\u0d4d\u0d15\u0d4d" },
            { "kha", "\u0d18\u0d3e\u0d38\u0d3f" },
            { "%%1996", "1996-\u0d32\u0d46 \u0d1c\u0d7c\u0d2e\u0d7b \u0d32\u0d3f\u0d2a\u0d3f" },
            { "nds_NL", "\u0d32\u0d4b \u0d38\u0d3e\u0d15\u0d4d\u0d38\u0d7a" },
            { "Sylo", "\u0d38\u0d48\u0d32\u0d4b\u0d24\u0d3f \u0d28\u0d3e\u0d17\u0d30\u0d3f" },
            { "ve", "\u0d35\u0d46\u0d28\u0d4d\u0d26" },
            { "type.ca.roc", "\u0d2e\u0d3f\u0d02\u0d17\u0d4d\u0d35\u0d4b \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "vi", "\u0d35\u0d3f\u0d2f\u0d31\u0d4d\u0d31\u0d4d\u0d28\u0d3e\u0d2e\u0d40\u0d38\u0d4d" },
            { "kho", "\u0d18\u0d4b\u0d31\u0d4d\u0d31\u0d3e\u0d28\u0d47\u0d38\u0d47" },
            { "khq", "\u0d15\u0d4a\u0d2f\u0d4d\u0d31 \u0d1a\u0d40\u0d28\u0d3f" },
            { "key.hc", "\u0d38\u0d2e\u0d2f \u0d18\u0d1f\u0d28 (12 / 24)" },
            { "vo", "\u0d35\u0d4b\u0d33\u0d3e\u0d2a\u0d41\u0d15\u0d4d" },
            { "syc", "\u0d2a\u0d41\u0d30\u0d3e\u0d24\u0d28 \u0d38\u0d41\u0d31\u0d3f\u0d2f\u0d3e\u0d28\u0d3f\u0d2d\u0d3e\u0d37" },
            { "type.nu.mathsans", "\u0d17\u0d23\u0d3f\u0d24 \u0d38\u0d3e\u0d7b\u0d38\u0d4d-\u0d38\u0d46\u0d30\u0d40\u0d2b\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "Osma", "\u0d12\u0d38\u0d4d\u200c\u0d2e\u0d3e\u0d28\u0d3f\u0d2f" },
            { "quc", "\u0d15\u0d4d\u0d35\u0d3f\u0d1a\u0d4d\u0d1a\u0d46" },
            { "type.nu.gonm", "\u0d2e\u0d38\u0d3e\u0d31\u0d02 \u0d17\u0d4b\u0d23\u0d4d\u0d1f\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "gaa", "\u0d17\u0d3e" },
            { "wa", "\u0d35\u0d32\u0d4d\u0d32\u0d42\u0d7a" },
            { "gag", "\u0d17\u0d3e\u0d17\u0d42\u0d38\u0d4d" },
            { "syr", "\u0d38\u0d41\u0d31\u0d3f\u0d2f\u0d3e\u0d28\u0d3f" },
            { "Grek", metaValue_el },
            { "gan", "\u0d17\u0d3e\u0d7b \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "Lydi", "\u0d32\u0d48\u0d21\u0d3f\u0d2f\u0d7b" },
            { "Xsux", "\u0d38\u0d41\u0d2e\u0d47\u0d31\u0d4b \u0d05\u0d15\u0d4d\u0d15\u0d3e\u0d21\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d2f\u0d41\u0d23\u0d3f\u0d2b\u0d4b\u0d02" },
            { "wo", "\u0d35\u0d4a\u0d33\u0d4b\u0d2b\u0d4d" },
            { "zgh", "\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3e\u0d7b\u0d21\u0d47\u0d7c\u0d21\u0d4d \u0d2e\u0d4a\u0d31\u0d4b\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d4d\u0d31\u0d3e\u0d2e\u0d38\u0d3f\u0d2f\u0d31\u0d4d\u0d31\u0d4d" },
            { "ar_001", "\u0d06\u0d27\u0d41\u0d28\u0d3f\u0d15 \u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3e\u0d7b\u0d21\u0d47\u0d7c\u0d21\u0d4d \u0d05\u0d31\u0d2c\u0d3f\u0d15\u0d4d" },
            { "Cans", "\u0d0f\u0d15\u0d40\u0d15\u0d43\u0d24 \u0d15\u0d28\u0d47\u0d21\u0d3f\u0d2f\u0d7b \u0d17\u0d4b\u0d24\u0d4d\u0d30\u0d32\u0d3f\u0d2a\u0d3f" },
            { "gay", "\u0d17\u0d2f\u0d4a" },
            { "Mong", metaValue_mn },
            { "mnc", "\u0d2e\u0d3e\u0d7b\u200c\u0d1a\u0d41" },
            { "Latf", "\u0d2b\u0d4d\u0d30\u0d3e\u0d15\u0d4d\u0d1f\u0d41\u0d7c \u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d7b" },
            { "gba", "\u0d17\u0d2c\u0d4d\u0d2f" },
            { "mni", "\u0d2e\u0d23\u0d3f\u0d2a\u0d4d\u0d2a\u0d42\u0d30\u0d3f" },
            { "Latn", metaValue_la },
            { "Latg", "\u0d17\u0d46\u0d2f\u0d4d\u200c\u0d32\u0d3f\u0d15\u0d4d \u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d7b" },
            { "type.nu.hans", "\u0d32\u0d33\u0d3f\u0d24\u0d35\u0d7d\u0d15\u0d4d\u0d15\u0d30\u0d3f\u0d1a\u0d4d\u0d1a \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "type.nu.hant", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24 \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "xh", "\u0d16\u0d4b\u0d38" },
            { "type.nu.romanlow", "\u0d31\u0d4b\u0d2e\u0d7b \u0d1a\u0d46\u0d31\u0d3f\u0d2f \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "byn", "\u0d2c\u0d4d\u0d32\u0d3f\u0d7b" },
            { "Lyci", "\u0d32\u0d48\u0d38\u0d3f\u0d7b" },
            { "osa", "\u0d12\u0d38\u0d47\u0d1c\u0d4d" },
            { "byv", "\u0d2e\u0d46\u0d21\u0d41\u0d02\u0d2c" },
            { "Moon", "\u0d2e\u0d42\u0d7a" },
            { "moh", "\u0d2e\u0d4b\u0d39\u0d3e\u0d15\u0d4d" },
            { "kkj", "\u0d15\u0d3e\u0d15\u0d4b" },
            { "yi", "\u0d2f\u0d3f\u0d26\u0d4d\u0d26\u0d3f\u0d37\u0d4d" },
            { "mos", "\u0d2e\u0d4a\u0d38\u0d4d\u0d38\u0d3f" },
            { "Syrc", "\u0d38\u0d3f\u0d31\u0d3f\u0d2f\u0d15\u0d4d\u0d15\u0d4d" },
            { "Dsrt", "\u0d21\u0d46\u0d38\u0d46\u0d7c\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "yo", "\u0d2f\u0d4a\u0d31\u0d42\u0d2c\u0d3e" },
            { "type.nu.traditional", "\u0d38\u0d3e\u0d27\u0d3e\u0d30\u0d23\u0d2f\u0d3e\u0d2f\u0d3f \u0d09\u0d2a\u0d2f\u0d4b\u0d17\u0d3f\u0d1a\u0d4d\u0d1a\u0d41\u0d35\u0d30\u0d41\u0d28\u0d4d\u0d28 \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "es_MX", "\u0d2e\u0d46\u0d15\u0d4d\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d4d\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d" },
            { "Syrj", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e\u0d38\u0d41\u0d31\u0d3f\u0d2f\u0d3e\u0d28\u0d3f" },
            { "ota", "\u0d13\u0d1f\u0d4d\u0d1f\u0d4b\u0d2e\u0d7b \u0d24\u0d41\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d37\u0d4d" },
            { "Syre", "\u0d0e\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\u0d30\u0d3e\u0d02\u0d17\u0d4d\u0d32\u0d4b \u0d38\u0d3f\u0d31\u0d3f\u0d2f\u0d15\u0d4d" },
            { "vai", metaValue_vai },
            { "za", "\u0d38\u0d4d\u0d35\u0d3e\u0d02\u0d17\u0d4d" },
            { "Cari", "\u0d1a\u0d30\u0d3f\u0d2f\u0d7b" },
            { "kln", "\u0d15\u0d32\u0d46\u0d1e\u0d4d\u0d1e\u0d3f\u0d7b" },
            { "zh", "\u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "Bopo", "\u0d2c\u0d4b\u0d2a\u0d4d\u0d2a\u0d4b\u0d2e\u0d4b\u0d2b\u0d4b" },
            { "Perm", "\u0d2a\u0d41\u0d30\u0d3e\u0d24\u0d28 \u0d2a\u0d46\u0d7c\u0d2e\u0d3f\u0d15\u0d4d" },
            { "key.lb", "\u0d30\u0d47\u0d16\u0d3e \u0d35\u0d3f\u0d2d\u0d3e\u0d1c\u0d3f \u0d36\u0d48\u0d32\u0d3f" },
            { "zu", "\u0d38\u0d41\u0d32\u0d41" },
            { "type.co.phonebook", "\u0d2b\u0d4b\u0d7a\u0d2c\u0d41\u0d15\u0d4d\u0d15\u0d3f\u0d32\u0d46 \u0d15\u0d4d\u0d30\u0d2e\u0d40\u0d15\u0d30\u0d23\u0d02" },
            { "%%MONOTON", "\u0d2e\u0d4b\u0d23\u0d4b\u0d31\u0d4d\u0d31\u0d4b\u0d23\u0d3f\u0d15\u0d4d" },
            { "Geor", "\u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f\u0d7b" },
            { "kmb", "\u0d15\u0d3f\u0d02\u0d2c\u0d41\u0d23\u0d4d\u0d1f\u0d41" },
            { "type.nu.jpanfin", "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d \u0d27\u0d28\u0d15\u0d3e\u0d30\u0d4d\u0d2f \u0d38\u0d02\u0d16\u0d4d\u0d2f\u0d15\u0d7e" },
            { "Cham", "\u0d1b\u0d02" },
            { "gez", "\u0d17\u0d40\u0d38\u0d4d" },
            { "Syrn", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d3f\u0d31\u0d3f\u0d2f\u0d15\u0d4d" },
            { "type.nu.mymrshan", "\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c \u0d37\u0d3e\u0d7b \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.nu.olck", "\u0d13\u0d7e \u0d1a\u0d3f\u0d15\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "type.co.reformed", "\u0d28\u0d35\u0d40\u0d15\u0d30\u0d3f\u0d1a\u0d4d\u0d1a \u0d05\u0d1f\u0d41\u0d15\u0d4d\u0d15\u0d7d \u0d15\u0d4d\u0d30\u0d2e\u0d02" },
            { "Tglg", "\u0d24\u0d17\u0d32\u0d4b\u0d17\u0d4d" },
            { "Egyd", "\u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u0d37\u0d4d\u0d2f\u0d7b \u0d21\u0d3f\u0d2e\u0d4b\u0d1f\u0d4d\u0d1f\u0d3f\u0d15\u0d4d" },
            { "Egyh", "\u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u0d37\u0d4d\u0d2f\u0d7b \u0d39\u0d3f\u0d30\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d" },
            { "ebu", "\u0d0e\u0d02\u0d2c\u0d41" },
            { "Egyp", "\u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u0d37\u0d4d\u0d2f\u0d7b \u0d1a\u0d3f\u0d24\u0d4d\u0d30\u0d32\u0d3f\u0d2a\u0d3f" },
            { "Geok", "\u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f\u0d7b \u0d16\u0d41\u0d1f\u0d4d\u0d38\u0d41\u0d30\u0d3f" },
            { "zh_Hans", "\u0d32\u0d33\u0d3f\u0d24\u0d2e\u0d3e\u0d15\u0d4d\u0d15\u0d3f\u0d2f \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "koi", "\u0d15\u0d4b\u0d2e\u0d3f-\u0d2a\u0d46\u0d7c\u0d2e\u0d4d\u0d2f\u0d3e\u0d15\u0d4d\u0d15\u0d4d" },
            { "Hung", "\u0d2a\u0d41\u0d30\u0d3e\u0d24\u0d28 \u0d39\u0d02\u0d17\u0d47\u0d31\u0d3f\u0d2f\u0d7b" },
            { "kok", "\u0d15\u0d4a\u0d19\u0d4d\u0d15\u0d23\u0d3f" },
            { "kos", "\u0d15\u0d4a\u0d38\u0d31\u0d47\u0d2f\u0d7b" },
            { "type.nu.limb", "\u0d32\u0d3f\u0d02\u0d2c\u0d41 \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "zh_Hant", "\u0d2a\u0d30\u0d2e\u0d4d\u0d2a\u0d30\u0d3e\u0d17\u0d24 \u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d" },
            { "Sund", "\u0d38\u0d28\u0d4d\u0d24\u0d3e\u0d28\u0d40\u0d38\u0d4d" },
            { "kpe", "\u0d15\u0d2a\u0d46\u0d32\u0d4d\u0d32\u0d47" },
            { "type.nu.khmr", "\u0d16\u0d2e\u0d47\u0d7c \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "ilo", "\u0d07\u0d32\u0d4b\u0d15\u0d4b" },
            { "Cprt", "\u0d38\u0d48\u0d2a\u0d4d\u0d30\u0d3f\u0d2f\u0d4b\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "mua", "\u0d2e\u0d41\u0d28\u0d4d\u0d26\u0d3e\u0d02\u0d17\u0d4d" },
            { "type.nu.guru", "\u0d17\u0d41\u0d30\u0d41\u0d2e\u0d41\u0d16\u0d3f \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "mul", "\u0d2a\u0d32\u0d2d\u0d3e\u0d37\u0d15\u0d7e" },
            { "cad", "\u0d15\u0d3e\u0d21\u0d4b" },
            { "key.ms", "\u0d05\u0d33\u0d15\u0d4d\u0d15\u0d7d \u0d38\u0d02\u0d35\u0d3f\u0d27\u0d3e\u0d28\u0d02" },
            { "mus", "\u0d15\u0d4d\u0d30\u0d40\u0d15\u0d4d\u0d15\u0d4d" },
            { "Glag", "\u0d17\u0d4d\u0d32\u0d17\u0d4b\u0d32\u0d3f\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d" },
            { "gil", "\u0d17\u0d3f\u0d7d\u0d2c\u0d7c\u0d1f\u0d4d\u0d1f\u0d40\u0d38\u0d4d" },
            { "Cher", "\u0d1a\u0d46\u0d31\u0d4b\u0d15\u0d4d\u0d15\u0d3f" },
            { "car", "\u0d15\u0d3e\u0d30\u0d3f\u0d2c\u0d4d" },
            { "cay", "\u0d15\u0d2f\u0d42\u0d17" },
            { "type.nu.tamldec", "\u0d24\u0d2e\u0d3f\u0d34\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e" },
            { "krc", "\u0d15\u0d30\u0d1a\u0d48-\u0d2c\u0d3e\u0d7d\u0d15\u0d7c" },
            { "inh", "\u0d07\u0d02\u0d17\u0d4d\u0d35\u0d3f\u0d37\u0d4d" },
            { "krl", "\u0d15\u0d30\u0d40\u0d32\u0d3f\u0d2f\u0d7b" },
            { "efi", "\u0d0e\u0d2b\u0d3f\u0d15\u0d4d" },
            { "key.nu", "\u0d05\u0d15\u0d4d\u0d15\u0d19\u0d4d\u0d19\u0d7e\u200c" },
            { "kru", "\u0d15\u0d41\u0d30\u0d41\u0d16\u0d4d" },
            { "ksb", "\u0d37\u0d02\u0d2d\u0d3e\u0d33" },
            { "Telu", metaValue_te },
            { "ksf", "\u0d2c\u0d3e\u0d2b\u0d3f\u0d2f" },
        };
        return data;
    }
}
