﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/savingsplans/SavingsPlans_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/savingsplans/model/SavingsPlan.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SavingsPlans
{
namespace Model
{
  class AWS_SAVINGSPLANS_API DescribeSavingsPlansResult
  {
  public:
    DescribeSavingsPlansResult();
    DescribeSavingsPlansResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    DescribeSavingsPlansResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline const Aws::Vector<SavingsPlan>& GetSavingsPlans() const{ return m_savingsPlans; }

    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline void SetSavingsPlans(const Aws::Vector<SavingsPlan>& value) { m_savingsPlans = value; }

    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline void SetSavingsPlans(Aws::Vector<SavingsPlan>&& value) { m_savingsPlans = std::move(value); }

    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline DescribeSavingsPlansResult& WithSavingsPlans(const Aws::Vector<SavingsPlan>& value) { SetSavingsPlans(value); return *this;}

    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline DescribeSavingsPlansResult& WithSavingsPlans(Aws::Vector<SavingsPlan>&& value) { SetSavingsPlans(std::move(value)); return *this;}

    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline DescribeSavingsPlansResult& AddSavingsPlans(const SavingsPlan& value) { m_savingsPlans.push_back(value); return *this; }

    /**
     * <p>Information about the Savings Plans.</p>
     */
    inline DescribeSavingsPlansResult& AddSavingsPlans(SavingsPlan&& value) { m_savingsPlans.push_back(std::move(value)); return *this; }


    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline DescribeSavingsPlansResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline DescribeSavingsPlansResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The token to use to retrieve the next page of results. This value is null
     * when there are no more results to return.</p>
     */
    inline DescribeSavingsPlansResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::Vector<SavingsPlan> m_savingsPlans;

    Aws::String m_nextToken;
  };

} // namespace Model
} // namespace SavingsPlans
} // namespace Aws
