/**
 * SECTION:search-view
 * @short_description: A view of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which match a given <link linkend="FolksQuery"><type>FolksQuery</type></link>.
 * 
 * <para>The search view supports ‘live’ and ‘snapshot’ search results. Live results will continue to update over a long period of time as persona stores go online and offline or individuals are edited so they start or stop matching the <link linkend="FolksQuery"><type>FolksQuery</type></link>.</para><para>For a shell search provider, for example, snapshot results are appropriate. For a search in a contacts UI, live results are more appropriate as they will update over time as other edits are made in the application.</para><para>In both cases, <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> is guaranteed to be correct after <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link> finishes.</para><para>For live results, continue listening to the <link linkend="FolksSearchView-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link> signal.</para>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_TYPE_SEARCH_VIEW:
 * 
 * The type for <link linkend="FolksSearchView"><type>FolksSearchView</type></link>.
 */
/**
 * folks_search_view_prepare:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Prepare the view for use.
 * 
 * <para>This calls <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> as necessary to start aggregating all <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>This function is guaranteed to be idempotent, so multiple search views may share a single aggregator; <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link> must be called on all of the views.</para><para>For any clients only interested in a snapshot of search results, <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> is valid once this async function is finished.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparation failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-search-view-prepare-finish"><function>folks_search_view_prepare_finish()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_prepare_finish:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Prepare the view for use.
 * 
 * <para>This calls <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> as necessary to start aggregating all <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>This function is guaranteed to be idempotent, so multiple search views may share a single aggregator; <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link> must be called on all of the views.</para><para>For any clients only interested in a snapshot of search results, <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> is valid once this async function is finished.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparation failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_unprepare:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Clean up and release resources used by the search view.
 * 
 * <para>This will disconnect the aggregator cleanly from any resources it is using. It is recommended to call this method before finalising the search view, but calling it is not required.</para><para>Note that this will not unprepare the underlying aggregator: call <link linkend="folks-individual-aggregator-unprepare"><function>folks_individual_aggregator_unprepare()</function></link> to do that. This allows multiple search views to use a single aggregator and unprepare at different times.</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if unpreparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-search-view-unprepare-finish"><function>folks_search_view_unprepare_finish()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_unprepare_finish:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Clean up and release resources used by the search view.
 * 
 * <para>This will disconnect the aggregator cleanly from any resources it is using. It is recommended to call this method before finalising the search view, but calling it is not required.</para><para>Note that this will not unprepare the underlying aggregator: call <link linkend="folks-individual-aggregator-unprepare"><function>folks_individual_aggregator_unprepare()</function></link> to do that. This allows multiple search views to use a single aggregator and unprepare at different times.</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if unpreparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-search-view-unprepare"><function>folks_search_view_unprepare()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_refresh:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Refresh the view’s results.
 * 
 * <para>Explicitly re-match all the view’s results to ensure matches are up to date. For a normal <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>, this is explicitly not necessary, as the view will watch signal emissions from the aggregator and keep itself up to date.</para><para>However, for search-only persona stores, which do not support notification of changes to personas, this method is the only way to update the set of matches against the store.</para><para>This method should be called whenever an explicit update is needed to the search results, e.g. if the user requests a refresh.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if matching failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-search-view-refresh-finish"><function>folks_search_view_refresh_finish()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_refresh_finish:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Refresh the view’s results.
 * 
 * <para>Explicitly re-match all the view’s results to ensure matches are up to date. For a normal <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>, this is explicitly not necessary, as the view will watch signal emissions from the aggregator and keep itself up to date.</para><para>However, for search-only persona stores, which do not support notification of changes to personas, this method is the only way to update the set of matches against the store.</para><para>This method should be called whenever an explicit update is needed to the search results, e.g. if the user requests a refresh.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if matching failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-search-view-refresh"><function>folks_search_view_refresh()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_new:
 * @aggregator: (in): &nbsp;.  <para>the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> to match within </para>
 * @query: (in): &nbsp;.  <para>query to match upon </para>
 * 
 * Create a new view of Individuals matching a given query.
 * 
 * <para>This view will be kept up-to-date as individuals change (which may change their membership in the results).</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView:aggregator:
 * 
 * The <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> that this view is based upon.
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_get_aggregator:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSearchView--aggregator"><type>"aggregator"</type></link> property.
 * 
 * The <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> that this view is based upon.
 * 
 * Returns: the value of the <link linkend="FolksSearchView--aggregator"><type>"aggregator"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView:query:
 * 
 * The <link linkend="FolksQuery"><type>FolksQuery</type></link> that this view is based upon.
 * 
 * <para>If this <link linkend="folks-search-view-new"><function>folks_search_view_new()</function></link> has already been prepared, setting this will force a re-evaluation of all <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s in the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> which can be an expensive operation.</para><para>This re-evaluates the query immediately, so most clients should implement de-bouncing to ensure re-evaluation only happens when (for example) the user has stopped typing a new query.</para>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_get_query:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSearchView--query"><type>"query"</type></link> property.
 * 
 * The <link linkend="FolksQuery"><type>FolksQuery</type></link> that this view is based upon.
 * 
 * <para>If this <link linkend="folks-search-view-new"><function>folks_search_view_new()</function></link> has already been prepared, setting this will force a re-evaluation of all <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s in the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> which can be an expensive operation.</para><para>This re-evaluates the query immediately, so most clients should implement de-bouncing to ensure re-evaluation only happens when (for example) the user has stopped typing a new query.</para>
 * 
 * Returns: the value of the <link linkend="FolksSearchView--query"><type>"query"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_set_query:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksSearchView--query"><type>"query"</type></link> property
 * 
 * Set the value of the <link linkend="FolksSearchView--query"><type>"query"</type></link> property to @value.
 * 
 * The <link linkend="FolksQuery"><type>FolksQuery</type></link> that this view is based upon.
 * 
 * <para>If this <link linkend="folks-search-view-new"><function>folks_search_view_new()</function></link> has already been prepared, setting this will force a re-evaluation of all <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s in the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> which can be an expensive operation.</para><para>This re-evaluates the query immediately, so most clients should implement de-bouncing to ensure re-evaluation only happens when (for example) the user has stopped typing a new query.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView:individuals:
 * 
 * A sorted set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which match the search query.
 * 
 * <para>This is the canonical set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s provided by this view. It is sorted by match strength, with the individual who is the best match to the search query as the <link linkend="gee-sorted-set-first"><function>gee_sorted_set_first()</function></link> element of the set.</para><para>Match strengths are not publicly exposed, as they are on an arbitrary scale. To compare two matching individuals for match strength, check for membership of one of them in the <link linkend="gee-sorted-set-head-set"><function>gee_sorted_set_head_set()</function></link> of the other.</para><para>For clients who only wish to have a snapshot of search results, this property is valid once <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link> is finished and this <link linkend="folks-search-view-new"><function>folks_search_view_new()</function></link> may be unreferenced and ignored afterward.</para>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_get_individuals:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> property.
 * 
 * A sorted set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which match the search query.
 * 
 * <para>This is the canonical set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s provided by this view. It is sorted by match strength, with the individual who is the best match to the search query as the <link linkend="gee-sorted-set-first"><function>gee_sorted_set_first()</function></link> element of the set.</para><para>Match strengths are not publicly exposed, as they are on an arbitrary scale. To compare two matching individuals for match strength, check for membership of one of them in the <link linkend="gee-sorted-set-head-set"><function>gee_sorted_set_head_set()</function></link> of the other.</para><para>For clients who only wish to have a snapshot of search results, this property is valid once <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link> is finished and this <link linkend="folks-search-view-new"><function>folks_search_view_new()</function></link> may be unreferenced and ignored afterward.</para>
 * 
 * Returns: the value of the <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView:is-prepared:
 * 
 * Whether <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for this view&apos;s aggregator.
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_get_is_prepared:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSearchView--is-prepared"><type>"is-prepared"</type></link> property.
 * 
 * Whether <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for this view&apos;s aggregator.
 * 
 * Returns: the value of the <link linkend="FolksSearchView--is-prepared"><type>"is-prepared"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView:is-quiescent:
 * 
 * Whether the search view has reached a quiescent state. This will happen at some point after <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for its aggregator.
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksSearchView--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para>
 *
 * Since: 0.11.0
 */
/**
 * folks_search_view_get_is_quiescent:
 * @self: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSearchView--is-quiescent"><type>"is-quiescent"</type></link> property.
 * 
 * Whether the search view has reached a quiescent state. This will happen at some point after <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for its aggregator.
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksSearchView--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para>
 * 
 * Returns: the value of the <link linkend="FolksSearchView--is-quiescent"><type>"is-quiescent"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView::individuals-changed-detailed:
 * @search_view: the <link linkend="FolksSearchView"><type>FolksSearchView</type></link> instance that received the signal
 * @added: &nbsp;.  <para>a set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s added to the search view </para><para></para>
 * @removed: &nbsp;.  <para>a set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s removed from the search view </para><para></para>
 * 
 * Emitted when one or more <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s are added to or removed from the view.
 * 
 * <para>The sets of `added` and `removed` individuals are sorted by descending match strength. Using the <link linkend="gee-sorted-set-lower"><function>gee_sorted_set_lower()</function></link> and <link linkend="gee-sorted-set-higher"><function>gee_sorted_set_higher()</function></link> APIs with <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link>, the `added` individuals can be inserted at the correct positions in a UI representation of the search view.</para><para>The match strengths are on the same scale as in <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link>, so orderings between the two sorted sets are valid. See <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> for more information about match strengths.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksIndividualAggregator-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link>
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchView:
 * 
 * A view of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which match a given <link linkend="FolksQuery"><type>FolksQuery</type></link>.
 * 
 * <para>The search view supports ‘live’ and ‘snapshot’ search results. Live results will continue to update over a long period of time as persona stores go online and offline or individuals are edited so they start or stop matching the <link linkend="FolksQuery"><type>FolksQuery</type></link>.</para><para>For a shell search provider, for example, snapshot results are appropriate. For a search in a contacts UI, live results are more appropriate as they will update over time as other edits are made in the application.</para><para>In both cases, <link linkend="FolksSearchView--individuals"><type>"individuals"</type></link> is guaranteed to be correct after <link linkend="folks-search-view-prepare"><function>folks_search_view_prepare()</function></link> finishes.</para><para>For live results, continue listening to the <link linkend="FolksSearchView-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link> signal.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksSearchViewClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-SEARCH-VIEW:CAPS"><literal>FOLKS_TYPE_SEARCH_VIEW</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
