/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_so extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BD = "Bangladesh";
        final String metaValue_CA = "Kanada";
        final String metaValue_DE = "Jarmal";
        final String metaValue_ET = "Itoobiya";
        final String metaValue_FR = "Faransiis";
        final String metaValue_IT = "Talyaani";
        final String metaValue_RU = "Ruush";
        final String metaValue_ar = "Carabi";
        final String metaValue_el = "Giriik";
        final String metaValue_gu = "Gujaraati";
        final String metaValue_he = "Cibraani";
        final String metaValue_hy = "Armeeniyaan";
        final String metaValue_ja = "Jabaaniis";
        final String metaValue_ko = "Kuuriyaan";
        final String metaValue_la = "Laatiin";
        final String metaValue_or = "Oodhiya";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "Kologniyaan" },
            { "nyn", "Inyankoole" },
            { "luo", "Luwada" },
            { "Zsym", "Calaamado" },
            { "fil", "Tagalog" },
            { "hmn", "Hamong" },
            { "Zsye", "Calaamad Dareen Muujin" },
            { "ccp", "Jakma" },
            { "luy", "Luhya" },
            { "bas", "Basaa" },
            { "es_ES", "Isbaanish (Isbayn)" },
            { "teo", "Teeso" },
            { "AC", "Jasiiradda Asensiyoon" },
            { "AD", "Andora" },
            { "AE", "Imaaraadka Carabta ee Midoobay" },
            { "nl_BE", "Af faleemi" },
            { "AF", "Afgaanistaan" },
            { "af", "Afrikaanka" },
            { "AG", "Antigua & Barbuuda" },
            { "type.ca.ethiopic", "Habeentiriska Itoobiya" },
            { "AI", "Anguula" },
            { "ak", "Akan" },
            { "AL", "Albaaniya" },
            { "AM", "Armeeniya" },
            { "am", "Axmaari" },
            { "Arab", metaValue_ar },
            { "AO", "Angoola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antaarktika" },
            { "ar", metaValue_ar },
            { "AR", "Arjentiina" },
            { "Hrkt", "Qoraalka Xuruufta Jabaaniiska" },
            { "AS", "Samowa Ameerika" },
            { "as", "Asaamiis" },
            { "AT", "Awsteriya" },
            { "AU", "Awstaraaliya" },
            { "AW", "Aruba" },
            { "en_US", "Ingiriis Maraykan" },
            { "AX", "Jasiiradda Aland" },
            { "AZ", "Asarbajan" },
            { "az", "Asarbayjan" },
            { "BA", "Boosniya & Harsegofina" },
            { "BB", "Baarbadoos" },
            { "ceb", "Sebuano" },
            { "BD", metaValue_BD },
            { "BE", "Biljam" },
            { "be", "Beleruusiyaan" },
            { "BF", "Burkiina Faaso" },
            { "BG", "Bulgaariya" },
            { "bg", "Bulgeeriyaan" },
            { "BH", "Baxreyn" },
            { "BI", "Burundi" },
            { "BJ", "Biniin" },
            { "BL", "St. Baathelemiy" },
            { "BM", "Barmuuda" },
            { "bm", "Bambaara" },
            { "bn", metaValue_BD },
            { "BN", "Buruneeya" },
            { "BO", "Boliifiya" },
            { "bo", "Tibeetaan" },
            { "BQ", "Karibiyaan Nadarlands" },
            { "BR", "Baraasiil" },
            { "br", "Biriton" },
            { "BS", "Bahaamas" },
            { "bs", "Bosniyaan" },
            { "xog", "Sooga" },
            { "BT", "Buutan" },
            { "BV", "Buufet Island" },
            { "BW", "Botuswaana" },
            { "Mymr", "Mayanmaar" },
            { "type.nu.laoo", "Godadka Laao" },
            { "BY", "Belarus" },
            { "seh", "Seena" },
            { "BZ", "Beliis" },
            { "type.ca.persian", "Habeentiriska Baarshiyaanka" },
            { "type.nu.hebr", "Nidaam Tireedka Cibraanka" },
            { "CA", metaValue_CA },
            { "ca", "Katalaan" },
            { "CC", "Jasiiradda Kookoos" },
            { "mzn", "Masanderaani" },
            { "ses", "Koyraboro Seenni" },
            { "CD", "Jamhuuriyadda Dimuquraadiga Kongo" },
            { "ce", "Jejen" },
            { "CF", "Jamhuuriyadda Afrikada Dhexe" },
            { "CG", "Kongo" },
            { "CH", "Swiiserlaand" },
            { "CI", "Ayfori Koost" },
            { "CK", "Jasiiradda Kook" },
            { "CL", "Jili" },
            { "CM", "Kaameruun" },
            { "CN", "Shiinaha" },
            { "CO", "Kolombiya" },
            { "co", "Korsikan" },
            { "CP", "Jasiiradda Kilibarton" },
            { "Orya", metaValue_or },
            { "CR", "Kosta Riika" },
            { "cs", "Jeeg" },
            { "CU", "Kuuba" },
            { "cu", "Kaniisadda Islaafik" },
            { "CV", "Jasiiradda Kayb Faarde" },
            { "CW", "Kurakaaw" },
            { "CX", "Jasiiradda Kirismas" },
            { "CY", "Qubrus" },
            { "cy", "Welsh" },
            { "CZ", "Jekiya" },
            { "type.nu.ethi", "Nidaam Tireedka Itoobiya" },
            { "da", "Dhaanish" },
            { "pt_PT", "Boortaqiis (Boortuqaal)" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "cgg", "Jiga" },
            { "DG", "Diyeego Karsiya" },
            { "type.cf.standard", "Habka Heerka Lacagta" },
            { "type.nu.deva", "Godadka Defangaari" },
            { "DJ", "Jabuuti" },
            { "DK", "Denmark" },
            { "Brai", "Qoraalka Indhoolaha" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Nidaam Tireedka Yaryar ee Armeeniya" },
            { "DO", "Jamhuuriyaddda Dominika" },
            { "bem", "Bemba" },
            { "es_419", "Isbaanishka Laatiin Ameerika" },
            { "DZ", "Aljeeriya" },
            { "dz", "D\u2019zongqa" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Habeetiriska Shiinaha" },
            { "EA", "Seyuta & Meliila" },
            { "EC", "Ikuwadoor" },
            { "dje", "Sarma" },
            { "type.nu.grek", "Nidaam Tireedka Giriiga" },
            { "EE", "Estooniya" },
            { "ee", "Eewe" },
            { "type.lb.normal", "Habka Jabinta Xariiqda Caadiga ah" },
            { "EG", "Masar" },
            { "EH", "Saxaraha Galbeed" },
            { "el", metaValue_el },
            { "en", "Ingiriisi" },
            { "eo", "Isberaanto" },
            { "chr", "Jerookee" },
            { "ER", "Eritreeya" },
            { "ES", "Isbeyn" },
            { "es", "Isbaanish" },
            { "ET", metaValue_ET },
            { "et", "Istooniyaan" },
            { "Hanb", "Hanb" },
            { "EU", "Midowga Yurub" },
            { "eu", "Basquu" },
            { "Hang", "Hanguul" },
            { "type.ca.gregorian", "Habeetiriska Geregoriyaan" },
            { "EZ", "Yurusoon" },
            { "shi", "Shilha" },
            { "type.nu.gujr", "Godadka Gujaraati" },
            { "hsb", "Sorobiyaanka Sare" },
            { "Hani", "Hani" },
            { "fa", "Faarisi" },
            { "Hans", "La fududeeyay" },
            { "type.nu.latn", "Godadka Ree Galbeedka" },
            { "Hant", "Hore" },
            { "ff", "Fuulah" },
            { "FI", "Finland" },
            { "fi", "Finishka" },
            { "FJ", "Fiji" },
            { "FK", "Jaziiradaha Fooklaan" },
            { "FM", "Mikroneesiya" },
            { "yue", "Kantoneese" },
            { "FO", "Jasiiradda Faroo" },
            { "fo", "Farowsi" },
            { "Taml", "Taamiil" },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "fy", "Firiisiyan Galbeed" },
            { "GA", "Gaaboon" },
            { "ga", "Ayrish" },
            { "GB", "Boqortooyada Midowday" },
            { "GD", "Giriinaada" },
            { "gd", "Iskot Giilik" },
            { "GE", "Joorjiya" },
            { "GF", "Faransiis Gini" },
            { "GG", "Guurnsey" },
            { "GH", "Gaana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "gl", "Galiisiyaan" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Guadeluub" },
            { "GQ", "Ekuwatooriyal Gini" },
            { "und", "Af aan la aqoon ama aan sax ahayn" },
            { "GR", "Giriig" },
            { "GS", "Jasiiradda Joorjiyada Koonfureed & Sandwij" },
            { "GT", "Guwaatamaala" },
            { "gu", metaValue_gu },
            { "GU", "Guaam" },
            { "gv", "Mankis" },
            { "GW", "Gini-Bisaaw" },
            { "GY", "Guyana" },
            { "ha", "Hawsa" },
            { "ckb", "Bartamaha Kurdish" },
            { "zxx", "Luuqad Looma Hayo" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "HK", "Hong Kong" },
            { "HM", "Jasiiradda Haad & MakDonald" },
            { "HN", "Honduras" },
            { "HR", "Korweeshiya" },
            { "hr", "Koro\u2019eeshiyaan" },
            { "agq", "Ageem" },
            { "gsw", "Jarmal Iswiis" },
            { "HT", "Haiti" },
            { "ht", "Heeytiyaan Karawle" },
            { "HU", "Hangari" },
            { "hu", "Hangariyaan" },
            { "hy", metaValue_hy },
            { "ia", "Interlinguwa" },
            { "IC", "Jasiiradda Kanari" },
            { "Jamo", "Jaamo" },
            { "ID", "Indoneesiya" },
            { "id", "Indunusiyaan" },
            { "type.nu.tibt", "Godka Tirada Tibetan" },
            { "IE", "Ayrlaand" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "Sijuwan Yi" },
            { "IL", "Israa\u02bciil" },
            { "IM", "Jasiiradda Isle of Man" },
            { "IN", "Hindiya" },
            { "IO", "Dhul xadeedka Badweynta Hindiya ee Biritishka" },
            { "IQ", "Ciraaq" },
            { "IR", "Iiraan" },
            { "IS", "Ayslaand" },
            { "is", "Ayslandays" },
            { "it", metaValue_IT },
            { "IT", metaValue_IT },
            { "Zmth", "Aqoonsiga Xisaabta" },
            { "type.nu.thai", "Godka Tirada Thai" },
            { "type.nu.beng", "Godadka Banglaa" },
            { "ja", metaValue_ja },
            { "Mlym", "Maalayalam" },
            { "JE", "Jaarsey" },
            { "type.ca.islamic", "Habeentiriska islaamka" },
            { "JM", "Jamaaika" },
            { "Beng", "Baangla" },
            { "JO", "Urdun" },
            { "JP", "Jabaan" },
            { "jv", "Jafaaniis" },
            { "guz", "Guusii" },
            { "type.nu.knda", "Godadka Kanada" },
            { "de_CH", "Jarmal (Iswiiserlaand)" },
            { "smn", "Inaari Saami" },
            { "ka", "Joorijiyaan" },
            { "type.ca.buddhist", "Habeentiriska Buudhist" },
            { "KE", "Kenya" },
            { "419", "Laatiin Ameerika" },
            { "KG", "Kirgistaan" },
            { "KH", "Kamboodiya" },
            { "KI", "Kiribati" },
            { "ki", "Kikuuyu" },
            { "mas", "Masaay" },
            { "kk", "Kasaaq" },
            { "kl", "Kalaallisuut" },
            { "KM", "Komooros" },
            { "km", "Kamboodhian" },
            { "Knda", metaValue_CA },
            { "KN", "St. Kitts & Nefis" },
            { "kn", "Kannadays" },
            { "fr_CA", "Faransiiska Kanada" },
            { "ko", metaValue_ko },
            { "KP", "Kuuriyada Waqooyi" },
            { "KR", "Kuuriyada Koonfureed" },
            { "ks", "Kaashmiir" },
            { "ku", "Kurdishka" },
            { "fr_CH", "Faransiis (Iswiiserlaand)" },
            { "KW", "Kuwayt" },
            { "kw", "Kornish" },
            { "KY", "Cayman Islands" },
            { "ky", "Kirgiis" },
            { "KZ", "Kasaakhistaan" },
            { "Cyrl", "Siriylik" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Lubnaan" },
            { "lb", "Luksaamboorgish" },
            { "LC", "St. Lusia" },
            { "type.nu.mlym", "Godadka Malayalam" },
            { "lg", "Gandha" },
            { "nds", "Jarmal Hooseeya" },
            { "LI", "Liyjtensteyn" },
            { "LK", "Sirilaanka" },
            { "Tibt", "Tibetaan" },
            { "ln", "Lingala" },
            { "fur", "Firiyuuliyaan" },
            { "lo", "Lao" },
            { "type.ms.uksystem", "Nidaamka Cabbirka Imperial-ka" },
            { "LR", "Laybeeriya" },
            { "LS", "Losooto" },
            { "LT", "Lituweeniya" },
            { "lt", "Lituwaanays" },
            { "LU", "Luksemboorg" },
            { "lu", "Luuba-kataanga" },
            { "LV", "Latfiya" },
            { "lv", "Laatfiyaan" },
            { "Kana", "Katakaana" },
            { "LY", "Liibya" },
            { "vun", "Fuunjo" },
            { "lag", "Laangi" },
            { "Thaa", "Daana" },
            { "MA", "Morooko" },
            { "MC", "Moonako" },
            { "MD", "Moldofa" },
            { "ME", "Moontenegro" },
            { "MF", "St. Maartin" },
            { "MG", "Madagaskar" },
            { "mg", "Malagaasi" },
            { "MH", "Jasiiradda Maarshal" },
            { "Thai", "Taay" },
            { "type.co.ducet", "Lambar Sireedka Caalamiga ee Kala Soocidda Dalabka" },
            { "mi", "Maaoori" },
            { "MK", "Masedooniya Waqooyi" },
            { "mk", "Masadooniyaan" },
            { "ML", "Maali" },
            { "ml", "Malayalam" },
            { "MM", "Miyanmar" },
            { "MN", "Mongooliya" },
            { "mn", "Mangooli" },
            { "MO", "Makaaw" },
            { "MP", "Jasiiradda Waqooyiga Mariaana" },
            { "MQ", "Maartinik" },
            { "MR", "Muritaaniya" },
            { "mr", "Maarati" },
            { "MS", "Montserrat" },
            { "ms", "Malaay" },
            { "MT", "Maalta" },
            { "mt", "Maltiis" },
            { "MU", "Mawrishiyaas" },
            { "MV", "Maaldiqeen" },
            { "MW", "Malaawi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "Habeentiriska jabbaanka" },
            { "MY", "Malaysia" },
            { "my", "Burmese" },
            { "Armn", metaValue_hy },
            { "MZ", "Musambiik" },
            { "dsb", "Soorbiyaanka Hoose" },
            { "NA", "Namiibiya" },
            { "type.co.search", "Raadinta Guud" },
            { "202", "Afrikada ka hooseysa Saxaraha" },
            { "nb", "Noorwijiyaan Bokma" },
            { "type.ca.hebrew", "Habeentiriska yuhuudda" },
            { "NC", "Jasiiradda Niyuu Kaledooniya" },
            { "nd", "Indhebeele" },
            { "NE", "Nayjer" },
            { "ne", "Nebaali" },
            { "NF", "Jasiiradda Noorfolk" },
            { "NG", "Nayjeeriya" },
            { "NI", "Nikaraaguwa" },
            { "NL", "Nederlaands" },
            { "nl", "Holandays" },
            { "nn", "Nowrwejiyan (naynoroski)" },
            { "NO", "Noorweey" },
            { "NP", "Nebaal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Inyaanja" },
            { "NZ", "Niyuusiilaand" },
            { "kab", "Kabayle" },
            { "kam", "Kaamba" },
            { "mer", "Meeru" },
            { "type.nu.armn", "Nidaam Tireedka Armeeniya" },
            { "OM", "Cumaan" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Oseetic" },
            { "mfe", "Moorisayn" },
            { "PA", "Baanama" },
            { "pa", "Bunjaabi" },
            { "dua", "Duaala" },
            { "en_GB", "Ingiriis Biritish" },
            { "PE", "Beeru" },
            { "PF", "Booliyneesiya Faransiiska" },
            { "PG", "Babua Niyuu Gini" },
            { "PH", "Filibiin" },
            { "PK", "Bakistaan" },
            { "PL", "Booland" },
            { "pl", "Boolish" },
            { "ewo", "Eewondho" },
            { "PM", "Saint Pierre and Miquelon" },
            { "PN", "Bitkairn" },
            { "type.ca.dangi", "Habeetiriska Dangi" },
            { "PR", "Bueerto Riiko" },
            { "PS", "Falastiin Daanka galbeed iyo Qasa" },
            { "ps", "Bashtuu" },
            { "PT", "Bortugaal" },
            { "pt", "Boortaqiis" },
            { "key.co", "Kala Soocidda Dalabka" },
            { "PW", "Balaaw" },
            { "type.nu.greklow", "Nidaam Tireedka Yaryar ee Giriiga" },
            { "PY", "Baraguaay" },
            { "pt_BR", "Boortaqiiska Baraasiil" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa" },
            { "key.cf", "Habka Lacagta" },
            { "QA", "Qadar" },
            { "key.ca", "Habeentiris" },
            { "Laoo", "Laoo" },
            { "mgo", "Meetaa" },
            { "type.hc.h23", "24 Saac ee Nidaamka Saacadda (0\u201323)" },
            { "type.hc.h24", "24 Saac ee Nidaamka Saacadda (1\u201324)" },
            { "type.nu.mymr", "Godadka Mayanmaar" },
            { "QO", "Dhulxeebeedka Osheeniya" },
            { "qu", "Quwejuwa" },
            { "brx", "Bodo" },
            { "kde", "Kimakonde" },
            { "Ethi", metaValue_ET },
            { "001", "Dunida" },
            { "002", "Afrika" },
            { "003", "Waqooyi Ameerika" },
            { "RE", "Riyuuniyon" },
            { "type.hc.h12", "12 Saac ee Nidaamka Saacadda (1\u201312)" },
            { "005", "Koonfur Ameerika" },
            { "type.hc.h11", "12 Saac ee Nidaamka Saacadda (0\u201312)" },
            { "009", "Osheeniya" },
            { "rm", "Romaanis" },
            { "rn", "Rundhi" },
            { "key.cu", "Lacagta" },
            { "RO", "Rumaaniya" },
            { "ro", "Romanka" },
            { "RS", "Seerbiya" },
            { "type.nu.orya", "Godadka Oodhiya" },
            { "type.nu.hanidec", "Nidaamka Tireedka Tobanle ee Shiinaha" },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "RW", "Ruwanda" },
            { "rw", "Ruwaandha" },
            { "kea", "Kabuferdiyanu" },
            { "en_AU", "Ingiriis Austaraaliyaan" },
            { "SA", "Sacuudi Carabiya" },
            { "sa", "Sanskrit" },
            { "SB", "Jasiiradda Solomon" },
            { "twq", "Tasaawaq" },
            { "011", "Galbeeka Afrika" },
            { "SC", "Sishelis" },
            { "SD", "Suudaan" },
            { "sd", "Siindhi" },
            { "013", "Bartamaha Ameerika" },
            { "SE", "Iswidhan" },
            { "se", "Koonfurta Saami" },
            { "014", "Afrikada Bari" },
            { "015", "Waqooyiga Afrika" },
            { "SG", "Singaboor" },
            { "sg", "Sango" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "Habka Jabinta Xariiqda Adag" },
            { "017", "Afrikada Dhexe" },
            { "SI", "Islofeeniya" },
            { "si", "Sinhaleys" },
            { "018", "Afrikada Koonfureed" },
            { "SJ", "Jasiiradda Sfaldbaad & Jaan Mayen" },
            { "019", "Ameerikaas" },
            { "SK", "Islofaakiya" },
            { "sk", "Isloofaak" },
            { "SL", "Siraaliyoon" },
            { "sl", "Islofeeniyaan" },
            { "SM", "San Marino" },
            { "sm", "Samowan" },
            { "SN", "Sinigaal" },
            { "sn", "Shoona" },
            { "SO", "Soomaaliya" },
            { "so", "Soomaali" },
            { "type.nu.arab", "Gdadka Carabi-Hindiya" },
            { "sq", "Albeeniyaan" },
            { "type.nu.taml", "Nidaam Tireedki Hore ee Taaamiil" },
            { "SR", "Surineym" },
            { "sr", "Seerbiyaan" },
            { "SS", "Koonfur Suudaan" },
            { "type.cf.account", "Habka Xisaabinta Lacagta" },
            { "ST", "Sao Tome & Birincibal" },
            { "st", "Sesooto" },
            { "su", "Suudaaniis" },
            { "SV", "El Salfadoor" },
            { "sv", "Swiidhis" },
            { "sw", "Sawaaxili" },
            { "SX", "Siint Maarteen" },
            { "SY", "Suuriya" },
            { "type.nu.hantfin", "Nidaam Tireedkii Hore ee Dhaqaalaha Shiinaha" },
            { "SZ", "Eswaatiini" },
            { "TA", "Tiristan da Kunha" },
            { "ta", "Tamiil" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Nidaamka Cabbirka ee US" },
            { "021", "Waqooyiga Ameerika" },
            { "142", "Aasiya" },
            { "TC", "Turks & Kaikos Island" },
            { "yav", "Yaangbeen" },
            { "143", "Bartamaha Aasiya" },
            { "TD", "Jaad" },
            { "te", "Teluugu" },
            { "145", "Aasiyada Galbeed" },
            { "TF", "Dhul xadeedka Koonfureed ee Faransiiska" },
            { "TG", "Toogo" },
            { "tg", "Taajik" },
            { "TH", "Taylaand" },
            { "th", "Taaylandays" },
            { "ti", "Tigrinya" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Ingiriis Kanadiyaan" },
            { "029", "Karibiyaan" },
            { "TK", "Tokelaaw" },
            { "tk", "Turkumaanish" },
            { "TL", "Timoor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tuniisiya" },
            { "TO", "Tonga" },
            { "to", "Toongan" },
            { "dyo", "Joola-Foonyi" },
            { "type.nu.jpan", "Nidaam Tireedka Jabbaanka" },
            { "TR", "Turki" },
            { "tr", "Turkish" },
            { "TT", "Tirinidaad & Tobago" },
            { "tt", "Taatar" },
            { "TV", "Tufaalu" },
            { "TW", "Taywaan" },
            { "ast", "Astuuriyaan" },
            { "TZ", "Tansaaniya" },
            { "nmg", "Kuwaasiyo" },
            { "Zzzz", "Far aan la aqoon amase aan saxnayn" },
            { "150", "Yurub" },
            { "UA", "Yukrayn" },
            { "030", "Aasiyada Bari" },
            { "151", "Yurubta Bari" },
            { "154", "Yurubta Waqooyi" },
            { "034", "Aasiyada Koonfureed" },
            { "155", "Yurubta Galbeed" },
            { "035", "Aasiyada Koonfur-galbeed" },
            { "UG", "Ugaanda" },
            { "ug", "Uighur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Caadi ahaan" },
            { "039", "Yurubta Koonfureed" },
            { "uk", "Yukreeniyaan" },
            { "Sinh", "Sinhaala" },
            { "UM", "Jasiiradaha ka baxsan Maraykanka" },
            { "UN", "Qaramada Midoobay" },
            { "ur", "Urduu" },
            { "US", "Maraykanka" },
            { "haw", "Hawaay" },
            { "UY", "Uruguwaay" },
            { "prg", "Brashiyaanki Hore" },
            { "UZ", "Uusbakistaan" },
            { "uz", "Usbakis" },
            { "tzm", "Bartamaha Atlaas Tamasayt" },
            { "nnh", "Ingiyembuun" },
            { "VA", "Faatikaan" },
            { "VC", "St. Finsent & Girenadiins" },
            { "VE", "Fenisuweela" },
            { "type.ca.roc", "Habeentiriska Minguwo" },
            { "VG", "Biritish Farjin Island" },
            { "VI", "U.S Fargin Island" },
            { "vi", "Fiitnaamays" },
            { "khq", "Koyra Jiini" },
            { "key.hc", "Wareegga Saacadda (12 ilaa 24)" },
            { "VN", "Fiyetnaam" },
            { "vo", "Folabuuk" },
            { "VU", "Fanuaatu" },
            { "rwk", "Raawa" },
            { "053", "Austraalaasiya" },
            { "054", "Melaneesiya" },
            { "WF", "Walis & Futuna" },
            { "Grek", metaValue_el },
            { "057", "Gobolka Aasiyada yar" },
            { "jgo", "Ingoomba" },
            { "lkt", "Laakoota" },
            { "wo", "Woolof" },
            { "wae", "Walseer" },
            { "zgh", "Morokaanka Tamasayt Rasmiga" },
            { "ar_001", "Carabiga rasmiga ah" },
            { "WS", "Samoowa" },
            { "Mong", "Mongooliyaan" },
            { "XA", "XA" },
            { "XB", "XB" },
            { "Latn", metaValue_la },
            { "061", "Booliyneesiya" },
            { "type.nu.hans", "Nidaam Tireedka Hore La Fududeeyay ee Shiinaha" },
            { "type.nu.hant", "Nidaam Tireedka Hore ee Shiinaha" },
            { "xh", "Hoosta" },
            { "XK", "Koosofo" },
            { "type.nu.romanlow", "Nidaam Tireedka yaryar ee Roomaanka" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Aan la qorin" },
            { "kkj", "Kaako" },
            { "YE", "Yaman" },
            { "type.co.standard", "Amarka Kala Soocidda Caadiga ah" },
            { "yi", "Yadhish" },
            { "yo", "Yoruuba" },
            { "YT", "Mayotte" },
            { "vai", "Faayi" },
            { "ZA", "Koonfur Afrika" },
            { "type.lb.loose", "Habka Jabinta Xariiqda Dabacsan" },
            { "kln", "Kalenjiin" },
            { "Deva", "Dhefangaari" },
            { "zh", "Shiinaha Mandarin" },
            { "type.nu.geor", "Nidaam Tireedka Giyoorgiyaanka" },
            { "Hira", "Hiragana" },
            { "ZM", "Saambiya" },
            { "Bopo", "Bopo" },
            { "key.lb", "Habka Jebinta Xariiqda" },
            { "zu", "Zuulu" },
            { "ZW", "Simbaabwe" },
            { "ZZ", "Gobol aan la aqoonin amase aan saxnayn" },
            { "Geor", "Jiyoorjoyaan" },
            { "type.ms.metric", "Nidaamka Metric" },
            { "type.ca.iso8601", "Habeentiriska ISO-8601" },
            { "type.nu.telu", "Godka Tirada Telugu" },
            { "type.nu.jpanfin", "Nidaam Tireedka Dhaqaalaha Jabbaanka" },
            { "ebu", "Embuu" },
            { "jmc", "Chaga" },
            { "zh_Hans", "Shiinaha Rasmiga ah" },
            { "type.nu.hansfin", "Nidaam Tireedka Hore La Fududeeyay ee Dhaqaalaha Shiinaha" },
            { "kok", "Konkani" },
            { "type.nu.arabext", "Tirooyinka Dheeraadka ah ee Godadka Carabi-Hindiya" },
            { "nus", "Nuweer" },
            { "type.nu.fullwide", "Ballac Godadka Buuxa" },
            { "dav", "Taiita" },
            { "lrc", "Koonfurta Luuri" },
            { "zh_Hant", "Shiinahii Hore" },
            { "type.nu.khmr", "Godadka Khamer" },
            { "mua", "Miyundhaang" },
            { "type.nu.guru", "Godadka Gurmukhi" },
            { "Khmr", "Khamer" },
            { "mul", "Luuqado kala duwan" },
            { "key.ms", "Nidaamka Cabbiraadda" },
            { "type.nu.roman", "Nidaam Tireedka Roomaanka" },
            { "sah", "Saaqa" },
            { "type.nu.tamldec", "Godka Tirada Taamiil" },
            { "saq", "Sambuuru" },
            { "key.nu", "Tirooyinka" },
            { "Guru", "Guru" },
            { "ksb", "Shambaala" },
            { "Telu", "Teeluguu" },
            { "ksf", "Bafiya" },
        };
        return data;
    }
}
