/*********************                                                        */
/** kind.h
 **
 ** Copyright 2010-2014  New York University and The University of Iowa,
 ** and as below.
 **
 ** This header file automatically generated by:
 **
 **     ../../../src/expr/mkkind /build/cvc4/src/CVC4-1.7/src/expr/kind_template.h /build/cvc4/src/CVC4-1.7/src/theory/builtin/kinds /build/cvc4/src/CVC4-1.7/src/theory/booleans/kinds /build/cvc4/src/CVC4-1.7/src/theory/uf/kinds /build/cvc4/src/CVC4-1.7/src/theory/arith/kinds /build/cvc4/src/CVC4-1.7/src/theory/bv/kinds /build/cvc4/src/CVC4-1.7/src/theory/fp/kinds /build/cvc4/src/CVC4-1.7/src/theory/arrays/kinds /build/cvc4/src/CVC4-1.7/src/theory/datatypes/kinds /build/cvc4/src/CVC4-1.7/src/theory/sep/kinds /build/cvc4/src/CVC4-1.7/src/theory/sets/kinds /build/cvc4/src/CVC4-1.7/src/theory/strings/kinds /build/cvc4/src/CVC4-1.7/src/theory/quantifiers/kinds /build/cvc4/src/CVC4-1.7/src/theory/idl/kinds
 **
 ** for the CVC4 project.
 **/

/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */

/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */

/* Edit the template file instead:                     */
/* /build/cvc4/src/CVC4-1.7/src/expr/kind_template.h */

/*********************                                                        */
/*! \file kind_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Dejan Jovanovic, Andres Noetzli
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2019 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Template for the Node kind header
 **
 ** Template for the Node kind header.
 **/

#include <cvc4/cvc4_public.h>

#ifndef __CVC4__KIND_H
#define __CVC4__KIND_H

#include <iosfwd>

#include <cvc4/base/exception.h>

namespace CVC4 {
namespace kind {

enum CVC4_PUBLIC Kind_t {
  UNDEFINED_KIND = -1, /**< undefined */
  NULL_EXPR, /**< Null kind */

  /* from builtin */
  SORT_TAG, /**< sort tag (1) */
  SORT_TYPE, /**< specifies types of user-declared 'uninterpreted' sorts (2) */
  UNINTERPRETED_CONSTANT, /**< the kind of expressions representing uninterpreted constants; payload is an instance of the CVC4::UninterpretedConstant class (used in models) (3) */
  ABSTRACT_VALUE, /**< the kind of expressions representing abstract values (other than uninterpreted sort constants); payload is an instance of the CVC4::AbstractValue class (used in models) (4) */
  BUILTIN, /**< the kind of expressions representing built-in operators (5) */
  FUNCTION, /**< a defined function (6) */
  APPLY, /**< application of a defined function (7) */
  EQUAL, /**< equality (two parameters only, sorts must match) (8) */
  DISTINCT, /**< disequality (N-ary, sorts must match) (9) */
  VARIABLE, /**< a variable (not permitted in bindings) (10) */
  BOUND_VARIABLE, /**< a bound variable (permitted in bindings and the associated lambda and quantifier bodies only) (11) */
  SKOLEM, /**< a Skolem variable (internal only) (12) */
  SEXPR, /**< a symbolic expression (any arity) (13) */
  LAMBDA, /**< a lambda expression; first parameter is a BOUND_VAR_LIST, second is lambda body (14) */
  CHOICE, /**< a Hilbert choice (epsilon) expression; first parameter is a BOUND_VAR_LIST, second is the Hilbert choice body (15) */
  CHAIN, /**< chained operator (N-ary), turned into a conjunction of binary applications of the operator on adjoining parameters; first parameter is a CHAIN_OP representing a binary operator, rest are arguments to that operator (16) */
  CHAIN_OP, /**< the chained operator; payload is an instance of the CVC4::Chain class (17) */
  TYPE_CONSTANT, /**< a representation for basic types (18) */
  FUNCTION_TYPE, /**< a function type (19) */
  SEXPR_TYPE, /**< the type of a symbolic expression (20) */

  /* from booleans */
  CONST_BOOLEAN, /**< truth and falsity; payload is a (C++) bool (21) */
  NOT, /**< logical not (22) */
  AND, /**< logical and (N-ary) (23) */
  IMPLIES, /**< logical implication (exactly two parameters) (24) */
  OR, /**< logical or (N-ary) (25) */
  XOR, /**< exclusive or (exactly two parameters) (26) */
  ITE, /**< if-then-else, used for both Boolean and term ITE constructs; first parameter is (Boolean-sorted) condition, second is 'then', third is 'else' and these two parameters must have same base sort (27) */

  /* from uf */
  APPLY_UF, /**< application of an uninterpreted function; first parameter is the function, remaining ones are parameters to that function (28) */
  BOOLEAN_TERM_VARIABLE, /**< Boolean term variable (29) */
  CARDINALITY_CONSTRAINT, /**< cardinality constraint on sort S: first parameter is (any) term of sort S, second is a positive integer constant k that bounds the cardinality of S (30) */
  COMBINED_CARDINALITY_CONSTRAINT, /**< combined cardinality constraint; parameter is a positive integer constant k that bounds the sum of the cardinalities of all sorts in the signature (31) */
  PARTIAL_APPLY_UF, /**< partial uninterpreted function application (32) */
  CARDINALITY_VALUE, /**< cardinality value of sort S: first parameter is (any) term of sort S (33) */
  HO_APPLY, /**< higher-order (partial) function application (34) */

  /* from arith */
  PLUS, /**< arithmetic addition (N-ary) (35) */
  MULT, /**< arithmetic multiplication (N-ary) (36) */
  NONLINEAR_MULT, /**< synonym for MULT (37) */
  MINUS, /**< arithmetic binary subtraction operator (38) */
  UMINUS, /**< arithmetic unary negation (39) */
  DIVISION, /**< real division, division by 0 undefined (user symbol) (40) */
  DIVISION_TOTAL, /**< real division with interpreted division by 0 (internal symbol) (41) */
  INTS_DIVISION, /**< integer division, division by 0 undefined (user symbol) (42) */
  INTS_DIVISION_TOTAL, /**< integer division with interpreted division by 0 (internal symbol) (43) */
  INTS_MODULUS, /**< integer modulus, division by 0 undefined (user symbol) (44) */
  INTS_MODULUS_TOTAL, /**< integer modulus with interpreted division by 0 (internal symbol) (45) */
  ABS, /**< absolute value (46) */
  DIVISIBLE, /**< divisibility-by-k predicate; first parameter is a DIVISIBLE_OP, second is integer term (47) */
  POW, /**< arithmetic power (48) */
  EXPONENTIAL, /**< exponential (49) */
  SINE, /**< sine (50) */
  COSINE, /**< consine (51) */
  TANGENT, /**< tangent (52) */
  COSECANT, /**< cosecant (53) */
  SECANT, /**< secant (54) */
  COTANGENT, /**< cotangent (55) */
  ARCSINE, /**< arc sine (56) */
  ARCCOSINE, /**< arc consine (57) */
  ARCTANGENT, /**< arc tangent (58) */
  ARCCOSECANT, /**< arc cosecant (59) */
  ARCSECANT, /**< arc secant (60) */
  ARCCOTANGENT, /**< arc cotangent (61) */
  SQRT, /**< square root (62) */
  DIVISIBLE_OP, /**< operator for the divisibility-by-k predicate; payload is an instance of the CVC4::Divisible class (63) */
  CONST_RATIONAL, /**< a multiple-precision rational constant; payload is an instance of the CVC4::Rational class (64) */
  LT, /**< less than, x < y (65) */
  LEQ, /**< less than or equal, x <= y (66) */
  GT, /**< greater than, x > y (67) */
  GEQ, /**< greater than or equal, x >= y (68) */
  IS_INTEGER, /**< term-is-integer predicate (parameter is a real-sorted term) (69) */
  TO_INTEGER, /**< convert term to integer by the floor function (parameter is a real-sorted term) (70) */
  TO_REAL, /**< cast term to real (parameter is an integer-sorted term; this is a no-op in CVC4, as integer is a subtype of real) (71) */
  PI, /**< pi (72) */

  /* from bv */
  BITVECTOR_TYPE, /**< bit-vector type (73) */
  CONST_BITVECTOR, /**< a fixed-width bit-vector constant; payload is an instance of the CVC4::BitVector class (74) */
  BITVECTOR_CONCAT, /**< concatenation of two or more bit-vectors (75) */
  BITVECTOR_AND, /**< bitwise and of two or more bit-vectors (76) */
  BITVECTOR_COMP, /**< equality comparison of two bit-vectors (returns one bit) (77) */
  BITVECTOR_OR, /**< bitwise or of two or more bit-vectors (78) */
  BITVECTOR_XOR, /**< bitwise xor of two or more bit-vectors (79) */
  BITVECTOR_NOT, /**< bitwise not of a bit-vector (80) */
  BITVECTOR_NAND, /**< bitwise nand of two bit-vectors (81) */
  BITVECTOR_NOR, /**< bitwise nor of two bit-vectors (82) */
  BITVECTOR_XNOR, /**< bitwise xnor of two bit-vectors (83) */
  BITVECTOR_MULT, /**< multiplication of two or more bit-vectors (84) */
  BITVECTOR_NEG, /**< unary negation of a bit-vector (85) */
  BITVECTOR_PLUS, /**< addition of two or more bit-vectors (86) */
  BITVECTOR_SUB, /**< subtraction of two bit-vectors (87) */
  BITVECTOR_UDIV, /**< unsigned division of two bit-vectors, truncating towards 0 (undefined if divisor is 0) (88) */
  BITVECTOR_UREM, /**< unsigned remainder from truncating division of two bit-vectors (undefined if divisor is 0) (89) */
  BITVECTOR_SDIV, /**< 2's complement signed division (90) */
  BITVECTOR_SMOD, /**< 2's complement signed remainder (sign follows divisor) (91) */
  BITVECTOR_SREM, /**< 2's complement signed remainder (sign follows dividend) (92) */
  BITVECTOR_UDIV_TOTAL, /**< unsigned division of two bit-vectors, truncating towards 0 (defined to be the all-ones bit pattern, if divisor is 0) (93) */
  BITVECTOR_UREM_TOTAL, /**< unsigned remainder from truncating division of two bit-vectors (defined to be equal to the dividend, if divisor is 0) (94) */
  BITVECTOR_ASHR, /**< bit-vector arithmetic shift right (the two bit-vector parameters must have same width) (95) */
  BITVECTOR_LSHR, /**< bit-vector logical shift right (the two bit-vector parameters must have same width) (96) */
  BITVECTOR_SHL, /**< bit-vector shift left (the two bit-vector parameters must have same width) (97) */
  BITVECTOR_ULE, /**< bit-vector unsigned less than or equal (the two bit-vector parameters must have same width) (98) */
  BITVECTOR_ULT, /**< bit-vector unsigned less than (the two bit-vector parameters must have same width) (99) */
  BITVECTOR_UGE, /**< bit-vector unsigned greater than or equal (the two bit-vector parameters must have same width) (100) */
  BITVECTOR_UGT, /**< bit-vector unsigned greater than (the two bit-vector parameters must have same width) (101) */
  BITVECTOR_SLE, /**< bit-vector signed less than or equal (the two bit-vector parameters must have same width) (102) */
  BITVECTOR_SLT, /**< bit-vector signed less than (the two bit-vector parameters must have same width) (103) */
  BITVECTOR_SGE, /**< bit-vector signed greater than or equal (the two bit-vector parameters must have same width) (104) */
  BITVECTOR_SGT, /**< bit-vector signed greater than (the two bit-vector parameters must have same width) (105) */
  BITVECTOR_ULTBV, /**< bit-vector unsigned less than but returns bv of size 1 instead of boolean (106) */
  BITVECTOR_SLTBV, /**< bit-vector signed less than but returns bv of size 1 instead of boolean (107) */
  BITVECTOR_REDAND, /**< bit-vector redand (108) */
  BITVECTOR_REDOR, /**< bit-vector redor (109) */
  BITVECTOR_ITE, /**< same semantics as regular ITE, but condition is bv of size 1 instead of Boolean (110) */
  BITVECTOR_TO_NAT, /**< bit-vector conversion to (nonnegative) integer; parameter is a bit-vector (111) */
  BITVECTOR_ACKERMANNIZE_UDIV, /**< term to be treated as a variable; used for eager bit-blasting Ackermann expansion of bvudiv (internal-only symbol) (112) */
  BITVECTOR_ACKERMANNIZE_UREM, /**< term to be treated as a variable; used for eager bit-blasting Ackermann expansion of bvurem (internal-only symbol) (113) */
  BITVECTOR_EAGER_ATOM, /**< formula to be treated as a bv atom via eager bit-blasting (internal-only symbol) (114) */
  BITVECTOR_BITOF_OP, /**< operator for the bit-vector boolean bit extract; payload is an instance of the CVC4::BitVectorBitOf class (115) */
  BITVECTOR_BITOF, /**< bit-vector boolean bit extract; first parameter is a BITVECTOR_BITOF_OP, second is a bit-vector term (116) */
  BITVECTOR_EXTRACT_OP, /**< operator for the bit-vector extract; payload is an instance of the CVC4::BitVectorExtract class (117) */
  BITVECTOR_EXTRACT, /**< bit-vector extract; first parameter is a BITVECTOR_EXTRACT_OP, second is a bit-vector term (118) */
  BITVECTOR_REPEAT_OP, /**< operator for the bit-vector repeat; payload is an instance of the CVC4::BitVectorRepeat class (119) */
  BITVECTOR_REPEAT, /**< bit-vector repeat; first parameter is a BITVECTOR_REPEAT_OP, second is a bit-vector term (120) */
  BITVECTOR_ROTATE_LEFT_OP, /**< operator for the bit-vector rotate left; payload is an instance of the CVC4::BitVectorRotateLeft class (121) */
  BITVECTOR_ROTATE_LEFT, /**< bit-vector rotate left; first parameter is a BITVECTOR_ROTATE_LEFT_OP, second is a bit-vector term (122) */
  BITVECTOR_ROTATE_RIGHT_OP, /**< operator for the bit-vector rotate right; payload is an instance of the CVC4::BitVectorRotateRight class (123) */
  BITVECTOR_ROTATE_RIGHT, /**< bit-vector rotate right; first parameter is a BITVECTOR_ROTATE_RIGHT_OP, second is a bit-vector term (124) */
  BITVECTOR_SIGN_EXTEND_OP, /**< operator for the bit-vector sign-extend; payload is an instance of the CVC4::BitVectorSignExtend class (125) */
  BITVECTOR_SIGN_EXTEND, /**< bit-vector sign-extend; first parameter is a BITVECTOR_SIGN_EXTEND_OP, second is a bit-vector term (126) */
  BITVECTOR_ZERO_EXTEND_OP, /**< operator for the bit-vector zero-extend; payload is an instance of the CVC4::BitVectorZeroExtend class (127) */
  BITVECTOR_ZERO_EXTEND, /**< bit-vector zero-extend; first parameter is a BITVECTOR_ZERO_EXTEND_OP, second is a bit-vector term (128) */
  INT_TO_BITVECTOR_OP, /**< operator for the integer conversion to bit-vector; payload is an instance of the CVC4::IntToBitVector class (129) */
  INT_TO_BITVECTOR, /**< integer conversion to bit-vector; first parameter is an INT_TO_BITVECTOR_OP, second is an integer term (130) */

  /* from fp */
  CONST_FLOATINGPOINT, /**< a floating-point literal (131) */
  CONST_ROUNDINGMODE, /**< a floating-point rounding mode (132) */
  FLOATINGPOINT_TYPE, /**< floating-point type (133) */
  FLOATINGPOINT_FP, /**< construct a floating-point literal from bit vectors (134) */
  FLOATINGPOINT_EQ, /**< floating-point equality (135) */
  FLOATINGPOINT_ABS, /**< floating-point absolute value (136) */
  FLOATINGPOINT_NEG, /**< floating-point negation (137) */
  FLOATINGPOINT_PLUS, /**< floating-point addition (138) */
  FLOATINGPOINT_SUB, /**< floating-point sutraction (139) */
  FLOATINGPOINT_MULT, /**< floating-point multiply (140) */
  FLOATINGPOINT_DIV, /**< floating-point division (141) */
  FLOATINGPOINT_FMA, /**< floating-point fused multiply and add (142) */
  FLOATINGPOINT_SQRT, /**< floating-point square root (143) */
  FLOATINGPOINT_REM, /**< floating-point remainder (144) */
  FLOATINGPOINT_RTI, /**< floating-point round to integral (145) */
  FLOATINGPOINT_MIN, /**< floating-point minimum (146) */
  FLOATINGPOINT_MAX, /**< floating-point maximum (147) */
  FLOATINGPOINT_MIN_TOTAL, /**< floating-point minimum (defined for all inputs) (148) */
  FLOATINGPOINT_MAX_TOTAL, /**< floating-point maximum (defined for all inputs) (149) */
  FLOATINGPOINT_LEQ, /**< floating-point less than or equal (150) */
  FLOATINGPOINT_LT, /**< floating-point less than (151) */
  FLOATINGPOINT_GEQ, /**< floating-point greater than or equal (152) */
  FLOATINGPOINT_GT, /**< floating-point greater than (153) */
  FLOATINGPOINT_ISN, /**< floating-point is normal (154) */
  FLOATINGPOINT_ISSN, /**< floating-point is sub-normal (155) */
  FLOATINGPOINT_ISZ, /**< floating-point is zero (156) */
  FLOATINGPOINT_ISINF, /**< floating-point is infinite (157) */
  FLOATINGPOINT_ISNAN, /**< floating-point is NaN (158) */
  FLOATINGPOINT_ISNEG, /**< floating-point is negative (159) */
  FLOATINGPOINT_ISPOS, /**< floating-point is positive (160) */
  FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP, /**< operator for to_fp from bit vector (161) */
  FLOATINGPOINT_TO_FP_IEEE_BITVECTOR, /**< convert an IEEE-754 bit vector to floating-point (162) */
  FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP, /**< operator for to_fp from floating point (163) */
  FLOATINGPOINT_TO_FP_FLOATINGPOINT, /**< convert between floating-point sorts (164) */
  FLOATINGPOINT_TO_FP_REAL_OP, /**< operator for to_fp from real (165) */
  FLOATINGPOINT_TO_FP_REAL, /**< convert a real to floating-point (166) */
  FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP, /**< operator for to_fp from signed bit vector (167) */
  FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR, /**< convert a signed bit vector to floating-point (168) */
  FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP, /**< operator for to_fp from unsigned bit vector (169) */
  FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR, /**< convert an unsigned bit vector to floating-point (170) */
  FLOATINGPOINT_TO_FP_GENERIC_OP, /**< operator for a generic to_fp (171) */
  FLOATINGPOINT_TO_FP_GENERIC, /**< a generic conversion to floating-point, used in parsing only (172) */
  FLOATINGPOINT_TO_UBV_OP, /**< operator for to_ubv (173) */
  FLOATINGPOINT_TO_UBV, /**< convert a floating-point value to an unsigned bit vector (174) */
  FLOATINGPOINT_TO_UBV_TOTAL_OP, /**< operator for to_ubv_total (175) */
  FLOATINGPOINT_TO_UBV_TOTAL, /**< convert a floating-point value to an unsigned bit vector (defined for all inputs) (176) */
  FLOATINGPOINT_TO_SBV_OP, /**< operator for to_sbv (177) */
  FLOATINGPOINT_TO_SBV, /**< convert a floating-point value to a signed bit vector (178) */
  FLOATINGPOINT_TO_SBV_TOTAL_OP, /**< operator for to_sbv_total (179) */
  FLOATINGPOINT_TO_SBV_TOTAL, /**< convert a floating-point value to a signed bit vector (defined for all inputs) (180) */
  FLOATINGPOINT_TO_REAL, /**< floating-point to real (181) */
  FLOATINGPOINT_TO_REAL_TOTAL, /**< floating-point to real (defined for all inputs) (182) */
  FLOATINGPOINT_COMPONENT_NAN, /**< NaN component of a word-blasted floating-point number (183) */
  FLOATINGPOINT_COMPONENT_INF, /**< Inf component of a word-blasted floating-point number (184) */
  FLOATINGPOINT_COMPONENT_ZERO, /**< Zero component of a word-blasted floating-point number (185) */
  FLOATINGPOINT_COMPONENT_SIGN, /**< Sign component of a word-blasted floating-point number (186) */
  FLOATINGPOINT_COMPONENT_EXPONENT, /**< Exponent component of a word-blasted floating-point number (187) */
  FLOATINGPOINT_COMPONENT_SIGNIFICAND, /**< Significand component of a word-blasted floating-point number (188) */
  ROUNDINGMODE_BITBLAST, /**< The bit-vector for a non-deterministic rounding mode (189) */

  /* from arrays */
  ARRAY_TYPE, /**< array type (190) */
  SELECT, /**< array select; first parameter is an array term, second is the selection index (191) */
  STORE, /**< array store; first parameter is an array term, second is the store index, third is the term to store at the index (192) */
  STORE_ALL, /**< array store-all; payload is an instance of the CVC4::ArrayStoreAll class (this is not supported by arrays decision procedure yet, but it is used for returned array models) (193) */
  ARR_TABLE_FUN, /**< array table function (internal-only symbol) (194) */
  ARRAY_LAMBDA, /**< array lambda (internal-only symbol) (195) */
  PARTIAL_SELECT_0, /**< partial array select, for internal use only (196) */
  PARTIAL_SELECT_1, /**< partial array select, for internal use only (197) */

  /* from datatypes */
  CONSTRUCTOR_TYPE, /**< constructor (198) */
  SELECTOR_TYPE, /**< selector (199) */
  TESTER_TYPE, /**< tester (200) */
  APPLY_CONSTRUCTOR, /**< constructor application; first parameter is the constructor, remaining parameters (if any) are parameters to the constructor (201) */
  APPLY_SELECTOR, /**< selector application; parameter is a datatype term (undefined if mis-applied) (202) */
  APPLY_SELECTOR_TOTAL, /**< selector application; parameter is a datatype term (defined rigidly if mis-applied) (203) */
  APPLY_TESTER, /**< tester application; first parameter is a tester, second is a datatype term (204) */
  DATATYPE_TYPE, /**< a datatype type index (205) */
  PARAMETRIC_DATATYPE, /**< parametric datatype (206) */
  APPLY_TYPE_ASCRIPTION, /**< type ascription, for datatype constructor applications; first parameter is an ASCRIPTION_TYPE, second is the datatype constructor application being ascribed (207) */
  ASCRIPTION_TYPE, /**< a type parameter for type ascription; payload is an instance of the CVC4::AscriptionType class (208) */
  TUPLE_UPDATE_OP, /**< operator for a tuple update; payload is an instance of the CVC4::TupleUpdate class (209) */
  TUPLE_UPDATE, /**< tuple update; first parameter is a TUPLE_UPDATE_OP (which references an index), second is the tuple, third is the element to store in the tuple at the given index (210) */
  RECORD_UPDATE_OP, /**< operator for a record update; payload is an instance CVC4::RecordUpdate class (211) */
  RECORD_UPDATE, /**< record update; first parameter is a RECORD_UPDATE_OP (which references a field), second is a record term to update, third is the element to store in the record in the given field (212) */
  DT_SIZE, /**< datatypes size (213) */
  DT_HEIGHT_BOUND, /**< datatypes height bound (214) */
  DT_SIZE_BOUND, /**< datatypes height bound (215) */
  DT_SYGUS_BOUND, /**< datatypes sygus bound (216) */
  DT_SYGUS_EVAL, /**< datatypes sygus evaluation function (217) */

  /* from sep */
  SEP_NIL, /**< separation nil (218) */
  SEP_EMP, /**< separation empty heap (219) */
  SEP_PTO, /**< points to relation (220) */
  SEP_STAR, /**< separation star (221) */
  SEP_WAND, /**< separation magic wand (222) */
  SEP_LABEL, /**< separation label (internal use only) (223) */

  /* from sets */
  EMPTYSET, /**< the empty set constant; payload is an instance of the CVC4::EmptySet class (224) */
  SET_TYPE, /**< set type, takes as parameter the type of the elements (225) */
  UNION, /**< set union (226) */
  INTERSECTION, /**< set intersection (227) */
  SETMINUS, /**< set subtraction (228) */
  SUBSET, /**< subset predicate; first parameter a subset of second (229) */
  MEMBER, /**< set membership predicate; first parameter a member of second (230) */
  SINGLETON, /**< the set of the single element given as a parameter (231) */
  INSERT, /**< set obtained by inserting elements (first N-1 parameters) into a set (the last parameter) (232) */
  CARD, /**< set cardinality operator (233) */
  COMPLEMENT, /**< set COMPLEMENT (with respect to finite universe) (234) */
  UNIVERSE_SET, /**< (finite) universe set, all set variables must be interpreted as subsets of it. (235) */
  JOIN, /**< set join (236) */
  PRODUCT, /**< set cartesian product (237) */
  TRANSPOSE, /**< set transpose (238) */
  TCLOSURE, /**< set transitive closure (239) */
  JOIN_IMAGE, /**< set join image (240) */
  IDEN, /**< set identity (241) */

  /* from strings */
  STRING_CONCAT, /**< string concat (N-ary) (242) */
  STRING_IN_REGEXP, /**< membership (243) */
  STRING_LENGTH, /**< string length (244) */
  STRING_SUBSTR, /**< string substr (245) */
  STRING_CHARAT, /**< string charat (246) */
  STRING_STRCTN, /**< string contains (247) */
  STRING_LT, /**< string less than (248) */
  STRING_LEQ, /**< string less than or equal (249) */
  STRING_STRIDOF, /**< string indexof (250) */
  STRING_STRREPL, /**< string replace (251) */
  STRING_STRREPLALL, /**< string replace all (252) */
  STRING_PREFIX, /**< string prefixof (253) */
  STRING_SUFFIX, /**< string suffixof (254) */
  STRING_ITOS, /**< integer to string (255) */
  STRING_STOI, /**< string to integer (total function) (256) */
  STRING_CODE, /**< string to code, returns the code of the first character of the string if it has length one, -1 otherwise (257) */
  CONST_STRING, /**< a string of characters (258) */
  STRING_TO_REGEXP, /**< convert string to regexp (259) */
  REGEXP_CONCAT, /**< regexp concat (260) */
  REGEXP_UNION, /**< regexp union (261) */
  REGEXP_INTER, /**< regexp intersection (262) */
  REGEXP_STAR, /**< regexp * (263) */
  REGEXP_PLUS, /**< regexp + (264) */
  REGEXP_OPT, /**< regexp ? (265) */
  REGEXP_RANGE, /**< regexp range (266) */
  REGEXP_LOOP, /**< regexp loop (267) */
  REGEXP_EMPTY, /**< regexp empty (268) */
  REGEXP_SIGMA, /**< regexp all characters (269) */
  REGEXP_RV, /**< regexp rv (internal use only) (270) */

  /* from quantifiers */
  FORALL, /**< universally quantified formula; first parameter is an BOUND_VAR_LIST, second is quantifier body, and an optional third parameter is an INST_PATTERN_LIST (271) */
  EXISTS, /**< existentially quantified formula; first parameter is an BOUND_VAR_LIST, second is quantifier body, and an optional third parameter is an INST_PATTERN_LIST (272) */
  INST_CONSTANT, /**< instantiation constant (273) */
  BOUND_VAR_LIST, /**< a list of bound variables (used to bind variables under a quantifier) (274) */
  INST_PATTERN, /**< instantiation pattern (275) */
  INST_NO_PATTERN, /**< instantiation no-pattern (276) */
  INST_ATTRIBUTE, /**< instantiation attribute (277) */
  INST_PATTERN_LIST, /**< a list of instantiation patterns (278) */
  INST_CLOSURE, /**< predicate for specifying term in instantiation closure. (279) */
  REWRITE_RULE, /**< general rewrite rule (for rewrite-rules theory) (280) */
  RR_REWRITE, /**< actual rewrite rule (for rewrite-rules theory) (281) */
  RR_REDUCTION, /**< actual reduction rule (for rewrite-rules theory) (282) */
  RR_DEDUCTION, /**< actual deduction rule (for rewrite-rules theory) (283) */

  /* from idl */

  LAST_KIND /**< marks the upper-bound of this enumeration */

};/* enum Kind_t */

}/* CVC4::kind namespace */

// import Kind into the "CVC4" namespace but keep the individual kind
// constants under kind::
typedef ::CVC4::kind::Kind_t Kind;

namespace kind {

std::ostream& operator<<(std::ostream&, CVC4::Kind) CVC4_PUBLIC;

#line 48 "/build/cvc4/src/CVC4-1.7/src/expr/kind_template.h"

/** Returns true if the given kind is associative. This is used by ExprManager to
 * decide whether it's safe to modify big expressions by changing the grouping of
 * the arguments. */
/* TODO: This could be generated. */
bool isAssociative(::CVC4::Kind k) CVC4_PUBLIC;
std::string kindToString(::CVC4::Kind k) CVC4_PUBLIC;

struct KindHashFunction {
  inline size_t operator()(::CVC4::Kind k) const {
    return k;
  }
};/* struct KindHashFunction */

}/* CVC4::kind namespace */

/**
 * The enumeration for the built-in atomic types.
 */
enum CVC4_PUBLIC TypeConstant {
  BUILTIN_OPERATOR_TYPE, /**< the type for built-in operators */
  BOOLEAN_TYPE, /**< Boolean type */
  REAL_TYPE, /**< real type */
  INTEGER_TYPE, /**< integer type */
  ROUNDINGMODE_TYPE, /**< floating-point rounding mode */
  STRING_TYPE, /**< String type */
  REGEXP_TYPE, /**< RegExp type */
  BOUND_VAR_LIST_TYPE, /**< the type of bound variable lists */
  INST_PATTERN_TYPE, /**< instantiation pattern type */
  INST_PATTERN_LIST_TYPE, /**< the type of instantiation pattern lists */
  RRHB_TYPE, /**< head and body of the rule type (for rewrite-rules theory) */

#line 70 "/build/cvc4/src/CVC4-1.7/src/expr/kind_template.h"
  LAST_TYPE
};/* enum TypeConstant */

/**
 * We hash the constants with their values.
 */
struct TypeConstantHashFunction {
  inline size_t operator()(TypeConstant tc) const {
    return tc;
  }
};/* struct TypeConstantHashFunction */

std::ostream& operator<<(std::ostream& out, TypeConstant typeConstant);

namespace theory {

enum TheoryId {
  THEORY_BUILTIN,
  THEORY_BOOL,
  THEORY_UF,
  THEORY_ARITH,
  THEORY_BV,
  THEORY_FP,
  THEORY_ARRAYS,
  THEORY_DATATYPES,
  THEORY_SEP,
  THEORY_SETS,
  THEORY_STRINGS,
  THEORY_QUANTIFIERS,

#line 89 "/build/cvc4/src/CVC4-1.7/src/expr/kind_template.h"
  THEORY_LAST
};/* enum TheoryId */

const TheoryId THEORY_FIRST = static_cast<TheoryId>(0);
const TheoryId THEORY_SAT_SOLVER = THEORY_LAST;

CVC4_PUBLIC inline TheoryId& operator++(TheoryId& id) {
  return id = static_cast<TheoryId>(static_cast<int>(id) + 1);
}

std::ostream& operator<<(std::ostream& out, TheoryId theoryId);
TheoryId kindToTheoryId(::CVC4::Kind k) CVC4_PUBLIC;
TheoryId typeConstantToTheoryId(::CVC4::TypeConstant typeConstant) CVC4_PUBLIC;
std::string getStatsPrefix(TheoryId theoryId) CVC4_PUBLIC;

}/* CVC4::theory namespace */
}/* CVC4 namespace */

#endif /* __CVC4__KIND_H */
