/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigObject;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

class ConfigPhysicalBody
extends ConfigObject {
    Point3d leftEyePosition = new Point3d(-0.033, 0.0, 0.0);
    Point3d rightEyePosition = new Point3d(0.033, 0.0, 0.0);
    double stereoEyeSeparation = Double.MAX_VALUE;
    Point3d leftEarPosition = new Point3d(-0.08, -0.03, 0.09);
    Point3d rightEarPosition = new Point3d(0.08, -0.03, 0.09);
    double nominalEyeHeightFromGround = 1.68;
    double nominalEyeOffsetFromNominalScreen = 0.4572;
    Matrix4d headToHeadTracker = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    PhysicalBody j3dPhysicalBody;

    ConfigPhysicalBody() {
    }

    @Override
    protected void initialize(ConfigCommand configCommand) {
    }

    @Override
    protected void setProperty(ConfigCommand configCommand) {
        int n = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        if (n != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[1])) {
            this.syntaxError("The first argument to " + configCommand.commandName + " must be a name");
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be an property/attribute name");
        }
        String string = (String)objectArray[2];
        Object object = objectArray[3];
        if (string.equals("StereoEyeSeparation")) {
            if (!(object instanceof Double)) {
                this.syntaxError("StereoEyeSeparation must be a number");
            }
            this.stereoEyeSeparation = (Double)object;
        } else if (string.equals("LeftEyePosition")) {
            if (!(object instanceof Point3d)) {
                this.syntaxError("LeftEyePosition must be a point");
            }
            this.leftEyePosition = (Point3d)object;
        } else if (string.equals("RightEyePosition")) {
            if (!(object instanceof Point3d)) {
                this.syntaxError("RightEyePosition must be a point");
            }
            this.rightEyePosition = (Point3d)object;
        } else if (string.equals("LeftEarPosition")) {
            if (!(object instanceof Point3d)) {
                this.syntaxError("LeftEarPosition must be a point");
            }
            this.leftEarPosition = (Point3d)object;
        } else if (string.equals("RightEarPosition")) {
            if (!(object instanceof Point3d)) {
                this.syntaxError("RightEarPosition must be a point");
            }
            this.leftEarPosition = (Point3d)object;
        } else if (string.equals("NominalEyeHeightFromGround")) {
            if (!(object instanceof Double)) {
                this.syntaxError("NominalEyeHeightFromGround must be a number");
            }
            this.nominalEyeHeightFromGround = (Double)object;
        } else if (string.equals("NominalEyeOffsetFromNominalScreen")) {
            if (!(object instanceof Double)) {
                this.syntaxError("NominalEyeOffsetFromNominalScreen must be a number");
            }
            this.nominalEyeOffsetFromNominalScreen = (Double)object;
        } else if (string.equals("HeadToHeadTracker")) {
            if (!(object instanceof Matrix4d)) {
                this.syntaxError("HeadToHeadTracker must be a matrix");
            }
            this.headToHeadTracker = (Matrix4d)object;
        } else {
            this.syntaxError("Unknown " + configCommand.commandName + " \"" + string + "\"");
        }
    }

    PhysicalBody createJ3dPhysicalBody() {
        if (this.stereoEyeSeparation < Double.MAX_VALUE) {
            this.leftEyePosition.set(-this.stereoEyeSeparation / 2.0, 0.0, 0.0);
            this.rightEyePosition.set(this.stereoEyeSeparation / 2.0, 0.0, 0.0);
        }
        this.j3dPhysicalBody = new PhysicalBody(this.leftEyePosition, this.rightEyePosition, this.leftEarPosition, this.rightEarPosition);
        this.j3dPhysicalBody.setHeadToHeadTracker(new Transform3D(this.headToHeadTracker));
        this.j3dPhysicalBody.setNominalEyeHeightFromGround(this.nominalEyeHeightFromGround);
        this.j3dPhysicalBody.setNominalEyeOffsetFromNominalScreen(this.nominalEyeOffsetFromNominalScreen);
        return this.j3dPhysicalBody;
    }
}

